/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this
 * file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */

/*
 * Do not use ASCII order when comparing strings. Instead, use
 * this randomized ordering which should result in a more balanced
 * tree.
 */
static const unsigned char randtable[] = {
	0xe3, 0xe2, 0x6b, 0x9c, 0x9f, 0x32, 0x76, 0x2b, 
	0x04, 0x2e, 0x02, 0x9b, 0x1e, 0x90, 0xff, 0xaf, 
	0x55, 0x8a, 0x2d, 0xe6, 0xb7, 0x81, 0x22, 0x4c, 
	0x52, 0xa3, 0x65, 0xab, 0x73, 0x5e, 0x6f, 0x2f, 
	0x7d, 0x9d, 0x58, 0xce, 0x99, 0x88, 0x85, 0x31, 
	0x66, 0x68, 0x91, 0xee, 0x43, 0xd2, 0x3e, 0x33, 
	0x5c, 0xdf, 0x21, 0x40, 0x06, 0xb6, 0x80, 0x89, 
	0xf1, 0x16, 0x0a, 0x77, 0x00, 0x17, 0x1b, 0x82, 
	0x28, 0xbd, 0x26, 0x61, 0x9a, 0xfe, 0x84, 0xfc, 
	0x45, 0x94, 0xe7, 0x53, 0x07, 0x7a, 0xa6, 0xc3, 
	0xa0, 0x75, 0xd5, 0xba, 0x8d, 0x7f, 0xca, 0xc5, 
	0xc8, 0xe4, 0x3b, 0xd0, 0x30, 0xe8, 0xfb, 0x87, 
	0xa5, 0xa7, 0x3d, 0x46, 0x51, 0x95, 0xf7, 0x09, 
	0xb3, 0x63, 0x20, 0x44, 0x71, 0x0d, 0x8f, 0x4d, 
	0x2c, 0xec, 0xda, 0x57, 0x7c, 0xac, 0x8b, 0x6c, 
	0x14, 0x37, 0x34, 0x92, 0x49, 0x10, 0xdd, 0xe9, 
	0x83, 0x0c, 0x67, 0xf0, 0xa1, 0x48, 0x97, 0x27, 
	0xe1, 0xe0, 0xa9, 0x9e, 0x7e, 0x6e, 0xb4, 0xf4, 
	0xc0, 0xd3, 0x4f, 0x5a, 0x8c, 0xaa, 0xdc, 0x36, 
	0x98, 0x18, 0x42, 0x05, 0xae, 0x78, 0x60, 0x0f, 
	0x64, 0x3a, 0x01, 0x1a, 0x50, 0xb1, 0x56, 0xeb, 
	0x15, 0xc6, 0xbe, 0xa4, 0x03, 0xe5, 0xb5, 0xd9, 
	0x39, 0xcf, 0x96, 0x5f, 0x29, 0xb8, 0xef, 0x62, 
	0xbb, 0xc1, 0xa2, 0xde, 0xbf, 0xd6, 0xc9, 0x12, 
	0xcb, 0x47, 0x5b, 0xc2, 0x6a, 0x86, 0xf3, 0x35, 
	0xbc, 0x4e, 0x79, 0xb9, 0xc4, 0xf2, 0x0b, 0x4a, 
	0x54, 0x0e, 0x74, 0x59, 0xf8, 0x8e, 0xf9, 0x72, 
	0x24, 0xfd, 0xd8, 0x08, 0x1c, 0xb0, 0xf6, 0x38, 
	0x19, 0x4b, 0xd7, 0xfa, 0x70, 0x5d, 0xc7, 0x69, 
	0xf5, 0xdb, 0x3c, 0x25, 0xd1, 0xcd, 0x3f, 0x7b, 
	0xed, 0x93, 0xa8, 0xad, 0xd4, 0x1d, 0x41, 0x13, 
	0xb2, 0x2a, 0x11, 0x23, 0xea, 0x1f, 0x6d, 0xcc, 
};

int
ranstrcmp(
	  const char *a,
	  const char *b
	  )
{
	while (*a && *a == *b) {
		a++;
		b++;
	}
	return (randtable[(unsigned char)*a] - randtable[(unsigned char)*b]);
}
