/*
 * Copyright (c) 2004 Apple Computer, Inc. All Rights Reserved.
 * 
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Copyright (c) 1999-2003 Apple Computer, Inc.  All Rights Reserved.
 * 
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this
 * file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */


//
// pcscmonitor - use PCSC to monitor smartcard reader/card state for securityd
//
#ifndef _H_PCSCMONITOR
#define _H_PCSCMONITOR

#include "securityserver.h"
#include "server.h"
#include "reader.h"
#include "token.h"
#include "notifications.h"
#include "pcsc++.h"
#include <set>


//
// A PCSCMonitor uses PCSC to monitor the state of smartcard readers and
// tokens (cards) in the system, and dispatches messages and events to the
// various related players in securityd. There should be at most one of these
// objects active within securityd.
//
class PCSCMonitor : private Listener, private MachServer::Timer {
public:
	PCSCMonitor(Server &server);
	virtual ~PCSCMonitor();

protected:
	void pollReaders();
	
	void notifyMe(SecurityServer::NotificationDomain domain,
		SecurityServer::NotificationEvent event, const CssmData &data);
	
	void action();
	
	Server &server;
	
private:
	PCSC::Session mSession;
		
	typedef map<string, RefPointer<Reader> > ReaderMap;
	ReaderMap mReaders;
};


#endif //_H_PCSCMONITOR
