/*
 * Copyright (c) 2000-2005 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * The contents of this file constitute Original Code as defined in and
 * are subject to the Apple Public Source License Version 1.1 (the
 * "License").  You may not use this file except in compliance with the
 * License.  Please obtain a copy of the License at
 * http://www.apple.com/publicsource and read it before using this file.
 * 
 * This Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
 * Copyright (c) 1995
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley
 * by Pace Willisson (pace@blitz.com).  The Rock Ridge Extension
 * Support code is derived from software contributed to Berkeley
 * by Atsushi Murai (amurai@spec.co.jp).
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)cd9660_mount.h	8.1 (Berkeley) 5/24/95
 */

#ifndef __ISOFS_CD9660_CD9660_MOUNT_H__
#define __ISOFS_CD9660_CD9660_MOUNT_H__

#include <sys/appleapiopts.h>
#include <sys/cdefs.h>

#ifdef __APPLE_API_UNSTABLE
/*
 * Arguments to mount ISO 9660 filesystems.
 */
struct CDTOC;
struct iso_args {
#ifndef KERNEL
	char	*fspec;			/* block special device to mount */
#endif
	int	flags;			/* mounting flags, see below */
	int	ssector;		/* starting sector, 0 for 1st session */
	int	toc_length;		/* Size of *toc, including the toc.length field */
	struct CDTOC *toc;
};
#define	ISOFSMNT_NORRIP   0x00000001	/* disable Rock Ridge Ext.*/
#define	ISOFSMNT_GENS     0x00000002	/* enable generation numbers */
#define	ISOFSMNT_EXTATT   0x00000004	/* enable extended attributes */
#define	ISOFSMNT_NOJOLIET 0x00000008	/* disable Joliet Ext.*/
#define ISOFSMNT_TOC	  0x00000010	/* iso_args.toc is valid */

#ifdef KERNEL
/* LP64 version of iso_args.  all pointers 
 * grow when we're dealing with a 64-bit process.
 * WARNING - keep in sync with iso_args
 */
/* LP64todo - should this move? */

struct user_iso_args {
	int	flags;			/* mounting flags, see below */
	int	ssector;		/* starting sector, 0 for 1st session */
	int	toc_length;		/* Size of *toc, including the toc.length field */
	user_addr_t toc __attribute((aligned(8)));
};

#endif /* KERNEL */

#endif /* __APPLE_API_UNSTABLE */
#endif /* __ISOFS_CD9660_CD9660_MOUNT_H__ */
