/*
 * Copyright (c) 2004 Apple Computer, Inc. All rights reserved.
 * 
 * @APPLE_LICENSE_HEADER_START@ 
 * 
 * The contents of this file constitute Original Code as defined in and 
 * are subject to the Apple Public Source License Version 1.1 (the 
 * "License").  You may not use this file except in compliance with the 
 * License.  Please obtain a copy of the License at 
 * http://www.apple.com/publicsource and read it before using this file. 
 * 
 * This Original Code and all software distributed under the License are 
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER 
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES, 
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT.  Please see the 
 * License for the specific language governing rights and limitations 
 * under the License. 
 * 
 * @APPLE_LICENSE_HEADER_END@ 
 * 
 * 
 * System call switch table.
 *
 * DO NOT EDIT-- this file is automatically generated.
 * created from syscalls.master
 */

#ifndef _SYS_SYSCALL_H_
#define	_SYS_SYSCALL_H_

#include <sys/appleapiopts.h>
#ifdef __APPLE_API_PRIVATE
#define	SYS_syscall        0
#define	SYS_exit           1
#define	SYS_fork           2
#define	SYS_read           3
#define	SYS_write          4
#define	SYS_open           5
#define	SYS_close          6
#define	SYS_wait4          7
			/* 8  old creat */
#define	SYS_link           9
#define	SYS_unlink         10
			/* 11  old execv */
#define	SYS_chdir          12
#define	SYS_fchdir         13
#define	SYS_mknod          14
#define	SYS_chmod          15
#define	SYS_chown          16
#define	SYS_obreak         17
#if COMPAT_GETFSSTAT
#define	SYS_ogetfsstat     18
#else
#define	SYS_getfsstat      18
#endif
			/* 19  old lseek */
#define	SYS_getpid         20
			/* 21  old mount */
			/* 22  old umount */
#define	SYS_setuid         23
#define	SYS_getuid         24
#define	SYS_geteuid        25
#define	SYS_ptrace         26
#define	SYS_recvmsg        27
#define	SYS_sendmsg        28
#define	SYS_recvfrom       29
#define	SYS_accept         30
#define	SYS_getpeername    31
#define	SYS_getsockname    32
#define	SYS_access         33
#define	SYS_chflags        34
#define	SYS_fchflags       35
#define	SYS_sync           36
#define	SYS_kill           37
			/* 38  old stat */
#define	SYS_getppid        39
			/* 40  old lstat */
#define	SYS_dup            41
#define	SYS_pipe           42
#define	SYS_getegid        43
#define	SYS_profil         44
#define	SYS_ktrace         45
#define	SYS_sigaction      46
#define	SYS_getgid         47
#define	SYS_sigprocmask    48
#define	SYS_getlogin       49
#define	SYS_setlogin       50
#define	SYS_acct           51
#define	SYS_sigpending     52
#define	SYS_sigaltstack    53
#define	SYS_ioctl          54
#define	SYS_reboot         55
#define	SYS_revoke         56
#define	SYS_symlink        57
#define	SYS_readlink       58
#define	SYS_execve         59
#define	SYS_umask          60
#define	SYS_chroot         61
			/* 62  old fstat */
			/* 63  used internally , reserved */
			/* 64  old getpagesize */
#define	SYS_msync          65
#define	SYS_vfork          66
			/* 67  old vread */
			/* 68  old vwrite */
#define	SYS_sbrk           69
#define	SYS_sstk           70
			/* 71  old mmap */
#define	SYS_ovadvise       72
#define	SYS_munmap         73
#define	SYS_mprotect       74
#define	SYS_madvise        75
			/* 76  old vhangup */
			/* 77  old vlimit */
#define	SYS_mincore        78
#define	SYS_getgroups      79
#define	SYS_setgroups      80
#define	SYS_getpgrp        81
#define	SYS_setpgid        82
#define	SYS_setitimer      83
			/* 84  old wait */
#define	SYS_swapon         85
#define	SYS_getitimer      86
			/* 87  old gethostname */
			/* 88  old sethostname */
#define	SYS_getdtablesize  89
#define	SYS_dup2           90
			/* 91  old getdopt */
#define	SYS_fcntl          92
#define	SYS_select         93
			/* 94  old setdopt */
#define	SYS_fsync          95
#define	SYS_setpriority    96
#define	SYS_socket         97
#define	SYS_connect        98
			/* 99  old accept */
#define	SYS_getpriority    100
			/* 101  old send */
			/* 102  old recv */
			/* 103  old sigreturn */
#define	SYS_bind           104
#define	SYS_setsockopt     105
#define	SYS_listen         106
			/* 107  old vtimes */
			/* 108  old sigvec */
			/* 109  old sigblock */
			/* 110  old sigsetmask */
#define	SYS_sigsuspend     111
			/* 112  old sigstack */
			/* 113  old recvmsg */
			/* 114  old sendmsg */
			/* 115  old vtrace */
#define	SYS_gettimeofday   116
#define	SYS_getrusage      117
#define	SYS_getsockopt     118
			/* 119  old resuba */
#define	SYS_readv          120
#define	SYS_writev         121
#define	SYS_settimeofday   122
#define	SYS_fchown         123
#define	SYS_fchmod         124
			/* 125  old recvfrom */
			/* 126  old setreuid */
			/* 127  old setregid */
#define	SYS_rename         128
			/* 129  old truncate */
			/* 130  old ftruncate */
#define	SYS_flock          131
#define	SYS_mkfifo         132
#define	SYS_sendto         133
#define	SYS_shutdown       134
#define	SYS_socketpair     135
#define	SYS_mkdir          136
#define	SYS_rmdir          137
#define	SYS_utimes         138
#define	SYS_futimes        139
#define	SYS_adjtime        140
			/* 141  old getpeername */
			/* 142  old gethostid */
			/* 143  old sethostid */
			/* 144  old getrlimit */
			/* 145  old setrlimit */
			/* 146  old killpg */
#define	SYS_setsid         147
			/* 148  old setquota */
			/* 149  old qquota */
			/* 150  old getsockname */
#define	SYS_getpgid        151
#define	SYS_setprivexec    152
#define	SYS_pread          153
#define	SYS_pwrite         154
#if NFSSERVER
#define	SYS_nfssvc         155
#else
			/* 155  */
#endif
			/* 156  old getdirentries */
#define	SYS_statfs         157
#define	SYS_fstatfs        158
#define	SYS_unmount        159
			/* 160  old async_daemon */
#if NFSCLIENT
#define	SYS_getfh          161
#else
			/* 161  */
#endif
			/* 162  old getdomainname */
			/* 163  old setdomainname */
			/* 164  */
#define	SYS_quotactl       165
			/* 166  old exportfs */
#define	SYS_mount          167
			/* 168  old ustat */
			/* 169  */
#define	SYS_table          170
			/* 171  old wait3 */
			/* 172  old rpause */
#define	SYS_waitid         173
			/* 174  old getdents */
			/* 175  old gc_control */
#define	SYS_add_profil     176
			/* 177  */
			/* 178  */
			/* 179  */
#define	SYS_kdebug_trace   180
#define	SYS_setgid         181
#define	SYS_setegid        182
#define	SYS_seteuid        183
#define	SYS_sigreturn      184
#define	SYS_chud           185
			/* 186  */
			/* 187  */
#define	SYS_stat           188
#define	SYS_fstat          189
#define	SYS_lstat          190
#define	SYS_pathconf       191
#define	SYS_fpathconf      192
#if COMPAT_GETFSSTAT
#define	SYS_getfsstat      193
#else
			/* 193  */
#endif
#define	SYS_getrlimit      194
#define	SYS_setrlimit      195
#define	SYS_getdirentries  196
#define	SYS_mmap           197
			/* 198  __syscall */
#define	SYS_lseek          199
#define	SYS_truncate       200
#define	SYS_ftruncate      201
#define	SYS___sysctl       202
#define	SYS_mlock          203
#define	SYS_munlock        204
#define	SYS_undelete       205
#define	SYS_ATsocket       206
#define	SYS_ATgetmsg       207
#define	SYS_ATputmsg       208
#define	SYS_ATPsndreq      209
#define	SYS_ATPsndrsp      210
#define	SYS_ATPgetreq      211
#define	SYS_ATPgetrsp      212
			/* 213  Reserved for AppleTalk */
#define	SYS_kqueue_from_portset_np 214
#define	SYS_kqueue_portset_np 215
#define	SYS_mkcomplex      216
#define	SYS_statv          217
#define	SYS_lstatv         218
#define	SYS_fstatv         219
#define	SYS_getattrlist    220
#define	SYS_setattrlist    221
#define	SYS_getdirentriesattr 222
#define	SYS_exchangedata   223
#ifdef __APPLE_API_OBSOLETE
#define	SYS_checkuseraccess 224
#else
			/* 224  HFS checkuseraccess check access to a file */
#endif /* __APPLE_API_OBSOLETE */
#define	SYS_searchfs       225
#define	SYS_delete         226
#define	SYS_copyfile       227
			/* 228  */
			/* 229  */
#define	SYS_poll           230
#define	SYS_watchevent     231
#define	SYS_waitevent      232
#define	SYS_modwatch       233
#define	SYS_getxattr       234
#define	SYS_fgetxattr      235
#define	SYS_setxattr       236
#define	SYS_fsetxattr      237
#define	SYS_removexattr    238
#define	SYS_fremovexattr   239
#define	SYS_listxattr      240
#define	SYS_flistxattr     241
#define	SYS_fsctl          242
#define	SYS_initgroups     243
			/* 244  */
			/* 245  */
			/* 246  */
#if NFSCLIENT
#define	SYS_nfsclnt        247
#define	SYS_fhopen         248
#else
			/* 247  */
			/* 248  */
#endif
			/* 249  */
#define	SYS_minherit       250
#define	SYS_semsys         251
#define	SYS_msgsys         252
#define	SYS_shmsys         253
#define	SYS_semctl         254
#define	SYS_semget         255
#define	SYS_semop          256
			/* 257 */
#define	SYS_msgctl         258
#define	SYS_msgget         259
#define	SYS_msgsnd         260
#define	SYS_msgrcv         261
#define	SYS_shmat          262
#define	SYS_shmctl         263
#define	SYS_shmdt          264
#define	SYS_shmget         265
#define	SYS_shm_open       266
#define	SYS_shm_unlink     267
#define	SYS_sem_open       268
#define	SYS_sem_close      269
#define	SYS_sem_unlink     270
#define	SYS_sem_wait       271
#define	SYS_sem_trywait    272
#define	SYS_sem_post       273
#define	SYS_sem_getvalue   274
#define	SYS_sem_init       275
#define	SYS_sem_destroy    276
#define	SYS_open_extended  277
#define	SYS_umask_extended 278
#define	SYS_stat_extended  279
#define	SYS_lstat_extended 280
#define	SYS_fstat_extended 281
#define	SYS_chmod_extended 282
#define	SYS_fchmod_extended 283
#define	SYS_access_extended 284
#define	SYS_settid         285
#define	SYS_gettid         286
#define	SYS_setsgroups     287
#define	SYS_getsgroups     288
#define	SYS_setwgroups     289
#define	SYS_getwgroups     290
#define	SYS_mkfifo_extended 291
#define	SYS_mkdir_extended 292
#define	SYS_identitysvc    293
			/* 294  */
			/* 295  */
#define	SYS_load_shared_file 296
#define	SYS_reset_shared_file 297
#define	SYS_new_system_shared_regions 298
#define	SYS_shared_region_map_file_np 299
#define	SYS_shared_region_make_private_np 300
			/* 301  */
			/* 302  */
			/* 303  */
			/* 304  */
			/* 305  */
			/* 306  */
			/* 307  */
			/* 308  */
			/* 309  */
#define	SYS_getsid         310
#define	SYS_settid_with_pid 311
			/* 312  */
#define	SYS_aio_fsync      313
#define	SYS_aio_return     314
#define	SYS_aio_suspend    315
#define	SYS_aio_cancel     316
#define	SYS_aio_error      317
#define	SYS_aio_read       318
#define	SYS_aio_write      319
#define	SYS_lio_listio     320
			/* 321  */
			/* 322  */
			/* 323  */
#define	SYS_mlockall       324
#define	SYS_munlockall     325
			/* 326  */
#define	SYS_issetugid      327
#define	SYS___pthread_kill 328
#define	SYS_pthread_sigmask 329
#define	SYS_sigwait        330
#define	SYS___disable_threadsignal 331
#define	SYS___pthread_markcancel 332
#define	SYS___pthread_canceled 333
#define	SYS___semwait_signal 334
#define	SYS_utrace         335
#define	SYS_proc_info      336
			/* 337  */
			/* 338  */
			/* 339  */
			/* 340  */
			/* 341  */
			/* 342  */
			/* 343  */
			/* 344  */
			/* 345  */
			/* 346  */
			/* 347  */
			/* 348  */
			/* 349  */
#define	SYS_audit          350
#define	SYS_auditon        351
			/* 352  */
#define	SYS_getauid        353
#define	SYS_setauid        354
#define	SYS_getaudit       355
#define	SYS_setaudit       356
#define	SYS_getaudit_addr  357
#define	SYS_setaudit_addr  358
#define	SYS_auditctl       359
			/* 360  */
			/* 361  */
#define	SYS_kqueue         362
#define	SYS_kevent         363
#define	SYS_lchown         364
#define	SYS_stack_snapshot 365
			/* 366  */
			/* 367  */
			/* 368  */
			/* 369  */
#define	SYS_MAXSYSCALL	370

#endif /* __APPLE_API_PRIVATE */
#endif /* !_SYS_SYSCALL_H_ */
