/*
 * Copyright (c) 2006 Apple Computer, Inc. All Rights Reserved.
 * 
 * @APPLE_LICENSE_OSREFERENCE_HEADER_START@
 * 
 * This file contains Original Code and/or Modifications of Original Code 
 * as defined in and that are subject to the Apple Public Source License 
 * Version 2.0 (the 'License'). You may not use this file except in 
 * compliance with the License.  The rights granted to you under the 
 * License may not be used to create, or enable the creation or 
 * redistribution of, unlawful or unlicensed copies of an Apple operating 
 * system, or to circumvent, violate, or enable the circumvention or 
 * violation of, any terms of an Apple operating system software license 
 * agreement.
 *
 * Please obtain a copy of the License at 
 * http://www.opensource.apple.com/apsl/ and read it before using this 
 * file.
 *
 * The Original Code and all software distributed under the License are 
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER 
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES, 
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT. 
 * Please see the License for the specific language governing rights and 
 * limitations under the License.
 *
 * @APPLE_LICENSE_OSREFERENCE_HEADER_END@
 */
 
/*
	Derived from Core Foundation headers:

		CFUniCharDecompData.h
		CFUniCharPrecompData.h
		CFUniCharNonBaseData.h
*/

static const u_int16_t
__CFUniCharDecompositionTable[] = {
	0x00C0, 0x2000,   0x00C1, 0x2002,   0x00C2, 0x2004,   0x00C3, 0x2006,
	0x00C4, 0x2008,   0x00C5, 0x200A,   0x00C7, 0x200C,   0x00C8, 0x200E,
	0x00C9, 0x2010,   0x00CA, 0x2012,   0x00CB, 0x2014,   0x00CC, 0x2016,
	0x00CD, 0x2018,   0x00CE, 0x201A,   0x00CF, 0x201C,   0x00D1, 0x201E,
	0x00D2, 0x2020,   0x00D3, 0x2022,   0x00D4, 0x2024,   0x00D5, 0x2026,
	0x00D6, 0x2028,   0x00D9, 0x202A,   0x00DA, 0x202C,   0x00DB, 0x202E,
	0x00DC, 0x2030,   0x00DD, 0x2032,   0x00E0, 0x2034,   0x00E1, 0x2036,
	0x00E2, 0x2038,   0x00E3, 0x203A,   0x00E4, 0x203C,   0x00E5, 0x203E,
	0x00E7, 0x2040,   0x00E8, 0x2042,   0x00E9, 0x2044,   0x00EA, 0x2046,
	0x00EB, 0x2048,   0x00EC, 0x204A,   0x00ED, 0x204C,   0x00EE, 0x204E,
	0x00EF, 0x2050,   0x00F1, 0x2052,   0x00F2, 0x2054,   0x00F3, 0x2056,
	0x00F4, 0x2058,   0x00F5, 0x205A,   0x00F6, 0x205C,   0x00F9, 0x205E,
	0x00FA, 0x2060,   0x00FB, 0x2062,   0x00FC, 0x2064,   0x00FD, 0x2066,
	0x00FF, 0x2068,   0x0100, 0x206A,   0x0101, 0x206C,   0x0102, 0x206E,
	0x0103, 0x2070,   0x0104, 0x2072,   0x0105, 0x2074,   0x0106, 0x2076,
	0x0107, 0x2078,   0x0108, 0x207A,   0x0109, 0x207C,   0x010A, 0x207E,
	0x010B, 0x2080,   0x010C, 0x2082,   0x010D, 0x2084,   0x010E, 0x2086,
	0x010F, 0x2088,   0x0112, 0x208A,   0x0113, 0x208C,   0x0114, 0x208E,
	0x0115, 0x2090,   0x0116, 0x2092,   0x0117, 0x2094,   0x0118, 0x2096,
	0x0119, 0x2098,   0x011A, 0x209A,   0x011B, 0x209C,   0x011C, 0x209E,
	0x011D, 0x20A0,   0x011E, 0x20A2,   0x011F, 0x20A4,   0x0120, 0x20A6,
	0x0121, 0x20A8,   0x0122, 0x20AA,   0x0123, 0x20AC,   0x0124, 0x20AE,
	0x0125, 0x20B0,   0x0128, 0x20B2,   0x0129, 0x20B4,   0x012A, 0x20B6,
	0x012B, 0x20B8,   0x012C, 0x20BA,   0x012D, 0x20BC,   0x012E, 0x20BE,
	0x012F, 0x20C0,   0x0130, 0x20C2,   0x0134, 0x20C4,   0x0135, 0x20C6,
	0x0136, 0x20C8,   0x0137, 0x20CA,   0x0139, 0x20CC,   0x013A, 0x20CE,
	0x013B, 0x20D0,   0x013C, 0x20D2,   0x013D, 0x20D4,   0x013E, 0x20D6,
	0x0143, 0x20D8,   0x0144, 0x20DA,   0x0145, 0x20DC,   0x0146, 0x20DE,
	0x0147, 0x20E0,   0x0148, 0x20E2,   0x014C, 0x20E4,   0x014D, 0x20E6,
	0x014E, 0x20E8,   0x014F, 0x20EA,   0x0150, 0x20EC,   0x0151, 0x20EE,
	0x0154, 0x20F0,   0x0155, 0x20F2,   0x0156, 0x20F4,   0x0157, 0x20F6,
	0x0158, 0x20F8,   0x0159, 0x20FA,   0x015A, 0x20FC,   0x015B, 0x20FE,
	0x015C, 0x2100,   0x015D, 0x2102,   0x015E, 0x2104,   0x015F, 0x2106,
	0x0160, 0x2108,   0x0161, 0x210A,   0x0162, 0x210C,   0x0163, 0x210E,
	0x0164, 0x2110,   0x0165, 0x2112,   0x0168, 0x2114,   0x0169, 0x2116,
	0x016A, 0x2118,   0x016B, 0x211A,   0x016C, 0x211C,   0x016D, 0x211E,
	0x016E, 0x2120,   0x016F, 0x2122,   0x0170, 0x2124,   0x0171, 0x2126,
	0x0172, 0x2128,   0x0173, 0x212A,   0x0174, 0x212C,   0x0175, 0x212E,
	0x0176, 0x2130,   0x0177, 0x2132,   0x0178, 0x2134,   0x0179, 0x2136,
	0x017A, 0x2138,   0x017B, 0x213A,   0x017C, 0x213C,   0x017D, 0x213E,
	0x017E, 0x2140,   0x01A0, 0x2142,   0x01A1, 0x2144,   0x01AF, 0x2146,
	0x01B0, 0x2148,   0x01CD, 0x214A,   0x01CE, 0x214C,   0x01CF, 0x214E,
	0x01D0, 0x2150,   0x01D1, 0x2152,   0x01D2, 0x2154,   0x01D3, 0x2156,
	0x01D4, 0x2158,   0x01D5, 0xA15A,   0x01D6, 0xA15C,   0x01D7, 0xA15E,
	0x01D8, 0xA160,   0x01D9, 0xA162,   0x01DA, 0xA164,   0x01DB, 0xA166,
	0x01DC, 0xA168,   0x01DE, 0xA16A,   0x01DF, 0xA16C,   0x01E0, 0xA16E,
	0x01E1, 0xA170,   0x01E2, 0x2172,   0x01E3, 0x2174,   0x01E6, 0x2176,
	0x01E7, 0x2178,   0x01E8, 0x217A,   0x01E9, 0x217C,   0x01EA, 0x217E,
	0x01EB, 0x2180,   0x01EC, 0xA182,   0x01ED, 0xA184,   0x01EE, 0x2186,
	0x01EF, 0x2188,   0x01F0, 0x218A,   0x01F4, 0x218C,   0x01F5, 0x218E,
	0x01F8, 0x2190,   0x01F9, 0x2192,   0x01FA, 0xA194,   0x01FB, 0xA196,
	0x01FC, 0x2198,   0x01FD, 0x219A,   0x01FE, 0x219C,   0x01FF, 0x219E,
	0x0200, 0x21A0,   0x0201, 0x21A2,   0x0202, 0x21A4,   0x0203, 0x21A6,
	0x0204, 0x21A8,   0x0205, 0x21AA,   0x0206, 0x21AC,   0x0207, 0x21AE,
	0x0208, 0x21B0,   0x0209, 0x21B2,   0x020A, 0x21B4,   0x020B, 0x21B6,
	0x020C, 0x21B8,   0x020D, 0x21BA,   0x020E, 0x21BC,   0x020F, 0x21BE,
	0x0210, 0x21C0,   0x0211, 0x21C2,   0x0212, 0x21C4,   0x0213, 0x21C6,
	0x0214, 0x21C8,   0x0215, 0x21CA,   0x0216, 0x21CC,   0x0217, 0x21CE,
	0x0218, 0x21D0,   0x0219, 0x21D2,   0x021A, 0x21D4,   0x021B, 0x21D6,
	0x021E, 0x21D8,   0x021F, 0x21DA,   0x0226, 0x21DC,   0x0227, 0x21DE,
	0x0228, 0x21E0,   0x0229, 0x21E2,   0x022A, 0xA1E4,   0x022B, 0xA1E6,
	0x022C, 0xA1E8,   0x022D, 0xA1EA,   0x022E, 0x21EC,   0x022F, 0x21EE,
	0x0230, 0xA1F0,   0x0231, 0xA1F2,   0x0232, 0x21F4,   0x0233, 0x21F6,
	0x0340, 0x1300,   0x0341, 0x1301,   0x0343, 0x1313,   0x0344, 0x21F8,
	0x0374, 0x12B9,   0x037E, 0x103B,   0x0385, 0x21FA,   0x0386, 0x21FC,
	0x0387, 0x10B7,   0x0388, 0x21FE,   0x0389, 0x2200,   0x038A, 0x2202,
	0x038C, 0x2204,   0x038E, 0x2206,   0x038F, 0x2208,   0x0390, 0xA20A,
	0x03AA, 0x220C,   0x03AB, 0x220E,   0x03AC, 0x2210,   0x03AD, 0x2212,
	0x03AE, 0x2214,   0x03AF, 0x2216,   0x03B0, 0xA218,   0x03CA, 0x221A,
	0x03CB, 0x221C,   0x03CC, 0x221E,   0x03CD, 0x2220,   0x03CE, 0x2222,
	0x03D3, 0x2224,   0x03D4, 0x2226,   0x0400, 0x2228,   0x0401, 0x222A,
	0x0403, 0x222C,   0x0407, 0x222E,   0x040C, 0x2230,   0x040D, 0x2232,
	0x040E, 0x2234,   0x0419, 0x2236,   0x0439, 0x2238,   0x0450, 0x223A,
	0x0451, 0x223C,   0x0453, 0x223E,   0x0457, 0x2240,   0x045C, 0x2242,
	0x045D, 0x2244,   0x045E, 0x2246,   0x0476, 0x2248,   0x0477, 0x224A,
	0x04C1, 0x224C,   0x04C2, 0x224E,   0x04D0, 0x2250,   0x04D1, 0x2252,
	0x04D2, 0x2254,   0x04D3, 0x2256,   0x04D6, 0x2258,   0x04D7, 0x225A,
	0x04DA, 0x225C,   0x04DB, 0x225E,   0x04DC, 0x2260,   0x04DD, 0x2262,
	0x04DE, 0x2264,   0x04DF, 0x2266,   0x04E2, 0x2268,   0x04E3, 0x226A,
	0x04E4, 0x226C,   0x04E5, 0x226E,   0x04E6, 0x2270,   0x04E7, 0x2272,
	0x04EA, 0x2274,   0x04EB, 0x2276,   0x04EC, 0x2278,   0x04ED, 0x227A,
	0x04EE, 0x227C,   0x04EF, 0x227E,   0x04F0, 0x2280,   0x04F1, 0x2282,
	0x04F2, 0x2284,   0x04F3, 0x2286,   0x04F4, 0x2288,   0x04F5, 0x228A,
	0x04F8, 0x228C,   0x04F9, 0x228E,   0x0622, 0x2290,   0x0623, 0x2292,
	0x0624, 0x2294,   0x0625, 0x2296,   0x0626, 0x2298,   0x06C0, 0x229A,
	0x06C2, 0x229C,   0x06D3, 0x229E,   0x0929, 0x22A0,   0x0931, 0x22A2,
	0x0934, 0x22A4,   0x0958, 0x22A6,   0x0959, 0x22A8,   0x095A, 0x22AA,
	0x095B, 0x22AC,   0x095C, 0x22AE,   0x095D, 0x22B0,   0x095E, 0x22B2,
	0x095F, 0x22B4,   0x09CB, 0x22B6,   0x09CC, 0x22B8,   0x09DC, 0x22BA,
	0x09DD, 0x22BC,   0x09DF, 0x22BE,   0x0A33, 0x22C0,   0x0A36, 0x22C2,
	0x0A59, 0x22C4,   0x0A5A, 0x22C6,   0x0A5B, 0x22C8,   0x0A5E, 0x22CA,
	0x0B48, 0x22CC,   0x0B4B, 0x22CE,   0x0B4C, 0x22D0,   0x0B5C, 0x22D2,
	0x0B5D, 0x22D4,   0x0B94, 0x22D6,   0x0BCA, 0x22D8,   0x0BCB, 0x22DA,
	0x0BCC, 0x22DC,   0x0C48, 0x22DE,   0x0CC0, 0x22E0,   0x0CC7, 0x22E2,
	0x0CC8, 0x22E4,   0x0CCA, 0x22E6,   0x0CCB, 0xA2E8,   0x0D4A, 0x22EA,
	0x0D4B, 0x22EC,   0x0D4C, 0x22EE,   0x0DDA, 0x22F0,   0x0DDC, 0x22F2,
	0x0DDD, 0xA2F4,   0x0DDE, 0x22F6,   0x0F43, 0x22F8,   0x0F4D, 0x22FA,
	0x0F52, 0x22FC,   0x0F57, 0x22FE,   0x0F5C, 0x2300,   0x0F69, 0x2302,
	0x0F73, 0x2304,   0x0F75, 0x2306,   0x0F76, 0x2308,   0x0F78, 0x230A,
	0x0F81, 0x230C,   0x0F93, 0x230E,   0x0F9D, 0x2310,   0x0FA2, 0x2312,
	0x0FA7, 0x2314,   0x0FAC, 0x2316,   0x0FB9, 0x2318,   0x1026, 0x231A,
	0x1E00, 0x231C,   0x1E01, 0x231E,   0x1E02, 0x2320,   0x1E03, 0x2322,
	0x1E04, 0x2324,   0x1E05, 0x2326,   0x1E06, 0x2328,   0x1E07, 0x232A,
	0x1E08, 0xA32C,   0x1E09, 0xA32E,   0x1E0A, 0x2330,   0x1E0B, 0x2332,
	0x1E0C, 0x2334,   0x1E0D, 0x2336,   0x1E0E, 0x2338,   0x1E0F, 0x233A,
	0x1E10, 0x233C,   0x1E11, 0x233E,   0x1E12, 0x2340,   0x1E13, 0x2342,
	0x1E14, 0xA344,   0x1E15, 0xA346,   0x1E16, 0xA348,   0x1E17, 0xA34A,
	0x1E18, 0x234C,   0x1E19, 0x234E,   0x1E1A, 0x2350,   0x1E1B, 0x2352,
	0x1E1C, 0xA354,   0x1E1D, 0xA356,   0x1E1E, 0x2358,   0x1E1F, 0x235A,
	0x1E20, 0x235C,   0x1E21, 0x235E,   0x1E22, 0x2360,   0x1E23, 0x2362,
	0x1E24, 0x2364,   0x1E25, 0x2366,   0x1E26, 0x2368,   0x1E27, 0x236A,
	0x1E28, 0x236C,   0x1E29, 0x236E,   0x1E2A, 0x2370,   0x1E2B, 0x2372,
	0x1E2C, 0x2374,   0x1E2D, 0x2376,   0x1E2E, 0xA378,   0x1E2F, 0xA37A,
	0x1E30, 0x237C,   0x1E31, 0x237E,   0x1E32, 0x2380,   0x1E33, 0x2382,
	0x1E34, 0x2384,   0x1E35, 0x2386,   0x1E36, 0x2388,   0x1E37, 0x238A,
	0x1E38, 0xA38C,   0x1E39, 0xA38E,   0x1E3A, 0x2390,   0x1E3B, 0x2392,
	0x1E3C, 0x2394,   0x1E3D, 0x2396,   0x1E3E, 0x2398,   0x1E3F, 0x239A,
	0x1E40, 0x239C,   0x1E41, 0x239E,   0x1E42, 0x23A0,   0x1E43, 0x23A2,
	0x1E44, 0x23A4,   0x1E45, 0x23A6,   0x1E46, 0x23A8,   0x1E47, 0x23AA,
	0x1E48, 0x23AC,   0x1E49, 0x23AE,   0x1E4A, 0x23B0,   0x1E4B, 0x23B2,
	0x1E4C, 0xA3B4,   0x1E4D, 0xA3B6,   0x1E4E, 0xA3B8,   0x1E4F, 0xA3BA,
	0x1E50, 0xA3BC,   0x1E51, 0xA3BE,   0x1E52, 0xA3C0,   0x1E53, 0xA3C2,
	0x1E54, 0x23C4,   0x1E55, 0x23C6,   0x1E56, 0x23C8,   0x1E57, 0x23CA,
	0x1E58, 0x23CC,   0x1E59, 0x23CE,   0x1E5A, 0x23D0,   0x1E5B, 0x23D2,
	0x1E5C, 0xA3D4,   0x1E5D, 0xA3D6,   0x1E5E, 0x23D8,   0x1E5F, 0x23DA,
	0x1E60, 0x23DC,   0x1E61, 0x23DE,   0x1E62, 0x23E0,   0x1E63, 0x23E2,
	0x1E64, 0xA3E4,   0x1E65, 0xA3E6,   0x1E66, 0xA3E8,   0x1E67, 0xA3EA,
	0x1E68, 0xA3EC,   0x1E69, 0xA3EE,   0x1E6A, 0x23F0,   0x1E6B, 0x23F2,
	0x1E6C, 0x23F4,   0x1E6D, 0x23F6,   0x1E6E, 0x23F8,   0x1E6F, 0x23FA,
	0x1E70, 0x23FC,   0x1E71, 0x23FE,   0x1E72, 0x2400,   0x1E73, 0x2402,
	0x1E74, 0x2404,   0x1E75, 0x2406,   0x1E76, 0x2408,   0x1E77, 0x240A,
	0x1E78, 0xA40C,   0x1E79, 0xA40E,   0x1E7A, 0xA410,   0x1E7B, 0xA412,
	0x1E7C, 0x2414,   0x1E7D, 0x2416,   0x1E7E, 0x2418,   0x1E7F, 0x241A,
	0x1E80, 0x241C,   0x1E81, 0x241E,   0x1E82, 0x2420,   0x1E83, 0x2422,
	0x1E84, 0x2424,   0x1E85, 0x2426,   0x1E86, 0x2428,   0x1E87, 0x242A,
	0x1E88, 0x242C,   0x1E89, 0x242E,   0x1E8A, 0x2430,   0x1E8B, 0x2432,
	0x1E8C, 0x2434,   0x1E8D, 0x2436,   0x1E8E, 0x2438,   0x1E8F, 0x243A,
	0x1E90, 0x243C,   0x1E91, 0x243E,   0x1E92, 0x2440,   0x1E93, 0x2442,
	0x1E94, 0x2444,   0x1E95, 0x2446,   0x1E96, 0x2448,   0x1E97, 0x244A,
	0x1E98, 0x244C,   0x1E99, 0x244E,   0x1E9B, 0x2450,   0x1EA0, 0x2452,
	0x1EA1, 0x2454,   0x1EA2, 0x2456,   0x1EA3, 0x2458,   0x1EA4, 0xA45A,
	0x1EA5, 0xA45C,   0x1EA6, 0xA45E,   0x1EA7, 0xA460,   0x1EA8, 0xA462,
	0x1EA9, 0xA464,   0x1EAA, 0xA466,   0x1EAB, 0xA468,   0x1EAC, 0xA46A,
	0x1EAD, 0xA46C,   0x1EAE, 0xA46E,   0x1EAF, 0xA470,   0x1EB0, 0xA472,
	0x1EB1, 0xA474,   0x1EB2, 0xA476,   0x1EB3, 0xA478,   0x1EB4, 0xA47A,
	0x1EB5, 0xA47C,   0x1EB6, 0xA47E,   0x1EB7, 0xA480,   0x1EB8, 0x2482,
	0x1EB9, 0x2484,   0x1EBA, 0x2486,   0x1EBB, 0x2488,   0x1EBC, 0x248A,
	0x1EBD, 0x248C,   0x1EBE, 0xA48E,   0x1EBF, 0xA490,   0x1EC0, 0xA492,
	0x1EC1, 0xA494,   0x1EC2, 0xA496,   0x1EC3, 0xA498,   0x1EC4, 0xA49A,
	0x1EC5, 0xA49C,   0x1EC6, 0xA49E,   0x1EC7, 0xA4A0,   0x1EC8, 0x24A2,
	0x1EC9, 0x24A4,   0x1ECA, 0x24A6,   0x1ECB, 0x24A8,   0x1ECC, 0x24AA,
	0x1ECD, 0x24AC,   0x1ECE, 0x24AE,   0x1ECF, 0x24B0,   0x1ED0, 0xA4B2,
	0x1ED1, 0xA4B4,   0x1ED2, 0xA4B6,   0x1ED3, 0xA4B8,   0x1ED4, 0xA4BA,
	0x1ED5, 0xA4BC,   0x1ED6, 0xA4BE,   0x1ED7, 0xA4C0,   0x1ED8, 0xA4C2,
	0x1ED9, 0xA4C4,   0x1EDA, 0xA4C6,   0x1EDB, 0xA4C8,   0x1EDC, 0xA4CA,
	0x1EDD, 0xA4CC,   0x1EDE, 0xA4CE,   0x1EDF, 0xA4D0,   0x1EE0, 0xA4D2,
	0x1EE1, 0xA4D4,   0x1EE2, 0xA4D6,   0x1EE3, 0xA4D8,   0x1EE4, 0x24DA,
	0x1EE5, 0x24DC,   0x1EE6, 0x24DE,   0x1EE7, 0x24E0,   0x1EE8, 0xA4E2,
	0x1EE9, 0xA4E4,   0x1EEA, 0xA4E6,   0x1EEB, 0xA4E8,   0x1EEC, 0xA4EA,
	0x1EED, 0xA4EC,   0x1EEE, 0xA4EE,   0x1EEF, 0xA4F0,   0x1EF0, 0xA4F2,
	0x1EF1, 0xA4F4,   0x1EF2, 0x24F6,   0x1EF3, 0x24F8,   0x1EF4, 0x24FA,
	0x1EF5, 0x24FC,   0x1EF6, 0x24FE,   0x1EF7, 0x2500,   0x1EF8, 0x2502,
	0x1EF9, 0x2504,   0x1F00, 0x2506,   0x1F01, 0x2508,   0x1F02, 0xA50A,
	0x1F03, 0xA50C,   0x1F04, 0xA50E,   0x1F05, 0xA510,   0x1F06, 0xA512,
	0x1F07, 0xA514,   0x1F08, 0x2516,   0x1F09, 0x2518,   0x1F0A, 0xA51A,
	0x1F0B, 0xA51C,   0x1F0C, 0xA51E,   0x1F0D, 0xA520,   0x1F0E, 0xA522,
	0x1F0F, 0xA524,   0x1F10, 0x2526,   0x1F11, 0x2528,   0x1F12, 0xA52A,
	0x1F13, 0xA52C,   0x1F14, 0xA52E,   0x1F15, 0xA530,   0x1F18, 0x2532,
	0x1F19, 0x2534,   0x1F1A, 0xA536,   0x1F1B, 0xA538,   0x1F1C, 0xA53A,
	0x1F1D, 0xA53C,   0x1F20, 0x253E,   0x1F21, 0x2540,   0x1F22, 0xA542,
	0x1F23, 0xA544,   0x1F24, 0xA546,   0x1F25, 0xA548,   0x1F26, 0xA54A,
	0x1F27, 0xA54C,   0x1F28, 0x254E,   0x1F29, 0x2550,   0x1F2A, 0xA552,
	0x1F2B, 0xA554,   0x1F2C, 0xA556,   0x1F2D, 0xA558,   0x1F2E, 0xA55A,
	0x1F2F, 0xA55C,   0x1F30, 0x255E,   0x1F31, 0x2560,   0x1F32, 0xA562,
	0x1F33, 0xA564,   0x1F34, 0xA566,   0x1F35, 0xA568,   0x1F36, 0xA56A,
	0x1F37, 0xA56C,   0x1F38, 0x256E,   0x1F39, 0x2570,   0x1F3A, 0xA572,
	0x1F3B, 0xA574,   0x1F3C, 0xA576,   0x1F3D, 0xA578,   0x1F3E, 0xA57A,
	0x1F3F, 0xA57C,   0x1F40, 0x257E,   0x1F41, 0x2580,   0x1F42, 0xA582,
	0x1F43, 0xA584,   0x1F44, 0xA586,   0x1F45, 0xA588,   0x1F48, 0x258A,
	0x1F49, 0x258C,   0x1F4A, 0xA58E,   0x1F4B, 0xA590,   0x1F4C, 0xA592,
	0x1F4D, 0xA594,   0x1F50, 0x2596,   0x1F51, 0x2598,   0x1F52, 0xA59A,
	0x1F53, 0xA59C,   0x1F54, 0xA59E,   0x1F55, 0xA5A0,   0x1F56, 0xA5A2,
	0x1F57, 0xA5A4,   0x1F59, 0x25A6,   0x1F5B, 0xA5A8,   0x1F5D, 0xA5AA,
	0x1F5F, 0xA5AC,   0x1F60, 0x25AE,   0x1F61, 0x25B0,   0x1F62, 0xA5B2,
	0x1F63, 0xA5B4,   0x1F64, 0xA5B6,   0x1F65, 0xA5B8,   0x1F66, 0xA5BA,
	0x1F67, 0xA5BC,   0x1F68, 0x25BE,   0x1F69, 0x25C0,   0x1F6A, 0xA5C2,
	0x1F6B, 0xA5C4,   0x1F6C, 0xA5C6,   0x1F6D, 0xA5C8,   0x1F6E, 0xA5CA,
	0x1F6F, 0xA5CC,   0x1F70, 0x25CE,   0x1F71, 0x93AC,   0x1F72, 0x25D0,
	0x1F73, 0x93AD,   0x1F74, 0x25D2,   0x1F75, 0x93AE,   0x1F76, 0x25D4,
	0x1F77, 0x93AF,   0x1F78, 0x25D6,   0x1F79, 0x93CC,   0x1F7A, 0x25D8,
	0x1F7B, 0x93CD,   0x1F7C, 0x25DA,   0x1F7D, 0x93CE,   0x1F80, 0xA5DC,
	0x1F81, 0xA5DE,   0x1F82, 0xA5E0,   0x1F83, 0xA5E2,   0x1F84, 0xA5E4,
	0x1F85, 0xA5E6,   0x1F86, 0xA5E8,   0x1F87, 0xA5EA,   0x1F88, 0xA5EC,
	0x1F89, 0xA5EE,   0x1F8A, 0xA5F0,   0x1F8B, 0xA5F2,   0x1F8C, 0xA5F4,
	0x1F8D, 0xA5F6,   0x1F8E, 0xA5F8,   0x1F8F, 0xA5FA,   0x1F90, 0xA5FC,
	0x1F91, 0xA5FE,   0x1F92, 0xA600,   0x1F93, 0xA602,   0x1F94, 0xA604,
	0x1F95, 0xA606,   0x1F96, 0xA608,   0x1F97, 0xA60A,   0x1F98, 0xA60C,
	0x1F99, 0xA60E,   0x1F9A, 0xA610,   0x1F9B, 0xA612,   0x1F9C, 0xA614,
	0x1F9D, 0xA616,   0x1F9E, 0xA618,   0x1F9F, 0xA61A,   0x1FA0, 0xA61C,
	0x1FA1, 0xA61E,   0x1FA2, 0xA620,   0x1FA3, 0xA622,   0x1FA4, 0xA624,
	0x1FA5, 0xA626,   0x1FA6, 0xA628,   0x1FA7, 0xA62A,   0x1FA8, 0xA62C,
	0x1FA9, 0xA62E,   0x1FAA, 0xA630,   0x1FAB, 0xA632,   0x1FAC, 0xA634,
	0x1FAD, 0xA636,   0x1FAE, 0xA638,   0x1FAF, 0xA63A,   0x1FB0, 0x263C,
	0x1FB1, 0x263E,   0x1FB2, 0xA640,   0x1FB3, 0x2642,   0x1FB4, 0xA644,
	0x1FB6, 0x2646,   0x1FB7, 0xA648,   0x1FB8, 0x264A,   0x1FB9, 0x264C,
	0x1FBA, 0x264E,   0x1FBB, 0x9386,   0x1FBC, 0x2650,   0x1FBE, 0x13B9,
	0x1FC1, 0x2652,   0x1FC2, 0xA654,   0x1FC3, 0x2656,   0x1FC4, 0xA658,
	0x1FC6, 0x265A,   0x1FC7, 0xA65C,   0x1FC8, 0x265E,   0x1FC9, 0x9388,
	0x1FCA, 0x2660,   0x1FCB, 0x9389,   0x1FCC, 0x2662,   0x1FCD, 0x2664,
	0x1FCE, 0x2666,   0x1FCF, 0x2668,   0x1FD0, 0x266A,   0x1FD1, 0x266C,
	0x1FD2, 0xA66E,   0x1FD3, 0x9390,   0x1FD6, 0x2670,   0x1FD7, 0xA672,
	0x1FD8, 0x2674,   0x1FD9, 0x2676,   0x1FDA, 0x2678,   0x1FDB, 0x938A,
	0x1FDD, 0x267A,   0x1FDE, 0x267C,   0x1FDF, 0x267E,   0x1FE0, 0x2680,
	0x1FE1, 0x2682,   0x1FE2, 0xA684,   0x1FE3, 0x93B0,   0x1FE4, 0x2686,
	0x1FE5, 0x2688,   0x1FE6, 0x268A,   0x1FE7, 0xA68C,   0x1FE8, 0x268E,
	0x1FE9, 0x2690,   0x1FEA, 0x2692,   0x1FEB, 0x938E,   0x1FEC, 0x2694,
	0x1FED, 0x2696,   0x1FEE, 0x9385,   0x1FEF, 0x1060,   0x1FF2, 0xA698,
	0x1FF3, 0x269A,   0x1FF4, 0xA69C,   0x1FF6, 0x269E,   0x1FF7, 0xA6A0,
	0x1FF8, 0x26A2,   0x1FF9, 0x938C,   0x1FFA, 0x26A4,   0x1FFB, 0x938F,
	0x1FFC, 0x26A6,   0x1FFD, 0x10B4,   0x304C, 0x26A8,   0x304E, 0x26AA,
	0x3050, 0x26AC,   0x3052, 0x26AE,   0x3054, 0x26B0,   0x3056, 0x26B2,
	0x3058, 0x26B4,   0x305A, 0x26B6,   0x305C, 0x26B8,   0x305E, 0x26BA,
	0x3060, 0x26BC,   0x3062, 0x26BE,   0x3065, 0x26C0,   0x3067, 0x26C2,
	0x3069, 0x26C4,   0x3070, 0x26C6,   0x3071, 0x26C8,   0x3073, 0x26CA,
	0x3074, 0x26CC,   0x3076, 0x26CE,   0x3077, 0x26D0,   0x3079, 0x26D2,
	0x307A, 0x26D4,   0x307C, 0x26D6,   0x307D, 0x26D8,   0x3094, 0x26DA,
	0x309E, 0x26DC,   0x30AC, 0x26DE,   0x30AE, 0x26E0,   0x30B0, 0x26E2,
	0x30B2, 0x26E4,   0x30B4, 0x26E6,   0x30B6, 0x26E8,   0x30B8, 0x26EA,
	0x30BA, 0x26EC,   0x30BC, 0x26EE,   0x30BE, 0x26F0,   0x30C0, 0x26F2,
	0x30C2, 0x26F4,   0x30C5, 0x26F6,   0x30C7, 0x26F8,   0x30C9, 0x26FA,
	0x30D0, 0x26FC,   0x30D1, 0x26FE,   0x30D3, 0x2700,   0x30D4, 0x2702,
	0x30D6, 0x2704,   0x30D7, 0x2706,   0x30D9, 0x2708,   0x30DA, 0x270A,
	0x30DC, 0x270C,   0x30DD, 0x270E,   0x30F4, 0x2710,   0x30F7, 0x2712,
	0x30F8, 0x2714,   0x30F9, 0x2716,   0x30FA, 0x2718,   0x30FE, 0x271A,
	0xFB1D, 0x271C,   0xFB1F, 0x271E,   0xFB2A, 0x2720,   0xFB2B, 0x2722,
	0xFB2C, 0xA724,   0xFB2D, 0xA726,   0xFB2E, 0x2728,   0xFB2F, 0x272A,
	0xFB30, 0x272C,   0xFB31, 0x272E,   0xFB32, 0x2730,   0xFB33, 0x2732,
	0xFB34, 0x2734,   0xFB35, 0x2736,   0xFB36, 0x2738,   0xFB38, 0x273A,
	0xFB39, 0x273C,   0xFB3A, 0x273E,   0xFB3B, 0x2740,   0xFB3C, 0x2742,
	0xFB3E, 0x2744,   0xFB40, 0x2746,   0xFB41, 0x2748,   0xFB43, 0x274A,
	0xFB44, 0x274C,   0xFB46, 0x274E,   0xFB47, 0x2750,   0xFB48, 0x2752,
	0xFB49, 0x2754,   0xFB4A, 0x2756,   0xFB4B, 0x2758,   0xFB4C, 0x275A,
	0xFB4D, 0x275C,   0xFB4E, 0x275E
};

static const u_int32_t __UniCharDecompositionTableLength =
	(sizeof(__CFUniCharDecompositionTable) / (sizeof(u_int16_t) * 2));


static const u_int16_t
__CFUniCharMultipleDecompositionTable[] = {
	0x0041, 0x0300, 0x0041, 0x0301, 0x0041, 0x0302, 0x0041, 0x0303,
	0x0041, 0x0308, 0x0041, 0x030A, 0x0043, 0x0327, 0x0045, 0x0300,
	0x0045, 0x0301, 0x0045, 0x0302, 0x0045, 0x0308, 0x0049, 0x0300,
	0x0049, 0x0301, 0x0049, 0x0302, 0x0049, 0x0308, 0x004E, 0x0303,
	0x004F, 0x0300, 0x004F, 0x0301, 0x004F, 0x0302, 0x004F, 0x0303,
	0x004F, 0x0308, 0x0055, 0x0300, 0x0055, 0x0301, 0x0055, 0x0302,
	0x0055, 0x0308, 0x0059, 0x0301, 0x0061, 0x0300, 0x0061, 0x0301,
	0x0061, 0x0302, 0x0061, 0x0303, 0x0061, 0x0308, 0x0061, 0x030A,
	0x0063, 0x0327, 0x0065, 0x0300, 0x0065, 0x0301, 0x0065, 0x0302,
	0x0065, 0x0308, 0x0069, 0x0300, 0x0069, 0x0301, 0x0069, 0x0302,
	0x0069, 0x0308, 0x006E, 0x0303, 0x006F, 0x0300, 0x006F, 0x0301,
	0x006F, 0x0302, 0x006F, 0x0303, 0x006F, 0x0308, 0x0075, 0x0300,
	0x0075, 0x0301, 0x0075, 0x0302, 0x0075, 0x0308, 0x0079, 0x0301,
	0x0079, 0x0308, 0x0041, 0x0304, 0x0061, 0x0304, 0x0041, 0x0306,
	0x0061, 0x0306, 0x0041, 0x0328, 0x0061, 0x0328, 0x0043, 0x0301,
	0x0063, 0x0301, 0x0043, 0x0302, 0x0063, 0x0302, 0x0043, 0x0307,
	0x0063, 0x0307, 0x0043, 0x030C, 0x0063, 0x030C, 0x0044, 0x030C,
	0x0064, 0x030C, 0x0045, 0x0304, 0x0065, 0x0304, 0x0045, 0x0306,
	0x0065, 0x0306, 0x0045, 0x0307, 0x0065, 0x0307, 0x0045, 0x0328,
	0x0065, 0x0328, 0x0045, 0x030C, 0x0065, 0x030C, 0x0047, 0x0302,
	0x0067, 0x0302, 0x0047, 0x0306, 0x0067, 0x0306, 0x0047, 0x0307,
	0x0067, 0x0307, 0x0047, 0x0327, 0x0067, 0x0327, 0x0048, 0x0302,
	0x0068, 0x0302, 0x0049, 0x0303, 0x0069, 0x0303, 0x0049, 0x0304,
	0x0069, 0x0304, 0x0049, 0x0306, 0x0069, 0x0306, 0x0049, 0x0328,
	0x0069, 0x0328, 0x0049, 0x0307, 0x004A, 0x0302, 0x006A, 0x0302,
	0x004B, 0x0327, 0x006B, 0x0327, 0x004C, 0x0301, 0x006C, 0x0301,
	0x004C, 0x0327, 0x006C, 0x0327, 0x004C, 0x030C, 0x006C, 0x030C,
	0x004E, 0x0301, 0x006E, 0x0301, 0x004E, 0x0327, 0x006E, 0x0327,
	0x004E, 0x030C, 0x006E, 0x030C, 0x004F, 0x0304, 0x006F, 0x0304,
	0x004F, 0x0306, 0x006F, 0x0306, 0x004F, 0x030B, 0x006F, 0x030B,
	0x0052, 0x0301, 0x0072, 0x0301, 0x0052, 0x0327, 0x0072, 0x0327,
	0x0052, 0x030C, 0x0072, 0x030C, 0x0053, 0x0301, 0x0073, 0x0301,
	0x0053, 0x0302, 0x0073, 0x0302, 0x0053, 0x0327, 0x0073, 0x0327,
	0x0053, 0x030C, 0x0073, 0x030C, 0x0054, 0x0327, 0x0074, 0x0327,
	0x0054, 0x030C, 0x0074, 0x030C, 0x0055, 0x0303, 0x0075, 0x0303,
	0x0055, 0x0304, 0x0075, 0x0304, 0x0055, 0x0306, 0x0075, 0x0306,
	0x0055, 0x030A, 0x0075, 0x030A, 0x0055, 0x030B, 0x0075, 0x030B,
	0x0055, 0x0328, 0x0075, 0x0328, 0x0057, 0x0302, 0x0077, 0x0302,
	0x0059, 0x0302, 0x0079, 0x0302, 0x0059, 0x0308, 0x005A, 0x0301,
	0x007A, 0x0301, 0x005A, 0x0307, 0x007A, 0x0307, 0x005A, 0x030C,
	0x007A, 0x030C, 0x004F, 0x031B, 0x006F, 0x031B, 0x0055, 0x031B,
	0x0075, 0x031B, 0x0041, 0x030C, 0x0061, 0x030C, 0x0049, 0x030C,
	0x0069, 0x030C, 0x004F, 0x030C, 0x006F, 0x030C, 0x0055, 0x030C,
	0x0075, 0x030C, 0x00DC, 0x0304, 0x00FC, 0x0304, 0x00DC, 0x0301,
	0x00FC, 0x0301, 0x00DC, 0x030C, 0x00FC, 0x030C, 0x00DC, 0x0300,
	0x00FC, 0x0300, 0x00C4, 0x0304, 0x00E4, 0x0304, 0x0226, 0x0304,
	0x0227, 0x0304, 0x00C6, 0x0304, 0x00E6, 0x0304, 0x0047, 0x030C,
	0x0067, 0x030C, 0x004B, 0x030C, 0x006B, 0x030C, 0x004F, 0x0328,
	0x006F, 0x0328, 0x01EA, 0x0304, 0x01EB, 0x0304, 0x01B7, 0x030C,
	0x0292, 0x030C, 0x006A, 0x030C, 0x0047, 0x0301, 0x0067, 0x0301,
	0x004E, 0x0300, 0x006E, 0x0300, 0x00C5, 0x0301, 0x00E5, 0x0301,
	0x00C6, 0x0301, 0x00E6, 0x0301, 0x00D8, 0x0301, 0x00F8, 0x0301,
	0x0041, 0x030F, 0x0061, 0x030F, 0x0041, 0x0311, 0x0061, 0x0311,
	0x0045, 0x030F, 0x0065, 0x030F, 0x0045, 0x0311, 0x0065, 0x0311,
	0x0049, 0x030F, 0x0069, 0x030F, 0x0049, 0x0311, 0x0069, 0x0311,
	0x004F, 0x030F, 0x006F, 0x030F, 0x004F, 0x0311, 0x006F, 0x0311,
	0x0052, 0x030F, 0x0072, 0x030F, 0x0052, 0x0311, 0x0072, 0x0311,
	0x0055, 0x030F, 0x0075, 0x030F, 0x0055, 0x0311, 0x0075, 0x0311,
	0x0053, 0x0326, 0x0073, 0x0326, 0x0054, 0x0326, 0x0074, 0x0326,
	0x0048, 0x030C, 0x0068, 0x030C, 0x0041, 0x0307, 0x0061, 0x0307,
	0x0045, 0x0327, 0x0065, 0x0327, 0x00D6, 0x0304, 0x00F6, 0x0304,
	0x00D5, 0x0304, 0x00F5, 0x0304, 0x004F, 0x0307, 0x006F, 0x0307,
	0x022E, 0x0304, 0x022F, 0x0304, 0x0059, 0x0304, 0x0079, 0x0304,
	0x0308, 0x0301, 0x00A8, 0x0301, 0x0391, 0x0301, 0x0395, 0x0301,
	0x0397, 0x0301, 0x0399, 0x0301, 0x039F, 0x0301, 0x03A5, 0x0301,
	0x03A9, 0x0301, 0x03CA, 0x0301, 0x0399, 0x0308, 0x03A5, 0x0308,
	0x03B1, 0x0301, 0x03B5, 0x0301, 0x03B7, 0x0301, 0x03B9, 0x0301,
	0x03CB, 0x0301, 0x03B9, 0x0308, 0x03C5, 0x0308, 0x03BF, 0x0301,
	0x03C5, 0x0301, 0x03C9, 0x0301, 0x03D2, 0x0301, 0x03D2, 0x0308,
	0x0415, 0x0300, 0x0415, 0x0308, 0x0413, 0x0301, 0x0406, 0x0308,
	0x041A, 0x0301, 0x0418, 0x0300, 0x0423, 0x0306, 0x0418, 0x0306,
	0x0438, 0x0306, 0x0435, 0x0300, 0x0435, 0x0308, 0x0433, 0x0301,
	0x0456, 0x0308, 0x043A, 0x0301, 0x0438, 0x0300, 0x0443, 0x0306,
	0x0474, 0x030F, 0x0475, 0x030F, 0x0416, 0x0306, 0x0436, 0x0306,
	0x0410, 0x0306, 0x0430, 0x0306, 0x0410, 0x0308, 0x0430, 0x0308,
	0x0415, 0x0306, 0x0435, 0x0306, 0x04D8, 0x0308, 0x04D9, 0x0308,
	0x0416, 0x0308, 0x0436, 0x0308, 0x0417, 0x0308, 0x0437, 0x0308,
	0x0418, 0x0304, 0x0438, 0x0304, 0x0418, 0x0308, 0x0438, 0x0308,
	0x041E, 0x0308, 0x043E, 0x0308, 0x04E8, 0x0308, 0x04E9, 0x0308,
	0x042D, 0x0308, 0x044D, 0x0308, 0x0423, 0x0304, 0x0443, 0x0304,
	0x0423, 0x0308, 0x0443, 0x0308, 0x0423, 0x030B, 0x0443, 0x030B,
	0x0427, 0x0308, 0x0447, 0x0308, 0x042B, 0x0308, 0x044B, 0x0308,
	0x0627, 0x0653, 0x0627, 0x0654, 0x0648, 0x0654, 0x0627, 0x0655,
	0x064A, 0x0654, 0x06D5, 0x0654, 0x06C1, 0x0654, 0x06D2, 0x0654,
	0x0928, 0x093C, 0x0930, 0x093C, 0x0933, 0x093C, 0x0915, 0x093C,
	0x0916, 0x093C, 0x0917, 0x093C, 0x091C, 0x093C, 0x0921, 0x093C,
	0x0922, 0x093C, 0x092B, 0x093C, 0x092F, 0x093C, 0x09C7, 0x09BE,
	0x09C7, 0x09D7, 0x09A1, 0x09BC, 0x09A2, 0x09BC, 0x09AF, 0x09BC,
	0x0A32, 0x0A3C, 0x0A38, 0x0A3C, 0x0A16, 0x0A3C, 0x0A17, 0x0A3C,
	0x0A1C, 0x0A3C, 0x0A2B, 0x0A3C, 0x0B47, 0x0B56, 0x0B47, 0x0B3E,
	0x0B47, 0x0B57, 0x0B21, 0x0B3C, 0x0B22, 0x0B3C, 0x0B92, 0x0BD7,
	0x0BC6, 0x0BBE, 0x0BC7, 0x0BBE, 0x0BC6, 0x0BD7, 0x0C46, 0x0C56,
	0x0CBF, 0x0CD5, 0x0CC6, 0x0CD5, 0x0CC6, 0x0CD6, 0x0CC6, 0x0CC2,
	0x0CCA, 0x0CD5, 0x0D46, 0x0D3E, 0x0D47, 0x0D3E, 0x0D46, 0x0D57,
	0x0DD9, 0x0DCA, 0x0DD9, 0x0DCF, 0x0DDC, 0x0DCA, 0x0DD9, 0x0DDF,
	0x0F42, 0x0FB7, 0x0F4C, 0x0FB7, 0x0F51, 0x0FB7, 0x0F56, 0x0FB7,
	0x0F5B, 0x0FB7, 0x0F40, 0x0FB5, 0x0F71, 0x0F72, 0x0F71, 0x0F74,
	0x0FB2, 0x0F80, 0x0FB3, 0x0F80, 0x0F71, 0x0F80, 0x0F92, 0x0FB7,
	0x0F9C, 0x0FB7, 0x0FA1, 0x0FB7, 0x0FA6, 0x0FB7, 0x0FAB, 0x0FB7,
	0x0F90, 0x0FB5, 0x1025, 0x102E, 0x0041, 0x0325, 0x0061, 0x0325,
	0x0042, 0x0307, 0x0062, 0x0307, 0x0042, 0x0323, 0x0062, 0x0323,
	0x0042, 0x0331, 0x0062, 0x0331, 0x00C7, 0x0301, 0x00E7, 0x0301,
	0x0044, 0x0307, 0x0064, 0x0307, 0x0044, 0x0323, 0x0064, 0x0323,
	0x0044, 0x0331, 0x0064, 0x0331, 0x0044, 0x0327, 0x0064, 0x0327,
	0x0044, 0x032D, 0x0064, 0x032D, 0x0112, 0x0300, 0x0113, 0x0300,
	0x0112, 0x0301, 0x0113, 0x0301, 0x0045, 0x032D, 0x0065, 0x032D,
	0x0045, 0x0330, 0x0065, 0x0330, 0x0228, 0x0306, 0x0229, 0x0306,
	0x0046, 0x0307, 0x0066, 0x0307, 0x0047, 0x0304, 0x0067, 0x0304,
	0x0048, 0x0307, 0x0068, 0x0307, 0x0048, 0x0323, 0x0068, 0x0323,
	0x0048, 0x0308, 0x0068, 0x0308, 0x0048, 0x0327, 0x0068, 0x0327,
	0x0048, 0x032E, 0x0068, 0x032E, 0x0049, 0x0330, 0x0069, 0x0330,
	0x00CF, 0x0301, 0x00EF, 0x0301, 0x004B, 0x0301, 0x006B, 0x0301,
	0x004B, 0x0323, 0x006B, 0x0323, 0x004B, 0x0331, 0x006B, 0x0331,
	0x004C, 0x0323, 0x006C, 0x0323, 0x1E36, 0x0304, 0x1E37, 0x0304,
	0x004C, 0x0331, 0x006C, 0x0331, 0x004C, 0x032D, 0x006C, 0x032D,
	0x004D, 0x0301, 0x006D, 0x0301, 0x004D, 0x0307, 0x006D, 0x0307,
	0x004D, 0x0323, 0x006D, 0x0323, 0x004E, 0x0307, 0x006E, 0x0307,
	0x004E, 0x0323, 0x006E, 0x0323, 0x004E, 0x0331, 0x006E, 0x0331,
	0x004E, 0x032D, 0x006E, 0x032D, 0x00D5, 0x0301, 0x00F5, 0x0301,
	0x00D5, 0x0308, 0x00F5, 0x0308, 0x014C, 0x0300, 0x014D, 0x0300,
	0x014C, 0x0301, 0x014D, 0x0301, 0x0050, 0x0301, 0x0070, 0x0301,
	0x0050, 0x0307, 0x0070, 0x0307, 0x0052, 0x0307, 0x0072, 0x0307,
	0x0052, 0x0323, 0x0072, 0x0323, 0x1E5A, 0x0304, 0x1E5B, 0x0304,
	0x0052, 0x0331, 0x0072, 0x0331, 0x0053, 0x0307, 0x0073, 0x0307,
	0x0053, 0x0323, 0x0073, 0x0323, 0x015A, 0x0307, 0x015B, 0x0307,
	0x0160, 0x0307, 0x0161, 0x0307, 0x1E62, 0x0307, 0x1E63, 0x0307,
	0x0054, 0x0307, 0x0074, 0x0307, 0x0054, 0x0323, 0x0074, 0x0323,
	0x0054, 0x0331, 0x0074, 0x0331, 0x0054, 0x032D, 0x0074, 0x032D,
	0x0055, 0x0324, 0x0075, 0x0324, 0x0055, 0x0330, 0x0075, 0x0330,
	0x0055, 0x032D, 0x0075, 0x032D, 0x0168, 0x0301, 0x0169, 0x0301,
	0x016A, 0x0308, 0x016B, 0x0308, 0x0056, 0x0303, 0x0076, 0x0303,
	0x0056, 0x0323, 0x0076, 0x0323, 0x0057, 0x0300, 0x0077, 0x0300,
	0x0057, 0x0301, 0x0077, 0x0301, 0x0057, 0x0308, 0x0077, 0x0308,
	0x0057, 0x0307, 0x0077, 0x0307, 0x0057, 0x0323, 0x0077, 0x0323,
	0x0058, 0x0307, 0x0078, 0x0307, 0x0058, 0x0308, 0x0078, 0x0308,
	0x0059, 0x0307, 0x0079, 0x0307, 0x005A, 0x0302, 0x007A, 0x0302,
	0x005A, 0x0323, 0x007A, 0x0323, 0x005A, 0x0331, 0x007A, 0x0331,
	0x0068, 0x0331, 0x0074, 0x0308, 0x0077, 0x030A, 0x0079, 0x030A,
	0x017F, 0x0307, 0x0041, 0x0323, 0x0061, 0x0323, 0x0041, 0x0309,
	0x0061, 0x0309, 0x00C2, 0x0301, 0x00E2, 0x0301, 0x00C2, 0x0300,
	0x00E2, 0x0300, 0x00C2, 0x0309, 0x00E2, 0x0309, 0x00C2, 0x0303,
	0x00E2, 0x0303, 0x1EA0, 0x0302, 0x1EA1, 0x0302, 0x0102, 0x0301,
	0x0103, 0x0301, 0x0102, 0x0300, 0x0103, 0x0300, 0x0102, 0x0309,
	0x0103, 0x0309, 0x0102, 0x0303, 0x0103, 0x0303, 0x1EA0, 0x0306,
	0x1EA1, 0x0306, 0x0045, 0x0323, 0x0065, 0x0323, 0x0045, 0x0309,
	0x0065, 0x0309, 0x0045, 0x0303, 0x0065, 0x0303, 0x00CA, 0x0301,
	0x00EA, 0x0301, 0x00CA, 0x0300, 0x00EA, 0x0300, 0x00CA, 0x0309,
	0x00EA, 0x0309, 0x00CA, 0x0303, 0x00EA, 0x0303, 0x1EB8, 0x0302,
	0x1EB9, 0x0302, 0x0049, 0x0309, 0x0069, 0x0309, 0x0049, 0x0323,
	0x0069, 0x0323, 0x004F, 0x0323, 0x006F, 0x0323, 0x004F, 0x0309,
	0x006F, 0x0309, 0x00D4, 0x0301, 0x00F4, 0x0301, 0x00D4, 0x0300,
	0x00F4, 0x0300, 0x00D4, 0x0309, 0x00F4, 0x0309, 0x00D4, 0x0303,
	0x00F4, 0x0303, 0x1ECC, 0x0302, 0x1ECD, 0x0302, 0x01A0, 0x0301,
	0x01A1, 0x0301, 0x01A0, 0x0300, 0x01A1, 0x0300, 0x01A0, 0x0309,
	0x01A1, 0x0309, 0x01A0, 0x0303, 0x01A1, 0x0303, 0x01A0, 0x0323,
	0x01A1, 0x0323, 0x0055, 0x0323, 0x0075, 0x0323, 0x0055, 0x0309,
	0x0075, 0x0309, 0x01AF, 0x0301, 0x01B0, 0x0301, 0x01AF, 0x0300,
	0x01B0, 0x0300, 0x01AF, 0x0309, 0x01B0, 0x0309, 0x01AF, 0x0303,
	0x01B0, 0x0303, 0x01AF, 0x0323, 0x01B0, 0x0323, 0x0059, 0x0300,
	0x0079, 0x0300, 0x0059, 0x0323, 0x0079, 0x0323, 0x0059, 0x0309,
	0x0079, 0x0309, 0x0059, 0x0303, 0x0079, 0x0303, 0x03B1, 0x0313,
	0x03B1, 0x0314, 0x1F00, 0x0300, 0x1F01, 0x0300, 0x1F00, 0x0301,
	0x1F01, 0x0301, 0x1F00, 0x0342, 0x1F01, 0x0342, 0x0391, 0x0313,
	0x0391, 0x0314, 0x1F08, 0x0300, 0x1F09, 0x0300, 0x1F08, 0x0301,
	0x1F09, 0x0301, 0x1F08, 0x0342, 0x1F09, 0x0342, 0x03B5, 0x0313,
	0x03B5, 0x0314, 0x1F10, 0x0300, 0x1F11, 0x0300, 0x1F10, 0x0301,
	0x1F11, 0x0301, 0x0395, 0x0313, 0x0395, 0x0314, 0x1F18, 0x0300,
	0x1F19, 0x0300, 0x1F18, 0x0301, 0x1F19, 0x0301, 0x03B7, 0x0313,
	0x03B7, 0x0314, 0x1F20, 0x0300, 0x1F21, 0x0300, 0x1F20, 0x0301,
	0x1F21, 0x0301, 0x1F20, 0x0342, 0x1F21, 0x0342, 0x0397, 0x0313,
	0x0397, 0x0314, 0x1F28, 0x0300, 0x1F29, 0x0300, 0x1F28, 0x0301,
	0x1F29, 0x0301, 0x1F28, 0x0342, 0x1F29, 0x0342, 0x03B9, 0x0313,
	0x03B9, 0x0314, 0x1F30, 0x0300, 0x1F31, 0x0300, 0x1F30, 0x0301,
	0x1F31, 0x0301, 0x1F30, 0x0342, 0x1F31, 0x0342, 0x0399, 0x0313,
	0x0399, 0x0314, 0x1F38, 0x0300, 0x1F39, 0x0300, 0x1F38, 0x0301,
	0x1F39, 0x0301, 0x1F38, 0x0342, 0x1F39, 0x0342, 0x03BF, 0x0313,
	0x03BF, 0x0314, 0x1F40, 0x0300, 0x1F41, 0x0300, 0x1F40, 0x0301,
	0x1F41, 0x0301, 0x039F, 0x0313, 0x039F, 0x0314, 0x1F48, 0x0300,
	0x1F49, 0x0300, 0x1F48, 0x0301, 0x1F49, 0x0301, 0x03C5, 0x0313,
	0x03C5, 0x0314, 0x1F50, 0x0300, 0x1F51, 0x0300, 0x1F50, 0x0301,
	0x1F51, 0x0301, 0x1F50, 0x0342, 0x1F51, 0x0342, 0x03A5, 0x0314,
	0x1F59, 0x0300, 0x1F59, 0x0301, 0x1F59, 0x0342, 0x03C9, 0x0313,
	0x03C9, 0x0314, 0x1F60, 0x0300, 0x1F61, 0x0300, 0x1F60, 0x0301,
	0x1F61, 0x0301, 0x1F60, 0x0342, 0x1F61, 0x0342, 0x03A9, 0x0313,
	0x03A9, 0x0314, 0x1F68, 0x0300, 0x1F69, 0x0300, 0x1F68, 0x0301,
	0x1F69, 0x0301, 0x1F68, 0x0342, 0x1F69, 0x0342, 0x03B1, 0x0300,
	0x03B5, 0x0300, 0x03B7, 0x0300, 0x03B9, 0x0300, 0x03BF, 0x0300,
	0x03C5, 0x0300, 0x03C9, 0x0300, 0x1F00, 0x0345, 0x1F01, 0x0345,
	0x1F02, 0x0345, 0x1F03, 0x0345, 0x1F04, 0x0345, 0x1F05, 0x0345,
	0x1F06, 0x0345, 0x1F07, 0x0345, 0x1F08, 0x0345, 0x1F09, 0x0345,
	0x1F0A, 0x0345, 0x1F0B, 0x0345, 0x1F0C, 0x0345, 0x1F0D, 0x0345,
	0x1F0E, 0x0345, 0x1F0F, 0x0345, 0x1F20, 0x0345, 0x1F21, 0x0345,
	0x1F22, 0x0345, 0x1F23, 0x0345, 0x1F24, 0x0345, 0x1F25, 0x0345,
	0x1F26, 0x0345, 0x1F27, 0x0345, 0x1F28, 0x0345, 0x1F29, 0x0345,
	0x1F2A, 0x0345, 0x1F2B, 0x0345, 0x1F2C, 0x0345, 0x1F2D, 0x0345,
	0x1F2E, 0x0345, 0x1F2F, 0x0345, 0x1F60, 0x0345, 0x1F61, 0x0345,
	0x1F62, 0x0345, 0x1F63, 0x0345, 0x1F64, 0x0345, 0x1F65, 0x0345,
	0x1F66, 0x0345, 0x1F67, 0x0345, 0x1F68, 0x0345, 0x1F69, 0x0345,
	0x1F6A, 0x0345, 0x1F6B, 0x0345, 0x1F6C, 0x0345, 0x1F6D, 0x0345,
	0x1F6E, 0x0345, 0x1F6F, 0x0345, 0x03B1, 0x0306, 0x03B1, 0x0304,
	0x1F70, 0x0345, 0x03B1, 0x0345, 0x03AC, 0x0345, 0x03B1, 0x0342,
	0x1FB6, 0x0345, 0x0391, 0x0306, 0x0391, 0x0304, 0x0391, 0x0300,
	0x0391, 0x0345, 0x00A8, 0x0342, 0x1F74, 0x0345, 0x03B7, 0x0345,
	0x03AE, 0x0345, 0x03B7, 0x0342, 0x1FC6, 0x0345, 0x0395, 0x0300,
	0x0397, 0x0300, 0x0397, 0x0345, 0x1FBF, 0x0300, 0x1FBF, 0x0301,
	0x1FBF, 0x0342, 0x03B9, 0x0306, 0x03B9, 0x0304, 0x03CA, 0x0300,
	0x03B9, 0x0342, 0x03CA, 0x0342, 0x0399, 0x0306, 0x0399, 0x0304,
	0x0399, 0x0300, 0x1FFE, 0x0300, 0x1FFE, 0x0301, 0x1FFE, 0x0342,
	0x03C5, 0x0306, 0x03C5, 0x0304, 0x03CB, 0x0300, 0x03C1, 0x0313,
	0x03C1, 0x0314, 0x03C5, 0x0342, 0x03CB, 0x0342, 0x03A5, 0x0306,
	0x03A5, 0x0304, 0x03A5, 0x0300, 0x03A1, 0x0314, 0x00A8, 0x0300,
	0x1F7C, 0x0345, 0x03C9, 0x0345, 0x03CE, 0x0345, 0x03C9, 0x0342,
	0x1FF6, 0x0345, 0x039F, 0x0300, 0x03A9, 0x0300, 0x03A9, 0x0345,
	0x304B, 0x3099, 0x304D, 0x3099, 0x304F, 0x3099, 0x3051, 0x3099,
	0x3053, 0x3099, 0x3055, 0x3099, 0x3057, 0x3099, 0x3059, 0x3099,
	0x305B, 0x3099, 0x305D, 0x3099, 0x305F, 0x3099, 0x3061, 0x3099,
	0x3064, 0x3099, 0x3066, 0x3099, 0x3068, 0x3099, 0x306F, 0x3099,
	0x306F, 0x309A, 0x3072, 0x3099, 0x3072, 0x309A, 0x3075, 0x3099,
	0x3075, 0x309A, 0x3078, 0x3099, 0x3078, 0x309A, 0x307B, 0x3099,
	0x307B, 0x309A, 0x3046, 0x3099, 0x309D, 0x3099, 0x30AB, 0x3099,
	0x30AD, 0x3099, 0x30AF, 0x3099, 0x30B1, 0x3099, 0x30B3, 0x3099,
	0x30B5, 0x3099, 0x30B7, 0x3099, 0x30B9, 0x3099, 0x30BB, 0x3099,
	0x30BD, 0x3099, 0x30BF, 0x3099, 0x30C1, 0x3099, 0x30C4, 0x3099,
	0x30C6, 0x3099, 0x30C8, 0x3099, 0x30CF, 0x3099, 0x30CF, 0x309A,
	0x30D2, 0x3099, 0x30D2, 0x309A, 0x30D5, 0x3099, 0x30D5, 0x309A,
	0x30D8, 0x3099, 0x30D8, 0x309A, 0x30DB, 0x3099, 0x30DB, 0x309A,
	0x30A6, 0x3099, 0x30EF, 0x3099, 0x30F0, 0x3099, 0x30F1, 0x3099,
	0x30F2, 0x3099, 0x30FD, 0x3099, 0x05D9, 0x05B4, 0x05F2, 0x05B7,
	0x05E9, 0x05C1, 0x05E9, 0x05C2, 0xFB49, 0x05C1, 0xFB49, 0x05C2,
	0x05D0, 0x05B7, 0x05D0, 0x05B8, 0x05D0, 0x05BC, 0x05D1, 0x05BC,
	0x05D2, 0x05BC, 0x05D3, 0x05BC, 0x05D4, 0x05BC, 0x05D5, 0x05BC,
	0x05D6, 0x05BC, 0x05D8, 0x05BC, 0x05D9, 0x05BC, 0x05DA, 0x05BC,
	0x05DB, 0x05BC, 0x05DC, 0x05BC, 0x05DE, 0x05BC, 0x05E0, 0x05BC,
	0x05E1, 0x05BC, 0x05E3, 0x05BC, 0x05E4, 0x05BC, 0x05E6, 0x05BC,
	0x05E7, 0x05BC, 0x05E8, 0x05BC, 0x05E9, 0x05BC, 0x05EA, 0x05BC,
	0x05D5, 0x05B9, 0x05D1, 0x05BF, 0x05DB, 0x05BF, 0x05E4, 0x05BF
};

static const u_int8_t
__CFUniCharDecomposableBitmap[] = {
	0x01, 0x02, 0x03, 0x04, 0x05, 0x00, 0x06, 0x00,
	0x00, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x00, 0x0C,
	0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x0F,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x11,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x00,

	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xBF, 0xFF, 0x7E, 0x3E, 0xBF, 0xFF, 0x7E, 0xBE,
	0xFF, 0xFF, 0xFC, 0xFF, 0x3F, 0xFF, 0xF1, 0x7E,
	0xF8, 0xF1, 0xF3, 0xFF, 0x3F, 0xFF, 0xFF, 0x7F,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x01, 0x00,
	0x00, 0xE0, 0xFF, 0xDF, 0xCF, 0xFF, 0x31, 0xFF,
	0xFF, 0xFF, 0xFF, 0xCF, 0xC0, 0xFF, 0x0F, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x40,
	0xE0, 0xD7, 0x01, 0x00, 0x00, 0xFC, 0x01, 0x00,
	0x00, 0x7C, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x8B, 0x70, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02,
	0x00, 0x00, 0x8B, 0x70, 0x00, 0x00, 0xC0, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x06, 0x00, 0xCF, 0xFC, 0xFC, 0xFC, 0x3F, 0x03,
	0x00, 0x00, 0x00, 0x00, 0x7C, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x05, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x12, 0x00,
	0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x18, 0x00, 0xB0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x00,
	0x00, 0x00, 0x00, 0x4E, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x19, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x81, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x08, 0x20, 0x84, 0x10, 0x00, 0x02, 0x68, 0x01,
	0x02, 0x00, 0x08, 0x20, 0x84, 0x10, 0x00, 0x02,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0x0B, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x03,
	0xFF, 0xFF, 0x3F, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF,
	0x3F, 0x3F, 0xFF, 0xAA, 0xFF, 0xFF, 0xFF, 0x3F,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDF, 0x5F,
	0xDE, 0xFF, 0xCF, 0xEF, 0xFF, 0xFF, 0xDC, 0x3F,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x50, 0x55, 0x55, 0xA5, 0x02, 0xDB, 0x36,
	0x00, 0x00, 0x10, 0x40, 0x00, 0x50, 0x55, 0x55,
	0xA5, 0x02, 0xDB, 0x36, 0x00, 0x00, 0x90, 0x47,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xA0, 0x00, 0xFC, 0x7F, 0x5F,
	0xDB, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const u_int32_t
__CFUniCharPrecompSourceTable[] = {
	0x00000300, 0x00540000, 0x00000301, 0x00750054,
	0x00000302, 0x002000C9, 0x00000303, 0x001C00E9,
	0x00000304, 0x002C0105, 0x00000306, 0x00200131,
	0x00000307, 0x002E0151, 0x00000308, 0x0036017F,
	0x00000309, 0x001801B5, 0x0000030A, 0x000601CD,
	0x0000030B, 0x000601D3, 0x0000030C, 0x002501D9,
	0x0000030F, 0x000E01FE, 0x00000311, 0x000C020C,
	0x00000313, 0x000E0218, 0x00000314, 0x00100226,
	0x0000031B, 0x00040236, 0x00000323, 0x002A023A,
	0x00000324, 0x00020264, 0x00000325, 0x00020266,
	0x00000326, 0x00040268, 0x00000327, 0x0016026C,
	0x00000328, 0x000A0282, 0x0000032D, 0x000C028C,
	0x0000032E, 0x00020298, 0x00000330, 0x0006029A,
	0x00000331, 0x001102A0, 0x00000338, 0x002C02B1,
	0x00000342, 0x001D02DD, 0x00000345, 0x003F02FA,
	0x00000653, 0x00010339, 0x00000654, 0x0006033A,
	0x00000655, 0x00010340, 0x0000093C, 0x00030341,
	0x000009BE, 0x00010344, 0x000009D7, 0x00010345,
	0x00000B3E, 0x00010346, 0x00000B56, 0x00010347,
	0x00000B57, 0x00010348, 0x00000BBE, 0x00020349,
	0x00000BD7, 0x0002034B, 0x00000C56, 0x0001034D,
	0x00000CC2, 0x0001034E, 0x00000CD5, 0x0003034F,
	0x00000CD6, 0x00010352, 0x00000D3E, 0x00020353,
	0x00000D57, 0x00010355, 0x00000DCA, 0x00020356,
	0x00000DCF, 0x00010358, 0x00000DDF, 0x00010359,
	0x0000102E, 0x0001035A, 0x00003099, 0x0030035B,
	0x0000309A, 0x000A038B
};

static const u_int32_t __CFUniCharPrecompositionTableLength =
		(sizeof(__CFUniCharPrecompSourceTable) / (sizeof(u_int32_t) * 2));


static const u_int16_t
__CFUniCharBMPPrecompDestinationTable[] = {
	0x0041, 0x00C0, 0x0045, 0x00C8, 0x0049, 0x00CC, 0x004E, 0x01F8,
	0x004F, 0x00D2, 0x0055, 0x00D9, 0x0057, 0x1E80, 0x0059, 0x1EF2,
	0x0061, 0x00E0, 0x0065, 0x00E8, 0x0069, 0x00EC, 0x006E, 0x01F9,
	0x006F, 0x00F2, 0x0075, 0x00F9, 0x0077, 0x1E81, 0x0079, 0x1EF3,
	0x00A8, 0x1FED, 0x00C2, 0x1EA6, 0x00CA, 0x1EC0, 0x00D4, 0x1ED2,
	0x00DC, 0x01DB, 0x00E2, 0x1EA7, 0x00EA, 0x1EC1, 0x00F4, 0x1ED3,
	0x00FC, 0x01DC, 0x0102, 0x1EB0, 0x0103, 0x1EB1, 0x0112, 0x1E14,
	0x0113, 0x1E15, 0x014C, 0x1E50, 0x014D, 0x1E51, 0x01A0, 0x1EDC,
	0x01A1, 0x1EDD, 0x01AF, 0x1EEA, 0x01B0, 0x1EEB, 0x0391, 0x1FBA,
	0x0395, 0x1FC8, 0x0397, 0x1FCA, 0x0399, 0x1FDA, 0x039F, 0x1FF8,
	0x03A5, 0x1FEA, 0x03A9, 0x1FFA, 0x03B1, 0x1F70, 0x03B5, 0x1F72,
	0x03B7, 0x1F74, 0x03B9, 0x1F76, 0x03BF, 0x1F78, 0x03C5, 0x1F7A,
	0x03C9, 0x1F7C, 0x03CA, 0x1FD2, 0x03CB, 0x1FE2, 0x0415, 0x0400,
	0x0418, 0x040D, 0x0435, 0x0450, 0x0438, 0x045D, 0x1F00, 0x1F02,
	0x1F01, 0x1F03, 0x1F08, 0x1F0A, 0x1F09, 0x1F0B, 0x1F10, 0x1F12,
	0x1F11, 0x1F13, 0x1F18, 0x1F1A, 0x1F19, 0x1F1B, 0x1F20, 0x1F22,
	0x1F21, 0x1F23, 0x1F28, 0x1F2A, 0x1F29, 0x1F2B, 0x1F30, 0x1F32,
	0x1F31, 0x1F33, 0x1F38, 0x1F3A, 0x1F39, 0x1F3B, 0x1F40, 0x1F42,
	0x1F41, 0x1F43, 0x1F48, 0x1F4A, 0x1F49, 0x1F4B, 0x1F50, 0x1F52,
	0x1F51, 0x1F53, 0x1F59, 0x1F5B, 0x1F60, 0x1F62, 0x1F61, 0x1F63,
	0x1F68, 0x1F6A, 0x1F69, 0x1F6B, 0x1FBF, 0x1FCD, 0x1FFE, 0x1FDD,
	0x0041, 0x00C1, 0x0043, 0x0106, 0x0045, 0x00C9, 0x0047, 0x01F4,
	0x0049, 0x00CD, 0x004B, 0x1E30, 0x004C, 0x0139, 0x004D, 0x1E3E,
	0x004E, 0x0143, 0x004F, 0x00D3, 0x0050, 0x1E54, 0x0052, 0x0154,
	0x0053, 0x015A, 0x0055, 0x00DA, 0x0057, 0x1E82, 0x0059, 0x00DD,
	0x005A, 0x0179, 0x0061, 0x00E1, 0x0063, 0x0107, 0x0065, 0x00E9,
	0x0067, 0x01F5, 0x0069, 0x00ED, 0x006B, 0x1E31, 0x006C, 0x013A,
	0x006D, 0x1E3F, 0x006E, 0x0144, 0x006F, 0x00F3, 0x0070, 0x1E55,
	0x0072, 0x0155, 0x0073, 0x015B, 0x0075, 0x00FA, 0x0077, 0x1E83,
	0x0079, 0x00FD, 0x007A, 0x017A, 0x00A8, 0x0385, 0x00C2, 0x1EA4,
	0x00C5, 0x01FA, 0x00C6, 0x01FC, 0x00C7, 0x1E08, 0x00CA, 0x1EBE,
	0x00CF, 0x1E2E, 0x00D4, 0x1ED0, 0x00D5, 0x1E4C, 0x00D8, 0x01FE,
	0x00DC, 0x01D7, 0x00E2, 0x1EA5, 0x00E5, 0x01FB, 0x00E6, 0x01FD,
	0x00E7, 0x1E09, 0x00EA, 0x1EBF, 0x00EF, 0x1E2F, 0x00F4, 0x1ED1,
	0x00F5, 0x1E4D, 0x00F8, 0x01FF, 0x00FC, 0x01D8, 0x0102, 0x1EAE,
	0x0103, 0x1EAF, 0x0112, 0x1E16, 0x0113, 0x1E17, 0x014C, 0x1E52,
	0x014D, 0x1E53, 0x0168, 0x1E78, 0x0169, 0x1E79, 0x01A0, 0x1EDA,
	0x01A1, 0x1EDB, 0x01AF, 0x1EE8, 0x01B0, 0x1EE9, 0x0391, 0x0386,
	0x0395, 0x0388, 0x0397, 0x0389, 0x0399, 0x038A, 0x039F, 0x038C,
	0x03A5, 0x038E, 0x03A9, 0x038F, 0x03B1, 0x03AC, 0x03B5, 0x03AD,
	0x03B7, 0x03AE, 0x03B9, 0x03AF, 0x03BF, 0x03CC, 0x03C5, 0x03CD,
	0x03C9, 0x03CE, 0x03CA, 0x0390, 0x03CB, 0x03B0, 0x03D2, 0x03D3,
	0x0413, 0x0403, 0x041A, 0x040C, 0x0433, 0x0453, 0x043A, 0x045C,
	0x1F00, 0x1F04, 0x1F01, 0x1F05, 0x1F08, 0x1F0C, 0x1F09, 0x1F0D,
	0x1F10, 0x1F14, 0x1F11, 0x1F15, 0x1F18, 0x1F1C, 0x1F19, 0x1F1D,
	0x1F20, 0x1F24, 0x1F21, 0x1F25, 0x1F28, 0x1F2C, 0x1F29, 0x1F2D,
	0x1F30, 0x1F34, 0x1F31, 0x1F35, 0x1F38, 0x1F3C, 0x1F39, 0x1F3D,
	0x1F40, 0x1F44, 0x1F41, 0x1F45, 0x1F48, 0x1F4C, 0x1F49, 0x1F4D,
	0x1F50, 0x1F54, 0x1F51, 0x1F55, 0x1F59, 0x1F5D, 0x1F60, 0x1F64,
	0x1F61, 0x1F65, 0x1F68, 0x1F6C, 0x1F69, 0x1F6D, 0x1FBF, 0x1FCE,
	0x1FFE, 0x1FDE, 0x0041, 0x00C2, 0x0043, 0x0108, 0x0045, 0x00CA,
	0x0047, 0x011C, 0x0048, 0x0124, 0x0049, 0x00CE, 0x004A, 0x0134,
	0x004F, 0x00D4, 0x0053, 0x015C, 0x0055, 0x00DB, 0x0057, 0x0174,
	0x0059, 0x0176, 0x005A, 0x1E90, 0x0061, 0x00E2, 0x0063, 0x0109,
	0x0065, 0x00EA, 0x0067, 0x011D, 0x0068, 0x0125, 0x0069, 0x00EE,
	0x006A, 0x0135, 0x006F, 0x00F4, 0x0073, 0x015D, 0x0075, 0x00FB,
	0x0077, 0x0175, 0x0079, 0x0177, 0x007A, 0x1E91, 0x1EA0, 0x1EAC,
	0x1EA1, 0x1EAD, 0x1EB8, 0x1EC6, 0x1EB9, 0x1EC7, 0x1ECC, 0x1ED8,
	0x1ECD, 0x1ED9, 0x0041, 0x00C3, 0x0045, 0x1EBC, 0x0049, 0x0128,
	0x004E, 0x00D1, 0x004F, 0x00D5, 0x0055, 0x0168, 0x0056, 0x1E7C,
	0x0059, 0x1EF8, 0x0061, 0x00E3, 0x0065, 0x1EBD, 0x0069, 0x0129,
	0x006E, 0x00F1, 0x006F, 0x00F5, 0x0075, 0x0169, 0x0076, 0x1E7D,
	0x0079, 0x1EF9, 0x00C2, 0x1EAA, 0x00CA, 0x1EC4, 0x00D4, 0x1ED6,
	0x00E2, 0x1EAB, 0x00EA, 0x1EC5, 0x00F4, 0x1ED7, 0x0102, 0x1EB4,
	0x0103, 0x1EB5, 0x01A0, 0x1EE0, 0x01A1, 0x1EE1, 0x01AF, 0x1EEE,
	0x01B0, 0x1EEF, 0x0041, 0x0100, 0x0045, 0x0112, 0x0047, 0x1E20,
	0x0049, 0x012A, 0x004F, 0x014C, 0x0055, 0x016A, 0x0059, 0x0232,
	0x0061, 0x0101, 0x0065, 0x0113, 0x0067, 0x1E21, 0x0069, 0x012B,
	0x006F, 0x014D, 0x0075, 0x016B, 0x0079, 0x0233, 0x00C4, 0x01DE,
	0x00C6, 0x01E2, 0x00D5, 0x022C, 0x00D6, 0x022A, 0x00DC, 0x01D5,
	0x00E4, 0x01DF, 0x00E6, 0x01E3, 0x00F5, 0x022D, 0x00F6, 0x022B,
	0x00FC, 0x01D6, 0x01EA, 0x01EC, 0x01EB, 0x01ED, 0x0226, 0x01E0,
	0x0227, 0x01E1, 0x022E, 0x0230, 0x022F, 0x0231, 0x0391, 0x1FB9,
	0x0399, 0x1FD9, 0x03A5, 0x1FE9, 0x03B1, 0x1FB1, 0x03B9, 0x1FD1,
	0x03C5, 0x1FE1, 0x0418, 0x04E2, 0x0423, 0x04EE, 0x0438, 0x04E3,
	0x0443, 0x04EF, 0x1E36, 0x1E38, 0x1E37, 0x1E39, 0x1E5A, 0x1E5C,
	0x1E5B, 0x1E5D, 0x0041, 0x0102, 0x0045, 0x0114, 0x0047, 0x011E,
	0x0049, 0x012C, 0x004F, 0x014E, 0x0055, 0x016C, 0x0061, 0x0103,
	0x0065, 0x0115, 0x0067, 0x011F, 0x0069, 0x012D, 0x006F, 0x014F,
	0x0075, 0x016D, 0x0228, 0x1E1C, 0x0229, 0x1E1D, 0x0391, 0x1FB8,
	0x0399, 0x1FD8, 0x03A5, 0x1FE8, 0x03B1, 0x1FB0, 0x03B9, 0x1FD0,
	0x03C5, 0x1FE0, 0x0410, 0x04D0, 0x0415, 0x04D6, 0x0416, 0x04C1,
	0x0418, 0x0419, 0x0423, 0x040E, 0x0430, 0x04D1, 0x0435, 0x04D7,
	0x0436, 0x04C2, 0x0438, 0x0439, 0x0443, 0x045E, 0x1EA0, 0x1EB6,
	0x1EA1, 0x1EB7, 0x0041, 0x0226, 0x0042, 0x1E02, 0x0043, 0x010A,
	0x0044, 0x1E0A, 0x0045, 0x0116, 0x0046, 0x1E1E, 0x0047, 0x0120,
	0x0048, 0x1E22, 0x0049, 0x0130, 0x004D, 0x1E40, 0x004E, 0x1E44,
	0x004F, 0x022E, 0x0050, 0x1E56, 0x0052, 0x1E58, 0x0053, 0x1E60,
	0x0054, 0x1E6A, 0x0057, 0x1E86, 0x0058, 0x1E8A, 0x0059, 0x1E8E,
	0x005A, 0x017B, 0x0061, 0x0227, 0x0062, 0x1E03, 0x0063, 0x010B,
	0x0064, 0x1E0B, 0x0065, 0x0117, 0x0066, 0x1E1F, 0x0067, 0x0121,
	0x0068, 0x1E23, 0x006D, 0x1E41, 0x006E, 0x1E45, 0x006F, 0x022F,
	0x0070, 0x1E57, 0x0072, 0x1E59, 0x0073, 0x1E61, 0x0074, 0x1E6B,
	0x0077, 0x1E87, 0x0078, 0x1E8B, 0x0079, 0x1E8F, 0x007A, 0x017C,
	0x015A, 0x1E64, 0x015B, 0x1E65, 0x0160, 0x1E66, 0x0161, 0x1E67,
	0x017F, 0x1E9B, 0x1E62, 0x1E68, 0x1E63, 0x1E69, 0x0041, 0x00C4,
	0x0045, 0x00CB, 0x0048, 0x1E26, 0x0049, 0x00CF, 0x004F, 0x00D6,
	0x0055, 0x00DC, 0x0057, 0x1E84, 0x0058, 0x1E8C, 0x0059, 0x0178,
	0x0061, 0x00E4, 0x0065, 0x00EB, 0x0068, 0x1E27, 0x0069, 0x00EF,
	0x006F, 0x00F6, 0x0074, 0x1E97, 0x0075, 0x00FC, 0x0077, 0x1E85,
	0x0078, 0x1E8D, 0x0079, 0x00FF, 0x00D5, 0x1E4E, 0x00F5, 0x1E4F,
	0x016A, 0x1E7A, 0x016B, 0x1E7B, 0x0399, 0x03AA, 0x03A5, 0x03AB,
	0x03B9, 0x03CA, 0x03C5, 0x03CB, 0x03D2, 0x03D4, 0x0406, 0x0407,
	0x0410, 0x04D2, 0x0415, 0x0401, 0x0416, 0x04DC, 0x0417, 0x04DE,
	0x0418, 0x04E4, 0x041E, 0x04E6, 0x0423, 0x04F0, 0x0427, 0x04F4,
	0x042B, 0x04F8, 0x042D, 0x04EC, 0x0430, 0x04D3, 0x0435, 0x0451,
	0x0436, 0x04DD, 0x0437, 0x04DF, 0x0438, 0x04E5, 0x043E, 0x04E7,
	0x0443, 0x04F1, 0x0447, 0x04F5, 0x044B, 0x04F9, 0x044D, 0x04ED,
	0x0456, 0x0457, 0x04D8, 0x04DA, 0x04D9, 0x04DB, 0x04E8, 0x04EA,
	0x04E9, 0x04EB, 0x0041, 0x1EA2, 0x0045, 0x1EBA, 0x0049, 0x1EC8,
	0x004F, 0x1ECE, 0x0055, 0x1EE6, 0x0059, 0x1EF6, 0x0061, 0x1EA3,
	0x0065, 0x1EBB, 0x0069, 0x1EC9, 0x006F, 0x1ECF, 0x0075, 0x1EE7,
	0x0079, 0x1EF7, 0x00C2, 0x1EA8, 0x00CA, 0x1EC2, 0x00D4, 0x1ED4,
	0x00E2, 0x1EA9, 0x00EA, 0x1EC3, 0x00F4, 0x1ED5, 0x0102, 0x1EB2,
	0x0103, 0x1EB3, 0x01A0, 0x1EDE, 0x01A1, 0x1EDF, 0x01AF, 0x1EEC,
	0x01B0, 0x1EED, 0x0041, 0x00C5, 0x0055, 0x016E, 0x0061, 0x00E5,
	0x0075, 0x016F, 0x0077, 0x1E98, 0x0079, 0x1E99, 0x004F, 0x0150,
	0x0055, 0x0170, 0x006F, 0x0151, 0x0075, 0x0171, 0x0423, 0x04F2,
	0x0443, 0x04F3, 0x0041, 0x01CD, 0x0043, 0x010C, 0x0044, 0x010E,
	0x0045, 0x011A, 0x0047, 0x01E6, 0x0048, 0x021E, 0x0049, 0x01CF,
	0x004B, 0x01E8, 0x004C, 0x013D, 0x004E, 0x0147, 0x004F, 0x01D1,
	0x0052, 0x0158, 0x0053, 0x0160, 0x0054, 0x0164, 0x0055, 0x01D3,
	0x005A, 0x017D, 0x0061, 0x01CE, 0x0063, 0x010D, 0x0064, 0x010F,
	0x0065, 0x011B, 0x0067, 0x01E7, 0x0068, 0x021F, 0x0069, 0x01D0,
	0x006A, 0x01F0, 0x006B, 0x01E9, 0x006C, 0x013E, 0x006E, 0x0148,
	0x006F, 0x01D2, 0x0072, 0x0159, 0x0073, 0x0161, 0x0074, 0x0165,
	0x0075, 0x01D4, 0x007A, 0x017E, 0x00DC, 0x01D9, 0x00FC, 0x01DA,
	0x01B7, 0x01EE, 0x0292, 0x01EF, 0x0041, 0x0200, 0x0045, 0x0204,
	0x0049, 0x0208, 0x004F, 0x020C, 0x0052, 0x0210, 0x0055, 0x0214,
	0x0061, 0x0201, 0x0065, 0x0205, 0x0069, 0x0209, 0x006F, 0x020D,
	0x0072, 0x0211, 0x0075, 0x0215, 0x0474, 0x0476, 0x0475, 0x0477,
	0x0041, 0x0202, 0x0045, 0x0206, 0x0049, 0x020A, 0x004F, 0x020E,
	0x0052, 0x0212, 0x0055, 0x0216, 0x0061, 0x0203, 0x0065, 0x0207,
	0x0069, 0x020B, 0x006F, 0x020F, 0x0072, 0x0213, 0x0075, 0x0217,
	0x0391, 0x1F08, 0x0395, 0x1F18, 0x0397, 0x1F28, 0x0399, 0x1F38,
	0x039F, 0x1F48, 0x03A9, 0x1F68, 0x03B1, 0x1F00, 0x03B5, 0x1F10,
	0x03B7, 0x1F20, 0x03B9, 0x1F30, 0x03BF, 0x1F40, 0x03C1, 0x1FE4,
	0x03C5, 0x1F50, 0x03C9, 0x1F60, 0x0391, 0x1F09, 0x0395, 0x1F19,
	0x0397, 0x1F29, 0x0399, 0x1F39, 0x039F, 0x1F49, 0x03A1, 0x1FEC,
	0x03A5, 0x1F59, 0x03A9, 0x1F69, 0x03B1, 0x1F01, 0x03B5, 0x1F11,
	0x03B7, 0x1F21, 0x03B9, 0x1F31, 0x03BF, 0x1F41, 0x03C1, 0x1FE5,
	0x03C5, 0x1F51, 0x03C9, 0x1F61, 0x004F, 0x01A0, 0x0055, 0x01AF,
	0x006F, 0x01A1, 0x0075, 0x01B0, 0x0041, 0x1EA0, 0x0042, 0x1E04,
	0x0044, 0x1E0C, 0x0045, 0x1EB8, 0x0048, 0x1E24, 0x0049, 0x1ECA,
	0x004B, 0x1E32, 0x004C, 0x1E36, 0x004D, 0x1E42, 0x004E, 0x1E46,
	0x004F, 0x1ECC, 0x0052, 0x1E5A, 0x0053, 0x1E62, 0x0054, 0x1E6C,
	0x0055, 0x1EE4, 0x0056, 0x1E7E, 0x0057, 0x1E88, 0x0059, 0x1EF4,
	0x005A, 0x1E92, 0x0061, 0x1EA1, 0x0062, 0x1E05, 0x0064, 0x1E0D,
	0x0065, 0x1EB9, 0x0068, 0x1E25, 0x0069, 0x1ECB, 0x006B, 0x1E33,
	0x006C, 0x1E37, 0x006D, 0x1E43, 0x006E, 0x1E47, 0x006F, 0x1ECD,
	0x0072, 0x1E5B, 0x0073, 0x1E63, 0x0074, 0x1E6D, 0x0075, 0x1EE5,
	0x0076, 0x1E7F, 0x0077, 0x1E89, 0x0079, 0x1EF5, 0x007A, 0x1E93,
	0x01A0, 0x1EE2, 0x01A1, 0x1EE3, 0x01AF, 0x1EF0, 0x01B0, 0x1EF1,
	0x0055, 0x1E72, 0x0075, 0x1E73, 0x0041, 0x1E00, 0x0061, 0x1E01,
	0x0053, 0x0218, 0x0054, 0x021A, 0x0073, 0x0219, 0x0074, 0x021B,
	0x0043, 0x00C7, 0x0044, 0x1E10, 0x0045, 0x0228, 0x0047, 0x0122,
	0x0048, 0x1E28, 0x004B, 0x0136, 0x004C, 0x013B, 0x004E, 0x0145,
	0x0052, 0x0156, 0x0053, 0x015E, 0x0054, 0x0162, 0x0063, 0x00E7,
	0x0064, 0x1E11, 0x0065, 0x0229, 0x0067, 0x0123, 0x0068, 0x1E29,
	0x006B, 0x0137, 0x006C, 0x013C, 0x006E, 0x0146, 0x0072, 0x0157,
	0x0073, 0x015F, 0x0074, 0x0163, 0x0041, 0x0104, 0x0045, 0x0118,
	0x0049, 0x012E, 0x004F, 0x01EA, 0x0055, 0x0172, 0x0061, 0x0105,
	0x0065, 0x0119, 0x0069, 0x012F, 0x006F, 0x01EB, 0x0075, 0x0173,
	0x0044, 0x1E12, 0x0045, 0x1E18, 0x004C, 0x1E3C, 0x004E, 0x1E4A,
	0x0054, 0x1E70, 0x0055, 0x1E76, 0x0064, 0x1E13, 0x0065, 0x1E19,
	0x006C, 0x1E3D, 0x006E, 0x1E4B, 0x0074, 0x1E71, 0x0075, 0x1E77,
	0x0048, 0x1E2A, 0x0068, 0x1E2B, 0x0045, 0x1E1A, 0x0049, 0x1E2C,
	0x0055, 0x1E74, 0x0065, 0x1E1B, 0x0069, 0x1E2D, 0x0075, 0x1E75,
	0x0042, 0x1E06, 0x0044, 0x1E0E, 0x004B, 0x1E34, 0x004C, 0x1E3A,
	0x004E, 0x1E48, 0x0052, 0x1E5E, 0x0054, 0x1E6E, 0x005A, 0x1E94,
	0x0062, 0x1E07, 0x0064, 0x1E0F, 0x0068, 0x1E96, 0x006B, 0x1E35,
	0x006C, 0x1E3B, 0x006E, 0x1E49, 0x0072, 0x1E5F, 0x0074, 0x1E6F,
	0x007A, 0x1E95, 0x003C, 0x226E, 0x003D, 0x2260, 0x003E, 0x226F,
	0x2190, 0x219A, 0x2192, 0x219B, 0x2194, 0x21AE, 0x21D0, 0x21CD,
	0x21D2, 0x21CF, 0x21D4, 0x21CE, 0x2203, 0x2204, 0x2208, 0x2209,
	0x220B, 0x220C, 0x2223, 0x2224, 0x2225, 0x2226, 0x223C, 0x2241,
	0x2243, 0x2244, 0x2245, 0x2247, 0x2248, 0x2249, 0x224D, 0x226D,
	0x2261, 0x2262, 0x2264, 0x2270, 0x2265, 0x2271, 0x2272, 0x2274,
	0x2273, 0x2275, 0x2276, 0x2278, 0x2277, 0x2279, 0x227A, 0x2280,
	0x227B, 0x2281, 0x227C, 0x22E0, 0x227D, 0x22E1, 0x2282, 0x2284,
	0x2283, 0x2285, 0x2286, 0x2288, 0x2287, 0x2289, 0x2291, 0x22E2,
	0x2292, 0x22E3, 0x22A2, 0x22AC, 0x22A8, 0x22AD, 0x22A9, 0x22AE,
	0x22AB, 0x22AF, 0x22B2, 0x22EA, 0x22B3, 0x22EB, 0x22B4, 0x22EC,
	0x22B5, 0x22ED, 0x00A8, 0x1FC1, 0x03B1, 0x1FB6, 0x03B7, 0x1FC6,
	0x03B9, 0x1FD6, 0x03C5, 0x1FE6, 0x03C9, 0x1FF6, 0x03CA, 0x1FD7,
	0x03CB, 0x1FE7, 0x1F00, 0x1F06, 0x1F01, 0x1F07, 0x1F08, 0x1F0E,
	0x1F09, 0x1F0F, 0x1F20, 0x1F26, 0x1F21, 0x1F27, 0x1F28, 0x1F2E,
	0x1F29, 0x1F2F, 0x1F30, 0x1F36, 0x1F31, 0x1F37, 0x1F38, 0x1F3E,
	0x1F39, 0x1F3F, 0x1F50, 0x1F56, 0x1F51, 0x1F57, 0x1F59, 0x1F5F,
	0x1F60, 0x1F66, 0x1F61, 0x1F67, 0x1F68, 0x1F6E, 0x1F69, 0x1F6F,
	0x1FBF, 0x1FCF, 0x1FFE, 0x1FDF, 0x0391, 0x1FBC, 0x0397, 0x1FCC,
	0x03A9, 0x1FFC, 0x03AC, 0x1FB4, 0x03AE, 0x1FC4, 0x03B1, 0x1FB3,
	0x03B7, 0x1FC3, 0x03C9, 0x1FF3, 0x03CE, 0x1FF4, 0x1F00, 0x1F80,
	0x1F01, 0x1F81, 0x1F02, 0x1F82, 0x1F03, 0x1F83, 0x1F04, 0x1F84,
	0x1F05, 0x1F85, 0x1F06, 0x1F86, 0x1F07, 0x1F87, 0x1F08, 0x1F88,
	0x1F09, 0x1F89, 0x1F0A, 0x1F8A, 0x1F0B, 0x1F8B, 0x1F0C, 0x1F8C,
	0x1F0D, 0x1F8D, 0x1F0E, 0x1F8E, 0x1F0F, 0x1F8F, 0x1F20, 0x1F90,
	0x1F21, 0x1F91, 0x1F22, 0x1F92, 0x1F23, 0x1F93, 0x1F24, 0x1F94,
	0x1F25, 0x1F95, 0x1F26, 0x1F96, 0x1F27, 0x1F97, 0x1F28, 0x1F98,
	0x1F29, 0x1F99, 0x1F2A, 0x1F9A, 0x1F2B, 0x1F9B, 0x1F2C, 0x1F9C,
	0x1F2D, 0x1F9D, 0x1F2E, 0x1F9E, 0x1F2F, 0x1F9F, 0x1F60, 0x1FA0,
	0x1F61, 0x1FA1, 0x1F62, 0x1FA2, 0x1F63, 0x1FA3, 0x1F64, 0x1FA4,
	0x1F65, 0x1FA5, 0x1F66, 0x1FA6, 0x1F67, 0x1FA7, 0x1F68, 0x1FA8,
	0x1F69, 0x1FA9, 0x1F6A, 0x1FAA, 0x1F6B, 0x1FAB, 0x1F6C, 0x1FAC,
	0x1F6D, 0x1FAD, 0x1F6E, 0x1FAE, 0x1F6F, 0x1FAF, 0x1F70, 0x1FB2,
	0x1F74, 0x1FC2, 0x1F7C, 0x1FF2, 0x1FB6, 0x1FB7, 0x1FC6, 0x1FC7,
	0x1FF6, 0x1FF7, 0x0627, 0x0622, 0x0627, 0x0623, 0x0648, 0x0624,
	0x064A, 0x0626, 0x06C1, 0x06C2, 0x06D2, 0x06D3, 0x06D5, 0x06C0,
	0x0627, 0x0625, 0x0928, 0x0929, 0x0930, 0x0931, 0x0933, 0x0934,
	0x09C7, 0x09CB, 0x09C7, 0x09CC, 0x0B47, 0x0B4B, 0x0B47, 0x0B48,
	0x0B47, 0x0B4C, 0x0BC6, 0x0BCA, 0x0BC7, 0x0BCB, 0x0B92, 0x0B94,
	0x0BC6, 0x0BCC, 0x0C46, 0x0C48, 0x0CC6, 0x0CCA, 0x0CBF, 0x0CC0,
	0x0CC6, 0x0CC7, 0x0CCA, 0x0CCB, 0x0CC6, 0x0CC8, 0x0D46, 0x0D4A,
	0x0D47, 0x0D4B, 0x0D46, 0x0D4C, 0x0DD9, 0x0DDA, 0x0DDC, 0x0DDD,
	0x0DD9, 0x0DDC, 0x0DD9, 0x0DDE, 0x1025, 0x1026, 0x3046, 0x3094,
	0x304B, 0x304C, 0x304D, 0x304E, 0x304F, 0x3050, 0x3051, 0x3052,
	0x3053, 0x3054, 0x3055, 0x3056, 0x3057, 0x3058, 0x3059, 0x305A,
	0x305B, 0x305C, 0x305D, 0x305E, 0x305F, 0x3060, 0x3061, 0x3062,
	0x3064, 0x3065, 0x3066, 0x3067, 0x3068, 0x3069, 0x306F, 0x3070,
	0x3072, 0x3073, 0x3075, 0x3076, 0x3078, 0x3079, 0x307B, 0x307C,
	0x309D, 0x309E, 0x30A6, 0x30F4, 0x30AB, 0x30AC, 0x30AD, 0x30AE,
	0x30AF, 0x30B0, 0x30B1, 0x30B2, 0x30B3, 0x30B4, 0x30B5, 0x30B6,
	0x30B7, 0x30B8, 0x30B9, 0x30BA, 0x30BB, 0x30BC, 0x30BD, 0x30BE,
	0x30BF, 0x30C0, 0x30C1, 0x30C2, 0x30C4, 0x30C5, 0x30C6, 0x30C7,
	0x30C8, 0x30C9, 0x30CF, 0x30D0, 0x30D2, 0x30D3, 0x30D5, 0x30D6,
	0x30D8, 0x30D9, 0x30DB, 0x30DC, 0x30EF, 0x30F7, 0x30F0, 0x30F8,
	0x30F1, 0x30F9, 0x30F2, 0x30FA, 0x30FD, 0x30FE, 0x306F, 0x3071,
	0x3072, 0x3074, 0x3075, 0x3077, 0x3078, 0x307A, 0x307B, 0x307D,
	0x30CF, 0x30D1, 0x30D2, 0x30D4, 0x30D5, 0x30D7, 0x30D8, 0x30DA,
	0x30DB, 0x30DD
};

static const u_int8_t
__CFUniCharCombiningBitmap[] = {
	0x00, 0x00, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05,
	0x00, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C,
	0x0D, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E,
	0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x13, 0x00,

	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x78, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xFE, 0xFF, 0xFB, 0xFF, 0xFF, 0xBB,
	0x16, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xF8, 0x3F, 0x00, 0x00, 0x00, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xC0, 0xFF, 0x9F, 0x3D, 0x00, 0x00,
	0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0xFF, 0xFF,
	0xFF, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xC0, 0xFF, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD0,
	0xFF, 0x3F, 0x1E, 0x00, 0x0C, 0x00, 0x00, 0x00,
	0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD0,
	0x9F, 0x39, 0x80, 0x00, 0x0C, 0x00, 0x00, 0x00,
	0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD0,
	0x87, 0x39, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00,
	0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD0,
	0xBF, 0x3B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD0,
	0x8F, 0x39, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0,
	0xC7, 0x3D, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0,
	0xDF, 0x3D, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0,
	0xDF, 0x3D, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0,
	0xCF, 0x3D, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x84, 0x5F, 0xFF, 0x00, 0x00, 0x0C, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF2, 0x07,
	0x80, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF2, 0x1B,
	0x00, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0xA0, 0xC2,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0xFF,
	0xDF, 0x00, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0x1F,
	0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xC7, 0x03,
	0x00, 0x00, 0xC0, 0x03, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1C, 0x00,
	0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x0C, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0xFF,
	0xFF, 0xFF, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x07, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xFF, 0xFF, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xFE, 0xFF, 0x3F, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF,
	0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

static const u_int8_t
__CFUniCharCombiningPropertyBitmap[] = {
	0x00, 0x00, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05,
	0x00, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C,
	0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E,
	0x0F, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x13, 0x00, 0x00, 0x14, 0x00,
	0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 0xE6,
	0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 0xE6,
	0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 0xE8, 0xDC, 0xDC,
	0xDC, 0xDC, 0xE8, 0xD8, 0xDC, 0xDC, 0xDC, 0xDC,
	0xDC, 0xCA, 0xCA, 0xDC, 0xDC, 0xDC, 0xDC, 0xCA,
	0xCA, 0xDC, 0xDC, 0xDC, 0xDC, 0xDC, 0xDC, 0xDC,
	0xDC, 0xDC, 0xDC, 0xDC, 0x01, 0x01, 0x01, 0x01,
	0x01, 0xDC, 0xDC, 0xDC, 0xDC, 0xE6, 0xE6, 0xE6,
	0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 0xF0, 0xE6, 0xDC,
	0xDC, 0xDC, 0xE6, 0xE6, 0xE6, 0xDC, 0xDC, 0x00,
	0xE6, 0xE6, 0xE6, 0xDC, 0xDC, 0xDC, 0xDC, 0xE6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xEA, 0xEA, 0xE9,
	0xEA, 0xEA, 0xE9, 0xE6, 0xE6, 0xE6, 0xE6, 0xE6,
	0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 0xE6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xE6, 0xE6, 0xE6, 0xE6, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xDC, 0xE6, 0xE6, 0xE6, 0xE6, 0xDC, 0xE6,
	0xE6, 0xE6, 0xDE, 0xDC, 0xE6, 0xE6, 0xE6, 0xE6,
	0xE6, 0xE6, 0x00, 0xDC, 0xDC, 0xDC, 0xDC, 0xDC,
	0xE6, 0xE6, 0xDC, 0xE6, 0xE6, 0xDE, 0xE4, 0xE6,
	0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x10, 0x11,
	0x12, 0x13, 0x00, 0x14, 0x15, 0x16, 0x00, 0x17,
	0x00, 0x18, 0x19, 0x00, 0xE6, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F,
	0x20, 0x21, 0x22, 0xE6, 0xE6, 0xDC, 0xDC, 0xE6,
	0xE6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE6, 0xE6,
	0xE6, 0xE6, 0xE6, 0xE6, 0xE6, 0x00, 0x00, 0xE6,
	0xE6, 0xE6, 0xE6, 0xDC, 0xE6, 0x00, 0x00, 0xE6,
	0xE6, 0x00, 0xDC, 0xE6, 0xE6, 0xDC, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xE6, 0xDC, 0xE6, 0xE6, 0xDC, 0xE6, 0xE6, 0xDC,
	0xDC, 0xDC, 0xE6, 0xDC, 0xDC, 0xE6, 0xDC, 0xE6,
	0xE6, 0xE6, 0xDC, 0xE6, 0xDC, 0xE6, 0xDC, 0xE6,
	0xDC, 0xE6, 0xE6, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00,
	0x00, 0xE6, 0xDC, 0xE6, 0xE6, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x54, 0x5B, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x67, 0x67, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x6B, 0x6B, 0x6B, 0x6B, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x76, 0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7A, 0x7A, 0x7A, 0x7A, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xDC, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xDC, 0x00, 0xDC,
	0x00, 0xD8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x81, 0x82, 0x00, 0x84, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x82, 0x82, 0x82, 0x82, 0x00, 0x00,
	0x82, 0x00, 0xE6, 0xE6, 0x09, 0x00, 0xE6, 0xE6,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xDC, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07,
	0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xE6, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xE4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xDE, 0xE6, 0xDC, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xE6, 0xE6, 0x01, 0x01, 0xE6, 0xE6, 0xE6, 0xE6,
	0x01, 0x01, 0x01, 0xE6, 0xE6, 0x00, 0x00, 0x00,
	0x00, 0xE6, 0x00, 0x00, 0x00, 0x01, 0x01, 0xE6,
	0xDC, 0xE6, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xDA, 0xE4, 0xE8, 0xDE, 0xE0, 0xE0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xE6, 0xE6, 0xE6, 0xE6, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};


