/*
 * Copyright (c) 2004 Apple Computer, Inc. All rights reserved.
 * 
 * @APPLE_LICENSE_HEADER_START@ 
 * 
 * The contents of this file constitute Original Code as defined in and 
 * are subject to the Apple Public Source License Version 1.1 (the 
 * "License").  You may not use this file except in compliance with the 
 * License.  Please obtain a copy of the License at 
 * http://www.apple.com/publicsource and read it before using this file. 
 * 
 * This Original Code and all software distributed under the License are 
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER 
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES, 
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT.  Please see the 
 * License for the specific language governing rights and limitations 
 * under the License. 
 * 
 * @APPLE_LICENSE_HEADER_END@ 
 * 
 * 
 * System call switch table.
 *
 * DO NOT EDIT-- this file is automatically generated.
 * created from syscalls.master
 */

const char *syscallnames[] = {
	"syscall",            /* 0 = syscall indirect syscall */
	"exit",               /* 1 = exit */
	"fork",               /* 2 = fork */
	"read",               /* 3 = read */
	"write",              /* 4 = write */
	"open",               /* 5 = open */
	"close",              /* 6 = close */
	"wait4",              /* 7 = wait4 */
	"#8",                 /* 8 = old creat */
	"link",               /* 9 = link */
	"unlink",             /* 10 = unlink */
	"#11",                /* 11 = old execv */
	"chdir",              /* 12 = chdir */
	"fchdir",             /* 13 = fchdir */
	"mknod",              /* 14 = mknod */
	"chmod",              /* 15 = chmod */
	"chown",              /* 16 = chown */
	"obreak",             /* 17 = obreak old break */
#if COMPAT_GETFSSTAT
	"ogetfsstat",         /* 18 = ogetfsstat */
#else
	"getfsstat",          /* 18 = getfsstat */
#endif
	"#19",                /* 19 = old lseek */
	"getpid",             /* 20 = getpid */
	"#21",                /* 21 = old mount */
	"#22",                /* 22 = old umount */
	"setuid",             /* 23 = setuid */
	"getuid",             /* 24 = getuid */
	"geteuid",            /* 25 = geteuid */
	"ptrace",             /* 26 = ptrace */
	"recvmsg",            /* 27 = recvmsg */
	"sendmsg",            /* 28 = sendmsg */
	"recvfrom",           /* 29 = recvfrom */
	"accept",             /* 30 = accept */
	"getpeername",        /* 31 = getpeername */
	"getsockname",        /* 32 = getsockname */
	"access",             /* 33 = access */
	"chflags",            /* 34 = chflags */
	"fchflags",           /* 35 = fchflags */
	"sync",               /* 36 = sync */
	"kill",               /* 37 = kill */
	"#38",                /* 38 = old stat */
	"getppid",            /* 39 = getppid */
	"#40",                /* 40 = old lstat */
	"dup",                /* 41 = dup */
	"pipe",               /* 42 = pipe */
	"getegid",            /* 43 = getegid */
	"profil",             /* 44 = profil */
	"ktrace",             /* 45 = ktrace */
	"sigaction",          /* 46 = sigaction */
	"getgid",             /* 47 = getgid */
	"sigprocmask",        /* 48 = sigprocmask */
	"getlogin",           /* 49 = getlogin */
	"setlogin",           /* 50 = setlogin */
	"acct",               /* 51 = acct */
	"sigpending",         /* 52 = sigpending */
	"sigaltstack",        /* 53 = sigaltstack */
	"ioctl",              /* 54 = ioctl */
	"reboot",             /* 55 = reboot */
	"revoke",             /* 56 = revoke */
	"symlink",            /* 57 = symlink */
	"readlink",           /* 58 = readlink */
	"execve",             /* 59 = execve */
	"umask",              /* 60 = umask */
	"chroot",             /* 61 = chroot */
	"#62",                /* 62 = old fstat */
	"#63",                /* 63 = used internally , reserved */
	"#64",                /* 64 = old getpagesize */
	"msync",              /* 65 = msync */
	"vfork",              /* 66 = vfork */
	"#67",                /* 67 = old vread */
	"#68",                /* 68 = old vwrite */
	"sbrk",               /* 69 = sbrk */
	"sstk",               /* 70 = sstk */
	"#71",                /* 71 = old mmap */
	"ovadvise",           /* 72 = ovadvise old vadvise */
	"munmap",             /* 73 = munmap */
	"mprotect",           /* 74 = mprotect */
	"madvise",            /* 75 = madvise */
	"#76",                /* 76 = old vhangup */
	"#77",                /* 77 = old vlimit */
	"mincore",            /* 78 = mincore */
	"getgroups",          /* 79 = getgroups */
	"setgroups",          /* 80 = setgroups */
	"getpgrp",            /* 81 = getpgrp */
	"setpgid",            /* 82 = setpgid */
	"setitimer",          /* 83 = setitimer */
	"#84",                /* 84 = old wait */
	"swapon",             /* 85 = swapon */
	"getitimer",          /* 86 = getitimer */
	"#87",                /* 87 = old gethostname */
	"#88",                /* 88 = old sethostname */
	"getdtablesize",      /* 89 = getdtablesize */
	"dup2",               /* 90 = dup2 */
	"#91",                /* 91 = old getdopt */
	"fcntl",              /* 92 = fcntl */
	"select",             /* 93 = select */
	"#94",                /* 94 = old setdopt */
	"fsync",              /* 95 = fsync */
	"setpriority",        /* 96 = setpriority */
	"socket",             /* 97 = socket */
	"connect",            /* 98 = connect */
	"#99",                /* 99 = old accept */
	"getpriority",        /* 100 = getpriority */
	"#101",               /* 101 = old send */
	"#102",               /* 102 = old recv */
#ifdef __ppc__
	"#103",               /* 103 = old sigreturn */
#else
	"sigreturn",          /* 103 = sigreturn */
#endif
	"bind",               /* 104 = bind */
	"setsockopt",         /* 105 = setsockopt */
	"listen",             /* 106 = listen */
	"#107",               /* 107 = old vtimes */
	"#108",               /* 108 = old sigvec */
	"#109",               /* 109 = old sigblock */
	"#110",               /* 110 = old sigsetmask */
	"sigsuspend",         /* 111 = sigsuspend */
	"#112",               /* 112 = old sigstack */
	"#113",               /* 113 = old recvmsg */
	"#114",               /* 114 = old sendmsg */
	"#115",               /* 115 = old vtrace */
#ifdef __ppc__
	"ppc_gettimeofday",   /* 116 = ppc_gettimeofday */
#else
	"gettimeofday",       /* 116 = gettimeofday */
#endif
	"getrusage",          /* 117 = getrusage */
	"getsockopt",         /* 118 = getsockopt */
	"#119",               /* 119 = old resuba */
	"readv",              /* 120 = readv */
	"writev",             /* 121 = writev */
	"settimeofday",       /* 122 = settimeofday */
	"fchown",             /* 123 = fchown */
	"fchmod",             /* 124 = fchmod */
	"#125",               /* 125 = old recvfrom */
	"#126",               /* 126 = old setreuid */
	"#127",               /* 127 = old setregid */
	"rename",             /* 128 = rename */
	"#129",               /* 129 = old truncate */
	"#130",               /* 130 = old ftruncate */
	"flock",              /* 131 = flock */
	"mkfifo",             /* 132 = mkfifo */
	"sendto",             /* 133 = sendto */
	"shutdown",           /* 134 = shutdown */
	"socketpair",         /* 135 = socketpair */
	"mkdir",              /* 136 = mkdir */
	"rmdir",              /* 137 = rmdir */
	"utimes",             /* 138 = utimes */
	"futimes",            /* 139 = futimes */
	"adjtime",            /* 140 = adjtime */
	"#141",               /* 141 = old getpeername */
	"#142",               /* 142 = old gethostid */
	"#143",               /* 143 = old sethostid */
	"#144",               /* 144 = old getrlimit */
	"#145",               /* 145 = old setrlimit */
	"#146",               /* 146 = old killpg */
	"setsid",             /* 147 = setsid */
	"#148",               /* 148 = old setquota */
	"#149",               /* 149 = old qquota */
	"#150",               /* 150 = old getsockname */
	"getpgid",            /* 151 = getpgid */
	"setprivexec",        /* 152 = setprivexec */
	"pread",              /* 153 = pread */
	"pwrite",             /* 154 = pwrite */
#if NFSSERVER
	"nfssvc",             /* 155 = nfssvc */
#else
	"#155",               /* 155 = */
#endif
	"#156",               /* 156 = old getdirentries */
	"statfs",             /* 157 = statfs */
	"fstatfs",            /* 158 = fstatfs */
	"unmount",            /* 159 = unmount */
	"#160",               /* 160 = old async_daemon */
#if NFSCLIENT
	"getfh",              /* 161 = getfh */
#else
	"#161",               /* 161 = */
#endif
	"#162",               /* 162 = old getdomainname */
	"#163",               /* 163 = old setdomainname */
	"#164",               /* 164 = */
	"quotactl",           /* 165 = quotactl */
	"#166",               /* 166 = old exportfs */
	"mount",              /* 167 = mount */
	"#168",               /* 168 = old ustat */
	"#169",               /* 169 = */
	"table",              /* 170 = table old table */
	"#171",               /* 171 = old wait3 */
	"#172",               /* 172 = old rpause */
	"waitid",             /* 173 = waitid */
	"#174",               /* 174 = old getdents */
	"#175",               /* 175 = old gc_control */
	"add_profil",         /* 176 = add_profil */
	"#177",               /* 177 = */
	"#178",               /* 178 = */
	"#179",               /* 179 = */
	"kdebug_trace",       /* 180 = kdebug_trace */
	"setgid",             /* 181 = setgid */
	"setegid",            /* 182 = setegid */
	"seteuid",            /* 183 = seteuid */
#ifdef __ppc__
	"sigreturn",          /* 184 = sigreturn */
#else
	"#184",               /* 184 = */
#endif
	"#185",               /* 185 = */
	"#186",               /* 186 = */
	"#187",               /* 187 = */
	"stat",               /* 188 = stat */
	"fstat",              /* 189 = fstat */
	"lstat",              /* 190 = lstat */
	"pathconf",           /* 191 = pathconf */
	"fpathconf",          /* 192 = fpathconf */
#if COMPAT_GETFSSTAT
	"getfsstat",          /* 193 = getfsstat */
#else
	"#193",               /* 193 = */
#endif
	"getrlimit",          /* 194 = getrlimit */
	"setrlimit",          /* 195 = setrlimit */
	"getdirentries",      /* 196 = getdirentries */
	"mmap",               /* 197 = mmap */
	"#198",               /* 198 = __syscall */
	"lseek",              /* 199 = lseek */
	"truncate",           /* 200 = truncate */
	"ftruncate",          /* 201 = ftruncate */
	"__sysctl",           /* 202 = __sysctl */
	"mlock",              /* 203 = mlock */
	"munlock",            /* 204 = munlock */
	"undelete",           /* 205 = undelete */
#ifdef __ppc__
	"ATsocket",           /* 206 = ATsocket */
	"ATgetmsg",           /* 207 = ATgetmsg */
	"ATputmsg",           /* 208 = ATputmsg */
	"ATPsndreq",          /* 209 = ATPsndreq */
	"ATPsndrsp",          /* 210 = ATPsndrsp */
	"ATPgetreq",          /* 211 = ATPgetreq */
	"ATPgetrsp",          /* 212 = ATPgetrsp */
	"#213",               /* 213 = Reserved for AppleTalk */
#else
	"ATsocket",           /* 206 = ATsocket */
	"ATgetmsg",           /* 207 = ATgetmsg */
	"ATputmsg",           /* 208 = ATputmsg */
	"ATPsndreq",          /* 209 = ATPsndreq */
	"ATPsndrsp",          /* 210 = ATPsndrsp */
	"ATPgetreq",          /* 211 = ATPgetreq */
	"ATPgetrsp",          /* 212 = ATPgetrsp */
	"#213",               /* 213 = Reserved for AppleTalk */
#endif /* __ppc__ */
	"kqueue_from_portset_np",  /* 214 = kqueue_from_portset_np */
	"kqueue_portset_np",  /* 215 = kqueue_portset_np */
	"mkcomplex",          /* 216 = mkcomplex soon to be obsolete */
	"statv",              /* 217 = statv soon to be obsolete */
	"lstatv",             /* 218 = lstatv soon to be obsolete */
	"fstatv",             /* 219 = fstatv soon to be obsolete */
	"getattrlist",        /* 220 = getattrlist */
	"setattrlist",        /* 221 = setattrlist */
	"getdirentriesattr",  /* 222 = getdirentriesattr */
	"exchangedata",       /* 223 = exchangedata */
#ifdef __APPLE_API_OBSOLETE
	"checkuseraccess",    /* 224 = checkuseraccess */
#else
	"#224",               /* 224 = HFS checkuseraccess check access to a file */
#endif /* __APPLE_API_OBSOLETE */
	"searchfs",           /* 225 = searchfs */
	"delete",             /* 226 = delete private delete ( Carbon semantics ) */
	"copyfile",           /* 227 = copyfile */
	"#228",               /* 228 = */
	"#229",               /* 229 = */
	"poll",               /* 230 = poll */
	"watchevent",         /* 231 = watchevent */
	"waitevent",          /* 232 = waitevent */
	"modwatch",           /* 233 = modwatch */
	"getxattr",           /* 234 = getxattr */
	"fgetxattr",          /* 235 = fgetxattr */
	"setxattr",           /* 236 = setxattr */
	"fsetxattr",          /* 237 = fsetxattr */
	"removexattr",        /* 238 = removexattr */
	"fremovexattr",       /* 239 = fremovexattr */
	"listxattr",          /* 240 = listxattr */
	"flistxattr",         /* 241 = flistxattr */
	"fsctl",              /* 242 = fsctl */
	"initgroups",         /* 243 = initgroups */
	"#244",               /* 244 = */
	"#245",               /* 245 = */
	"#246",               /* 246 = */
#if NFSCLIENT
	"nfsclnt",            /* 247 = nfsclnt */
	"fhopen",             /* 248 = fhopen */
#else
	"#247",               /* 247 = */
	"#248",               /* 248 = */
#endif
	"#249",               /* 249 = */
	"minherit",           /* 250 = minherit */
	"semsys",             /* 251 = semsys */
	"msgsys",             /* 252 = msgsys */
	"shmsys",             /* 253 = shmsys */
	"semctl",             /* 254 = semctl */
	"semget",             /* 255 = semget */
	"semop",              /* 256 = semop */
	"semconfig",          /* 257 = semconfig */
	"msgctl",             /* 258 = msgctl */
	"msgget",             /* 259 = msgget */
	"msgsnd",             /* 260 = msgsnd */
	"msgrcv",             /* 261 = msgrcv */
	"shmat",              /* 262 = shmat */
	"shmctl",             /* 263 = shmctl */
	"shmdt",              /* 264 = shmdt */
	"shmget",             /* 265 = shmget */
	"shm_open",           /* 266 = shm_open */
	"shm_unlink",         /* 267 = shm_unlink */
	"sem_open",           /* 268 = sem_open */
	"sem_close",          /* 269 = sem_close */
	"sem_unlink",         /* 270 = sem_unlink */
	"sem_wait",           /* 271 = sem_wait */
	"sem_trywait",        /* 272 = sem_trywait */
	"sem_post",           /* 273 = sem_post */
	"sem_getvalue",       /* 274 = sem_getvalue */
	"sem_init",           /* 275 = sem_init */
	"sem_destroy",        /* 276 = sem_destroy */
	"open_extended",      /* 277 = open_extended */
	"umask_extended",     /* 278 = umask_extended */
	"stat_extended",      /* 279 = stat_extended */
	"lstat_extended",     /* 280 = lstat_extended */
	"fstat_extended",     /* 281 = fstat_extended */
	"chmod_extended",     /* 282 = chmod_extended */
	"fchmod_extended",    /* 283 = fchmod_extended */
	"access_extended",    /* 284 = access_extended */
	"settid",             /* 285 = settid */
	"gettid",             /* 286 = gettid */
	"setsgroups",         /* 287 = setsgroups */
	"getsgroups",         /* 288 = getsgroups */
	"setwgroups",         /* 289 = setwgroups */
	"getwgroups",         /* 290 = getwgroups */
	"mkfifo_extended",    /* 291 = mkfifo_extended */
	"mkdir_extended",     /* 292 = mkdir_extended */
	"identitysvc",        /* 293 = identitysvc */
	"#294",               /* 294 = */
	"#295",               /* 295 = */
	"load_shared_file",   /* 296 = load_shared_file */
	"reset_shared_file",  /* 297 = reset_shared_file */
	"new_system_shared_regions",  /* 298 = new_system_shared_regions */
	"shared_region_map_file_np",  /* 299 = shared_region_map_file_np */
	"shared_region_make_private_np",  /* 300 = shared_region_make_private_np */
	"#301",               /* 301 = */
	"#302",               /* 302 = */
	"#303",               /* 303 = */
	"#304",               /* 304 = */
	"#305",               /* 305 = */
	"#306",               /* 306 = */
	"#307",               /* 307 = */
	"#308",               /* 308 = */
	"#309",               /* 309 = */
	"getsid",             /* 310 = getsid */
	"settid_with_pid",    /* 311 = settid_with_pid */
	"#312",               /* 312 = */
	"aio_fsync",          /* 313 = aio_fsync */
	"aio_return",         /* 314 = aio_return */
	"aio_suspend",        /* 315 = aio_suspend */
	"aio_cancel",         /* 316 = aio_cancel */
	"aio_error",          /* 317 = aio_error */
	"aio_read",           /* 318 = aio_read */
	"aio_write",          /* 319 = aio_write */
	"lio_listio",         /* 320 = lio_listio */
	"#321",               /* 321 = */
	"#322",               /* 322 = */
	"#323",               /* 323 = */
	"mlockall",           /* 324 = mlockall */
	"munlockall",         /* 325 = munlockall */
	"#326",               /* 326 = */
	"issetugid",          /* 327 = issetugid */
	"__pthread_kill",     /* 328 = __pthread_kill */
	"pthread_sigmask",    /* 329 = pthread_sigmask */
	"sigwait",            /* 330 = sigwait */
	"__disable_threadsignal",  /* 331 = __disable_threadsignal */
	"__pthread_markcancel",  /* 332 = __pthread_markcancel */
	"__pthread_canceled",  /* 333 = __pthread_canceled */
	"__semwait_signal",   /* 334 = __semwait_signal */
	"utrace",             /* 335 = utrace */
	"#336",               /* 336 = */
	"#337",               /* 337 = */
	"#338",               /* 338 = */
	"#339",               /* 339 = */
	"#340",               /* 340 = */
	"#341",               /* 341 = */
	"#342",               /* 342 = */
	"#343",               /* 343 = */
	"#344",               /* 344 = */
	"#345",               /* 345 = */
	"#346",               /* 346 = */
	"#347",               /* 347 = */
	"#348",               /* 348 = */
	"#349",               /* 349 = */
	"audit",              /* 350 = audit */
	"auditon",            /* 351 = auditon */
	"#352",               /* 352 = */
	"getauid",            /* 353 = getauid */
	"setauid",            /* 354 = setauid */
	"getaudit",           /* 355 = getaudit */
	"setaudit",           /* 356 = setaudit */
	"getaudit_addr",      /* 357 = getaudit_addr */
	"setaudit_addr",      /* 358 = setaudit_addr */
	"auditctl",           /* 359 = auditctl */
	"#360",               /* 360 = */
	"#361",               /* 361 = */
	"kqueue",             /* 362 = kqueue */
	"kevent",             /* 363 = kevent */
	"lchown",             /* 364 = lchown */
	"#365",               /* 365 = */
	"#366",               /* 366 = */
	"#367",               /* 367 = */
	"#368",               /* 368 = */
	"#369",               /* 369 = */
};
