/*
	$Id: AMSMailTool.h,v 1.4 2003/08/29 20:35:37 dasenbro Exp $

	File: AMSMailTool.h

	Contains: Header for AMSMailTool.h

	Version:	Apple Mail Server Mail Tool : 	$Revision: 1.4 $

	Copyright:	 2003 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:
*/

#ifndef __AMSMailTool_h__
#define __AMSMailTool_h__	1

// Tool options

typedef enum {
	kDoNothing			= 0,
	kMigrateDefault		= 1,
	kMigrate10_1_Only	= 2,
	kMigrate10_2_Only	= 3,
	kImportFile			= 4
} eOptions;

typedef enum {
	kNoErrors			=  0,
	kNotRoot			=  1,
	kMissingSrcPath		=  2,
	kBadSrcPath			=  3,
	kBadSrcFile			=  4,
	kMissingDestPath	=  5,
	kBadDestPath		=  6,
	kTooManyArgs		=  7,
	kIllegalArg			=  8,
	kMissingSize		=  9,
	kBadSizeArg			= 10
} eLaunchErrors;	

// Main App's error types
typedef enum {
		kAppNoErr				= 0,
		kAppInvalidOSTypeErr,
		kAppInvalidMachineTypeErr,
		kAppInvalidOSReleaseErr,
		kAppInvalidUserErr,
		kAppAlreadyRunningErr,
		kAppInvalidFSErr,
		kAppFSTooSmallErr,
		kAppRunDirErr,
		kAppDirectoryErr,
		kAppMemAllocError,
		kAppUnknownErr			= 0xFF
} eAppError;

// Mail server's version
typedef struct {
	short	major;		// major release number
	short	minor;		// minor release number
	short	update;		// update number
	short	fix;		// fix number
} MailVersionInfo;

#define FLAG_ANSWERED (1<<0)
#define FLAG_FLAGGED (1<<1)
#define FLAG_DELETED (1<<2)
#define FLAG_DRAFT (1<<3)

#endif // __AMSMailTool_h__
