/*
	$Id: DSMailGroup.cpp,v 1.1 2003/04/20 23:34:11 dasenbro Exp $

	File:		DSMailGroup.cpp

	Contains:	implementation of DSMailGroup object

	Version:	Apple Mail Server - Mac OS X :  $Revision: 1.1 $

	Written by:	Michael Dasenbrock

	Copyright:	 1996-2001 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: DSMailGroup.cpp,v $
		Revision 1.1  2003/04/20 23:34:11  dasenbro
		Initial check-in.
		
		Revision 1.10  2002/05/09 16:58:56  dasenbro
		Changed all str... calls to CUtils::Str... to be NULL safe.
		
		Revision 1.9  2002/03/21 16:38:52  dasenbro
		Addes network transition support.
		
		Revision 1.8  2001/06/21 20:50:54  dasenbro
		Updated file header info.
		
		Revision 1.7  2001/06/21 17:13:21  dasenbro
		Added Change History.
		

	Projector History:

	To Do:
*/

#include "DSMgr.h"
#include "DSMailGroup.h"
#include "CUtils.h"



// --------------------------------------------------------------------------------
//	* DSMailGroup ()
// --------------------------------------------------------------------------------

DSMailGroup::DSMailGroup ( void )
{
	fGroupID			= 0;
	fGroupName			= nil;
	fIsExpanded			= false;
	fMemberCount		= 0;
	fMemberArray		= nil;
} // DSMailGroup


// --------------------------------------------------------------------------------
//	* DSMailGroup ()
//
//		- copy constructor
// --------------------------------------------------------------------------------

DSMailGroup::DSMailGroup ( DSMailGroup* inMailGroup )
{
	fGroupID			= 0;
	fGroupName			= nil;
	fIsExpanded			= false;
	fMemberCount		= 0;
	fMemberArray		= nil;

	if ( inMailGroup != NULL )
	{
		fGroupID			= inMailGroup->fGroupID;
		fIsExpanded			= inMailGroup->fIsExpanded;
		this->CopyString( &fGroupName, inMailGroup->fGroupName );

		if ( (inMailGroup->fMemberCount != 0) && (inMailGroup->fMemberArray != nil) )
		{
			fMemberArray = new GroupMemberList[ inMailGroup->fMemberCount ];
			if ( fMemberArray != nil )
			{
				fMemberCount = inMailGroup->fMemberCount;
				::memcpy( fMemberArray, inMailGroup->fMemberArray, sizeof( GroupMemberList ) * fMemberCount );
			}
		}
	}
} // DSMailGroup


// --------------------------------------------------------------------------------
//	* ~DSMailGroup ()
// --------------------------------------------------------------------------------

DSMailGroup::~DSMailGroup ( void )
{
	if ( fGroupName != nil )
	{
		delete[] ( fGroupName );
		fGroupName = nil;
	}

	if ( fMemberArray != nil )
	{
		delete[] ( fMemberArray );
		fMemberArray = nil;
	}
} // ~DSMailGroup


// --------------------------------------------------------------------------------
//	* SetGroupName ()
// --------------------------------------------------------------------------------

DSMailGroup::eMailGroupErr DSMailGroup::SetGroupName ( const char *inGroupName )
{
	eMailGroupErr	siResult 	= eMailGroupNoErr;

	if ( inGroupName != nil )
	{
		if ( fGroupName != nil )
		{
			delete( fGroupName );
			fGroupName = nil;
		}

		fGroupName = new char[ CUtils::Strlen( inGroupName ) + 1 ];
		if ( fGroupName != nil )
		{
			CUtils::Strcpy( fGroupName, inGroupName );
		}
		else
		{
			siResult = eMemoryError;
		}
	}
	else
	{
		siResult = eNullGroupName;
	}

	return( siResult );

} // SetGroupName


// --------------------------------------------------------------------------------
//	* SetGroupID ()
// --------------------------------------------------------------------------------

DSMailGroup::eMailGroupErr DSMailGroup::SetGroupID ( const uInt32 inGroupID )
{
	eMailGroupErr siResult = eNoGroupID;

	if ( inGroupID != 0 )
	{
		fGroupID = inGroupID;
		siResult = eMailGroupNoErr;
	}

	return( siResult );

} // SetGroupID


// -------------------------------------------------------------------------------------
#pragma mark * Get Attributes *
// -------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------
//	* GetGroupID ()
//	
// --------------------------------------------------------------------------------

uInt32 DSMailGroup::GetGroupID ( void )
{
	return( fGroupID );
} // GetGroupID


// --------------------------------------------------------------------------------
//	* GetName ()
//	
// --------------------------------------------------------------------------------

const char*	DSMailGroup::GetName ( void )
{
	return( fGroupName );
} // GetName


// --------------------------------------------------------------------------------
//	* GetMemberCount ()
//	
// --------------------------------------------------------------------------------

uInt32 DSMailGroup::GetMemberCount ( void )
{
	return( fMemberCount );
} // GetMemberCount


// --------------------------------------------------------------------------------
//	* SetMemberCount ()
//	
// --------------------------------------------------------------------------------

void DSMailGroup::SetMemberCount ( uInt32 inCount )
{
	fMemberCount = inCount;
} // SetMemberCount


// --------------------------------------------------------------------------------
//	* IsExpanded ()
//	
// --------------------------------------------------------------------------------

Boolean DSMailGroup::IsExpanded ( void )
{
	return( fIsExpanded );
} // IsExpanded


// --------------------------------------------------------------------------------
//	* ExpandGroup ()
//	
// --------------------------------------------------------------------------------

eMUGError DSMailGroup::ExpandGroup ( void )
{
	eMUGError	result = kMUGErrUndefined;

	if ( fIsExpanded == false )
	{
	}
	else
	{
		result = kMUGErrNoErr;
	}

	return( result );

} // ExpandGroup


// --------------------------------------------------------------------------------
//	* GetGroupMembers ()
//	
// --------------------------------------------------------------------------------

Boolean DSMailGroup::GetGroupMembers ( uInt32 *ioArrayBuffer, const uInt32 inBufferLen, uInt32 &outCount )
{
#pragma unused (  ioArrayBuffer, inBufferLen, outCount )
	return( false );
} // GetGroupMembers


// --------------------------------------------------------------------------------
//	* GetGroupMembers ()
//	
// --------------------------------------------------------------------------------

Boolean DSMailGroup::GetGroupMembers ( GroupMemberList **outMemberArray, uInt32 &outCount )
{
	Boolean		bResult = false;

	if ( (fMemberArray != nil) || (fMemberCount != 0) )
	{
		*outMemberArray = fMemberArray;
		outCount = fMemberCount;

		bResult = true;
	}

	return( bResult );

} // GetGroupMembers


// --------------------------------------------------------------------------------
//	* SetGroupMembers ()
//	
// --------------------------------------------------------------------------------

void DSMailGroup::SetGroupMembers ( GroupMemberList *inMemberList )
{
	fMemberArray = inMemberList;
} // SetGroupMembers


// --------------------------------------------------------------------------------
//	* CopyString
//
// --------------------------------------------------------------------------------

void DSMailGroup::CopyString( char** outDestStr, char* inSourceStr )
{
	if (outDestStr == NULL)
	{
		return;
	}
	if (inSourceStr == NULL)
	{
		*outDestStr = NULL;
	}
	else
	{
		*outDestStr = new char[ CUtils::Strlen( inSourceStr ) + 1 ];
		if ( outDestStr != nil )
		{
			CUtils::Strcpy( *outDestStr, inSourceStr );
		}
	}
}

	
