/*
	File:		CEnvelope.10.1.h

	Contains:	C++ class definition of Message Envelope container

	Copyright:	 2003 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: CEnvelope.10.1.h,v $
		Revision 1.1  2003/04/20 23:46:10  dasenbro
		Initial check-in.
		

	To Do:
*/


#ifndef __CEnvelope_10_1_h__
#define __CEnvelope_10_1_h__	1

#include "CMailDatabase.10.1.h"
#include "CDBMailBaseObject.10.1.h"
#include "MailGlobals.h"
#include "CString.h"

const uInt32 kMessagePrefixSize = 1024;		// 1K

#pragma options align=mac68k
typedef struct
{
	StdDBObjHeader_10_1	fDBHeader;

				ObjID		fEnvelopeID;				// this is us (denormalized)
	volatile	ObjID		fSenderID;					// this is our sender recipient object
	volatile	ObjID		fMsgTocID;					// message table of contents ID

	volatile	uInt32		fVTwinReference;

	
	volatile	ObjID		fRecipListHeadID;			// 
	volatile	ObjID		fMsgPartListHeadID;			// 
	volatile	ObjID		fSmallMsgPartID;
	
	// Reserved
				uInt32		fReserved1;					// reserverd
				uInt32		fReserved2;					// reserverd

	// Envelope Information
				uInt32		fViaCode;								// how did we get it
				char		fSendingHost[ kMaxHostNameLength + 1 ];	// the sending host name
				uInt32		fMessageSize;							// size in bytes of message (cached)
				uInt32		fCreationTime;							// time created
				uInt32		fWarningSentTime;						// time the Warning was sent...
				uInt32		fAttemptTime;							// last attempt at delivery
				uInt16		fTransports;							// AppleTalk, TCP/IP, or Bounce

				uInt16		fTOCEnvelopeStrOffset;					// Offset for TOC Envelope string
				uInt16		fTOCEnvelopeStrLength;					// Lenght of TOC Envelope string

				uInt16		fMessagePrefixLength;					// Length of prepended headers
				char		fMessagePrefix[ kMessagePrefixSize ];// prepended headers + TOC Envelope string	

				uInt32		fServerIPAddr;							// server IP Address (used for multihoming)
				uInt32		fFlags;									// envelope flags

	volatile	uInt16		fSpoolRefCount;				// Number of CEnvelopeInfo objects referring to me
	volatile	uInt16		fHostRefCount;				// Number of Host Spool objects referring to me
	
	// Recipient Counts
				uInt16		fOriginalRecipientCount;	// # Before routing expansions
				uInt16		fTotalRecipientCount;		// # Currently
	
				uInt16		fPendingRecipientCount;		// # Pending Routing
				uInt16		fDeliveredRecipients;		// # Delivered To Successfully
				uInt16		fErrorRecipientCount;		// # Routing or delivery unsuccessful
	
				uInt16		fGroupRecipientCount;		// # of groups
				uInt16		fAutoForwardRecipientCount;	// # of autoforwards
				uInt16		fLocalRecipientCount;		// # of local recipients
				uInt16		fRemoteRecipientCount;		// # of remote recipients
	volatile	uInt16		fRemotePostingDone;			// true when the router is done posting the message to _ALL_ hosts

	// MessagePart Count
	volatile	uInt16		fMessagePartCount;
				uInt16		fPadding1;					// added in 6.3 to maintain format compatibility with 6.0, 6.1 & 6.2

	StdDBObjFooter_10_1	fDBFooter;
} CEnvelopeData_10_1;

#pragma options align=reset


// CDBMailBaseObject Constants
const uInt32 kEnvelopeDataSize_10_1	= sizeof ( CEnvelopeData_10_1 );
const uInt32 kEnvelopeVersion_10_1	= kDBCurrentVersion_10_1 + kEnvelopeDataSize_10_1;

// Envelope flags (more to come)
const uInt32	kForwardToAnyUser_10_1	= 0x00000001;


class CEnvelope_10_1 : public CDBMailBaseObject_10_1
{
public:

	typedef enum 
	{ 
		kViaUnknown					= '--VA', 
		kViaSMTP 					= 'ipVA',		// SMTP
		kViaATalk					= 'atVA',		// SMTP over ADSP
		kViaUUCP	 				= 'uuVA', 		// UUCP
		kViaNDR						= 'ndVA',		// NDR Generated
		kViaIMAP					= 'imVA',		// IMAP
		kViaNDRTwice				= 'ndV2',		// NDR has been posted to the Postmaster once before...
		kViaPOPAccountNo822Parse	= 'POP1',
		kViaPOPAccountWith822Parse	= 'POP2',
		kViaDoorNail				= 'deth'
	} ViaCodes;

	// Static Methods
	static CEnvelope_10_1*	Create					( uInt32 inViaCode,
													const char* inSendingHost );
	static Boolean		Delete					( CEnvelope_10_1* inEnvelope );
	static uInt32		Count					( void );
	static SDBIterator_10_1*	GetEnvelopeIterator		( void );
	static void			ReleaseEnvelopeIterator	( SDBIterator_10_1* &inIterator );
	static Boolean		GetSetFields			(const eFieldDataRequest_10_1 inFieldRequest, const void *inObjDataPtr, void *outFieldData);

	static 	CEnvelope_10_1*		FindByID			( const	ObjID	inObjectID );
	static	CDBBaseObject_10_1*	ObjectAllocNew		( void );

	static	OSType		GetObjTypeConstant	( void ) { return kEnvelopeSignature_10_1; }
	static	uInt32		GetObjVersConstant	( void ) { return kEnvelopeVersion_10_1; }
	static	uInt32		GetObjSizeConstant	( void ) { return kEnvelopeDataSize_10_1; }

	virtual	ObjID		GetObjectID					( void );
	virtual	void		ChkCompilerStructAlignment	( void );
	void				Done						( CEnvelope_10_1* &inPtr );

	// Construction/Destruction
				CEnvelope_10_1	( void );
	virtual	   ~CEnvelope_10_1	( void );

	CEnvelopeData_10_1*	GetEnvelopeData	( void );
	void			SetDirty (void);

	// Object IDs
	ObjID		GetEnvelopeID		( void );

	ObjID		GetSenderID			( void );
	void		SetSenderID			( ObjID inSenderID );

	ObjID		GetMessageTocID		( void );
	void		SetMessageTocID		( ObjID inMsgTocID );

	// CEnvelope_10_1 Information
	uInt32		GetViaCode(void);
	void		SetViaCode(uInt32 inViaCode);
	
	const char* GetSendingHost(void);
	void		SetSendingHost(const char* inSendingHost);

	uInt16		GetMessagePrefixLength	( void );
	char*		GetMessagePrefix		( void );
	void		GetFullMessagePrefix	( CString &outMessagePrefix );
	void		SetMessagePrefix		( char *inData, uInt16 inLength );

	uInt16		GetTOCEnvStringLength	( void );
	char*		GetTOCEnvString			( void );
	void		SetTOCEnvString			( char *inData, uInt16 inLength );

	uInt32		GetMessageSize( const Boolean inUseRawMsgPrefixSize );
	void		SetMessageSize(uInt32 inMessageSize);
	
	Boolean		GetRemotePostingFlag(void);
	void		SetRemotePostingFlag(Boolean inPostingFlag);

	ObjID		GetRecipListHeadID		 ( void );
	void		SetRecipientListHeadID	 ( ObjID inListHeadID );

	ObjID		GetMsgPartListHeadID		( void );
	void		SetMsgPartListHeadID		( ObjID inListHeadID );

	ObjID		GetSmallMsgPartID		(void);
	void		SetSmallMsgPartID		(const ObjID inSmallMsgPartID );
	
	uInt32		GetServerIPAddr			( void );
	void		SetServerIPAddr			( uInt32 inServerIPAddr );
	
	enum { kSpoolReference = 0x01, kHostReference = 0x02 };
	void		AddReference(uInt32 inType);
	void		RemoveReference(uInt32 inType);
	uInt32		GetRefCount (uInt32 inType);

	enum { kTCPTransport = 0x01, kADSPTransport = 0x02, kBounceTransport = 0x04 };
	void		AddTransport (uInt16 inTransport);
	uInt16		GetTransports (void);

	uInt32		GetEnvWarningTime ( void );
	void		SetEnvWarningTime (const uInt32 inWarningSentTime);

	// CRecipient Methods 
	void		AddRecipient(ObjID inRecipientID);
	void		DeleteAllRecipients (void);
	Boolean		DeleteSender(void);
	
	enum 
	{ 
		kOriginalCount = 1,						// Original number submitted across SMTP 
		kTotalCount, 							// Total number currently
		kPendingRoutingCount,					// Remaining to be routed
		kDeliveredCount,						// Delivered to local spool or sent by SMTP 
		kErrorCount, 							// All routing, expansion, and delivery errors
		kGroupCount, kAutoForwardCount, 		// Recipients which should be expanded
		kLocalCount, kRemoteCount 				// Destination recipients
	};
	
	uInt16		GetRecipientCount(uInt32 inType);
	void		SetRecipientCount(uInt32 inType, uInt16 inCount);
	void		IncrementRecipientCount(uInt32 inType);
	void		DecrementRecipientCount(uInt32 inType);
	
	
	// CMessagePart Methods 
	void		AddMessagePart(ObjID inMessagePartID, const Boolean inSmallMsgPartFlag);
	void		DeleteAllMessageParts	(void);
	void		DeleteMessageTOC		(void);
	uInt32		GetMessagePartCount(void);

	// V-Twin references
	uInt32		GetVTwinReference	( void );
	void		SetVTwinReference	( uInt32 inRef );

	// Object creation semaphore methods
	ExceptionCode	GetTOCSemaphore		( const Boolean inWaitForTOCFlag );
	void			ReleaseTOCSemaphore	( const Boolean inNotifyOtherThreadsFlag );

	ExceptionCode	GetIndexSemaphore		( const Boolean inWaitForTOCFlag );
	void			ReleaseIndexSemaphore	( const Boolean inNotifyOtherThreadsFlag );

	// Time Fields
	void		SetCreationTime (void);
	uInt32		GetCreationTime (void);
	void		SetLastAttemptTime (void);
	uInt32		GetLastAttemptTime (void);
	
	// flags
	uInt32		GetEnvelopeFlags	( void );
	void		SetEnvelopeFlags	( uInt32 inFlags );

	uInt32				fCacheFullMessageSize;

	CEnvelopeData_10_1		fEnvelopeData;				// this portion stored on disk...
};

#endif // __CEnvelope_10_1_h__
