/*
	File:		CEnvelopeInfo.10.1.h

	Contains:	C++ class definition for EnvelopeInfo pointer objects to Envelopes

	Copyright:	 2003 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: CEnvelopeInfo.10.1.h,v $
		Revision 1.2  2003/07/22 18:43:10  dasenbro
		Mark messages that have been migrated.
		
		Revision 1.1  2003/04/20 23:46:10  dasenbro
		Initial check-in.
		

	To Do:
*/


#ifndef __CEnvelopeInfo_10_1_h__
#define __CEnvelopeInfo_10_1_h__	1

#include "CMailDatabase.10.1.h"
#include "CDBBaseObject.10.1.h"
#include "CDBMailBaseObject.10.1.h"
#include "DatabaseTypes.h"

typedef struct
{
	StdDBObjHeader_10_1	fDBHeader;
	ObjID				fEnvelopeInfoID;		// this is us (denormalized)
	ObjID				fMailSpoolID;			// this is the mail spool we belong to
	ObjID				fEnvelopeID;			// this is the envelope we point at
	ObjID				fSeenTime;				// set the time this message was seen
	
	// Reserved
	uInt32				fUID;					// message UID
	uInt32				fReserved2;				// reserverd

	// EnvelopeInfo Information
	uInt32				fMessageSize;
	uInt32				fFlags;
	uInt32				fEnvInfoWarningTime;
	StdDBObjFooter_10_1	fDBFooter;
} CEnvInfoData_10_1;

// CDBMailBaseObject constants
const uInt32 kEnvelopeInfoDataSize_10_1	= sizeof( CEnvInfoData_10_1 );
const uInt32 kEnvelopeInfoVersion_10_1	= kDBCurrentVersion_10_1 + kEnvelopeInfoDataSize_10_1;

class CEnvelopeInfo_10_1 : public CDBMailBaseObject_10_1
{
public:

	typedef enum
	{
		kNone			= 0x00000000,
		
		// POP3
		kPOP3FlagsMask 	= 0x0000000F,
		kPOP3Read		= 0x00000001,	
		kPOP3Deleted	= 0x00000002,	
		
		// IMAP4
		kIMAP4FlagsMask	= 0x00000FF0,
		kIMAP4Seen		= 0x00000010,	
		kIMAP4Answered	= 0x00000020,	
		kIMAP4Flagged	= 0x00000040,	
		kIMAP4Deleted	= 0x00000080,	
		kIMAP4Draft		= 0x00000100,
		kIMAP4Recent	= 0x00000200
	} EnvelopeInfoFlags;

	// Static Methods
	static CEnvelopeInfo_10_1*	FindBySpoolEnvelope (ObjID inMailSpoolID, ObjID inEnvelopeID); 
											     
	static CEnvelopeInfo_10_1*	Create(ObjID inMailSpoolID, ObjID inEnvelopeID, uInt32 inMsgSize );
	static Boolean			Delete(CEnvelopeInfo_10_1* inEnvelopeInfo);
	static uInt32			Count(void);
	static Boolean			GetSetFields	(const eFieldDataRequest_10_1 inFieldRequest, const void *inObjDataPtr, void *outFieldData);

	static 	CEnvelopeInfo_10_1*	FindByID		( const	ObjID	inObjectID );
	static	CDBBaseObject_10_1*	ObjectAllocNew		( void );

	static	OSType		GetObjTypeConstant	( void ) { return kEnvelopeInfoSignature_10_1; }
	static	uInt32		GetObjVersConstant	( void ) { return kEnvelopeInfoVersion_10_1; }
	static	uInt32		GetObjSizeConstant	( void ) { return kEnvelopeInfoDataSize_10_1; }
	virtual	ObjID		GetObjectID			( void );

// Construction/Destruction
				CEnvelopeInfo_10_1		(void);
	virtual	   ~CEnvelopeInfo_10_1		(void);

	void		Done				( CEnvelopeInfo_10_1* &inPtr );
						
	// Object IDs
	ObjID		GetEnvelopeInfoID	( void );
	
	ObjID		GetMailSpoolID		( void );
	void		SetMailSpoolID		( ObjID inMailSpoolID );

	ObjID		GetEnvelopeID		( void );
	void		SetEnvelopeID		( ObjID inEnvelopeID );

	uInt32		GetUID				( void );
	void		SetUID				( uInt32 inUID );

	// CEnvelopeInfo Information 
	uInt32		GetMsgSize(Boolean inIncludeStatus = false);
	void		SetMsgSize(uInt32 inMsgSize);

	uInt32		GetFlags(void);
	void		SetFlags(uInt32 inFlags);
	
	uInt32		GetEnvInfoWarnTime(void);
	void		SetEnvInfoWarnTime(const uInt32 inWarnTime);
 
	uInt32		GetSeenTime			( void );
	void		SetSeenTime			( const uInt32 inWarnTime );
	
	uInt32		GetMigrationFlag	( void );
	void		SetMigrationFlag	( uInt32 inMigrationFlag );

	// POP3 Flags
	Boolean		IsPOP3Read(void);
	Boolean		IsPOP3Deleted(void);
	
	void		SetPOP3Read(Boolean inValue);
	void		SetPOP3Deleted(Boolean inValue);

	// CEnvelope Methods 
	uInt32		GetMessageSize(Boolean inIncludeStatus = false);	// convenience
				
	enum 
	{ 
		kRouting 			= 0x00000001, 
		kSending			= 0x00000002,
		kExpiration 		= 0x00000004,
		kBounceDisabled		= 0x00000008,
		kWarningCheck		= 0x00000010,
		kRejectThisMessage  = 0x00000020
	};
	

	CEnvInfoData_10_1*	GetEnvInfoData ( void );
	void			SetDirty ( void );
	
	CEnvInfoData_10_1	fEnvInfoData;
};

//------------------------------------------------------------------------------
#endif // __CEnvelopeInfo_10_1_h__
