/*
	File:		CExpansion.10.1.h

	Contains:	C++ class definitions for generic

	Copyright:	 2003 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: CExpansion.10.1.h,v $
		Revision 1.1  2003/04/20 23:46:10  dasenbro
		Initial check-in.
		

	To Do:
*/


#ifndef __CExpansion_10_1_h__
#define __CExpansion_10_1_h__ 1

#include "CMailDatabase.10.1.h"
#include "CDBBaseObject.10.1.h"
#include "CDBMailBaseObject.10.1.h"
#include "DatabaseTypes.h"

class CString;

const	sInt32		kMaxDataBlockSize_10_1	= 128;

typedef struct
{
	StdDBObjHeader_10_1	fDBHeader;
	ObjID			fObjectID;				// this is us (denormalized)
	ObjID			fOwnerID;				// who ownes us

	ObjID			fPrevObjectID;			// Link to previous object
	ObjID			fNextObjectID;			// Link to next object

	sInt16			fItemCount;
	sInt16			fItemSize;

	// Reserved
	uInt32			fReserved1;				// reserverd
	uInt32			fReserved2;				// reserverd

	char			fDataBlock[ kMaxDataBlockSize_10_1 ];
	StdDBObjFooter_10_1	fDBFooter;
} CExpandData_10_1;

// CDBMailBaseObject Constants
const uInt32 kExpansionDataSize_10_1	= sizeof( CExpandData_10_1 );
const uInt32 kExpansiontVersion_10_1	= kDBCurrentVersion_10_1 + kExpansionDataSize_10_1;

class CExpansion_10_1 : public CDBMailBaseObject_10_1
{
public:
	// Static Methods
	static CExpansion_10_1*		Create				( ObjID inOwner, uInt32 inItemSize );
	static Boolean 			Delete				( CExpansion_10_1 *inObjPtr );
	static uInt32			Count				( void );
	static void				VerifyAll			( void );
	static Boolean			GetSetFields		( const eFieldDataRequest_10_1 inFieldRequest, const void *inObjDataPtr,  void *outFieldData );
	static CExpansion_10_1*		FindByID			( const	ObjID inObjectID );
	static CDBBaseObject_10_1*	ObjectAllocNew		( void );

	static	OSType		GetObjTypeConstant	( void ) { return kExpansionSignature_10_1; }
	static	uInt32		GetObjVersConstant	( void ) { return kExpansiontVersion_10_1; }
	static	uInt32		GetObjSizeConstant	( void ) { return kExpansionDataSize_10_1; }

	virtual	ObjID		GetObjectID			( void );
	virtual	void		ChkCompilerStructAlignment			( void );
		void			Done				( CExpansion_10_1* &inPtr );

	// Construction/Destruction
						CExpansion_10_1			( void );
	virtual		 	   ~CExpansion_10_1			( void );

		ObjID			GetMyObjectID		( void );
		void			SetMyObjectID		( ObjID inObjID );

		ObjID			GetOwnerID			( void );
		void			SetOwnerID			( ObjID inObjID );

		ObjID			GetNextObjectID		( void );
		void			SetNextObjectID		( ObjID inObjID );

		ObjID			GetPrevObjectID		( void );
		void			SetPrevObjectID		( ObjID inObjID );

		sInt16			GetItemCount		( void );
		void			SetItemCount		( sInt16 inCount );
		void			IncItemCount		( void );
		void			DecItemCount		( void );

		sInt16			GetItemSize			( void );
		void			SetItemSize			( sInt16 inSize );

		sInt16			GetMaxItems			( void );
		void			SetMaxItems			( void );

		CExpandData_10_1*	GetMyObjectData		( void );
		void			SetDirty			( void );

protected:
		void			GetDataBlock		( char *outData );
		void			SetDataBlock		( char *inData );

private:
	CExpandData_10_1	fObjectData;

	sInt16				fTotalItems;
};

#endif // __CExpansion_10_1_h__

