/*
	File:		CHostEntryPref_10_1.cpp

	Contains:	C++ implementation of host preferences.

	Copyright:	 2003 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:
*/


#include <time.h>
#include <stdlib.h>		// for calloc

#include "CHostEntryPref.10.1.h"
#include "CUtils.h"
#include "CMailDatabase.10.1.h"
#include "CRootObject.10.1.h"
#include "DSMgr.h"
#include "DSMailUser.h"
#include "CGlobals.h"


const char * const kValueKeyEnableSubdomainInheritance			= "Enable_Subdomain_Inheritance";
const char * const kDictKeyNetwork								= "Network";
const char * const kDictKeyDNSCacheSettings						= "DNS_Cache_Settings";
const char * const kValueKeyAllowARecordLookup  				= "Allow_ARecord_Lookup";
const char * const kValueKeyCacheEnabled		  				= "Cache_Enabled";
const char * const kValueKeyAllowMXRecordLookup					= "Allow_MXRecord_Lookup";
const char * const kValueKeyCacheHours							= "Cache_Hours";
const char * const kValueKeyOpenConnectionTimeout				= "Open_Connection_Timeout";
const char * const kValueKeyReadWriteTimeout					= "Read_Write_Timeout";
const char * const kDictKeyIncomingMail							= "Incoming_Mail";
const char * const kValueKeyMaxMsgHopCount						= "Max_Msg_Hop_Count";
const char * const kDictKeyMaxMsgSizeLimits						= "Max_Msg_Size_Limits";
const char * const kValueKeyMaxMsgSizeKbytes					= "Max_Msg_Size_Kbytes";
const char * const kDictKeyBlindCC								= "Blind_CC";
const char * const kDictKeyAntispamSettings						= "Antispam_Settings";
const char * const kValueKeyLogRejectedMsgRecipients   			= "Log_Rejected_Msg_Recipients";
const char * const kValueKeyDisableSMTPRelay   					= "Disable_SMTP_Relay";
const char * const kValueKeyRejectAllIncomingMail				= "Reject_All_Incoming_Mail";
const char * const kValueKeyHostSettingsName					= "Host_Settings_Name";
const char * const kValueKeyGenerateDeliveryReportsIfRequested	= "Generate_Delivery_Reports_If_Requested";
const char * const kArrayKeyHostDNSList							= "Host_DNS_List";
const char * const kDictKeyOutgoingMail							= "Outgoing_Mail";
const char * const kValueKeyMaximumConnectionTimeMinutes		= "Maximum_Connection_Time_Minutes";
const char * const kDictKeyCustomOutgoingTCPPort   				= "Custom_Outgoing_TCP_Port";
const char * const kDictKeyRelaySMTPOutgoingMail				= "Relay_SMTP_Outgoing_Mail";
const char * const kValueKeyRelaySMTPMailVia					= "Relay_SMTP_Mail_Via";
const char * const kDictKeyRejectAllOutgoingMail				= "Reject_All_Outgoing_Mail";
const char * const kValueKeySendNonDeliveryReportToSender  		= "Send_Non_Delivery_Report_To_Sender";
const char * const kValueKeyCCNDRToPostmaster					= "CC_NDR_To_Postmaster";
const char * const kDictKeyWarnSenderOfNonDelivery 				= "Warn_Sender_Of_Non_Delivery";
const char * const kValueKeyCCPostmaster						= "CC_Postmaster";
const char * const kValueKeyNonDeliveryWarningHours				= "Non_Delivery_Warning_Hours";
const char * const kDictKeyScheduleSettings						= "Schedule_Settings";
const char * const kValueKeyConnectAsNeeded						= "Connect_As_Needed";
const char * const kDictKey724AllowedConnectionSchedule			= "7-24_Allowed_Connection_Schedule";
const char * const kDictKey724RetrySettings						= "7-24_Retry_Settings";
const char * const kValueKeyUseDefaultBehavior					= "Use_Default_Behavior";
const char * const kValueKeyRetryFreqMinutes					= "Retry_Freq_Minutes";
const char * const kArrayKeyDays24HourScheduleBitmap   			= "Days_24-Hour_Schedule_Bitmap";
const char * const kDictKeyConnectionRetrySettings				= "Connection_Retry_Settings";
const char * const kValueKeyHoldAllMail							= "Hold_All_Mail";
const char * const kValueKeyMessageExpireHours					= "Message_Expire_Hours";

// Generic Keys
const char * const kValueKeyEnabled								= "Enabled";
const char * const kValueKeyDSAlias								= "Directory_Record_Alias";
const char * const kValueKeyPortValue							= "Port_Value";

const char * const kDictKey						= "";
const char * const kValueKey					= "";
const char * const kArrayKey					= "";



extern CMailDatabase_10_1	*gDB_10_1;	// From CAppServer.cpp

//--------------------------------------------------------------------------------------------------
//	* GetSetFields
//
//--------------------------------------------------------------------------------------------------

Boolean	CHostEntryPref_10_1::GetSetFields ( const eFieldDataRequest_10_1 inFieldRequest,
											const void *inObjDataPtr, void *outFieldData )
{
	Boolean					result = false;
	CHostEntryPrefData_10_1	*theData = (CHostEntryPrefData_10_1 *) inObjDataPtr;
	CHostEntryPref_10_1		*aTempObject	= NULL;
	char					*theDestString = (char *) outFieldData;
	ObjID					*anObjIDPtr = (ObjID *) outFieldData;

	switch (inFieldRequest)
	{
		case kSetObjID_10_1:
			theData->fHostEntryPrefID = *anObjIDPtr;
			break;
			
		case kObjectPINGRequest_10_1:
			// cause the objects constructor to get called, so we force a check of
			// the struct alignment...
			aTempObject = new CHostEntryPref_10_1;
			delete( aTempObject );
			break;
			
		case kStringNameRequest_10_1:
			if (::strlen(theData->fName) != 0)
			{
				CUtils::Strncpy(theDestString, theData->fName, kStr2IDMaxStringSize_10_1);
				result = true;
			}
			break;
			
		case k2ndIDTargetChk_10_1:
			// fall through...

		case k2ndIDRequest_10_1:
		default:
			result = false;
			break;
	}
	
	return result;
} // GetSetFields



//--------------------------------------------------------------------------------------------------
//	* ObjectAllocNew
//
//--------------------------------------------------------------------------------------------------

CDBBaseObject_10_1 * CHostEntryPref_10_1::ObjectAllocNew	( void )
{
	return new CHostEntryPref_10_1;
}

ObjID CHostEntryPref_10_1::GetObjectID ( void )
{
	return (this->GetHostEntryPrefID());
}

//--------------------------------------------------------------------------------------------------
//	 Done
//
//--------------------------------------------------------------------------------------------------

void CHostEntryPref_10_1::Done ( CHostEntryPref_10_1* &inPtr )
{
	CDBBaseObject_10_1 *aDBObject = (CDBBaseObject_10_1 *) inPtr;
	aDBObject->Done(aDBObject);

	inPtr = (CHostEntryPref_10_1 *)aDBObject;

}


CHostEntryPref_10_1* CHostEntryPref_10_1::FindByID ( const ObjID inObjectID )
{
	return (CHostEntryPref_10_1 *) CDBMailBaseObject_10_1::MailUniversalFindByID(	inObjectID,
														CHostEntryPref_10_1::GetObjTypeConstant(),
														CHostEntryPref_10_1::GetObjVersConstant(),
														CHostEntryPref_10_1::GetObjSizeConstant(),
														CHostEntryPref_10_1::ObjectAllocNew		);
} // FindByID

//--------------------------------------------------------------------------------------------------
//	 FindByName
//
//--------------------------------------------------------------------------------------------------

CHostEntryPref_10_1* CHostEntryPref_10_1::FindByName ( const char* inPrefName, bool inCreate )
{
	//static ObjID	lastHostPrefIDFound = 0;

	Boolean		foundOne = false;
	ObjID		theHostPrefID;
	CHostEntryPref_10_1	*theHostEntryPref = NULL;
	OSErr 		result;

	(gDB_10_1->GetBaseObjectCachePtr())->LockTheCache(CHostEntryPref_10_1::GetObjTypeConstant());

	try
	{
		result = gDB_10_1->GetObjDataByString(kHostPrefSignature_10_1, inPrefName, theHostPrefID);
		if (result == CMailDatabase_10_1::kDBNoErr)
		{
			theHostEntryPref = CHostEntryPref_10_1::FindByID(theHostPrefID);

			if (theHostEntryPref != NULL)
			{
				foundOne = true;
			}
		}
		else
		{
			if ( inCreate )
			{
				theHostEntryPref = CHostEntryPref_10_1::Create( inPrefName );
			}
		}
	}
	catch ( ExceptionCode err )
	{
		(gDB_10_1->GetBaseObjectCachePtr())->UnLockTheCache(CHostEntryPref_10_1::GetObjTypeConstant());
		Throw_(err);
	}

	(gDB_10_1->GetBaseObjectCachePtr())->UnLockTheCache(CHostEntryPref_10_1::GetObjTypeConstant());

	return theHostEntryPref;
} // FindByName


//--------------------------------------------------------------------------------------------------
//	* Create
//
//--------------------------------------------------------------------------------------------------

CHostEntryPref_10_1* CHostEntryPref_10_1::Create ( const char *inPrefName )
{
	CHostEntryPref_10_1	*hostEntryPref = nil;
	OSErr			result = kNoErr;
	ObjID			aNewID = 0;
	
	try
	{
		// Initialize it

		(gDB_10_1->GetBaseObjectCachePtr())->LockTheCache(CHostEntryPref_10_1::GetObjTypeConstant());

		// MUST do a find before a create to see if it already exists...
		hostEntryPref = CHostEntryPref_10_1::FindByName( inPrefName, false );
		if ( hostEntryPref == nil )
		{
			hostEntryPref = new CHostEntryPref_10_1;
			ThrowIfMemFail_( hostEntryPref );

			hostEntryPref->SetName( inPrefName );

			result = gDB_10_1->CreateObj(CHostEntryPref_10_1::GetObjTypeConstant(), aNewID, hostEntryPref->GetHostEntryPrefData());
			if ( result == CMailDatabase_10_1::kDBNoErr )
			{
				hostEntryPref->Use();

				if ( ::strcmp(inPrefName, kDefaultString_10_1) == 0 )
				{
					hostEntryPref->SetDefault();
				}
				hostEntryPref->SetDirty();
			}
			else
			{
				delete( hostEntryPref );
				hostEntryPref = nil;
			}
		}
		
		(gDB_10_1->GetBaseObjectCachePtr())->UnLockTheCache(CHostEntryPref_10_1::GetObjTypeConstant());
	}

	catch ( ExceptionCode err )
	{
	}
	
	return (hostEntryPref);
} // Create



//--------------------------------------------------------------------------------------------------
//	* Delete
//
//--------------------------------------------------------------------------------------------------

Boolean CHostEntryPref_10_1::Delete ( CHostEntryPref_10_1* inHostEntryPref )
{
	OSErr	result	= kNoErr;
	Boolean deleted = false;
	
	try
	{
		if (inHostEntryPref != nil)
		{
			(gDB_10_1->GetBaseObjectCachePtr())->LockTheCache(CHostEntryPref_10_1::GetObjTypeConstant());

			result = gDB_10_1->RemoveObj( CHostEntryPref_10_1::GetObjTypeConstant(), inHostEntryPref->GetHostEntryPrefID() );
			deleted = (result == kNoErr);
			if ( deleted )
			{
				inHostEntryPref->fHostEntryPrefData.fHostEntryPrefID = 0;
			}

			(gDB_10_1->GetBaseObjectCachePtr())->UnLockTheCache(CHostEntryPref_10_1::GetObjTypeConstant());
		}
	}
	catch ( ExceptionCode err )
	{
		(gDB_10_1->GetBaseObjectCachePtr())->UnLockTheCache(CHostEntryPref_10_1::GetObjTypeConstant());
	}

	return (deleted);

} // Delete



//--------------------------------------------------------------------------------------------------
//	* Count
//
//--------------------------------------------------------------------------------------------------

uInt32 CHostEntryPref_10_1::Count ( void )
{
	OSErr result;
	uInt32 aCount = 0;
	result = gDB_10_1->GetObjectCount (CHostEntryPref_10_1::GetObjTypeConstant(), aCount);	// of ourselves
	if (result != kNoErr)
	{
		aCount = 0;
	}
	
	return aCount;
} // Count


//--------------------------------------------------------------------------------------------------
//	* GetDefaultHostEntry
//
//--------------------------------------------------------------------------------------------------

CHostEntryPref_10_1* CHostEntryPref_10_1::GetDefaultHostEntry ( void )
{
	CHostEntryPref_10_1	*pOutResult	= nil;

	pOutResult = CHostEntryPref_10_1::GetHostEntryPrefsObj( kDefaultHostPrefsID );

	return( pOutResult );

} // GetDefaultHostEntry


//--------------------------------------------------------------------------------------------------
//	* GetHostEntryPrefsObj
//
//--------------------------------------------------------------------------------------------------

CHostEntryPref_10_1* CHostEntryPref_10_1::GetHostEntryPrefsObj ( ObjID inHostID )
{
	ObjID					prefsID			= 0;
	ObjID					defltPrefsID	= 0;
	CHostEntryPref_10_1	   *prefsObj		= nil;

	// If we got here we either couldn't find the prefs, or we are looking for default
	// Get the object ID from the global root object
	defltPrefsID = gRootObj_10_1->GetHostDefltPrefsID();

	prefsObj = CHostEntryPref_10_1::FindByName( kDefaultString_10_1, false );
	if ( (prefsObj == nil) || (!prefsObj->IsDefault()) )
	{
		if ( (prefsObj != NULL) && (!prefsObj->IsDefault()) )
		{
			prefsObj->Done( prefsObj );
		}

		OSErr			result;
		ObjID			objID;
		SDBIterator_10_1		iterator(gDB_10_1);

		result = gDB_10_1->CreateIterator( CHostEntryPref_10_1::GetObjTypeConstant(), &iterator );
		if ( result == kNoErr )
		{
			while ( gDB_10_1->NextObject( &iterator, objID ) == kNoErr )
			{
				prefsObj = CHostEntryPref_10_1::FindByID( objID );
				if ( prefsObj != nil )
				{
					if ( prefsObj->IsDefault() )
					{
						gRootObj_10_1->SetHostDefltPrefsID( objID );
						break;
					}
					prefsObj->Done( prefsObj );
				}
			}
		}
		gDB_10_1->ReleaseIterator( &iterator );
	}

	// If we still don't have a default prefs record, create it
	if ( prefsObj == nil )
	{
		prefsObj = CHostEntryPref_10_1::Create( kDefaultString_10_1 );
		if ( prefsObj != nil )
		{
			prefsObj->Initialize( true );
			gRootObj_10_1->SetHostDefltPrefsID( prefsObj->GetHostEntryPrefID() );
		}

	}
	
	return( prefsObj );

} // GetHostEntryPrefsObj



#pragma mark -



//--------------------------------------------------------------------------------------------------
//	* CHostEntryPref_10_1
//
//--------------------------------------------------------------------------------------------------

CHostEntryPref_10_1::CHostEntryPref_10_1 ( void ) :
	CDBMailBaseObject_10_1(	&fHostEntryPrefData.fDBHeader,
							&fHostEntryPrefData.fDBFooter,
							&fHostEntryPrefData,
							CHostEntryPref_10_1::GetObjTypeConstant(),
							CHostEntryPref_10_1::GetObjVersConstant(),
							CHostEntryPref_10_1::GetObjSizeConstant() )

{
	fHostEntryPrefData.fHostEntryPrefID		= 0;
	fHostEntryPrefData.fParentHostEntryID	= 0;
	fHostEntryPrefData.fIsDefault			= false;
	fHostEntryPrefData.fName[0]				= '\0';

	::memset( &fHostEntryPrefData.fPrefsData, 0, sizeof( HostPrefs ) );

	// Reserved
	fHostEntryPrefData.fReserved1	= kReservedConst;
	fHostEntryPrefData.fReserved2	= kReservedConst;

	this->ChkCompilerStructAlignment();
} // CHostEntryPref_10_1



//--------------------------------------------------------------------------------------------------
//	* CHostEntryPref_10_1
//
//--------------------------------------------------------------------------------------------------

CHostEntryPref_10_1::~CHostEntryPref_10_1 ( void )
{
} // CHostEntryPref_10_1



void	CHostEntryPref_10_1::ChkCompilerStructAlignment	( void )
{
	/*
		this dump was aquired by using the MPW command DumpSYM - TTE from the .xsym file produced
		from a Code Warrior Pro 1 Release Build of the AppleShare IP Mail Server for MacOS version 6.2
		
		this version of the structure is consider the "reference" standard for all future ASIP Mail Servers.
		If the structure does NOT match these offsets the version of the Mail Server that 
		you are compiling will _NOT_ be compatible with AppleShare IP 6.0, 6.1, or 6.2 (this also effects
		the AppleShare IP Mail Tool, and to a more limited extent the AppleShare IP Mail Admin since some
		of these structures are passed across the wire..)
		
		If _ANY_ of these Asserts "fire" you've got a backwards compatibility problem that _MUST_ be fixed!!
		
		this code wasn't put here for my personal amusement, this code was put here from a hard earned lesson
		that simple changes to headers/compilers _WILL_ break this stuff, better to know now than after we
		ship.  Look upon this code as a debugging AIDE, not an impediment.
		
		Type Name:  CHostEntryPrefData_10_1		TINFO offset: 54628		(TINFO SYM file offset (hex): $125564)
			RecordOf 
			offset 0 NamedTypeOf fDBHeader TypeDef of "Type ID 248"
			offset 12 NamedTypeOf fHostEntryPrefID 
			offset 16 NamedTypeOf fParentHostEntryID unsigned long 
			offset 20 NamedTypeOf fReserved1 
			offset 24 NamedTypeOf fReserved2 unsigned long 
			offset 28 NamedTypeOf fHostName 
			offset 284 NamedTypeOf fIsDefault unsigned byte 
			offset 286 NamedTypeOf fPrefsData TypeDef of "Type ID 266"
			offset 672 

	*/

	static Boolean	aRunOnceFlag = false;	
	if (aRunOnceFlag == false)
	{
		//FileFormatSaftyChk(CHostEntryPrefData_10_1, fDBHeader,			0);
		//FileFormatSaftyChk(CHostEntryPrefData_10_1, fHostEntryPrefID,	12);		// this is us (denormalized)
		//FileFormatSaftyChk(CHostEntryPrefData_10_1, fParentHostEntryID,	16);		// this is us (denormalized)
		//FileFormatSaftyChk(CHostEntryPrefData_10_1, fReserved1,			20);
		//FileFormatSaftyChk(CHostEntryPrefData_10_1, fReserved2,			24);
		//FileFormatSaftyChk(CHostEntryPrefData_10_1, fHostName,			28);			// duplicate of the host name in the HostEntryRecord
		//FileFormatSaftyChk(CHostEntryPrefData_10_1, fIsDefault,			284);			// true if this is the default host prefs record
		//FileFormatSaftyChk(CHostEntryPrefData_10_1, fPrefsData,			286);
		//FileFormatSaftyChk(CHostEntryPrefData_10_1, fDBFooter,			672);
//		this->ReportBackwardCompatibility(sizeof(CHostEntryPrefData_10_1),	676,	"CHostEntryPrefData_10_1", "SIZEOF()");
//		this->ReportBackwardCompatibility(kHostEntryPrefDataSize,	676,	"CHostEntryPrefData_10_1", "kHostEntryPrefDataSize");

		//-----------------------------------------------------------------------------------------
		// now lets check the embedded struct, to make sure it hasn't realigned itself, but kept the
		// same size...
		/*
			Type Name:  HostPrefs		TINFO offset: 54714		(TINFO SYM file offset (hex): $1255BA)
				RecordOf
				offset 0 NamedTypeOf fMHPMailInAllowMailFromUserAtBtn unsigned byte 
				offset 1 NamedTypeOf fMHPMailInDeliverMailFromUserAtBtn 
				offset 2 NamedTypeOf fMHPMailInRejectAllMailFromUsersAtBtn unsigned byte 
				offset 3 NamedTypeOf fMHPMailInLogMsgRejectToErrorLogChk 
				offset 4 NamedTypeOf fMHPMailInLogRecipRejectToErrorLogChk1 unsigned byte 
				offset 5 NamedTypeOf fMHPMailInSendBlindCarbonCopiesChk 
				offset 6 NamedTypeOf fMHPMailInSendBlindCarbonCopiesToUandGID unsigned long 
				offset 10 NamedTypeOf fMHPMailInSendBCCFingerPrint 
				offset 26 NamedTypeOf fMHPMailOutAllowMailToHostBtn unsigned byte 
				offset 27 NamedTypeOf fMHPMailOutHoldMailToHostBtn 
				offset 28 NamedTypeOf fMHPMailOutDeleteMailToHostBtn unsigned byte 
				offset 30 NamedTypeOf fMHPMailOutMessageExpiresAfterEdit 
				offset 34 NamedTypeOf fMHPMailOutWarnSenderOfNonDeliveryChk unsigned byte 
				offset 36 NamedTypeOf fMHPMailOutWarnSenderOfNonDeliveryAfterEdit 
				offset 40 NamedTypeOf fMHPMailOutWarnPostmasterOfNonDeliveryChk unsigned byte 
				offset 41 NamedTypeOf fMHPMailOutForwardAllRemoteMailToChk 
				offset 42 NamedTypeOf fMHPMailOutNotifySenderThatMailToWasRejectedChk unsigned byte 
				offset 43 NamedTypeOf fMHPMailOutNotifyPostmasterThatMailToWasRejectedChk 
				offset 44 NamedTypeOf fMHPMailOutForwardAllRemoteMailToEdit TypeDef of "Type ID 263"
				offset 300 NamedTypeOf fMHPMailOutMessageExpiresAfterChk 
				offset 302 NamedTypeOf fMHPScheduleConnectionPopup unsigned long 
				offset 306 NamedTypeOf fAllowConnectionTimes 
				offset 334 NamedTypeOf fMHPScheduleUseServersDefaultFrequencyBtn unsigned byte 
				offset 335 NamedTypeOf fMHPRemoteMailPollUseServerSchedule 
				offset 336 NamedTypeOf fMHPScheduleConnectEveryBtn unsigned byte 
				offset 337 NamedTypeOf fMHPRemoteMailPollRepeating 
				offset 338 NamedTypeOf fMHPScheduleConnectEveryEdit unsigned long 
				offset 342 NamedTypeOf fMHPRemoteMailETRNScheduleFreq 
				offset 346 NamedTypeOf fMHPScheduleETRNAsNeededChk unsigned byte 
				offset 347 NamedTypeOf fMHPScheduleETRNDuringScheduleChk 
				offset 348 NamedTypeOf fMHPNetworkDNSPopup unsigned long 
				offset 352 NamedTypeOf fMHPNetworkRespectTimeToLiveBtn 
				offset 353 NamedTypeOf fMHPNetworkCacheDNSBtn unsigned byte 
				offset 354 NamedTypeOf fMHPNetworkCacheDNSForEdit 
				offset 358 NamedTypeOf fMHPNetworkResolveMXListChk unsigned byte 
				offset 359 NamedTypeOf fMHPNetworkResolveDNSARecordChk 
				offset 360 NamedTypeOf fMHPNetworkOpenConnectionTimeoutEdit unsigned long 
				offset 364 NamedTypeOf fMHPNetworkRNTimeoutEdit 
				offset 368 NamedTypeOf fMHPNetworkUseSMTPPortChk unsigned byte 
				offset 370 NamedTypeOf fMHPNetworkUseSMTPPortEdit 
				offset 374 NamedTypeOf fMHPNetworkNetworkTimeoutChk unsigned byte 
				offset 376 NamedTypeOf fMHPWindowPositionTopLeft 
				offset 380 NamedTypeOf fMHPWindowPositionBottomRight TypeDef of "Type ID 187"
		*/

		//FileFormatSaftyChk(HostPrefs, fMHPMailInAllowMailFromUserAtBtn,						0);							// 101
		//FileFormatSaftyChk(HostPrefs, fMHPMailInDeliverMailFromUserAtBtn,						1);							// 102
		//FileFormatSaftyChk(HostPrefs, fMHPMailInRejectAllMailFromUsersAtBtn,					2);						// 103
		//FileFormatSaftyChk(HostPrefs, fMHPMailInLogMsgRejectToErrorLogChk,					3);						// 104
		//FileFormatSaftyChk(HostPrefs, fMHPMailInLogRecipRejectToErrorLogChk1,					4);						// 106
		//FileFormatSaftyChk(HostPrefs, fMHPMailInSendBlindCarbonCopiesChk,						5);							// 108
		//FileFormatSaftyChk(HostPrefs, fMHPMailInSendBlindCarbonCopiesToUandGID,				6);					// 109 is text. Data is uInt32.
		//FileFormatSaftyChk(HostPrefs, fMHPMailInSendBCCFingerPrint,							10);								// Finger print for Any User
		//FileFormatSaftyChk(HostPrefs, fMHPMailOutAllowMailToHostBtn,							26);								// 201
		//FileFormatSaftyChk(HostPrefs, fMHPMailOutHoldMailToHostBtn,							27);								// 202
		//FileFormatSaftyChk(HostPrefs, fMHPMailOutDeleteMailToHostBtn,							28);								// 203
		//FileFormatSaftyChk(HostPrefs, fMHPMailOutMessageExpiresAfterEdit,						30);							// 204
		//FileFormatSaftyChk(HostPrefs, fMHPMailOutWarnSenderOfNonDeliveryChk,					34);						// 205
		//FileFormatSaftyChk(HostPrefs, fMHPMailOutWarnSenderOfNonDeliveryAfterEdit,			36);				// 206
		//FileFormatSaftyChk(HostPrefs, fMHPMailOutWarnPostmasterOfNonDeliveryChk,				40);					// 207
		//FileFormatSaftyChk(HostPrefs, fMHPMailOutForwardAllRemoteMailToChk,					41);						// 208
		//FileFormatSaftyChk(HostPrefs, fMHPMailOutNotifySenderThatMailToWasRejectedChk,		42);			// 209
		//FileFormatSaftyChk(HostPrefs, fMHPMailOutNotifyPostmasterThatMailToWasRejectedChk,	43);		// 210
		//FileFormatSaftyChk(HostPrefs, fMHPMailOutForwardAllRemoteMailToEdit,					44);						// 211
		//FileFormatSaftyChk(HostPrefs, fMHPMailOutMessageExpiresAfterChk,						300);							// 212
		//FileFormatSaftyChk(HostPrefs, fMHPScheduleConnectionPopup,							302);								// 3
		//FileFormatSaftyChk(HostPrefs, fAllowConnectionTimes,									306);
		//FileFormatSaftyChk(HostPrefs, fMHPScheduleUseServersDefaultFrequencyBtn,				334);					// 301
		//FileFormatSaftyChk(HostPrefs, fMHPRemoteMailPollUseServerSchedule,					335);	// To be done. Shadow 301 for now.
		//FileFormatSaftyChk(HostPrefs, fMHPScheduleConnectEveryBtn,							336);								// 302
		//FileFormatSaftyChk(HostPrefs, fMHPRemoteMailPollRepeating,							337);			// To be done. Shadow 302 for now.
		//FileFormatSaftyChk(HostPrefs, fMHPScheduleConnectEveryEdit,							338);								// 303
		//FileFormatSaftyChk(HostPrefs, fMHPRemoteMailETRNScheduleFreq,							342);			// To be done. Shadow 303 for now.
		//FileFormatSaftyChk(HostPrefs, fMHPScheduleETRNAsNeededChk,							346);								// 304. kEditHostScheduleConnectionPopupConnectAsNeeded.
		//FileFormatSaftyChk(HostPrefs, fMHPScheduleETRNDuringScheduleChk,						347);							//      kEditHostScheduleConnectionPopupUseCustome
		//FileFormatSaftyChk(HostPrefs, fMHPNetworkDNSPopup,									348);										// 4
		//FileFormatSaftyChk(HostPrefs, fMHPNetworkRespectTimeToLiveBtn,						352);							// 401
		//FileFormatSaftyChk(HostPrefs, fMHPNetworkCacheDNSBtn,									353);										// 402
		//FileFormatSaftyChk(HostPrefs, fMHPNetworkCacheDNSForEdit,								354);									// 403
		//FileFormatSaftyChk(HostPrefs, fMHPNetworkResolveMXListChk,							358);								// 404
		//FileFormatSaftyChk(HostPrefs, fMHPNetworkResolveDNSARecordChk,						359);							// 405
		//FileFormatSaftyChk(HostPrefs, fMHPNetworkOpenConnectionTimeoutEdit,					360);						// 406
		//FileFormatSaftyChk(HostPrefs, fMHPNetworkRNTimeoutEdit,								364);									// 407
		//FileFormatSaftyChk(HostPrefs, fMHPNetworkUseSMTPPortChk,								368);									// 408
		//FileFormatSaftyChk(HostPrefs, fMHPNetworkUseSMTPPortEdit,								370);									// 409
		//FileFormatSaftyChk(HostPrefs, fMHPNetworkNetworkTimeoutChk,							374);								// 411
		//FileFormatSaftyChk(HostPrefs, fMHPWindowPositionTopLeft,								376);
		//FileFormatSaftyChk(HostPrefs, fMHPWindowPositionBottomRight,							380);
//		this->ReportBackwardCompatibility(sizeof(HostPrefs),	384,	"HostPrefs", "SIZEOF()");
	}
	
	aRunOnceFlag = true;
}

//--------------------------------------------------------------------------------------------------
//	* SetUpDefaultValue
//
//--------------------------------------------------------------------------------------------------

void CHostEntryPref_10_1::SetUpDefaultValue ( HostPrefs *inHostProfile )
{
	inHostProfile->fDeliverToLocalOnlyFlag			= false;
	inHostProfile->fLogRejectionsFlag				= false;
	inHostProfile->fSendBCCofAllToUserFlag			= false;
	::memset( &inHostProfile->fSendBCCofAllToUserInfo, 0, sizeof( UserStruct ) );

	// Outgoing Mail
	inHostProfile->fOutMailPopupFlags				= 1;
	inHostProfile->fNotifySenderOfNDRFlag			= false;
	inHostProfile->fNotifyPostmasterOfNDR			= false;
	inHostProfile->fRelaySMTPFlag					= false;
	inHostProfile->fExpireMsgAfterHours				= 72;
	inHostProfile->fRetryFailedMinutes				= 30;
	inHostProfile->fNotifySenderOfNDRHours			= 4;

	// Network Settings
	inHostProfile->fDNS_RequestButtonFlag			= 1;
	inHostProfile->fCacheSettingsButtonFlag			= 1;
	inHostProfile->fCacheDNSMinutes					= 720;
	inHostProfile->fOpenConnTimeoutSeconds			= 120;
	inHostProfile->fReadWriteTimeoutSeconds			= 120;
	inHostProfile->fOutSMTPPortNumber				= 25;

	// Mail-In Panel
	inHostProfile->fMHPMailInAllowMailFromUserAtBtn						= true;
	inHostProfile->fMHPMailInDeliverMailFromUserAtBtn					= false;
	inHostProfile->fMHPMailInRejectAllMailFromUsersAtBtn				= false;
	inHostProfile->fMHPMailInLogMsgRejectToErrorLogChk					= false;
	inHostProfile->fMHPMailInLogRecipRejectToErrorLogChk1				= false;
	inHostProfile->fMHPMailInSendBlindCarbonCopiesChk					= false;
	inHostProfile->fMHPMailInSendBlindCarbonCopiesToUandGID				= 0;

	// Mail-Out Panel
	inHostProfile->fMHPMailOutAllowMailToHostBtn						= true;
	inHostProfile->fMHPMailOutHoldMailToHostBtn							= false;
	inHostProfile->fMHPMailOutDeleteMailToHostBtn						= false;
	inHostProfile->fMHPMailOutMessageExpiresAfterEdit					= 72;
	inHostProfile->fMHPMailOutWarnSenderOfNonDeliveryChk				= false;
	inHostProfile->fMHPMailOutWarnSenderOfNonDeliveryAfterEdit			= 4;
	inHostProfile->fMHPMailOutWarnPostmasterOfNonDeliveryChk			= false;
	inHostProfile->fMHPMailOutForwardAllRemoteMailToChk					= false;
	inHostProfile->fMHPMailOutNotifySenderThatMailToWasRejectedChk		= false;
	inHostProfile->fMHPMailOutNotifyPostmasterThatMailToWasRejectedChk	= false;
	inHostProfile->fMHPMailOutMessageExpiresAfterChk					= true;
	inHostProfile->fMHPMailOutForwardAllRemoteMailToEdit[0]				= '\0';

	// Schedule Panel
	inHostProfile->fMHPScheduleConnectionPopup							= kEditHostScheduleConnectionPopupConnectAsNeeded;
	inHostProfile->fMHPScheduleUseServersDefaultFrequencyBtn			= true;
	inHostProfile->fMHPScheduleConnectEveryBtn							= false;
	inHostProfile->fMHPRemoteMailPollRepeating							= inHostProfile->fMHPRemoteMailPollRepeating;	// shadow value for fMHPScheduleConnectEveryBtn
	inHostProfile->fMHPScheduleConnectEveryEdit							= 20;
	inHostProfile->fMHPRemoteMailETRNScheduleFreq						= inHostProfile->fMHPScheduleConnectEveryEdit;
	inHostProfile->fMHPScheduleETRNAsNeededChk							= false;
	inHostProfile->fMHPScheduleETRNDuringScheduleChk					= false;

	// Network Panel
	inHostProfile->fMHPNetworkDNSPopup									= kEditHostNetworkDNSPopupCacheDNS;
	inHostProfile->fMHPNetworkRespectTimeToLiveBtn						= true;
	inHostProfile->fMHPNetworkCacheDNSBtn								= false;
	inHostProfile->fMHPNetworkCacheDNSForEdit							= 720;
	inHostProfile->fMHPNetworkResolveMXListChk							= true;
	inHostProfile->fMHPNetworkResolveDNSARecordChk						= true;
	inHostProfile->fMHPNetworkOpenConnectionTimeoutEdit					= 120;
	inHostProfile->fMHPNetworkRNTimeoutEdit								= 120;
	inHostProfile->fMHPNetworkUseSMTPPortChk							= false;
	inHostProfile->fMHPNetworkUseSMTPPortEdit							= 25;
	inHostProfile->fMHPNetworkNetworkTimeoutChk							= false;

	::memset( &inHostProfile->fSMTPRelayServerName, 0, 128 );

	short i=0;
	for (i=0; i<kDayCount; i++)
	{
		inHostProfile->fAllowConnectionTimes.fDayHours[i] = k24HoursADay;
	}
} // SetUpDefaultValue



//--------------------------------------------------------------------------------------------------
//	* Initialize
//
//--------------------------------------------------------------------------------------------------

void CHostEntryPref_10_1::Initialize ( Boolean inIsDefault )
{
	if ( inIsDefault == true )
	{
		HostPrefs	tmp;
		SetUpDefaultValue(&tmp);
		SetPrefsData( &tmp );
	}
	else
	{
		CHostEntryPref_10_1 *defltPrefsObj = CHostEntryPref_10_1::GetHostEntryPrefsObj( kDefaultHostPrefsID );
		if ( defltPrefsObj != nil )
		{
			SetPrefsData( defltPrefsObj->GetPrefsData() );
			defltPrefsObj->Done( defltPrefsObj );
			defltPrefsObj = nil;
		}
		else
		{
			HostPrefs	tmp;
			SetUpDefaultValue(&tmp);
			SetPrefsData( &tmp );
		}
	}

} // Initialize


//--------------------------------------------------------------------------------------------------
//	* InitializeFromXML
//
//--------------------------------------------------------------------------------------------------

void CHostEntryPref_10_1::InitializeFromXML ( char & inXMLData )
{
} // InitializeFromXML


#pragma mark -



//--------------------------------------------------------------------------------------------------
//	* SetDirty
//
//--------------------------------------------------------------------------------------------------

void CHostEntryPref_10_1::SetDirty ( void )
{
	if ((this != NULL) && (this->GetHostEntryPrefID() != 0))
	{
		ObjID	parentHostEntryID = this->GetParentHostEntryID();
		if ( (parentHostEntryID != 0) && (parentHostEntryID != kDefaultHostPrefsID) )
		{
		}
		this->setDirty();
	}
} // SetDirty



//--------------------------------------------------------------------------------------------------
//	* GetHostEntryPrefData
//
//--------------------------------------------------------------------------------------------------

CHostEntryPrefData_10_1* CHostEntryPref_10_1::GetHostEntryPrefData ( void )
{
	if (this != nil)
	{
		return( &fHostEntryPrefData );
	}

	return( nil );
} // GetHostEntryPrefData



//--------------------------------------------------------------------------------------------------
//	* GetHostEntryPrefID
//
//--------------------------------------------------------------------------------------------------

ObjID CHostEntryPref_10_1::GetHostEntryPrefID ( void )
{
	return (fHostEntryPrefData.fHostEntryPrefID);
} // GetHostEntryPrefID



//--------------------------------------------------------------------------------------------------
//	* SetHostEntryPrefID
//
//--------------------------------------------------------------------------------------------------

void CHostEntryPref_10_1::SetHostEntryPrefID ( const ObjID inNewObjID )
{
	if (fHostEntryPrefData.fHostEntryPrefID != inNewObjID)
	{
		fHostEntryPrefData.fHostEntryPrefID = inNewObjID;
		this->SetDirty();
	}
} // SetHostEntryPrefID



//--------------------------------------------------------------------------------------------------
//	* GetParentHostEntryID
//
//--------------------------------------------------------------------------------------------------

ObjID CHostEntryPref_10_1::GetParentHostEntryID ( void )
{
	return ( fHostEntryPrefData.fParentHostEntryID );
} // GetParentHostEntryID



//--------------------------------------------------------------------------------------------------
//	* SetParentHostEntryID
//
//--------------------------------------------------------------------------------------------------

void CHostEntryPref_10_1::SetParentHostEntryID ( const ObjID inNewObjID )
{
	if (fHostEntryPrefData.fParentHostEntryID != inNewObjID)
	{
		fHostEntryPrefData.fParentHostEntryID = inNewObjID;
		this->SetDirty();
	}
} // SetParentHostEntryID



//--------------------------------------------------------------------------------------------------
//	* GetName
//
//--------------------------------------------------------------------------------------------------

const char*	CHostEntryPref_10_1::GetName ( void )
{
	return ( fHostEntryPrefData.fName );
} // GetName



//--------------------------------------------------------------------------------------------------
//	* SetName
//
//--------------------------------------------------------------------------------------------------

void CHostEntryPref_10_1::SetName ( const char* inName )
{
	if (CUtils::Stricmp(inName, fHostEntryPrefData.fName) != 0)
	{
		CUtils::Strncpy( fHostEntryPrefData.fName, (char *) inName, sizeof(InetDomainName));
		this->SetDirty();
	}
} // SetName



//--------------------------------------------------------------------------------------------------
//	* GetPrefsData
//
//--------------------------------------------------------------------------------------------------

HostPrefs* CHostEntryPref_10_1::GetPrefsData ( void )
{
	return ( &fHostEntryPrefData.fPrefsData );
} // GetPrefsData



//--------------------------------------------------------------------------------------------------
//	* SetPrefsData
//
//--------------------------------------------------------------------------------------------------

void CHostEntryPref_10_1::SetPrefsData ( HostPrefs *inData )
{
	fHostEntryPrefData.fPrefsData = *inData;
	this->SetDirty();
} // SetPrefsData



//--------------------------------------------------------------------------------------------------
//	* IsDefault
//
//--------------------------------------------------------------------------------------------------

Boolean CHostEntryPref_10_1::IsDefault ( void )
{
	return( fHostEntryPrefData.fIsDefault );
} // IsDefault



//--------------------------------------------------------------------------------------------------
//	* SetDefault
//
//--------------------------------------------------------------------------------------------------

void CHostEntryPref_10_1::SetDefault ( void )
{
	fHostEntryPrefData.fIsDefault = true;
	this->SetDirty();
} // IsDefault



//--------------------------------------------------------------------------------------------------
//	* GetWarnSenderFlag
//
//--------------------------------------------------------------------------------------------------

Boolean CHostEntryPref_10_1::GetWarnSenderFlag ( void )
{
	return( fHostEntryPrefData.fPrefsData.fMHPMailOutWarnSenderOfNonDeliveryChk );
} // GetWarnSenderFlag



//--------------------------------------------------------------------------------------------------
//	* GetWarnPostMasterFlag
//
//--------------------------------------------------------------------------------------------------

Boolean CHostEntryPref_10_1::GetWarnPostMasterFlag ( void )
{
	return fHostEntryPrefData.fPrefsData.fMHPMailOutWarnPostmasterOfNonDeliveryChk;
} // GetWarnPostMasterFlag



//--------------------------------------------------------------------------------------------------
//	* GetWarningTimeHours
//
//--------------------------------------------------------------------------------------------------

uInt32 CHostEntryPref_10_1::GetWarningTimeHours ( void )
{
	return( fHostEntryPrefData.fPrefsData.fMHPMailOutWarnSenderOfNonDeliveryAfterEdit );
} // GetWarningTimeHours



//--------------------------------------------------------------------------------------------------
//	* GetInHostMsgPref ()
//
//--------------------------------------------------------------------------------------------------

EInMsgPreference CHostEntryPref_10_1::GetInHostMsgPref ( void )
{
	
	if ( fHostEntryPrefData.fPrefsData.fMHPMailInAllowMailFromUserAtBtn == true )
	{
		if ( fHostEntryPrefData.fPrefsData.fMHPMailInDeliverMailFromUserAtBtn == true )
		{
			return( kAllowLocalDelivery );
		}
		
		return( kAllowAllMessages );
	}
	else if ( fHostEntryPrefData.fPrefsData.fMHPMailInRejectAllMailFromUsersAtBtn == true )
	{
		return( kRejectAllMessages );
	}
	
	return( kNoValue );

} // GetInHostMsgPref


//--------------------------------------------------------------------------------------------------
//	* SetRejectSMTPInButton ()
//
//--------------------------------------------------------------------------------------------------

void CHostEntryPref_10_1::SetRejectSMTPInState ( void )
{
	if ( (fHostEntryPrefData.fPrefsData.fMHPMailInAllowMailFromUserAtBtn == true) ||
		 (fHostEntryPrefData.fPrefsData.fMHPMailInRejectAllMailFromUsersAtBtn == false) )
	{
		fHostEntryPrefData.fPrefsData.fMHPMailInAllowMailFromUserAtBtn = false;
		fHostEntryPrefData.fPrefsData.fMHPMailInRejectAllMailFromUsersAtBtn = true;
		this->SetDirty();
	}
} // SetRejectSMTPInState


Boolean CHostEntryPref_10_1::GetLogMsgFromRejectFlag ( void )
{
	
	return (fHostEntryPrefData.fPrefsData.fMHPMailInLogMsgRejectToErrorLogChk == true);
}

Boolean CHostEntryPref_10_1::GetLogMsgRecipRejectFlag ( void )
{
	
	return (fHostEntryPrefData.fPrefsData.fMHPMailInLogRecipRejectToErrorLogChk1 == true);
}



//--------------------------------------------------------------------------------------------------
//	* GetSendBCCFlag
//
//--------------------------------------------------------------------------------------------------

Boolean CHostEntryPref_10_1::GetSendBCCFlag ( void )
{
	
	return ( fHostEntryPrefData.fPrefsData.fMHPMailInSendBlindCarbonCopiesChk == true );
} // GetSendBCCFlag



//--------------------------------------------------------------------------------------------------
//	* GetBCCName
//
//--------------------------------------------------------------------------------------------------

Boolean CHostEntryPref_10_1::GetBCCName ( CString &outStr )
{
	Boolean		bResult		= false;

	if ( (fHostEntryPrefData.fPrefsData.fSendBCCofAllToUserInfo.fID != 0) &&
		 (fHostEntryPrefData.fPrefsData.fSendBCCofAllToUserInfo.fUserName[ 0 ] != 0) )
	{
		outStr.Set( &fHostEntryPrefData.fPrefsData.fSendBCCofAllToUserInfo.fUserName[ 1 ], 
					fHostEntryPrefData.fPrefsData.fSendBCCofAllToUserInfo.fUserName[ 0 ] );
		bResult = true;
	}

	return( bResult );
	
} // GetBCCName



//--------------------------------------------------------------------------------------------------
//	* GetOutHostMsgPref
//
//--------------------------------------------------------------------------------------------------

EOutMsgPreference_10_1 CHostEntryPref_10_1::GetOutHostMsgPref ( void )
{
	if (fHostEntryPrefData.fPrefsData.fMHPMailOutAllowMailToHostBtn == true)
	{
		return kAllowAllMailOut_10_1;
	}
	else if (fHostEntryPrefData.fPrefsData.fMHPMailOutHoldMailToHostBtn == true)
	{
		return kHoldAllMailOut_10_1;
	}
	else if (fHostEntryPrefData.fPrefsData.fMHPMailOutDeleteMailToHostBtn == true)
	{
		return kRejectAllMailOut_10_1;
	}
	
	return kNoValueMailOut_10_1;

} // GetOutHostMsgPref



//--------------------------------------------------------------------------------------------------
//	* GetUserNDROnRejectFlag
//
//--------------------------------------------------------------------------------------------------

Boolean CHostEntryPref_10_1::GetUserNDROnRejectFlag ( void )
{
	
	return (fHostEntryPrefData.fPrefsData.fMHPMailOutNotifySenderThatMailToWasRejectedChk == true);
} // GetUserNDROnRejectFlag



//--------------------------------------------------------------------------------------------------
//	* GetPostMstrNDROnRejectFlag
//
//--------------------------------------------------------------------------------------------------

Boolean CHostEntryPref_10_1::GetPostMstrNDROnRejectFlag ( void )
{
	
	return (fHostEntryPrefData.fPrefsData.fMHPMailOutNotifyPostmasterThatMailToWasRejectedChk == true);
} // GetPostMstrNDROnRejectFlag



//--------------------------------------------------------------------------------------------------
//	* GetRejectNDRPref
//
//--------------------------------------------------------------------------------------------------

Boolean CHostEntryPref_10_1::GetRejectNDRPref ( void )
{
	
	return (this->GetUserNDROnRejectFlag() == true) || (this->GetPostMstrNDROnRejectFlag() == true);
} // GetRejectNDRPref


//--------------------------------------------------------------------------------------------------
//	* GetRedirectHostFlag ()
//
//--------------------------------------------------------------------------------------------------

Boolean CHostEntryPref_10_1::GetRedirectHostFlag ( void )
{
	
	return (fHostEntryPrefData.fPrefsData.fMHPMailOutForwardAllRemoteMailToChk == true);
} // GetRedirectHostFlag


//--------------------------------------------------------------------------------------------------
//	* SetRedirectHostFlag ()
//
//--------------------------------------------------------------------------------------------------

void CHostEntryPref_10_1::SetRedirectHostFlag ( const Boolean inRedirectHostFlag )
{
	
	if (fHostEntryPrefData.fPrefsData.fMHPMailOutForwardAllRemoteMailToChk != inRedirectHostFlag )
	{
		fHostEntryPrefData.fPrefsData.fMHPMailOutForwardAllRemoteMailToChk = inRedirectHostFlag;
		this->SetDirty();
	}
} // GetRedirectHostFlag


//--------------------------------------------------------------------------------------------------
//	* GetRedirectHostName ()
//
//--------------------------------------------------------------------------------------------------

char * CHostEntryPref_10_1::GetRedirectHostName ( void )
{
	char *theName = (char *) fHostEntryPrefData.fPrefsData.fMHPMailOutForwardAllRemoteMailToEdit;
	
	if ((unsigned char)(theName[0]) < 0xff)
	{
		theName[theName[0]+1] = 0x00;
	}
	return ( &theName[ 1 ] );
} // GetRedirectHostName


//--------------------------------------------------------------------------------------------------
//	* SetRedirectHostName ()
//
//--------------------------------------------------------------------------------------------------

void CHostEntryPref_10_1::SetRedirectHostName ( const char *inRedirectHostName )
{
	char *theName = (char *) fHostEntryPrefData.fPrefsData.fMHPMailOutForwardAllRemoteMailToEdit;
	
	if ( CUtils::Stricmp( (const char *)&theName[1], inRedirectHostName ) != 0 )
	{
		uInt16 length = ::strlen( inRedirectHostName );
		if (length > 0xfe)
		{
			length = 0xfd;
		}
		CUtils::Strncpy( &theName[1], (char *) inRedirectHostName, length );
		theName[ length + 2 ] = length;	//yes we need +2...this is a pascal string....
		theName[ 0 ] = length;
		this->SetDirty();
	}
} // SetRedirectHostName


//--------------------------------------------------------------------------------------------------
//	* GetHostDNSPopUpValue ()
//
//--------------------------------------------------------------------------------------------------

uInt32 CHostEntryPref_10_1::GetHostDNSPopUpValue ( void )
{
	return ( fHostEntryPrefData.fPrefsData.fMHPNetworkDNSPopup );
} // GetHostDNSPopUpValue


//--------------------------------------------------------------------------------------------------
//	* SetHostDNSPopUpValue ()
//
//--------------------------------------------------------------------------------------------------

void CHostEntryPref_10_1::SetHostDNSPopUpValue ( const uInt32 inHostDNSPopUpValue )
{
	
	if ( inHostDNSPopUpValue != fHostEntryPrefData.fPrefsData.fMHPNetworkDNSPopup )
	{
		fHostEntryPrefData.fPrefsData.fMHPNetworkDNSPopup = inHostDNSPopUpValue;
		this->SetDirty();
	}
} // SetHostDNSPopUpValue


//--------------------------------------------------------------------------------------------------
//	* GetDNSCacheDeltaType ()
//
//--------------------------------------------------------------------------------------------------

ECacheDNSDeltaType_10_1 CHostEntryPref_10_1::GetDNSCacheDeltaType ( void )
{
	if ( fHostEntryPrefData.fPrefsData.fMHPNetworkRespectTimeToLiveBtn == true )
	{
		return( kRespectTTLValue_10_1 );
	}
	else if (fHostEntryPrefData.fPrefsData.fMHPNetworkCacheDNSBtn == true)
	{
		return( kUseCustomCacheDeltaValue_10_1 );
	}

	return( kNoDNSDeltaValue_10_1 );

} // GetDNSCacheDeltaType


void CHostEntryPref_10_1::SetDSNCacheDeltaType ( const ECacheDNSDeltaType_10_1 inCachDeltaType )
{
	switch ( inCachDeltaType )
	{
		case kRespectTTLValue_10_1:
			if (fHostEntryPrefData.fPrefsData.fMHPNetworkRespectTimeToLiveBtn != true)
			{
				fHostEntryPrefData.fPrefsData.fMHPNetworkRespectTimeToLiveBtn = true;
				fHostEntryPrefData.fPrefsData.fMHPNetworkCacheDNSBtn = false;
				this->SetDirty();
			}
			break;

		case kUseCustomCacheDeltaValue_10_1:
			if (fHostEntryPrefData.fPrefsData.fMHPNetworkCacheDNSBtn != true)
			{
				fHostEntryPrefData.fPrefsData.fMHPNetworkRespectTimeToLiveBtn = false;
				fHostEntryPrefData.fPrefsData.fMHPNetworkCacheDNSBtn = true;
				this->SetDirty();
			}
			break;

		default:
			break;	// to make the compiler happy
	}
} // GetDNSCacheDeltaType




//--------------------------------------------------------------------------------------------------
//	* GetCustomDNSDeltaValue
//
//--------------------------------------------------------------------------------------------------

uInt32 CHostEntryPref_10_1::GetCustomDNSDeltaValue ( void )
{
	return (fHostEntryPrefData.fPrefsData.fMHPNetworkCacheDNSForEdit);	// value is returned in Min. quantities..
} // GetCustomDNSDeltaValue

void CHostEntryPref_10_1::SetCustomDNSDeltaValue ( const uInt32 inCustomDNSDeltaValue  )
{
	if (fHostEntryPrefData.fPrefsData.fMHPNetworkCacheDNSForEdit != inCustomDNSDeltaValue)
	{
		fHostEntryPrefData.fPrefsData.fMHPNetworkCacheDNSForEdit = inCustomDNSDeltaValue;
		this->SetDirty();
	}
} // SetCustomDNSDeltaValue



//--------------------------------------------------------------------------------------------------
//	* GetAllowMXListFlag
//
//--------------------------------------------------------------------------------------------------

Boolean CHostEntryPref_10_1::GetAllowMXListFlag ( void )
{
	return (fHostEntryPrefData.fPrefsData.fMHPNetworkResolveMXListChk == true);
} // GetAllowMXListFlag

//--------------------------------------------------------------------------------------------------
//	* GetAllowARecordFlag
//
//--------------------------------------------------------------------------------------------------

Boolean CHostEntryPref_10_1::GetAllowARecordFlag ( void )
{
	return (fHostEntryPrefData.fPrefsData.fMHPNetworkResolveDNSARecordChk == true);
} // GetAllowARecordFlag



//--------------------------------------------------------------------------------------------------
//	* GetNetworkPortFlag
//
//--------------------------------------------------------------------------------------------------

Boolean CHostEntryPref_10_1::GetNetworkPortFlag ( void )
{
	return (fHostEntryPrefData.fPrefsData.fMHPNetworkUseSMTPPortChk == true);
} // GetNetworkPortFlag



//--------------------------------------------------------------------------------------------------
//	* UseHostTimeouts
//
//--------------------------------------------------------------------------------------------------

Boolean CHostEntryPref_10_1::UseHostTimeouts ( void )
{
	return( fHostEntryPrefData.fPrefsData.fMHPNetworkNetworkTimeoutChk == true );
} // UseHostTimeouts



//--------------------------------------------------------------------------------------------------
//	* GetOpenTimeout
//
//--------------------------------------------------------------------------------------------------

uInt32 CHostEntryPref_10_1::GetOpenTimeout ( void )
{
	return( fHostEntryPrefData.fPrefsData.fMHPNetworkOpenConnectionTimeoutEdit );
} // GetOpenTimeout



//--------------------------------------------------------------------------------------------------
//	* GetRdWrTimeout
//
//--------------------------------------------------------------------------------------------------

uInt32 CHostEntryPref_10_1::GetRdWrTimeout ( void )
{
	return( fHostEntryPrefData.fPrefsData.fMHPNetworkRNTimeoutEdit );
} // GetRdWrTimeout



//--------------------------------------------------------------------------------------------------
//	* GetNetworkPortNumber
//
//--------------------------------------------------------------------------------------------------

uInt32 CHostEntryPref_10_1::GetNetworkPortNumber ( void )
{
	return( fHostEntryPrefData.fPrefsData.fMHPNetworkUseSMTPPortEdit );
} // GetNetworkPortNumber

Boolean CHostEntryPref_10_1::GetDefaultFreqFlag ( void )
{
	return (fHostEntryPrefData.fPrefsData.fMHPScheduleUseServersDefaultFrequencyBtn == true);
} // GetDefaultFreqFlag

Boolean CHostEntryPref_10_1::GetCustomFreqFlag ( void )
{
	return (fHostEntryPrefData.fPrefsData.fMHPScheduleConnectEveryBtn == true);
} // GetCustomFreqFlag

uInt32 CHostEntryPref_10_1::GetCustomFreqValue ( void )
{
	return (fHostEntryPrefData.fPrefsData.fMHPScheduleConnectEveryEdit);
} // GetCustomFreqValue


//--------------------------------------------------------------------------------------------------
//	* GetMsgExpireCheckBox
//
//--------------------------------------------------------------------------------------------------

Boolean CHostEntryPref_10_1::GetMsgExpireCheckBox ( void )
{
	return (fHostEntryPrefData.fPrefsData.fMHPMailOutMessageExpiresAfterChk == true);
} // GetMsgExpireCheckBox



//--------------------------------------------------------------------------------------------------
//	* GetMsgExpireHoursValue
//
//--------------------------------------------------------------------------------------------------

uInt32 CHostEntryPref_10_1::GetMsgExpireHoursValue ( void )
{
	return( fHostEntryPrefData.fPrefsData.fMHPMailOutMessageExpiresAfterEdit );
} // GetMsgExpireHoursValue



//--------------------------------------------------------------------------------------------------
//	* IsConnectionAllowed
//
//--------------------------------------------------------------------------------------------------

Boolean CHostEntryPref_10_1::IsConnectionAllowed ( const EDays inDay2Check, const uInt32 inHour2Check )
{
	uInt32	theDayHourMap = 0;
	uInt32	theHour2Check = 0;
	
	if (fHostEntryPrefData.fPrefsData.fMHPScheduleConnectionPopup == kEditHostScheduleConnectionPopupConnectAsNeeded)
	{
		return true;
	}
	else
	{
		if ((inDay2Check >= kSunday) && (inDay2Check <kDayCount))
		{
			theDayHourMap = fHostEntryPrefData.fPrefsData.fAllowConnectionTimes.fDayHours[inDay2Check];
			if ((theHour2Check >= 0) && (theHour2Check <= 23))
			{
				theHour2Check = 0x00000001 << inHour2Check;
				return ((theDayHourMap & theHour2Check) != 0);
			}
			else
			{
			}
		}
		else
		{
		}
	}
	
	return (false);
} // IsConnectionAllowed



//--------------------------------------------------------------------------------------------------
//	* IsCustomSchedule
//
//--------------------------------------------------------------------------------------------------

Boolean CHostEntryPref_10_1::IsCustomSchedule ( void )
{
	
	return(fHostEntryPrefData.fPrefsData.fMHPScheduleConnectionPopup == kEditHostScheduleConnectionPopupUseCustome);
} // IsCustomSchedule



//--------------------------------------------------------------------------------------------------
//	* IsSendETRNOn
//
//--------------------------------------------------------------------------------------------------

Boolean CHostEntryPref_10_1::IsSendETRNOn ( void )
{
	Boolean		resutl = false;
	
	if ( ((fHostEntryPrefData.fPrefsData.fMHPScheduleETRNAsNeededChk == true) &&
		 (fHostEntryPrefData.fPrefsData.fMHPScheduleConnectionPopup == kEditHostScheduleConnectionPopupConnectAsNeeded)) ||
		 ((fHostEntryPrefData.fPrefsData.fMHPScheduleETRNDuringScheduleChk == true) &&
		 (fHostEntryPrefData.fPrefsData.fMHPScheduleConnectionPopup == kEditHostScheduleConnectionPopupUseCustome)) )
	{
		resutl = true;
	}

	return( resutl );

} // IsSendETRNOn



//--------------------------------------------------------------------------------------------------
//	* IsETRNAsNeededOn
//
//--------------------------------------------------------------------------------------------------

Boolean CHostEntryPref_10_1::IsETRNAsNeededOn ( void )
{
	
	return ( fHostEntryPrefData.fPrefsData.fMHPScheduleETRNAsNeededChk );

} // IsETRNAsNeededOn



//--------------------------------------------------------------------------------------------------
//	* IsETRNScheduleOn
//
//--------------------------------------------------------------------------------------------------

Boolean CHostEntryPref_10_1::IsETRNScheduleOn ( void )
{
	
	return ( fHostEntryPrefData.fPrefsData.fMHPScheduleETRNDuringScheduleChk );

} // IsETRNScheduleOn



//--------------------------------------------------------------------------------------------------
//	* GetETRNFreqValue
//
//--------------------------------------------------------------------------------------------------

uInt32 CHostEntryPref_10_1::GetETRNFreqValue ( void )
{
	if ( fHostEntryPrefData.fPrefsData.fMHPRemoteMailETRNScheduleFreq != 0 )
	{
		return( 0 );
	}
	else
	{
		return( fHostEntryPrefData.fPrefsData.fMHPScheduleConnectEveryEdit );
	}
} // GetETRNFreqValue


//--------------------------------------------------------------------------------------------------
//	* CalcNextAllowedTimeDelta
//
//--------------------------------------------------------------------------------------------------

time_t CHostEntryPref_10_1::CalcNextAllowedTimeDelta ( const time_t inCurrentTime,
												  		Boolean  &outAllDaysAreOffFlag )
{
	tm		inCurrentTm = *(::localtime(&inCurrentTime));
	uInt32	startHour = inCurrentTm.tm_hour;
	sInt32	curDay = inCurrentTm.tm_wday;
	sInt32	curDayMap = 0;
	uInt32	dayCount = 0;
	uInt32	sleepDelta = 0;
	sInt32	hour2Check = 0;
	uInt32	emptyDayCount = 0;
	outAllDaysAreOffFlag = false;
	
	while (dayCount < kDayCount)
	{
		curDayMap = fHostEntryPrefData.fPrefsData.fAllowConnectionTimes.fDayHours[curDay];
		if (curDayMap != 0)
		{
			for (hour2Check=startHour; hour2Check<24; hour2Check++)
			{
				if ((curDayMap & (0x00000001 << hour2Check)) == 0)
				{
					if ((hour2Check == (inCurrentTm.tm_hour)) && (curDay == inCurrentTm.tm_wday))
					{
						sleepDelta += (60-inCurrentTm.tm_min);
					}
					else
					{
						sleepDelta += 60;	// add 1 hour to our sleep time...
					}
				}
				else
				{
					return (sleepDelta * 60);	// convert the minute delta to seconds...
				}
			}
		}
		else
		{
			if (curDay == inCurrentTm.tm_wday)
			{
				sleepDelta += (((23 - inCurrentTm.tm_hour) * 60) + (60-inCurrentTm.tm_min));
			}
			else
			{
				sleepDelta += (24 * 60);	// add a whole day to the hours..
			}
			emptyDayCount++;
		}
		
		curDay = (curDay + 1) % kDayCount;	// increment the day count, and wrap at the "end of the week"..
		dayCount++;		// we've check another day...
		startHour = 0;	// start checking at midnight...
	}
	
	outAllDaysAreOffFlag = (emptyDayCount == kDayCount);
	return (sleepDelta * 60);	// convert the sleep delta to seconds...
} // CalcNextAllowedTimeDelta


//--------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------

//--------------------------------------------------------------------------------------------------
//	* GetDeliverToLocalOnlyFlag ()
//
//--------------------------------------------------------------------------------------------------

uInt8 CHostEntryPref_10_1::GetDeliverToLocalOnlyFlag ( void )
{
	return( fHostEntryPrefData.fPrefsData.fDeliverToLocalOnlyFlag );

} // GetDeliverToLocalOnlyFlag


//--------------------------------------------------------------------------------------------------
//	* SetDeliverToLocalOnlyFlag ()
//
//--------------------------------------------------------------------------------------------------

void CHostEntryPref_10_1::SetDeliverToLocalOnlyFlag ( uInt8 inFlag )
{
	if ( fHostEntryPrefData.fPrefsData.fDeliverToLocalOnlyFlag != inFlag )
	{
		fHostEntryPrefData.fPrefsData.fDeliverToLocalOnlyFlag = inFlag;
		this->SetDirty();
	}

	// Legacy support
	if ( inFlag == true )
	{
		fHostEntryPrefData.fPrefsData.fMHPMailInAllowMailFromUserAtBtn = true;
		fHostEntryPrefData.fPrefsData.fMHPMailInDeliverMailFromUserAtBtn = true;
		this->SetDirty();
	}
	else
	{
		fHostEntryPrefData.fPrefsData.fMHPMailInAllowMailFromUserAtBtn = true;
		fHostEntryPrefData.fPrefsData.fMHPMailInDeliverMailFromUserAtBtn = false;
		this->SetDirty();
	}
	
} // SetDeliverToLocalOnlyFlag


//--------------------------------------------------------------------------------------------------
//	* GetLogRejectionsFlag ()
//
//--------------------------------------------------------------------------------------------------

uInt8 CHostEntryPref_10_1::GetLogRejectionsFlag ( void )
{
	return( fHostEntryPrefData.fPrefsData.fLogRejectionsFlag );

} // GetLogRejectionsFlag



//--------------------------------------------------------------------------------------------------
//	* SetLogRejectionsFlag ()
//
//--------------------------------------------------------------------------------------------------

void CHostEntryPref_10_1::SetLogRejectionsFlag ( uInt8 inFlag )
{
	if ( fHostEntryPrefData.fPrefsData.fLogRejectionsFlag != inFlag )
	{
		fHostEntryPrefData.fPrefsData.fLogRejectionsFlag = inFlag;
		this->SetDirty();
	}

	// Legacy support
	if ( fHostEntryPrefData.fPrefsData.fMHPMailInLogMsgRejectToErrorLogChk != inFlag )
	{
		fHostEntryPrefData.fPrefsData.fMHPMailInLogMsgRejectToErrorLogChk = inFlag;
		this->SetDirty();
	}
} // SetLogRejectionsFlag


//--------------------------------------------------------------------------------------------------
//	* GetSendBCC_CopiesOfAllFlag
//
//--------------------------------------------------------------------------------------------------

uInt8 CHostEntryPref_10_1::GetSendBCC_CopiesOfAllFlag ( void )
{
	return( fHostEntryPrefData.fPrefsData.fSendBCCofAllToUserFlag );

} // GetSendBCC_CopiesOfAllFlag


//--------------------------------------------------------------------------------------------------
//	* SetSendBCC_CopiesOfAllFlag
//
//--------------------------------------------------------------------------------------------------

void CHostEntryPref_10_1::SetSendBCC_CopiesOfAllFlag ( uInt8 inFlag )
{
	if ( fHostEntryPrefData.fPrefsData.fSendBCCofAllToUserFlag != inFlag )
	{
		fHostEntryPrefData.fPrefsData.fSendBCCofAllToUserFlag = inFlag;
		this->SetDirty();
	}

	// Legacy Support
	if ( fHostEntryPrefData.fPrefsData.fMHPMailInSendBlindCarbonCopiesChk != inFlag )
	{
		fHostEntryPrefData.fPrefsData.fMHPMailInSendBlindCarbonCopiesChk = inFlag;
		this->SetDirty();
	}

} // SetSendBCC_CopiesOfAllFlag


//--------------------------------------------------------------------------------------------------
//	* GetSendBCC_CopiesOfAllUser ()
//
//--------------------------------------------------------------------------------------------------

void CHostEntryPref_10_1::GetSendBCC_CopiesOfAllUser ( UserStruct *outInfo )
{
	if ( outInfo != nil )
	{
		::memcpy( outInfo, &fHostEntryPrefData.fPrefsData.fSendBCCofAllToUserInfo, sizeof( UserStruct ) );
	}
} // GetSendBCC_CopiesOfAllUser


//--------------------------------------------------------------------------------------------------
//	* SetSendBCC_CopiesOfAllUser
//
//--------------------------------------------------------------------------------------------------

void CHostEntryPref_10_1::SetSendBCC_CopiesOfAllUser ( UserStruct *inInfo )
{
	uInt32		uiStrLen	= 0;

	if ( inInfo != nil )
	{
		::memcpy( &fHostEntryPrefData.fPrefsData.fSendBCCofAllToUserInfo, inInfo, sizeof( UserStruct ) );
		this->SetDirty();
	}
} // SetSendBCC_CopiesOfAllUser


//--------------------------------------------------------------------------------------------------
//	* GetOutMailPopupFlags
//
//--------------------------------------------------------------------------------------------------

uInt32 CHostEntryPref_10_1::GetOutMailPopupFlags ( void )
{
	return( fHostEntryPrefData.fPrefsData.fOutMailPopupFlags );

} // GetOutMailPopupFlags


//--------------------------------------------------------------------------------------------------
//	* SetOutMailPopupFlags
//
//--------------------------------------------------------------------------------------------------

void CHostEntryPref_10_1::SetOutMailPopupFlags ( uInt32 inValue )
{
	if ( fHostEntryPrefData.fPrefsData.fOutMailPopupFlags != inValue )
	{
		fHostEntryPrefData.fPrefsData.fOutMailPopupFlags = inValue;
		this->SetDirty();
	}
} // SetOutMailPopupFlags


//--------------------------------------------------------------------------------------------------
//	* GetExpireOutMailAfterHours
//
//--------------------------------------------------------------------------------------------------

uInt32 CHostEntryPref_10_1::GetExpireOutMailAfterHours ( void )
{
	return( fHostEntryPrefData.fPrefsData.fExpireMsgAfterHours );

} // GetExpireOutMailAfterHours


//--------------------------------------------------------------------------------------------------
//	* SetExpireOutMailAfterHours
//
//--------------------------------------------------------------------------------------------------

void CHostEntryPref_10_1::SetExpireOutMailAfterHours ( uInt32 inValue )
{
	if ( fHostEntryPrefData.fPrefsData.fExpireMsgAfterHours != inValue )
	{
		fHostEntryPrefData.fPrefsData.fExpireMsgAfterHours = inValue;
		this->SetDirty();
	}

	// Legacy
	if ( fHostEntryPrefData.fPrefsData.fMHPMailOutMessageExpiresAfterEdit != inValue )
	{
		fHostEntryPrefData.fPrefsData.fMHPMailOutMessageExpiresAfterEdit = inValue;
		this->SetDirty();
	}

	if ( fHostEntryPrefData.fPrefsData.fMHPMailOutMessageExpiresAfterChk != true )
	{
		fHostEntryPrefData.fPrefsData.fMHPMailOutMessageExpiresAfterChk = true;
		this->SetDirty();
	}

} // SetExpireOutMailAfterHours


//--------------------------------------------------------------------------------------------------
//	* GetRetryFailedMinutes
//
//--------------------------------------------------------------------------------------------------

uInt32 CHostEntryPref_10_1::GetRetryFailedMinutes ( void )
{
	return( fHostEntryPrefData.fPrefsData.fRetryFailedMinutes );

} // GetRetryFailedMinutes


//--------------------------------------------------------------------------------------------------
//	* SetRetryFailedMinutes
//
//--------------------------------------------------------------------------------------------------

void CHostEntryPref_10_1::SetRetryFailedMinutes ( uInt32 inMinutes )
{
	if ( fHostEntryPrefData.fPrefsData.fRetryFailedMinutes != inMinutes )
	{
		fHostEntryPrefData.fPrefsData.fRetryFailedMinutes = inMinutes;
		this->SetDirty();
	}
} // SetRetryFailedMinutes


//--------------------------------------------------------------------------------------------------
//	* GetNotifySenderOfNDRFlag
//
//--------------------------------------------------------------------------------------------------

uInt8 CHostEntryPref_10_1::GetNotifySenderOfNDRFlag ( void )
{
	return( fHostEntryPrefData.fPrefsData.fNotifySenderOfNDRFlag );

} // GetNotifySenderOfNDRFlag


//--------------------------------------------------------------------------------------------------
//	* SetNotifySenderOfNDRFlag
//
//--------------------------------------------------------------------------------------------------

void CHostEntryPref_10_1::SetNotifySenderOfNDRFlag ( uInt8 inFlag )
{
	if ( fHostEntryPrefData.fPrefsData.fNotifySenderOfNDRFlag != inFlag )
	{
		fHostEntryPrefData.fPrefsData.fNotifySenderOfNDRFlag = inFlag;
		this->SetDirty();
	}

	// Legacy support
	if ( fHostEntryPrefData.fPrefsData.fMHPMailOutWarnSenderOfNonDeliveryChk != inFlag )
	{
		fHostEntryPrefData.fPrefsData.fMHPMailOutWarnSenderOfNonDeliveryChk = inFlag;
		this->SetDirty();
	}
} // SetNotifySenderOfNDRFlag


//--------------------------------------------------------------------------------------------------
//	* GetNotifySenderOfNDRMinutes
//
//--------------------------------------------------------------------------------------------------

uInt32 CHostEntryPref_10_1::GetNotifySenderOfNDRMinutes ( void )
{
	return( fHostEntryPrefData.fPrefsData.fNotifySenderOfNDRHours );

} // GetNotifySenderOfNDRMinutes


//--------------------------------------------------------------------------------------------------
//	* SetNotifySenderOfNDRMinutes
//
//--------------------------------------------------------------------------------------------------

void CHostEntryPref_10_1::SetNotifySenderOfNDRMinutes ( uInt32 inMinutes )
{
	if ( fHostEntryPrefData.fPrefsData.fNotifySenderOfNDRHours != inMinutes )
	{
		fHostEntryPrefData.fPrefsData.fNotifySenderOfNDRHours = inMinutes;
		this->SetDirty();
	}

	// Legacy Support
	if ( fHostEntryPrefData.fPrefsData.fMHPMailOutWarnSenderOfNonDeliveryAfterEdit != inMinutes )
	{
		fHostEntryPrefData.fPrefsData.fMHPMailOutWarnSenderOfNonDeliveryAfterEdit = inMinutes;
		this->SetDirty();
	}
} // SetNotifySenderOfNDRMinutes


//--------------------------------------------------------------------------------------------------
//	* GetNotifyPostmasterOfNDR
//
//--------------------------------------------------------------------------------------------------

uInt8 CHostEntryPref_10_1::GetNotifyPostmasterOfNDR ( void )
{
	return( fHostEntryPrefData.fPrefsData.fNotifyPostmasterOfNDR );

} // GetNotifyPostmasterOfNDR


//--------------------------------------------------------------------------------------------------
//	* SetNotifyPostmasterOfNDR
//
//--------------------------------------------------------------------------------------------------

void CHostEntryPref_10_1::SetNotifyPostmasterOfNDR ( uInt8 inFlag )
{
	if ( fHostEntryPrefData.fPrefsData.fNotifyPostmasterOfNDR != inFlag )
	{
		fHostEntryPrefData.fPrefsData.fNotifyPostmasterOfNDR = inFlag;
		this->SetDirty();
	}

	// Legacy support
	if ( fHostEntryPrefData.fPrefsData.fMHPMailOutWarnPostmasterOfNonDeliveryChk != inFlag )
	{
		fHostEntryPrefData.fPrefsData.fMHPMailOutWarnPostmasterOfNonDeliveryChk = inFlag;
		this->SetDirty();
	}

} // SetNotifyPostmasterOfNDR


//--------------------------------------------------------------------------------------------------
//	* GetRelaySMTPFlag
//
//--------------------------------------------------------------------------------------------------

uInt8 CHostEntryPref_10_1::GetRelaySMTPFlag ( void )
{
	return( fHostEntryPrefData.fPrefsData.fRelaySMTPFlag );

} // GetRelaySMTPFlag


//--------------------------------------------------------------------------------------------------
//	* SetRelaySMTPFlag
//
//--------------------------------------------------------------------------------------------------

void CHostEntryPref_10_1::SetRelaySMTPFlag ( uInt8 inFlag )
{
	if ( fHostEntryPrefData.fPrefsData.fRelaySMTPFlag != inFlag )
	{
		fHostEntryPrefData.fPrefsData.fRelaySMTPFlag = inFlag;
		this->SetDirty();
	}

	// Legacy Support

	SetRedirectHostFlag( inFlag );

} // SetRelaySMTPFlag


//--------------------------------------------------------------------------------------------------
//	* GetRelaySMTPServer
//
//--------------------------------------------------------------------------------------------------

const char * CHostEntryPref_10_1::GetRelaySMTPServer ( void )
{
	return( fHostEntryPrefData.fPrefsData.fSMTPRelayServerName );

} // GetRelaySMTPServer


//--------------------------------------------------------------------------------------------------
//	* SetRelaySMTPServer
//
//--------------------------------------------------------------------------------------------------

void CHostEntryPref_10_1::SetRelaySMTPServer ( const char *inSvrName, uInt32 inLen )
{
	uInt32		strLen	= inLen;
	char		*p		= nil;
	
	if ( inSvrName != nil )
	{
		p = (char *)::calloc( inLen + 2, sizeof( char ) );
		::strncpy( p, inSvrName, inLen );

		if ( ::strcmp( p, fHostEntryPrefData.fPrefsData.fSMTPRelayServerName ) != 0 )
		{
			if ( inLen > 127 )
			{
				strLen = 127;
			}

			::memset( fHostEntryPrefData.fPrefsData.fSMTPRelayServerName, 0, 128 );
			::strncpy( fHostEntryPrefData.fPrefsData.fSMTPRelayServerName, p, strLen );
			this->SetDirty();
		}

		// Legacy Support
		SetRedirectHostName( p );
		free( p );
	}
} // SetRelaySMTPServer


//--------------------------------------------------------------------------------------------------
//	* GetDNSRequestButtonFlags
//
//--------------------------------------------------------------------------------------------------

uInt16 CHostEntryPref_10_1::GetDNSRequestButtonFlags ( void )
{
	return( fHostEntryPrefData.fPrefsData.fDNS_RequestButtonFlag );

} // GetDNSRequestButtonFlags


//--------------------------------------------------------------------------------------------------
//	* SetDNSRequestButtonFlags
//
//--------------------------------------------------------------------------------------------------

void CHostEntryPref_10_1::SetDNSRequestButtonFlags ( uInt16 inValue )
{
	if ( fHostEntryPrefData.fPrefsData.fDNS_RequestButtonFlag != inValue )
	{
		fHostEntryPrefData.fPrefsData.fDNS_RequestButtonFlag = inValue;
		this->SetDirty();
	}

	// Legacy support
	bool	bMXListFlag	= false;
	bool	bARecFlag	= false;

	switch ( inValue )
	{
		default:
		case kMXandARecord:
			bMXListFlag	= true;
			bARecFlag	= true;
			break;

		case kMXonly:
			bMXListFlag	= true;
			bARecFlag	= false;
			break;

		case kARecordOnly:
			bMXListFlag	= false;
			bARecFlag	= true;
			break;
	}

	if ( fHostEntryPrefData.fPrefsData.fMHPNetworkResolveMXListChk != bMXListFlag )
	{
		fHostEntryPrefData.fPrefsData.fMHPNetworkResolveMXListChk = bMXListFlag;
		this->SetDirty();
	}

	if ( fHostEntryPrefData.fPrefsData.fMHPNetworkResolveDNSARecordChk != bARecFlag )
	{
		fHostEntryPrefData.fPrefsData.fMHPNetworkResolveDNSARecordChk = bARecFlag;
		this->SetDirty();
	}

} // SetDNSRequestButtonFlags


//--------------------------------------------------------------------------------------------------
//	* GetCacheSettingsButtonFlags
//
//--------------------------------------------------------------------------------------------------

uInt16 CHostEntryPref_10_1::GetCacheSettingsButtonFlags ( void )
{
	return( fHostEntryPrefData.fPrefsData.fCacheSettingsButtonFlag );

} // GetCacheSettingsButtonFlags


//--------------------------------------------------------------------------------------------------
//	* SetCacheSettingsButtonFlags
//
//--------------------------------------------------------------------------------------------------

void CHostEntryPref_10_1::SetCacheSettingsButtonFlags ( uInt16 inValue )
{
	if ( fHostEntryPrefData.fPrefsData.fCacheSettingsButtonFlag != inValue )
	{
		fHostEntryPrefData.fPrefsData.fCacheSettingsButtonFlag = inValue;
		this->SetDirty();
	}

	// Legacy support
	this->SetHostDNSPopUpValue( kEditHostNetworkDNSPopupCacheDNS );

	ECacheDNSDeltaType_10_1 cachType	= kUseCustomCacheDeltaValue_10_1;
	if ( inValue == kRespectTTL )
	{
		cachType = kRespectTTLValue_10_1;
	}

	this->SetDSNCacheDeltaType ( cachType );

} // SetCacheSettingsButtonFlags


//--------------------------------------------------------------------------------------------------
//	* GetCacheDNSMinutes
//
//--------------------------------------------------------------------------------------------------

uInt32 CHostEntryPref_10_1::GetCacheDNSMinutes ( void )
{
	return( fHostEntryPrefData.fPrefsData.fCacheDNSMinutes );

} // GetCacheDNSMinutes


//--------------------------------------------------------------------------------------------------
//	* SetCacheDNSMinutes
//
//--------------------------------------------------------------------------------------------------

void CHostEntryPref_10_1::SetCacheDNSMinutes ( uInt32 inValue )
{
	if ( fHostEntryPrefData.fPrefsData.fCacheDNSMinutes != inValue )
	{
		fHostEntryPrefData.fPrefsData.fCacheDNSMinutes = inValue;
		this->SetDirty();
	}

	// Legacy support
	this->SetCustomDNSDeltaValue( inValue  );

} // SetCacheDNSMinutes


//--------------------------------------------------------------------------------------------------
//	* GetOpenConnTimeoutSeconds
//
//--------------------------------------------------------------------------------------------------

uInt32 CHostEntryPref_10_1::GetOpenConnTimeoutSeconds ( void )
{
	return( fHostEntryPrefData.fPrefsData.fOpenConnTimeoutSeconds );

} // GetOpenConnTimeoutSeconds


//--------------------------------------------------------------------------------------------------
//	* SetOpenConnTimeoutSeconds
//
//--------------------------------------------------------------------------------------------------

void CHostEntryPref_10_1::SetOpenConnTimeoutSeconds ( uInt32 inValue )
{
	if ( fHostEntryPrefData.fPrefsData.fOpenConnTimeoutSeconds != inValue )
	{
		fHostEntryPrefData.fPrefsData.fOpenConnTimeoutSeconds = inValue;
		this->SetDirty();
	}

	// Legacy support
	if ( fHostEntryPrefData.fPrefsData.fMHPNetworkOpenConnectionTimeoutEdit != inValue )
	{
		fHostEntryPrefData.fPrefsData.fMHPNetworkOpenConnectionTimeoutEdit = inValue;
		this->SetDirty();
	}
} // SetOpenConnTimeoutSeconds


//--------------------------------------------------------------------------------------------------
//	* GetReadWriteTimeoutSeconds
//
//--------------------------------------------------------------------------------------------------

uInt32 CHostEntryPref_10_1::GetReadWriteTimeoutSeconds ( void )
{
	return( fHostEntryPrefData.fPrefsData.fReadWriteTimeoutSeconds );

} // GetReadWriteTimeoutSeconds


//--------------------------------------------------------------------------------------------------
//	* SetReadWriteTimeoutSeconds
//
//--------------------------------------------------------------------------------------------------

void CHostEntryPref_10_1::SetReadWriteTimeoutSeconds ( uInt32 inValue )
{
	if ( fHostEntryPrefData.fPrefsData.fReadWriteTimeoutSeconds != inValue )
	{
		fHostEntryPrefData.fPrefsData.fReadWriteTimeoutSeconds = inValue;
		this->SetDirty();
	}

	// Legacy support
	if ( fHostEntryPrefData.fPrefsData.fMHPNetworkRNTimeoutEdit != inValue )
	{
		fHostEntryPrefData.fPrefsData.fMHPNetworkRNTimeoutEdit = inValue;
		this->SetDirty();
	}

} // SetReadWriteTimeoutSeconds


//--------------------------------------------------------------------------------------------------
//	* GetOutSMTPPortNumber
//
//--------------------------------------------------------------------------------------------------

uInt32 CHostEntryPref_10_1::GetOutSMTPPortNumber ( void )
{
	return( fHostEntryPrefData.fPrefsData.fOutSMTPPortNumber );

} // GetOutSMTPPortNumber


//--------------------------------------------------------------------------------------------------
//	* SetOutSMTPPortNumber
//
//--------------------------------------------------------------------------------------------------

void CHostEntryPref_10_1::SetOutSMTPPortNumber ( uInt32 inValue )
{
	if ( fHostEntryPrefData.fPrefsData.fOutSMTPPortNumber != inValue )
	{
		fHostEntryPrefData.fPrefsData.fOutSMTPPortNumber = inValue;
		this->SetDirty();
	}

	// Legacy support
	if ( fHostEntryPrefData.fPrefsData.fMHPNetworkUseSMTPPortEdit != inValue )
	{
		fHostEntryPrefData.fPrefsData.fMHPNetworkUseSMTPPortEdit = inValue;
		this->SetDirty();
	}

	bool	bCheckSMTP = false;
	if ( inValue != 25 )
	{
		bCheckSMTP = true;
	}
	if ( fHostEntryPrefData.fPrefsData.fMHPNetworkUseSMTPPortChk != bCheckSMTP )
	{
		fHostEntryPrefData.fPrefsData.fMHPNetworkUseSMTPPortChk = bCheckSMTP;
		this->SetDirty();
	}

} // SetOutSMTPPortNumber




