/*
	File:		CServerPrefs.10.1.h

	Contains:	C++ class definition for Host Entry

	Copyright:	 1996-2001 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: CServerPrefs.10.1.h,v $
		Revision 1.1  2003/04/20 23:46:10  dasenbro
		Initial check-in.
		

	To Do:
*/


#ifndef _CServerPrefs__10_1_h__
#define _CServerPrefs__10_1_h__ 1

#include "CMailDatabase.10.1.h"
#include "CDBMailBaseObject.10.1.h"
#include "ServerPrefs.10.1.h"
#include "MailGlobals.h"

class	CString;

const uInt32	kExtraBytesMaxSize_10_1 = 1024;	// Prefs2

typedef enum
{
	kNoSvrPrefsFlags_10_1		=	0x00000000,		// was kNoSvrPrefs2Flags
	kDoRBLDomainCheckFlag_10_1	=	0x00000001,
	kUseCustRBLDomainFlag_10_1	=	0x00000002,
	kDoFullHostListChkFlag_10_1	=	0x40000000
} eServerPrefsFlags_10_1;							// was eServerPrefs2Flags


typedef struct
{
	StdDBObjHeader_10_1	fDBHeader;

	ObjID				fServerPrefsID;		// self ID, here for data scavenging reasons...
	uInt32				fTimeStamp;
	uInt32				fOurLastIPAddress;	// our last IP Address // to detect if our IP address has changed since last startup - we may need to change the greeting name accordingly. 

	// Reserved
	uInt32				fReserved1;				// reserverd
	uInt32				fReserved2;				// reserverd

	ServerPrefs			fPrefsData;

// Prefs2
	uInt32				fServerPrefsFlags;		// was fServerPrefs2Flags
	Str255				fRBLAlternateDomainName;
	uInt32				fExtraFlags[ kExtraBytesMaxSize_10_1 ];
//

	StdDBObjFooter_10_1	fDBFooter;

} CServerPrefsData_10_1;


// CDBMailBaseObject Constants
const uInt32	kServerPrefsDataSize_10_1	= sizeof( CServerPrefsData_10_1 );
const uInt32	kServerPrefsVersion_10_1	= kDBCurrentVersion_10_1 + kServerPrefsDataSize_10_1;

typedef enum
{
	kServerNoDNSDeltaValue_10_1,
	kServerRespectTTLValue_10_1,
	kServerUseCustomCacheDeltaValue_10_1
} EServerDNSDeltaType_10_1;

class CServerPrefs_10_1 : public CDBMailBaseObject_10_1
{
public:

	// Static Methods
	static CServerPrefs_10_1*	GetServerPrefsObj		( const Boolean inOKToFindFlag = true, const Boolean inForceInitFlag = false );
	static CServerPrefs_10_1*	prefsObjPtr;

	static CServerPrefs_10_1*	Create					( void );
	static Boolean 				Delete					( CServerPrefs_10_1* inServerPrefs	);
	static uInt32 				Count					( void );
	static Boolean				GetSetFields			( const eFieldDataRequest_10_1 inFieldRequest, const void *inObjDataPtr, void *outFieldData );

	static 	CServerPrefs_10_1*	FindByID			( const	ObjID	inObjectID );
	static	CDBBaseObject_10_1*	ObjectAllocNew		( void );

	static	OSType		GetObjTypeConstant	( void ) { return kServerPrefsSignature_10_1; }
	static	uInt32		GetObjVersConstant	( void ) { return kServerPrefsVersion_10_1; }
	static	uInt32		GetObjSizeConstant	( void ) { return kServerPrefsDataSize_10_1; }

	virtual	ObjID		GetObjectID					( void );
//	virtual	void		ChkCompilerStructAlignment	( void );
			 void		Done						( CServerPrefs_10_1* &inPtr );

	// Constructor/Destructor
						CServerPrefs_10_1				( void );
	virtual			   ~CServerPrefs_10_1				( void );

	void				Initialize					( void );
	void				InitializeGreetings			( void );

	// Object IDs
	ObjID				GetServerPrefsID			( void );
	void				SetServerPrefsID			( const ObjID inNewObjID );

	uInt32				GetOurLastIPAddr			( void );
	void				SetOurLastIPAddr			( const uInt32 inIPAddr );

	uInt32				GetPrefsTimeStamp			( void );

	ServerPrefs*		GetPrefsData				( void );
	void				SetPrefsData				( ServerPrefs *inData );

// -----------------
	bool				GetMaxMessageSizeFlag		( void );
	void				SetMaxMessageSizeFlag		( bool inFlag );

	uInt32				GetMaxMessageSize			( void );
	void				SetMaxMessageSize			( uInt32 inValue );

	bool				GetBCC_Flag					( void );
	void				SetBCC_Flag					( bool inFlag );

	void				GetBCC_UserStruct			( UserStruct *outInfo );
	void				SetBCC_UserStruct			( UserStruct *inInfo );

	bool				GetAutoMailDeleteFlag		( void );
	void				SetAutoMailDeleteFlag		( bool inFlag );

	uInt32				GetDeleteUnseenDays			( void );
	void				SetDeleteUnseenDays			( uInt32 inValue );

	uInt32				GetDeleteSeenDays			( void );
	void				SetDeleteSeenDays			( uInt32 inValue );

	bool				GetFWDUnknownLoalUserFlag	( void );
	void				SetFWDUnknownLoalUserFlag	( bool inFlag );

	void				GetFWDUnknownLoalUserUserStruct	( UserStruct *outInfo );
	void				SetFWDUnknownLoalUserUserStruct	( UserStruct *inInfo );

	bool				GetCheckSMTP_InFlag			( void );
	void				SetCheckSMTP_InFlag			( bool inFlag );

	bool				GetUseDefaultSpamSrvrFlag	( void );
	void				SetUseDefaultSpamSrvrFlag	( bool inFlag );

	bool				GetUseCustomSpamSrvrFlag	( void );
	void				SetUseCustomSpamSrvrFlag	( bool inFlag );

	char*				GetDefaultSpamSrvr			( void );
	void				SetDefaultSpamSrvr			( char *inName, uInt32 inLen );

	char*				GetCustomSpamSrvr			( void );
	void				SetCustomSpamSrvr			( char *inName, uInt32 inLen );

	bool				GetLogIfBadSMTPNameFlag		( void );
	void				SetLogIfBadSMTPNameFlag		( bool inFlag );

	bool				GetRejectIfNameNoMatch		( void );
	void				SetRejectIfNameNoMatch		( bool inFlag );

	bool				GetRequireLocalFromFlag		( void );
	void				SetRequireLocalFromFlag		( bool inFlag );

	bool				GetRejectIfNotInHostListFlag( void );
	void				SetRejectIfNotInHostListFlag( bool inFlag );

	uInt32				GetSMTP_State				( void );
	void				SetSMTP_State				( uInt32 inFlag );

	bool				GetSMTP_EnabledFlag			( void );
	void				SetSMTP_EnabledFlag			( bool inFlag );

	bool				GetIMAP_EnabledFlag			( void );
	void				SetIMAP_EnabledFlag			( bool inFlag );

	bool				GetPOP3_EnabledFlag			( void );
	void				SetPOP3_EnabledFlag			( bool inFlag );

	bool				GetNofifyEnabledFlag		( void );
	void				SetNofifyEnabledFlag		( bool inFlag );

	bool				GetSMTPRelayWhenBackupFlag	( void );
	void				SetSMTPRelayWhenBackupFlag	( bool inFlag );

	bool				GetSendUndelivNDRToPMFlag	( void );
	void				SetSendUndelivNDRToPMFlag	( bool inFlag );

	bool				GetAllowNDRsBulkMailFlag	( void );
	void				SetAllowNDRsBulkMailFlag	( bool inFlag );

	bool				GetAllowIMAPAdminAccessFlag	( void );
	void				SetAllowIMAPAdminAccessFlag	( bool inFlag );

	uInt32				GetAdminPortNumber			( void );
	void				SetAdminPortNumber			( uInt32 inValue );

	bool				GetCaseSensativeFldrNameFlag( void );
	void				SetCaseSensativeFldrNameFlag( bool inFlag );

	uInt32				GetConnPerIMAPAcctPerIP		( void );
	void				SetConnPerIMAPAcctPerIP		( uInt32 inValue );

	uInt32				GetIMAPConnIdleTimeout		( void );
	void				SetIMAPConnIdleTimeout		( uInt32 inValue );


//	uInt32				GetDeleteUnseenDays			( void );
//	void				SetDeleteUnseenDays			( uInt32 inValue );

//	uInt32				GetDeleteUnseenDays			( void );
//	void				SetDeleteUnseenDays			( uInt32 inValue );

// --- xxx --- xxx --- xxx --- xxx --- xxx --- xxx --- xxx --- xxx --- xxx --- xxx --- xxx --- xxx 

	uInt32				GetMsgExpirationHours		( void );
	uInt32				GetMsgWarningHours			( void );
	
	Boolean				GetForwardRemoteMsgFlag		( void );
	void				SetForwardRemoteMsgFlag		( const Boolean inSetForwardRemoteMailFlag );

	char *				GetForwardRemoteMsgName		( void );

	Boolean				GetMsgWarningFlag			( void );
	Boolean				GetWarn_PM_OfNonDelivery	( void );
	Boolean				GetCheckMaxMsgSize			( void );
	Boolean				GetSendBCCFlag				( void );

	
	uInt16				GetSMTPInPort				( void );
	void				SetSMTPInPort				( uInt16 inPort );

	uInt16				GetSMTPOutPort				( void );
	void				SetSMTPOutPort				( uInt16 inPort );

	uInt16				GetIMAPPort					( void );
	void				SetIMAPPort					( uInt16 inPort );

	uInt16				GetPOP3Port					( void );
	void				SetPOP3Port					( uInt16 inPort );

	uInt16				GetNotifyMailPort			( void );
	void				SetNotifyMailPort			( uInt16 inPort );


	void				SetThisProtocolPort			( PortSelector inPortSelector, uInt16 inPortNumber );	
	uInt16				GetThisProtocolPort			( PortSelector inPortSelector );
	uInt16				GetAdminPort				( void );

	uInt32				GetOpenTimeout				( void );
	uInt32				GetRdWrTimeout				( void );

	uInt32				GetServerDNSCachePopUp		( void );
	uInt32				GetServerDNSCacheDeltaValue ( void );
	
	Boolean				GetServerResolveMXFlag		( void );
	Boolean				GetServerResolveARecord		( void );

	void				GetSMTPResponseName			( CString &outName );
	void				SetSMTPResponseName			( const char *inName );

	void				GetSMTPOutResponseName		( CString &outName );
	void				SetSMTPOutResponseName		( const char *inName );

	void				GetPOP3ResponseName			( CString &outName );
	void				SetPOP3ResponseName			( const char *inName );

	void				GetIMAPResponseName			( CString &outName );
	void				SetIMAPResponseName			( const char *inName );

	Boolean				IsProtocolOn				( uInt32 inWhichProtocolType );
	void				SetProtocolState			( uInt32 inWhichProtocolType, Boolean inState );

	Boolean				IsPOP3_On					( void );
	Boolean				IsSMTP_On					( void );
	Boolean				IsIMAP_On					( void );
	Boolean				IsNotifyMail_On				( void );
	Boolean				IsAdminPort_On				( void );

	Boolean				IsHoldMailOn				( void );

	Boolean				ForwardToAnyUser			( void );
	Boolean				CantCreateLocalHosts		( void );
	Boolean				LocalFromMustExist			( void );

	Boolean				IsLogMsgBitSet				( const ELogType inLogType, const uInt32 inMsgBit2Check );
	void				SetLogMsgBit				( const ELogType inLogType, const uInt32 inMsgBit2Set );
	void				ClearLogMsgBit				( const ELogType inLogType, const uInt32 inMsgBit2Clear );

	uInt32				GetBCCUserID				( void );
	uInt32				GetForwardAnyUserID			( void );

	Boolean				GetBCCName					( CString &outStr );
	Boolean				GetAnyUserName				( CString &outStr );

	Boolean				IsExpireMessagesOn			( void );
	uInt32				GetExpireSeenMsgs			( void );
	uInt32				GetExpireUnSeenMsgs			( void );
	Boolean				IsCaseSensitiveOn			( void );
	Boolean				SendBulkNDRs				( void );
	Boolean				FwdBadNDRsToPostmaster		( void );
	Boolean				VerifySMTPInConnections		( void );
	Boolean				RejectBadSMTPInConnections	( void );
	Boolean				IngoreAntiSPAMIfRelay		( void );
	Boolean				DeleteDefaultHosts			( void );
	uInt32				GetIMAPIdleTime				( void );
	uInt32				GetMaxIMAPConnections		( void );


// ServerPrefs2 begin
	void				SetDoRBLSMTPConnFlag		( const Boolean inConnFlag );
	Boolean				GetDoRBLSMTPConnFlag		( void );
	
	void				SetUseCustomRBLDomainFlag	( const Boolean	inCustRBLDomainFlag );
	Boolean				GetUseCustomRBLDomainFlag	( void );
	
	void				SetFullHostListCheck		( const Boolean	inFullHostListChkFlag );
	Boolean				GetFullHostListCheck		( void );
	
	void				SetCustomRBLDomainName		( CString	&inName	);
	void				GetCustomRBLDomainName		( CString	&outName );

	Boolean				IsExpireUGAtStartupOn		( void ) const;
	void				SetExpireUGAtStartup			( const Boolean inFlag );

	uInt32				GetUGTTLDelta				( void ) const;
	void				SetUGTTLDelta				( const uInt32 inTime );

	void				SetPrefsFlags				( uInt32 inFlags );		// was SetPrefs2Flags

// ServerPrefs2 end

protected:
	CServerPrefsData_10_1*		GetServerPrefsData		( void );
	void					SetDirty				( void );
	void					DoSendmailRules			( void );

private:
	// Persistent Fields
	CServerPrefsData_10_1	fServerPrefsData;
};

#endif // _CServerPrefs__10_1_h__
