
/*
	$Id: IMAPStringsTable.h,v 1.1 2003/04/20 23:30:51 dasenbro Exp $

	File:		IMAPStringsTable.h

	Contains:	xxx put contents here xxx

	Version:	Apple Mail Server - Mac OS X :  $Revision: 1.1 $

	Written by:	Michael Dasenbrock

	Copyright:	 1996-2001 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: IMAPStringsTable.h,v $
		Revision 1.1  2003/04/20 23:30:51  dasenbro
		Initial check-in.
		
		Revision 1.14  2002/06/10 22:42:29  dasenbro
		Added strings and consts for required auth methods Kerberos and CRAM-MD5.
		
		Revision 1.13  2002/05/30 17:06:44  dasenbro
		Added login disabled IMAP response.
		
		Revision 1.12  2002/05/20 21:24:55  dasenbro
		Added "Not Admin" response.
		
		Revision 1.11  2002/03/25 22:54:49  dasenbro
		Added SSL response codes, strings and consts.
		
		Revision 1.10  2002/03/21 16:41:33  dasenbro
		Updated file version information.
		
		Revision 1.9  2001/06/21 20:51:04  dasenbro
		Updated file header info.
		
		Revision 1.8  2001/06/21 19:38:12  dasenbro
		Added Change History.
		

	Projector History:

	To Do:


	Notes:
		These should not be localized. They are the commands send
		by the client application down the wire.
*/


#ifndef __IMAPStringsTable_h__
#define __IMAPStringsTable_h__ 1


// CIMAP4Server.cpp, CIMAPSession.cpp, CAdminSession.cpp

static const char *const sIMAPStrings[] = 
{
	/*  1 */    "OK ",
	/*  2 */    "NO ",
	/*  3 */    "BAD ",
	/*  4 */    "PREAUTH ",
	/*  5 */    "BYE ",
	/*  6 */    "\r\n",
	/*  7 */    "* OK %s IMAP4rev1 %s ready\r\n",
	/*  8 */    ".XDUMP",
	/*  9 */	".XDUMPNOLF",				// Experimental x-dump strip line feeds extension
	/* 10 */	"* OK [PARSE] %s",
	/* 11 */	"* OK [PARSE] ",
	/* END */       ""
};

// CIMAP4Server.cpp

static const char *const sIMAPNoErrStrings[] =
{
	/*  1 */	"301 Server error",
	/*  2 */	"302 Invalid tag %s",
	/*  3 */	"303 Bad LOGIN user name and/or password",
	/*  4 */	"304 This mailbox is marked read only",
	/*  5 */	"305 %s failed: Mailbox %s does not exist",
	/*  6 */	"306 %s failed: Mailbox %s is marked \"Noselect\"",
	/*  7 */	"307 %s failed: Mailbox path %s contains null mailbox name(s)",
	/*  8 */	"308 %s failed: Mailbox name %s contains illegal characters",
	/*  9 */	"309 %s failed: Invalid attribute %s",
	/* 10 */	"310 %s failed: Mailbox %s already exists",
	/* 11 */	"311 %s failed: Cannot delete INBOX",
	/* 12 */	"312 %s failed: Cannot delete %s, it contains other mailboxes",
	/* 13 */	"313 %s failed: Cannot Unsubscribe the INBOX",
	/* 14 */	"314 %s failed. Unrecognized character set",
	/* 15 */	"315 %s failed: Selected mailbox changed size from %u to %u",
	/* 16 */	"316 %s failed: Mailbox is locked by POP server",
	/* 17 */	"317 %s failed: Message may not exist.  Please close and reselect this mailbox",
	/* 18 */	"318 %s failed: Mailbox name is too long",
	/* 19 */	"319 %s failed: Cannot exceed maximum number mailboxes of %d",
	/* 20 */	"320 %s failed: Cannot exceed maximum depth of %d",
	/* 21 */	"321 %s failed: Access denied.  Mailbox %s has an outstanding reference",
	/* 22 */	"322 %s failed: Cannot exceed maximum of %d messages per mailbox",
	/* 23 */	"323 %s failed: Invalid rights %s",
	/* 24 */	"324 %s failed: Cannot create a mailbox in a shared hierarchy",
	/* 25 */	"325 %s failed: User \"%s\" does not have mail enabled",
	/* 26 */	"326 %s failed: User \"%s\" has autoforward turned on",
	/* 27 */	"327 %s failed: Cannot modify mailbox owners rights",
	/* 28 */	"328 %s failed: Unsupported command",
	/* 29 */	"329 %s failed: Mailbox is currently selected by another IMAP session.",
	/* 30 */	"330 %s failed: Cannot expunge.",
	/* 31 */	"331 %s failed: TLS already active.",
	/* 32 */	"332 %s failed: SSL Session required first.",
	/* 33 */	"333 %s failed: User \"%s\" is not an administrator on this server.",
	/* 34 */	"334 %s failed: Login is disabled.",
	/* 35 */	"335 %s failed: CRAM-MD5 Authentication required.",
	/* 36 */	"336 %s failed: Kerberos Authentication required.",
	/* 00 */	""
};


// CIMAP4Server.cpp and CAdminServer.cpp

const char *const sIMAPBadErrStrings[] =
{
	/*  1 */	"Missing required argument to %s",
	/*  2 */	"Invalid argument to %s",
	/*  3 */	"Unexpected extra arguments to %s",
	/*  4 */	"Bogus sequence in %s",
	/*  5 */	"Unexpected command",
	/*  6 */	"Bogus criteria list in %s",
	/*  7 */	"No mailbox selected.  Please select a mailbox first",
	/*  8 */	"Invalid body partial",
	/*  9 */	"Null command",
	/* 10 */	"Missing command",
	/* 11 */	"Unrecognized command",
	/* 12 */	"Invalid body section",
	/* 13 */	"Bogus date string in %s",
	/* 14 */	"Bad command termination sequence",

	/* 00 */	""
    
};



// CIMAP4Server.cpp

static const char *const sIMAPASIPErrStrings[] =
{
	/*  1 */	"401 %s failed.  Cannot create \"POP3 INBOX\".  This name space is reserverd",
	/*  2 */	"402 %s failed.  \"POP3 INBOX\" cannot contain subfolders",
	/*  3 */	"403 %s failed.  Cannot delete \"POP3 INBOX\"",
	/*  4 */	"404 %s failed.  Cannot rename \"POP3 INBOX\"",
	/*  5 */	"405 %s failed.  Cannot rename a users INBOX",
	/*  6 */	"406 Server error.  No current IMAP session",
	/*  7 */	"407 Server error.  No network endpoint",
	/*  8 */	"408 %s failed: Maximum number of connections for a single user reached.  Please close some connections to continue",
	/*  9 */	"409 %s failed. Not a number string.",
	/* 10 */	"410 %s failed. User does not have an active account on this Mail Server.",
	/* 11 */	"411 %s failed. User has a mail account located at: \"%s\".",
	/* 12 */	"412 %s failed. User does not exist.",
	/* 13 */	"413 %s failed. Cannot contact the directory server at this time.",

	/* 14 */	"[ALERT] 497 %s failed: Server volume is full.  Please alert your administrator.",
	/* 15 */	"[ALERT] 498 %s failed: Mail Server database is full.  Please alert your administrator.",
	/* 16 */	"499 %s failed: Unknown server error: ",
	/* 00 */	""
};


// CIMAP4Server.cpp

static const char *const sIMAPAdminErrStrings[] =
{
	/*  1 */	"501 %s failed: Operation not allowed on admin port",
	/*  2 */	"502 %s failed: Mailbox %s cannot be created on admin port",
	/*  3 */	"503 %s failed: Cannot copy messages to mailbox %s",
	/*  4 */	"504 %s failed: Cannot delete mailbox %s",
	/*  5 */	"505 %s failed: Cannot append to mailbox %s",
	/* 00 */	""
};


// CIMAP4Server.cpp

static const char *const sIMAPCompleteStrings[] =
{
	/*  1 */	"%s completed",
	/* 00 */	""
   
};


// CIMAP4Server.cpp and CIMAPSession.cpp

const char *const sIMAPAlertStrings[] =
{
   	/*  1 */	"IMAP mailbox has exceed server quota of 1000 messages",
	/*  2 */	"Connection terminated due to Server shutdown",
	/*  3 */	"Connection terminated due to user inactivity",
	/*  4 */	"Administrator has terminated this connections",
	/*  5 */	"Connection terminated",
	/*  6 */	"Server is busy Indexing...\r\n",
	/*  7 */	"Server is busy Searching...\r\n",
	/*  8 */	"Server is busy Fetching...\r\n",
	/*  9 */	"Server is indexing message %s of %s ...\n\r",
	/* 10 */	"Server is searching message %s of %s ...\n\r",
	/* 11 */	"Server is creating table of contents for message %s of %s ...\n\r",
	/* 12 */	"Server is creating search response form message %s of %s ...\n\r",
	/* 00 */	""
};


// CIMAP4Server.cpp only

static const char *const sACLErrStrings[] =
{
	/*  1 */	"601 %s failed: User does not have administrative rights",
	/*  2 */	"602 %s failed: No such user or group %s",
	/*  3 */	"603 %s failed: User does not have sufficient rights",
	/* 00 */	""
};


#endif	// __IMAPStringsTable_h__
