/*
	$Id: CString.h,v 1.1 2003/04/20 23:29:40 dasenbro Exp $

	File:	CString.h

	Contains: Interface for a reasonable String Object.

	Version:	Apple Mail Server - Mac OS X :  $Revision: 1.1 $

	Written by: Claris Corporation 

	Copyright:	 1996-2001 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: CString.h,v $
		Revision 1.1  2003/04/20 23:29:40  dasenbro
		Initial check-in.
		
		Revision 1.8  2002/06/07 22:40:46  dasenbro
		Added GetDataLength() MemSet() to handle data blocks with imbedded NULL's.
		
		Revision 1.7  2002/04/15 21:25:54  dasenbro
		Syntax changes for better readability.
		
		Revision 1.6  2002/03/21 16:41:47  dasenbro
		Updated file version information.
		
		Revision 1.5  2002/01/14 17:05:05  dasenbro
		Initial S4 updates.
		
		Revision 1.4  2001/06/21 20:45:06  dasenbro
		Added Change History.
		

	Projector History:

		 <1>	7/30/98	cpj		Completely rewritten for optimized performance.

	To Do:
 */


#ifndef __CString_h__
#define __CString_h__	1

#include <stdarg.h>		// for va_list type for Vsprintf
#include <string.h>		// for strcmp()

#include "MailTypes.h"

const int kCStringDefSize = 128 ;


typedef struct StrListObj StrListObj;
typedef struct StrListObj
{
	char		*fString;
	StrListObj  *fNext;
} StrListObj;

//-----------------------------------------------------------------------------
// * CString ()
//
//		- Your Basic String Class
//
//		- NOTE: static CStrings will show up in the leaks.log because
//			destructors for static objects are called after main exits,
//			so the DebugNewReportLeaks() will report them even though
//			they do get deleted on exit.
//
//-----------------------------------------------------------------------------


class CString
{
public:
	/**** Typedefs, enums, and constants. ****/
	// Exceptions
	enum {
		kUnknownEscapeErr	= 'str0'	// bad %x in sprintf.
	};

	friend class CDigest;

public:
	/**** Static methods. ****/
	static void AppendString		( StrListObj **inStrList, const char *inStr, unsigned long inStrLen );
	static void FreeStringList		( StrListObj **inStrList );
	static void DuplicateStringList	( StrListObj **inDestList, StrListObj *inSrcList );

	/**** Instance methods. ****/
	// ctor and dtor.
				CString			( int sz = 0 );
				CString			( int resID, int index );
				CString			( const char *str );
				CString			( const char *str, int len );
				CString			( const CString& cs );
				CString			( const char *pattern, va_list args );
				CString			( int resID, int index, va_list args );
	virtual	   ~CString			( void );
		
	// Inline accessors.
	int			GetLength		( void ) const ;			 // { return mLength; }
	int			GetDataLength	( void ) const ;
	int			GetAllocSize	( void ) const					{ return mSize; }
	char*		GetData			( void ) const					{ return mData; }
	void		GetPascal		( unsigned char *pstr ) const ;

				operator const char*	(  ) const				{ return mData ; }
	int			operator==		( const CString& other ) const	{ return !::strcmp (mData, other.mData) ; }
	CString&	operator=		( const CString& other )		{ this->Set (other) ; return *this ; }

	// Data modifiers.
	void		Sprintf			( const char *pattern, ... );
	void		Sprintf			( int resID, int index, ... );
	void		Vsprintf		( const char *pattern, va_list args );

	void		Set				( int resID, int index );
	void		Set				( const char *str );
	void		Set				( const char *str, int len );
	void		Set				( const unsigned char *pstr );
	void		Set				( const CString& cs );

	void		MemSet			( const char *inStr, int inLen );

	void		Append			( char inChar );
	void		Append			( const char *str );
	void		Append			( const char *str, int len );
	void		Append			( const unsigned char *pstr );
	void		Append			( const CString& cs );

	void		Prepend			( const char *str );
	void		Clear			( int inNewSize = 0 );

protected:
	/**** Instance methods accessible only to class and subclasses. ****/
	void		Grow			( int newSz = 0 );

	/**** Instance data. ****/
	int			mSize;		// Alloc size, *not* length of string
	int			mLength;	// length of string
	char	   *mData;		// ptr to string data.
};



//------------------------------------------------------------------------------
//	* CDigest: an MD5 based string digest object
//
//------------------------------------------------------------------------------

class CDigest
{
	public:
				CDigest		( CString& );
				CDigest		( char*, int );
		
		void	ComputeOn		( CString& );
		int		operator==		( CDigest& );
		void	AsString		( CString& );
	
	protected:
		void	ComputeDigest		( unsigned char*, unsigned int );
		unsigned char mDigest[16];
};


#endif	/* __CString_h__ */
