/*
	$Id: CACLObject.h,v 1.1 2003/04/20 23:33:11 dasenbro Exp $

	File:		CACLObject.h

	Contains:	C++ class definitions for generic

	Version:	Apple Mail Server - Mac OS X :  $Revision: 1.1 $

	Written by:	Michael Dasenbrock

	Copyright:	 1996-2001 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: CACLObject.h,v $
		Revision 1.1  2003/04/20 23:33:11  dasenbro
		Initial check-in.
		
		Revision 1.6  2002/03/21 16:24:19  dasenbro
		Updated version information.
		
		Revision 1.5  2001/06/21 20:50:50  dasenbro
		Updated file header info.
		
		Revision 1.4  2001/06/21 16:31:00  dasenbro
		Added Change History.
		

	Projector History:

	  <ASM5>	 3/22/99	MED		Added SetACLData() to set the acl data block.
	  <ASM4>	 3/15/99	MED		GetACLInfo() returns an error status.
		 <3>	10/22/98	MED		Added RemoveUserRef() to remove the user from an ACL list.
		 <2>	10/12/98	MED		Added RemoveSpoolRef() to remove just the spool ID.
		 <4>	 9/14/98	MED		Added IsSpoolInList and IsUserInList().
		 <3>	  9/8/98	MED		Added GetACLData() and GetNextObjInfo().
		 <2>	 8/10/98	MED		Added QuoteAnySpaces to quote any user names that include
									spaces.

	To Do:
*/


#ifndef __CACLObject_h__
#define __CACLObject_h__ 1

#include "CExpansion.h"

class	CString;

const	ObjID	kAnyoneUserID	= 0xFFFFFFFE;

typedef struct
{
	ObjID	fSpoolID;
	ObjID	fUserID;
	uInt32	fRights;
} SACLInfo;


class CACLObject : public CExpansion
{
public:
	//Construction/Destruction
						CACLObject			( void );
	virtual		 	   ~CACLObject			( void );
		void			Done				( CACLObject* &inPtr );
		OSStatus		GetACLInfo			( CString &outData );
		Boolean			GetACLData			( ObjID inUserID, SACLInfo &outData );
		Boolean			SetExistingACLInfo	( ObjID inUserID, ObjID inSrcSpoolID, uInt32 inRights );
		Boolean			SetNewACLInfo		( ObjID inUserID, ObjID inSrcSpoolID, uInt32 inRights );
		Boolean			DeleteACLInfo		( ObjID inUserID, ObjID inSrcSpoolID );
		Boolean			RemoveSpoolRef		( ObjID inSrcSpoolID );
		Boolean			RemoveUserRef		( ObjID inUserID );
		void			DeleteAllSpools		( void );

		void			GetRightsString		( CString &outData, uInt32 inRights );
		void			QuoteAnySpaces		( CString &inData );

		Boolean			GetNextObjInfo		( sInt16 &inIterator, SACLInfo &outObjInfo );
		Boolean			IsSpoolInList		( ObjID inSpoolID, SACLInfo *outACLData = nil );
		Boolean			IsUserInList		( ObjID inUserID, SACLInfo *outACLData = nil );
		void			SetACLData			( char *outData );
private:
};

#endif // __CACLObject_h__

