/*
	File:		CBaseDatabase.10.1.h

	Copyright:	 2003 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:
*/

#ifndef __CBaseDatabase_10_1_h__
#define __CBaseDatabase_10_1_h__	1

#include "CFile.h"
#include "DatabaseTypes.h"
#include "CIDTable.10.1.h"
#include "CStr2IDTable.10.1.h"

#define			kDBTag_10_1					"OSX.0.0"
const uInt32	kFreeSpaceCheckDelta_10_1 = 15;

typedef struct 
{
	OSType	fObjType;
	uInt32	fObjSize;
} SObjTypeInfo_10_1;

typedef enum
{
	kNoListType_10_1		= 0,
	kListNotEnabled_10_1	= 'off ',
	kID2Data_10_1			= 'data',
	kID2PageMap_10_1		= 'idmp',
	kIDRangeMap_10_1		= 'idrg',
	kStr2ID_10_1			= 'stid',
	k2ndIDListMap_10_1		= '2idm'
} enumListType_10_1;

typedef struct
{
	OSType			fListType;
	Boolean			fListSorted;
	volatile uInt32	fPageCount;
	volatile uInt32	fEntryCount;
	uInt32			fEntryDataSize;
	volatile PageID	fHeadPageID;
	PageID			fLastPageUsed;
} SObjList_10_1;

typedef enum
{
	kNoRequest_10_1			= 'none',
	kSetObjID_10_1			= 'nwID',
	k2ndIDRequest_10_1		= '2nID',	// outFieldData points to a ObjID setup by the "caller"
	kStringNameRequest_10_1	= 'name',	// outFieldData points to a str64 setup by the "caller"
	kObjectPINGRequest_10_1	= 'PING',	// called when the "type" is successfully registered...
	k2ndIDTargetChk_10_1	= '2chk'
} eFieldDataRequest_10_1;

typedef Boolean	(*DataFieldProc_10_1)(const eFieldDataRequest_10_1 inFieldRequest, const void *inObjDataPtr, void *outFieldData);	// return false if there is no data....

class SDBIterator_10_1;
class CBaseDatabase_10_1;

typedef SDBIterator_10_1	*SDBIteratorPtr_10_1;

class SDBIterator_10_1
{
public:
				SDBIterator_10_1		( CBaseDatabase_10_1 *inBaseDBPtr = NULL );
	virtual	   ~SDBIterator_10_1		( void );

	SDBIteratorPtr_10_1	fNextIterator;
	Boolean				fIteratorDone;
	OSType				fIteratorDataType;
	ObjID				fCurrentObjID;
	PageID				fCurrentPageID;
	ObjID				f2ndIDMatch;
	CBaseDatabase_10_1	*fParentDatabase;
};

typedef struct
{
	// *********************************************************************************
	// Warning: DO NOT CHANGE/ADD/REMOVE PUBLIC/PRIVATE DATA FIELDS TO THIS CLASS/STRUCT
	// WITHOUT CONSULTING WITH A APPLESHARE IP MAIL TEAM MEMBER.  CHANGES TO
	// THIS STRUCTURE __WILL__ CAUSE FILE FORMAT COMPATIBILITY ISSUES FOR APPLESHARE IP 5.0
	// AND 6.0 MAIL DATABASES.
	//
	// FAILURE TO HEED THIS WARNING __WILL__ LEAD TO DATA LOSS
	// AND/OR CRASHING BUGS WHEN CUSTOMERS ATTEMPT TO USE YOUR SIMPLE MODIFICATIONS WITH
	// A PRE-EXISTING MAIL DATABASE.
	//
	// SINCE THIS FILE IS SHARED BY MORE COMPONENTS THAN JUST YOURS, PLEASE BE AWARE OF THE
	// C++ FRAGILE BASE CLASS PROBLEM AND DON'T MAKE CHANGES IN THE BASE CLASS SOURCE CODE
	// WITH OUT CONSULTING OTHER SOURCES THAT ARE DEPENDANT ON THIS STURUCTURE.
	// *********************************************************************************

	// NOTE: THIS ITEM IS WRITTEN TO DISK AS A BINARY "BLOB"...CHANGES WILL
	// CAUSE FILE FORMAT COMPATIBILITY PROBLEMS.

	OSType				fObjType;
	Boolean				fObjStrCaseSensitive;
	DataFieldProc_10_1	fObjDataFieldProc;
	SDBIteratorPtr_10_1	fIteratorList;
	SObjList_10_1		fDataList;			// head pointer to a linked list of Data Table pages..
	SObjList_10_1		fIDList;			// head pointer to a linked list of ID to Page Number Tables
	SObjList_10_1		fIDRangeList;		// head pointer to a linked list of ID Range to Page Tables...
	SObjList_10_1		fStringList;		// head pointer to a linked list of String to ID Tables...
} SPrivObjTypeInfo_10_1;

typedef SPrivObjTypeInfo_10_1 *SPrivObjTypeInfoPtr_10_1;

typedef struct
{
	// *********************************************************************************
	// Warning: DO NOT CHANGE/ADD/REMOVE PUBLIC/PRIVATE DATA FIELDS TO THIS CLASS/STRUCT
	// WITHOUT CONSULTING WITH A APPLESHARE IP MAIL TEAM MEMBER.  CHANGES TO
	// THIS STRUCTURE __WILL__ CAUSE FILE FORMAT COMPATIBILITY ISSUES FOR APPLESHARE IP 5.0
	// AND 6.0 MAIL DATABASES.
	//
	// FAILURE TO HEED THIS WARNING __WILL__ LEAD TO DATA LOSS
	// AND/OR CRASHING BUGS WHEN CUSTOMERS ATTEMPT TO USE YOUR SIMPLE MODIFICATIONS WITH
	// A PRE-EXISTING MAIL DATABASE.
	//
	// SINCE THIS FILE IS SHARED BY MORE COMPONENTS THAN JUST YOURS, PLEASE BE AWARE OF THE
	// C++ FRAGILE BASE CLASS PROBLEM AND DON'T MAKE CHANGES IN THE BASE CLASS SOURCE CODE
	// WITH OUT CONSULTING OTHER SOURCES THAT ARE DEPENDANT ON THIS STURUCTURE.
	// *********************************************************************************

	// NOTE: THIS ITEM IS WRITTEN TO DISK AS A BINARY "BLOB"...CHANGES WILL
	// CAUSE FILE FORMAT COMPATIBILITY PROBLEMS.

	PageID	fFreePageCount;
	PageID	fFreeListHead;
} SOldFreeList_10_1;

typedef struct
{
	// *********************************************************************************
	// Warning: DO NOT CHANGE/ADD/REMOVE PUBLIC/PRIVATE DATA FIELDS TO THIS CLASS/STRUCT
	// WITHOUT CONSULTING WITH A APPLESHARE IP MAIL TEAM MEMBER.  CHANGES TO
	// THIS STRUCTURE __WILL__ CAUSE FILE FORMAT COMPATIBILITY ISSUES FOR APPLESHARE IP 5.0
	// AND 6.0 MAIL DATABASES.
	//
	// FAILURE TO HEED THIS WARNING __WILL__ LEAD TO DATA LOSS
	// AND/OR CRASHING BUGS WHEN CUSTOMERS ATTEMPT TO USE YOUR SIMPLE MODIFICATIONS WITH
	// A PRE-EXISTING MAIL DATABASE.
	//
	// SINCE THIS FILE IS SHARED BY MORE COMPONENTS THAN JUST YOURS, PLEASE BE AWARE OF THE
	// C++ FRAGILE BASE CLASS PROBLEM AND DON'T MAKE CHANGES IN THE BASE CLASS SOURCE CODE
	// WITH OUT CONSULTING OTHER SOURCES THAT ARE DEPENDANT ON THIS STURUCTURE.
	// *********************************************************************************

	// NOTE: THIS ITEM IS WRITTEN TO DISK AS A BINARY "BLOB"...CHANGES WILL
	// CAUSE FILE FORMAT COMPATIBILITY PROBLEMS.

	uInt32	fEntryCount;
	uInt32	f1stEntry;
	PageID	fFreeListPage;
} SNewFreeListEntry_10_1;

typedef enum
{
	kNoDBState_10_1		= 'none',
	kDBOpen_10_1		= 'open',
	kDBClosed_10_1		= 'clos',
	kDBFlushing_10_1	= 'flsh',
	kDBSafe_10_1		= 'dbok',
	kDBNotSafe_10_1		= 'ntok'
} eDBState_10_1;


// OS X database calculations for a max database size of 132 Gig

const uInt32	kBitsPerByte_10_1		= 8;
const uInt32	kMaxDBPageCount_10_1	= 16777216;														// Will yield a 128 gig db
const uInt32	kFreeCountPerPage_10_1	= kStandardPageSize * kBitsPerByte_10_1;						// 65536
const uInt32	kFreeMapPageCount_10_1	= (kMaxDBPageCount_10_1 / kFreeCountPerPage_10_1) + 1;			// 257
const uInt64	kMaxDBFileSize_10_1		= (uInt64)kMaxDBPageCount_10_1 * (uInt64)kStandardPageSize;		// 137438953472

// the following definitions are 100% backwards compatible with
// AppleShare IP Mail: 6.0, 6.1, 6.2
//	const uInt32	kBitsPerByte		= 8;
//	const uInt32	kMaxDBPageCount		= (0x7fffffff / kStandardPageSize) - 1;	// subtract 1, no need to push it to the absolute limit..
//	const uInt32	kFreeCountPerPage	= kStandardPageSize * kBitsPerByte;
//	const uInt32	kFreeMapPageCount	= (kMaxDBPageCount / kFreeCountPerPage) + 1;
//	const long long	kMaxDBFileSize		= kMaxDBPageCount * kStandardPageSize;

typedef struct
{	// header type stuff, basic counts & such...

	// *********************************************************************************
	// Warning: DO NOT CHANGE/ADD/REMOVE PUBLIC/PRIVATE DATA FIELDS TO THIS CLASS/STRUCT
	// WITHOUT CONSULTING WITH A APPLESHARE IP MAIL TEAM MEMBER.  CHANGES TO
	// THIS STRUCTURE __WILL__ CAUSE FILE FORMAT COMPATIBILITY ISSUES FOR APPLESHARE IP 5.0
	// AND 6.0 MAIL DATABASES.
	//
	// FAILURE TO HEED THIS WARNING __WILL__ LEAD TO DATA LOSS
	// AND/OR CRASHING BUGS WHEN CUSTOMERS ATTEMPT TO USE YOUR SIMPLE MODIFICATIONS WITH
	// A PRE-EXISTING MAIL DATABASE.
	//
	// SINCE THIS FILE IS SHARED BY MORE COMPONENTS THAN JUST YOURS, PLEASE BE AWARE OF THE
	// C++ FRAGILE BASE CLASS PROBLEM AND DON'T MAKE CHANGES IN THE BASE CLASS SOURCE CODE
	// WITH OUT CONSULTING OTHER SOURCES THAT ARE DEPENDANT ON THIS STURUCTURE.
	// *********************************************************************************

	// NOTE: THIS ITEM IS WRITTEN TO DISK AS A BINARY "BLOB"...CHANGES WILL
	// CAUSE FILE FORMAT COMPATIBILITY PROBLEMS.

	char				fDatabaseTag[ 8 ];
	uInt32				fDatabaseVersion;
	uInt32				fPageSize;
	uInt32				fSmallObjectSize;
	uInt32				fMaxObjectSize;
	uInt32				fMaxObjTypeCount;
	uInt32				f1stPageOffset;

	// current state of the DB...
	volatile uInt32		fNextObjID;
	volatile uInt32		fPageCount;
	eDBState_10_1		fDBState;
	eDBState_10_1		fDBReOpenState;

	uInt32				fObjTypeCount;
	SPrivObjTypeInfo_10_1	fObjTypeList[ kMaxObjTypeCount ];
	SNewFreeListEntry_10_1	fNewFreeList[ kFreeMapPageCount_10_1 ];
} SDatabaseHeaderData_10_1;

typedef struct
{
	PageID	fPageID;
	uInt32	fRefCount;
	uInt32	fNextPageIndex;	// hash table next pointer for collisions
	
	uInt32  fLRUPrevIndex;	// for the LRU list membership.
	uInt32  fLRUNextIndex;

	Boolean	fDirty;
	char	fPageData[ kStandardPageSize ];
} PageCacheEntry_10_1;

typedef PageCacheEntry_10_1 *PageCacheEntryPtr_10_1;

const uInt32 kMaxPageCacheEntries_10_1 = (16 * 1024 * 1024) / kStandardPageSize;		// we really don't want more than 16 meg cache, since all of
																				// that could become "dirty" and need to be written to disk...
const uInt32 kMaxHashTableSize_10_1 = kMaxPageCacheEntries_10_1 * 2;

typedef struct
{
	uInt32					fCount;
	uInt32					fEntryCount;
	uInt32					fLRUEntryCount;
	uInt32					fDirtyCount;
	uInt32					fPageCacheFreeListHead;
	
	uInt32					fLRUListHead;
	uInt32					fLRUListTail;
	
	uInt32					fPageCacheHashTable[ kMaxHashTableSize_10_1 ];
	PageCacheEntryPtr_10_1	fPageCacheEntryList[ kMaxPageCacheEntries_10_1 ];
} PageCacheList_10_1;

// Version is divided into parts:
//	0xFF000000 == Major Version
//	0x00FF0000 == Minor Version
//	0x0000FF00 == Development Stage (Dev = D, Alpha = A, Beta = B, Final = F)
//	0x000000FF == Development Substage

const uInt32 k501DataBaseVersion_10_1	= 0x05010B06;		// 5.01b6
const uInt32 k502DataBaseVersion_10_1	= 0x05020B03;		// 5.02b3
const uInt32 k60DataBaseVersion_10_1	= 0x06000D03;		// 6.0d3
const uInt32 k63DatabaseVersion_10_1	= 0x07000001;		// 6.x
const uInt32 kOSXDatabaseVersion_10_1	= 0x1000F001;		// OS X 10.0 Final Version

const uInt32 kCurrentDBVersion_10_1		= kOSXDatabaseVersion_10_1;

const uInt32 kBadDBVersion_10_1			= 0xffffffff;
const uInt32 kNoIndexHint_10_1			= 0xffffffff;
const uInt32 kNULLIndex_10_1			= 0xffffffff;
const uInt32 kStartingObjID_10_1		= 100;
const uInt32 kNormalPageCacheCount_10_1	= 16;

class CDBBaseObjectCache_10_1;
class CBaseDatabase_10_1
{
public:
						CBaseDatabase_10_1		(	const uInt32 inMinFreeDiskSpace,
												CDBBaseObjectCache_10_1 *inBaseObjectCachePtr,
												uInt32 inPageCacheCount = kNormalPageCacheCount_10_1 );

	virtual				~CBaseDatabase_10_1		( void );
	
	static void			CheckBackwardCompatibility	( void );
	static void			ReportBackwardCompatibility	( const uInt32 curSize, const uInt32 correctSize );
	
	virtual	OSStatus	OpenDatabaseFile	(	const CFileSpecPtr	inFSSpec,
												const OSType		inFileType,
												const OSType		inFileCreator,
												const Boolean		inCreateFlag = false,
												const uInt32		inDBVersion = kCurrentDBVersion_10_1	);
	
	virtual CDBBaseObjectCache_10_1	*GetBaseObjectCachePtr	( void );

	virtual	OSStatus	CloseDatabaseFile	( void );
	virtual	OSStatus	FlushDatabaseFile	( eDBState_10_1 inReOpenState );
	virtual	eDBState_10_1	GetDBOpenState		( void );
	virtual	void		SetDBOpenState		( const eDBState_10_1 inReOpenState);
	
	virtual	void		DBIdle				( void );
	
	virtual	OSStatus	AddObjType			( const OSType inObjType, const uInt32 inObjectSize, const Boolean inCaseSensitiveFlag, const DataFieldProc_10_1 inFieldCallBackProc = NULL);
	virtual uInt32		GetObjTypeCount		( void );
	virtual uInt32		GetMaxObjTypeCount	( void );
	virtual OSStatus	GetObjTypeInfo		( const uInt32 inObjTypeIndex, SObjTypeInfo_10_1 &outObjTypeInfo );
	virtual uInt32		GetMaxObjSize		( void );

	virtual uInt32		GetPageCount		( void );
	virtual uInt32		GetPageCacheCount	( void );
	virtual uInt32		GetPageSize			( void );
	
	virtual uInt32		GetMinFreeDiskSpace	( void );
	virtual void		SetMinFreeDiskSpace ( const uInt32 inMinFreeDiskSpace );

	virtual sInt64		GetDatabaseSize		( void ) { return( fStore.FileSize() ); };

	virtual OSStatus	CreateObj						( const OSType inObjType, ObjID &outNewObjID, void *inObjData = NULL);
	virtual OSStatus	GetObjectCount					( const OSType inObjType, uInt32 &outObjectCount );	
	virtual OSStatus	GetObjectStingNameEntryCount	( const OSType inObjType, uInt32 &outNameEntryCount );	
	virtual OSStatus	SetObjData						( const OSType inObjType, const ObjID inObjID, void *inObjData );
	virtual OSStatus	GetObjData						( const OSType inObjType, const ObjID inObjID, void *outObjData );
	virtual OSStatus	GetObjDataByString				( const OSType inObjType, const char *inSearchString, ObjID &outObjID, void *outObjData = NULL );
	virtual OSStatus	RemoveObj						( const OSType inObjType, ObjID inObjID );

	virtual ObjID		GetNextDBObjID					( void ) { return( fDatabaseHeader.fNextObjID + 1 ); };

	// iteration routines...
	virtual OSStatus	CreateIterator			( const OSType inObjType, SDBIteratorPtr_10_1 outIterator, const ObjID in2ndID2Match = 0 );
	virtual OSStatus	ReleaseIterator			( SDBIteratorPtr_10_1 inOutIterator );
	virtual OSStatus	ResetIterator			( SDBIteratorPtr_10_1 inOutIterator, ObjID &outObjID, void *outObjData = NULL );
	virtual OSStatus	GetCurObject			( SDBIteratorPtr_10_1 inOutIterator, ObjID &outObjID, void *outObjData = NULL );
	virtual OSStatus	NextObject				( SDBIteratorPtr_10_1 inOutIterator, ObjID &outObjID, void *outObjData = NULL );
	virtual OSStatus	PrevObject				( SDBIteratorPtr_10_1 inOutIterator, ObjID &outObjID, void *outObjData = NULL );
	virtual OSStatus	FixAndRemoveCurObject	( SDBIteratorPtr_10_1 inOutIterator );
	virtual	OSStatus	GetIteratorItemCnt		( SDBIteratorPtr_10_1 inOutIterator, uInt32 &outCount );
	virtual	ObjID		GetCurrentObjID			( void );

	enum
	{
		kDBNoErr						=   0,
		kDBTypeListFull					=  -1,
		kDBObjTypeCount2Big				=  -2,
		kDBObjTypeIndexBad				=  -3,
		kDBBadFile						=  -4,
		kDBBadDBVersion					=  -5,
		kDBNoSuchObjType				=  -6,
		kDBNotOpen						=  -7,
		kDBFreeListErr					=  -8,
		kDBBadIterator					=  -9,
		kDBNoSuchPage					= -10,
		kDBListNotEnabled				= -11,
		kDBNoAddObject					= -12,
		kDBOutOfMemory					= -13,
		kDBObjTypeExists				= -14,
		kDBWrongVersion					= -15,
		kDBPageTableAllUsed				= -16,
		kDB2ManyReleases				= -17,
		kDBObjNotFound					= -18,
		kDBDataTypeSizesNoMatch			= -19,
		kDBDataTypeHasFieldProc			= -20,
		kDBNotClosedProperly			= -21,
		kDBCanNotOpen					= -22,
		kDBMismatchFileTypeCreator		= -23,
		kDBDuplicateObjNamesNotAllowed	= -24,
		kDBDiskFull			 			= -25,
		kDBPageNotInCache				= -26,
		kDBObjTypeNotAllowedDBInteral	= -27,
		kDBObjStringNameListNeedsUpdate	= -28,
		kDBObjTypeSize2Big2Fit			= -29
	};
	
private:

	// ****************************************************
	// While not _REQUIRED_ it is _HIGHLY_ recommended that any clients of
	// this Base Class override the following virtual functions.
	// The Base implementation provided here will cause a debugger break,
	// this is intention to call attention to the fact that they should be
	// overridden, if at all possible I would've left them as "pure-virtual"
	// functions, but that can't be done since the base class needs to call
	// these virtual functions.

	virtual	void	DoYield				( const Boolean inForceYieldFlag );
	virtual Boolean IsThreadQuitting	( void );

	virtual void DoLockDB		( void );
	virtual void DoReleaseDB	( void );
	

	// ****************************************************

	virtual OSStatus	MakeNew2ndIDObject	( const ObjID inObjID, const SObjList_10_1 *outObjListPtr );
	virtual OSStatus	CreateObjWithID		( const OSType inObjType, const ObjID inObjID, void *inObjData = NULL);
	virtual OSStatus	Delete2ndIDList		( const ObjID inObjID );

	// Free List Management
	virtual	OSStatus	GetNextFreePage		( PageID &outPageNum );
	virtual OSStatus	AddPage2FreeList	( const PageID inPageNum, const Boolean inAllowFileShrink );

	virtual	uInt32		GetDBVersion		( void );
	virtual uInt32		Get1stPageOffset	( void );
	virtual uInt32		GetSmallObjSize		( void );

	virtual	ObjID		GetNextObjID		( void );
	virtual OSStatus	PrivGetNextObject	( SDBIterator_10_1 *inOutIterator, ObjID &outObjID, Boolean inForwardFlag, void *outObjData = NULL );
	virtual void		FixIteratorList		( SPrivObjTypeInfoPtr_10_1 inObjTypeInfoPtr, const ObjID inObjID, const ObjID in2ndID );

	// Internal List Management Functions
	virtual OSStatus 	AddObject2List			( SObjList_10_1 &inObjTypeInfo, const ObjID inObjID, void *inData, PageID &outPageID );
	virtual OSStatus	RemovePageFromList		( SObjList_10_1 &inObjTypeInfo, const PageID inPageID, SPrivObjTypeInfoPtr_10_1 inObjTypeInfoPtr );
	virtual OSStatus	RemovePageFromStrList	( SObjList_10_1 &inObjTypeInfo, const PageID inPageID, const Boolean inCaseFlag );

	virtual OSStatus	RemoveObjFromList			( SObjList_10_1 &inObjTypeInfo, const ObjID inObjID, PageID inHintPage, SPrivObjTypeInfoPtr_10_1 inObjTypeInfoPtr );
	virtual OSStatus	RemoveObjectFromStringList	( SPrivObjTypeInfoPtr_10_1 inObjTypeInfo, const ObjID inObjID, char *inObjDataPtr );
	virtual OSStatus	FindObjectInList			( SObjList_10_1 &inObjTypeInfo, const ObjID inObjID, void *outData, PageID &outPageID, PageID inHintPage = kNoHintPage );
	virtual OSStatus	FuzzyFind					( SObjList_10_1 &inObjTypeInfo, const ObjID inObjID, void *outData, PageID inHintPage = kNoHintPage );
	virtual OSStatus	SetObjectDataInList 		( SObjList_10_1 &inObjTypeInfo, const ObjID inObjID, void *inData, PageID inHintPage = kNoHintPage );

	virtual OSStatus	FindObjectInStrList 	( SPrivObjTypeInfoPtr_10_1 inObjTypeInfo, const char *inSearchString, ObjID &outObjID, PageID &outObjPageID, PageID &outStrIndexPageID );
	virtual OSStatus	AddObject2StringList	( SPrivObjTypeInfoPtr_10_1 inObjTypeInfo, const ObjID inObjID, const void *inObjData, const PageID inObjPageID );

	virtual OSStatus	AddObject2DataList	( SPrivObjTypeInfoPtr_10_1 inObjTypeInfo, const ObjID inObjID, void *inData, PageID &outPageID );
	virtual OSStatus	AddObject2IDList	( SPrivObjTypeInfoPtr_10_1 inObjTypeInfo, const ObjID inObjID, void *inData, PageID &outPageID );

	virtual OSStatus	RemoveObjectFrom2ndIDList	(SPrivObjTypeInfoPtr_10_1 inObjTypeInfo, const ObjID inObjID, char *inObjDataPtr );
	virtual OSStatus	AddObjectTo2ndIDList		(SPrivObjTypeInfoPtr_10_1 inObjTypeInfo, const ObjID inObjID, void *inObjData, const PageID inObjDataPageID );

	virtual OSStatus	GetPage 			( const PageID inPageNum, char * &outPageData, const Boolean inSkipPageIOFlag, uInt32 &outPageIndexHint );
	virtual OSStatus	GetStr2IDPage		( const PageID inPageNum, const Boolean inSkipPageIOFlag, CStr2IDTable_10_1 &outStr2IDTable );
	virtual OSStatus	GetIDPage			( const PageID inPageNum, const Boolean inSkipPageIOFlag, CIDTable_10_1 &outCIDTable, uInt32 &outPageIndexHint );

	virtual OSStatus	ReleasePage			( const PageID inPageID, const Boolean inDirtyFlag );
	virtual OSStatus	ReleaseStr2IDPage	( CStr2IDTable_10_1 &outStr2IDTable, Boolean inDirtyFlag = false );
	virtual OSStatus	ReleaseIDPage		( CIDTable_10_1 &outCIDTable, Boolean inDirtyFlag );

	virtual OSStatus	ClearPageFromCache	( const PageID inPageID );
	virtual OSStatus	DirtyPage			( const PageID inPageID );
	virtual OSStatus	FlushPageCache		( const Boolean inMarkEmpty = false );
	
	virtual Boolean		FindPageByIndex		( const PageID inPageID, uInt32 &outPageIndex );
	virtual void		RemovePageFromIndex	( const PageID inPageID );
	virtual uInt32		HashResult			( const PageID inPageID );
	virtual void		AddPage2Index 		( const uInt32 inPageIndex );

	virtual void		Add2LRUList 		( const uInt32 inPageIndex );
	virtual uInt32		GetLRUTailPage 		( void );
	virtual void		RemoveFromLRUList 	( const uInt32 inPageIndex );

	virtual OSStatus	SetPageCount		( uInt32 inPageCount );
	virtual OSStatus	AddPage				( PageID &outPageNum );
	virtual OSStatus	ReadPage			( const PageID inPageNum, char *outDataPtr );
	virtual OSStatus	WritePage			( const PageID inPageNum, char *inDataPtr );
	
	virtual OSStatus	SetObjTypeCount		( uInt32 inObjTypeCount );
	virtual	OSStatus	SetObjTypeEntry		( const uInt32 inIndex, const SPrivObjTypeInfo_10_1 &inObjTypeInfo );
	virtual	OSStatus	GetObjTypeEntry		( const uInt32 inIndex, SPrivObjTypeInfoPtr_10_1 &inObjTypeInfoPtr );
	virtual OSStatus	FindObjTypeEntry	( const OSType inObjType, uInt32 &outIndex);
	
	virtual	OSStatus	ReadDatabaseHeader	( const uInt32 inDBVersion );
	virtual	OSStatus	WriteDatabaseHeader	( Boolean inTrueWriteFlag = false );
	virtual	OSStatus	SetupDatabase		( const uInt32 inDBVersion );

	// Database Page Consolodate Routines...	
	virtual uInt32		CalcPageSavings				( const SObjList_10_1	*inList );
	virtual uInt32		CalcMaxItems				( const SObjList_10_1	*inList );
	virtual void		ConsolodatePages			( void );
	virtual Boolean		MakeFreeSpace				( SPrivObjTypeInfoPtr_10_1 inObjTypeInfo );
	virtual Boolean		CheckGenericList4Space		( SObjList_10_1 *inList );
	virtual Boolean		CheckDataPages4FreeSpace	( SPrivObjTypeInfoPtr_10_1 inObjTypeInfo );
	virtual Boolean		CheckID2PageIndex4FreeSpace	( SPrivObjTypeInfoPtr_10_1 inObjTypeInfo );
	virtual Boolean		ConsolodateDataPages		( SPrivObjTypeInfoPtr_10_1 inObjTypeInfo,
										  			  const uInt32		  inMaxDataItemCount );
	virtual Boolean		ConsolodateIndexPages		( SPrivObjTypeInfoPtr_10_1 inObjTypeInfo,
										  			  const uInt32		  inMaxDataItemCount );
	virtual void		MoveData					( SPrivObjTypeInfoPtr_10_1 inObjTypeInfo,
													  const PageID		  inTargetDataPageID,
													  const uInt32		  inObjectCount,
													  uInt32 			  &outObjectMoved,
													  Boolean			  &outPageDeleteFlag	);
	virtual void		MoveIndexData				( SPrivObjTypeInfoPtr_10_1 inObjTypeInfo,
													  const PageID		  inTargetDataPageID,
													  const uInt32		  inObjectCount,
													  uInt32 			  &outObjectMoved,
													  Boolean			  &outPageDeleteFlag	);
	virtual void		MoveDataFromNextPage		(	SObjList_10_1			*inList,
														const PageID		inTargetPageID,
														const uInt32		inObjectCount,
														uInt32 				&outObjectMoved,
														Boolean				&outPageDeleteFlag	);


	// instance data that is not stored on disk
//		FSSpec				fFSSpec;
		CFile				fStore;
//		short				fFileRef;
		OSType				fFileType;
		OSType				fFileCreator;
		PageCacheList_10_1		fPageCache;
		volatile Boolean	fHeaderDirty;
//		ParamBlockRec		fFileIOPB;
		uInt32				fMinFreeDiskSpace;
		sInt32				fOldPageCount;	
		
		uTime_t				fNextFreeSpaceCheck;
		long				fPageCountTillFreeCheck;
		
		CDBBaseObjectCache_10_1	*fObjectCachePtr;

	// persistant data stored on disk		
		SDatabaseHeaderData_10_1	fDatabaseHeader;
};

#endif	// __CBaseDatabase_h__
