/*
	$Id: CDBMailBaseObject.10.1.cpp,v 1.1 2003/04/20 23:32:27 dasenbro Exp $

	File:		CDBMailBaseObject_10_1.cpp

	Contains:	C++ implementation of basic persistent database object

	Written by:	Nick Brosnahan

	Copyright:	 1996-2001 by Apple Computer, Inc., all rights reserved.

	Change History:

		$Log: CDBMailBaseObject.10.1.cpp,v $
		Revision 1.1  2003/04/20 23:32:27  dasenbro
		Initial check-in.
		
		Revision 1.8  2001/06/21 20:50:53  dasenbro
		Updated file header info.
		
		Revision 1.7  2001/06/21 17:01:16  dasenbro
		Added Change History.
		

	Projector History:

	  <ASM4>	  6/7/99	DOR		Pass NULL to a base-class constructor.
	  <ASM3>	  6/4/99	DOR		Add code to check object characteristics and report if there are
									any word-alignment issues with this version of
									sources/compiler/header-files.  This check is a runtime sanity
									check to hopefully "catch" any potential build problems that
									could lead to file-format compatilbility problems with 6.0, 6.1
									or 6.2....
	  <ASM2>	  6/2/99	DOR		Add a new virtual function to check compiler object offset
									issues.  Avoid a "silent" bad build when the build preferences
									are wrong.

	To Do:
*/

#include "Database.10.1.h"
#include "CDBMailBaseObject.10.1.h"
#include "CString.h"

// ----------------------------------------------------------------------------------------
#pragma mark * Static Methods *
// ----------------------------------------------------------------------------------------

#pragma mark -

CDBMailObjectCacheList_10_1::CDBMailObjectCacheList_10_1()
{
}

CDBMailObjectCacheList_10_1::~CDBMailObjectCacheList_10_1()
{
}
		
void CDBMailObjectCacheList_10_1::DoListLock ( void )
{
//	this->fObjectLock.Wait();
}

void CDBMailObjectCacheList_10_1::DoListRelease ( void )
{
//	this->fObjectLock.Signal();
}

#pragma mark -

CDBMailObjectCache_10_1::CDBMailObjectCache_10_1() : CDBBaseObjectCache_10_1 ( NULL )
{
//	fCacheLock = NULL;
}

CDBMailObjectCache_10_1::~CDBMailObjectCache_10_1()
{
//	if ( fCacheLock != NULL )
//	{
//		delete [] fCacheLock;
//		fCacheLock = NULL;
//	}
}

void CDBMailObjectCache_10_1::SetBaseDBPtr( CBaseDatabase_10_1 *inBaseDBPtr )
{
	BaseDBAssert_if (this != NULL)
	{
		this->fBaseDBPtr = inBaseDBPtr;
		this->SetUpHashTable();
//		if ( fCacheLock != NULL )
//		{
//			delete [] fCacheLock;
//			fCacheLock = NULL;
//		}
//		if (this->GetListCount() != 0)
//		{
//			fCacheLock = new CFastMutex[ this->GetListCount() ];
//		}
	}
}
		
void CDBMailObjectCache_10_1::Wait ( const uInt32 inIndex )
{
//	BaseDBAssert(this != NULL);
//	BaseDBAssert(inIndex < this->GetListCount());
//	BaseDBAssert(fCacheLock != NULL);
//
//	if ((this != NULL) && (inIndex < this->GetListCount()) && (fCacheLock != NULL))
//	{
//		this->fCacheLock[inIndex].Wait();
//	}
}

void CDBMailObjectCache_10_1::Signal ( const uInt32 inIndex )
{
//	BaseDBAssert(this != NULL);
//	BaseDBAssert(inIndex < this->GetListCount());
//	BaseDBAssert(fCacheLock != NULL);
//	
//	if ((this != NULL) && (inIndex < this->GetListCount()) && (fCacheLock != NULL))
//	{
//		this->fCacheLock[inIndex].Signal();
//	}
}

#pragma mark -

CDBMailBaseObject_10_1::CDBMailBaseObject_10_1 (	StdDBObjHeader_10_1	*inObjHeader,
													StdDBObjFooter_10_1	*inObjFooter,
													void			*inObjData,
													const OSType	inObjSignature,
													const uInt32	inObjVersion,
													const uInt32	inObjSize 		)
	: CDBBaseObject_10_1 (inObjHeader, inObjFooter, inObjData, inObjSignature, inObjVersion, inObjSize)
{
}

CDBMailBaseObject_10_1::~CDBMailBaseObject_10_1 ( void )
{
}

void CDBMailBaseObject_10_1::ChkCompilerStructAlignment ( void )
{
}

CDBBaseObject_10_1 *CDBMailBaseObject_10_1::Use ( CBaseDatabase_10_1	*inBaseDB )
{
	#pragma unused (inBaseDB)
	
	return (CDBBaseObject_10_1::Use(gDB_10_1));
}

CDBMailBaseObject_10_1* CDBMailBaseObject_10_1::MailUniversalFindByID (	const ObjID				inObjID,
																		const OSType			inObjType,
																		const uInt32			inObjVersion,
																		const uInt32			inObjSize,
																		ObjAllocFuncPtr_10_1	inObjAllocFuncPtr	)
{
	return ((CDBMailBaseObject_10_1*) CDBBaseObject_10_1::UniversalFindByID( 	gDB_10_1,
																	inObjID, inObjType, inObjVersion,
																	inObjSize, inObjAllocFuncPtr));
}

void CDBMailBaseObject_10_1::ReportBackwardCompatibility ( const uInt32 curSize, const uInt32 correctSize, char *inBaseClassName, char *inFieldName )
{
	if (curSize != correctSize)
	{
		CString	aTempString;
		
		aTempString.Sprintf("### FILE FORMAT COMPATIBILITY SAFETY CHECK FAILED ### %s::%s - offset is (%d) vs. (%d) reference standard",inBaseClassName, inFieldName, curSize, correctSize);
// xxxx		ERRLOG1(kLogApplication, kELFileFormatCHKFailed, aTempString.GetData());
	}
	
	#ifdef DEBUG
		if (curSize == correctSize)
		{
			CString	aTempString1;
			
			aTempString1.Sprintf("### File Format Compatibility Safety Check Good! - %s::%s - offset is (%d) vs. (%d) reference standard",inBaseClassName, inFieldName, curSize, correctSize);
// xxxx			ERRLOG1(kLogApplication, kELFileFormatCHKFailed, aTempString1.GetData());
		}
	#endif
	
	if ((curSize > CIDTable_10_1::GetEntryMaxByteSize()) || (curSize > kStandardPageSize))
	{
		CString	aTempString2;
		
		aTempString2.Sprintf("### FILE FORMAT COMPATIBILITY SAFETY CHECK FAILED ### %s::%s - objectsize of (%d) is too big.",inBaseClassName, inFieldName, curSize);
// xxxx		ERRLOG1(kLogApplication, kELFileFormatCHKFailed, aTempString2.GetData());
	}
}

//--------------------------------------------------------------------------------------------------
//	* GetObjectLock
//
//--------------------------------------------------------------------------------------------------

ExceptionCode CDBMailBaseObject_10_1::GetObjectLock ( const Boolean inWaitForObjectLock, const uInt32  inMaxWaitTime )
{
	ExceptionCode grabError = kNoErr;
	
//	grabError = fObjectLock.Wait(semaphore_NoWait);
//	while ( (grabError != kNoErr) && (inWaitForObjectLock == true) )
//	{
//		grabError = fWait4ObjectLock.Wait( inMaxWaitTime );
//		if (grabError == kNoErr)
//		{
//			try
//			{
//				fWait4ObjectLock.Reset();
//			}
//
//			catch ( ExceptionCode err )
//			{
//			}
//		}
//		
//		grabError = fObjectLock.Wait(semaphore_NoWait);
//	}

	return( grabError );

} // GetObjectLock



//--------------------------------------------------------------------------------------------------
//	* ReleaseObjectLock
//
//--------------------------------------------------------------------------------------------------

void CDBMailBaseObject_10_1::ReleaseObjectLock ( const Boolean inNotifyOtherThreadsFlag )
{
//	if (inNotifyOtherThreadsFlag == true)
//	{
//		this->WakeUpObjectThreads();
//	}
} // ReleaseObjectLock

void CDBMailBaseObject_10_1::WakeUpObjectThreads ( void )
{
//	fWait4ObjectLock.Signal();
}

