/*
	File:		CSTr2IDTable.10.1.h

	Copyright:	 2002 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:
*/

#ifndef __CSTr2IDTable_10_1_h__
#define __CSTr2IDTable_10_1_h__ 1

#include "DatabaseTypes.h"

const uInt32	kStr2IDTableType_10_1		= 'str2';
const uInt32	kStr2IDMaxStringSize_10_1	= 256;

typedef struct
{
	short	fStrOffset;
	ObjID	fObjID;
	PageID	fObjPageID;
} SStr2IDEntry_10_1;


typedef struct
{
	uInt32			fDataTableVersion;
	
	OSType			fTableType;
	Boolean			fCaseSensitiveFlag;
	uInt32			fCount;			// current number of entries in this table

	PageID			fNextID;
	PageID			fPrevID;
	PageID			fParentID;
	
	unsigned short	fStringHeap;
	char			fCurrentMinString[ kStr2IDMaxStringSize_10_1 ];

	// -------------------------------------------------------
	SStr2IDEntry_10_1	f1stStringEntry[1];	// this field _MUST_ be the last field in the struct...
} SStr2IDTableHeader_10_1;


const uInt32 kMaxStr2IDTableSize_10_1		= (kStandardPageSize - sizeof(SStr2IDTableHeader_10_1));
const uInt32 kStr2IDTableVersion1_10_1		= 0x05010001 + sizeof(SStr2IDTableHeader_10_1) + kMaxStr2IDTableSize_10_1;
const uInt32 kStr2IDTableCurVersion_10_1	= kStr2IDTableVersion1_10_1;
const uInt32 kStr2IDNullIndex_10_1			= 0xffffffff;

typedef struct
{
	SStr2IDTableHeader_10_1	fStr2IDTableHeader;
	char					fStr2IDDTableData[ kMaxStr2IDTableSize_10_1 ];
} SStr2IDTable_10_1;

class CStr2IDTable_10_1
{
	public:
							 CStr2IDTable_10_1	( const Boolean inCaseSensitiveFlag );
		virtual 			~CStr2IDTable_10_1	( void );
		
		static void CheckBackwardCompatibility	( void );
		static void ReportBackwardCompatibility	( const uInt32 curSize, const uInt32 correctSize );
		static void			strncpy				(	char *inTargetStr,
													char *inSourceStr,
													const uInt32 inMaxLength );
		
		virtual OSStatus	SetTable			( void *inTablePtr, const PageID inPageID);
		
		virtual	OSStatus	AddStr2List			( const char *inEntryString, const ObjID inEntryID, const PageID inObjPageID, Boolean allowNewMin = false);
		virtual OSStatus	RemoveStrFromList	( const char *inEntryString );
		virtual OSStatus	FindEntry			( const char *inEntryString, uInt32 &outIndex );
		virtual OSStatus	GetEntry			( const uInt32 inIndex, SStr2IDEntry_10_1 &outEntry );

		virtual OSType		GetTableType			( void );
		virtual Boolean		GetCaseSensitiveFlag	( void );
		virtual char *		GetNewString			( const char *inSourceString, const Boolean inMakeLowerCaseFlag );

		virtual OSStatus		SetStringHeap			( const unsigned short inStringHeap );
		virtual unsigned short	GetStringHeap			( void );

		
		virtual OSStatus	SetEntryCount		( const uInt32 inEntryCount );
		virtual uInt32		GetEntryCount		( void );

		virtual OSStatus	ClearStr2IDTable	( const Boolean inCaseSensitiveFlag );

		virtual	char *		GetCharStar			( const unsigned short inStringOffset );
		virtual char *		GetMinCharStar		( void );
		
		virtual PageID		GetParentID			( void );
		virtual OSStatus    SetParentID			( const PageID inParentIDTable );
		
		virtual PageID		GetNextID			( void );
		virtual OSStatus    SetNextID			( const PageID inNextIDTable );
		
		virtual PageID		GetPrevID			( void );
		virtual OSStatus    SetPrevID			( const PageID inPrevIDTable );
		
		virtual	OSStatus	SetTablePageID		( const PageID inPageID );
		virtual	PageID		GetTablePageID		( void );
		
		enum
		{
			kStr2IDTableNoErr = 0,
			kStr2IDTableFull = -1,
			kStr2IDTableNoSuchObject = -2,
			kStr2IDTableDuplicateObject = -3,
			kStr2IDTableObjNoAdd = -4,
			kStr2IDTableIndexOutOfRange = -5,
			kStr2IDTableEntryCountTooBig = -6,
			kStr2IDTableNoInsertAllowed = -7,
			kStr2IDNewMinNotAllowed = -8,
			kStr2IDNewMaxNotAllowed = -9,
			kStr2IDBadTablePtr = -10,
			kStr2IDBadString = -11,
			kStr2IDString2Big = -12,
			kStr2IDBadThisObject = -13
		};
	
	protected:
		virtual uInt32		CalcFreeSpace	( void );
		virtual OSStatus	DeleteEntry 	(const uInt32 inIndex);
		virtual OSStatus	SetEntry		(const uInt32 inIndex, const SStr2IDEntry_10_1 inEntry );
		virtual OSStatus	InsertEntry		(const uInt32 inIndex, const SStr2IDEntry_10_1 inEntry);
				OSStatus	SanityCheck		( void );

		// volitile data, no read/write to disk
		PageID				fPageID;
		SStr2IDTableHeader_10_1	fTempHeader;
		
		// Data portion of the object, this can be saved and restored
		// to disk....
		SStr2IDTable_10_1		*fStr2IDTablePtr;
};

#endif	// __CSTr2IDTable_10_1_h__
