/*
	File:	Database.10.1.h

	Contains: Database functions.

	Copyright:	 1996-2001 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: Database.10.1.h,v $
		Revision 1.1  2003/04/20 23:32:27  dasenbro
		Initial check-in.
		

	To Do:
 */


#ifndef __Database_10_1_h__
#define __Database_10_1_h__ 1

#include "MailTypes.h"
#include "CMailDatabase.10.1.h"

// DB Cache Percentage Resource
const uInt32 kDatabasePercentageResType_10_1	= 'DBcp';
const uInt32 kDatabasePercentageResID_10_1		= 128;

//#if PRAGMA_ALIGN_SUPPORTED
//#pragma options align=mac68k
//#endif

typedef struct
{
	uInt16 version;
	uInt16 percentage;
} DBCachePercentage_10_1;

//#if PRAGMA_ALIGN_SUPPORTED
//#pragma options align=reset
//#endif


enum {
	kSeedDB_10_1		= 'sdDB',
	kNormalDB_10_1		= 'nmDB'
};

enum {
	kDBIsOK_10_1			= 0x00000001,
	kNewDBCreated_10_1		= 0x00000002,
	kWrongDBVersion_10_1	= 0x00000004,
	kPoorlyClosedDB_10_1	= 0x00000008,
	kCantOpenDB_10_1		= 0x00000010
};

typedef enum {
	kDBVerUnknown_10_1		= 0x00000001,
	kDBVer6_X_10_1			= 0x00000002,
	kDBVer10_0_10_1			= 0x00000004,
	kDBVer10_1_10_1			= 0x00000006,
	kDBCurrent_10_1			= 0x00000008
} eDBVers_10_1;

// Main Database
sInt32		CheckDBVersion_10_1			( const char *inDBPath, eDBVers_10_1 *outDBVer );
sInt32		ValidateMailDB_10_1			( const char *inDBPath );
Boolean		InitializeMainDB_10_1		( const char *inSpec, uInt32 &outDBFlags );
void		CloseMainDB_10_1			( void );
void		GetDiskFreeSpace_10_1		( long long &volFree );

OSErr		CanCreateDB_10_1			( void );
Boolean		IsDBFull_10_1				( void );

extern CMailDatabase_10_1 *gDB_10_1;


#endif /* __Database_10_1_h__ */
