/*
	$Id: CDBMailBaseObject.h,v 1.1 2003/04/20 23:32:51 dasenbro Exp $

	File:		CDBMailBaseObject.h

	Contains:	C++ base class definition for persistent database objects

	Version:	Apple Mail Server - Mac OS X :  $Revision: 1.1 $

	Written by:	Nick Brosnahan

	Copyright:	 1996-2001 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: CDBMailBaseObject.h,v $
		Revision 1.1  2003/04/20 23:32:51  dasenbro
		Initial check-in.
		
		Revision 1.7  2002/03/21 16:41:17  dasenbro
		Updated file version information.
		
		Revision 1.6  2001/06/21 20:50:53  dasenbro
		Updated file header info.
		
		Revision 1.5  2001/06/21 17:05:39  dasenbro
		Added Change History.
		

	Projector History:

	  <ASM3>	  6/4/99	DOR		Add code to check object characteristics and report if there are
									any word-alignment issues with this version of
									sources/compiler/header-files.  This check is a runtime sanity
									check to hopefully "catch" any potential build problems that
									could lead to file-format compatilbility problems with 6.0, 6.1
									or 6.2....
	  <ASM2>	  6/2/99	DOR		Add a new function to check compiler alignment issues.

	To Do:
*/


#ifndef __CDBMailBaseObject_h__
#define __CDBMailBaseObject_h__	1

#include "CDBBaseObject.h"

class CDBMailBaseObject : public CDBBaseObject
{
	public :
				CDBMailBaseObject		( 	StdDBObjHeader		*inObjHeader,
				 				  		StdDBObjFooter		*inObjFooter,
				 				  		void				*inObjData,
							 	   		const OSType		inObjSignature,
							 	   		const uInt32		inObjVersion,
							 	   		const uInt32		inObjSize 		);
		virtual	~CDBMailBaseObject		( void );

		virtual CDBBaseObject*		Use	( CBaseDatabase	*inBaseDB = NULL);
		static	CDBMailBaseObject*	MailUniversalFindByID	(	const ObjID			inObjID,
																const OSType		inObjType,
																const uInt32		inObjVersion,
																const uInt32		inObjSize,
																ObjAllocFuncPtr		inObjAllocFuncPtr	);
		// Thread OwnerShip
		virtual	ExceptionCode	GetObjectLock		( const Boolean inWaitForObjectLock,
												  	  const uInt32	inMaxWaitTime = kSafetyWaitTime );
		virtual	void			ReleaseObjectLock	( const Boolean inNotifyOtherThreadsFlag );
		virtual	void			WakeUpObjectThreads	( void );

		virtual void			ChkCompilerStructAlignment	( void );
		virtual void			ReportBackwardCompatibility	( const uInt32 curSize, const uInt32 correctSize, char *inBaseClassName, char *inFieldName );

	private:
};

class CDBMailObjectCacheList : public CDBBaseObjectCacheList
{
	public:
				CDBMailObjectCacheList();
		virtual ~CDBMailObjectCacheList();
		
		virtual void			DoListLock		( void );
		virtual void			DoListRelease	( void );
	
	private:
};

class CDBMailObjectCache : public CDBBaseObjectCache
{
	public:
				CDBMailObjectCache();
		virtual	~CDBMailObjectCache();
		
		virtual void		SetBaseDBPtr		( CBaseDatabase *inObject );

		virtual	void		Wait				( const uInt32 inIndex );
		virtual	void		Signal				( const uInt32 inIndex );

	private:
};


#endif // __CDBMailBaseObject_h__
