/*
	$Id: MailUGCommon.h,v 1.1 2003/04/20 23:34:11 dasenbro Exp $

	File:		MailUGCommon.h

	Contains:	class definition of a Mail User object

	Version:	Apple Mail Server - Mac OS X :  $Revision: 1.1 $

	Written by:	acheung

	Copyright:	 1999-2001 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: MailUGCommon.h,v $
		Revision 1.1  2003/04/20 23:34:11  dasenbro
		Initial check-in.
		
		Revision 1.8  2002/03/21 16:38:52  dasenbro
		Addes network transition support.
		
		Revision 1.7  2001/06/21 20:50:55  dasenbro
		Updated file header info.
		
		Revision 1.6  2001/06/21 17:22:47  dasenbro
		Added Change History.
		
		

	To Do:
*/


#ifndef MAILUGCOMMON_H
#define MAILUGCOMMON_H

#include "MailTypes.h"

typedef enum {
		kMUGErrNoErr			= 0x0000,
		kMUGErrRecordDontExist	= 0x0001,
		kMUGErrRecordExpired	= 0x0002,
		kMUGErrRecordMismatch	= 0x0004,
		kMUGErrUpdateError		= 0x0008,
		kMUGErrGroupExpansion	= 0x0010,
		kMUGErrCaughtException	= 0x0F00,
		kMUGErrUndefined		= 0x0FFF
} eMUGError;

typedef		uInt32		tUserFlagsType;
typedef		uInt32		tGroupFlagsType;
typedef 	Str32		tShortNameStorageType;
typedef 	Str255		tLongNameStorageType;

const uInt32 	kInetNameLen = 32;						// length of internet name
const uInt32	kCNameLen = 64;							// length of canonical name
const uInt32 	kNameLen = 64;							// length of other nicknames
const uInt32	kMaxNameCount = 8;						// max number of nicknames
const uInt32	kGroupNameLen = 32;						// length of group name
const uInt32 	kDirPathLen = 256;						// path to the directory
const uInt32	kEmailAddrNameLen = 256;				// max length of email address
const uInt32	kDefaultMUGExpireTimeDelta = 60 * 60;		// 1 hour=3600 sec - how long we cache the directory info	




// ***************
// User Attributes - taken from MU60Attributes
// ***************

enum eMailUserFlags		
{
	KMUUserEnableMask		= 0x0000000F,
	kMUAPOPRequired			= 0x00000004,	// User must use APOP to authenticate
	
	kMUForwardingMask	 	= 0x000000F0,	// Mask to get forwarding options
	kMUNoForwarding			= 0x00000010,	// enabled mail...this bit should be set..
	kMUForwardSMTP			= 0x00000020,	// Forward mail to SMTP address

	// 6.0 flag additions
	kMUIMAPPOPFlagsMask		= 0x00000F00,
	kMUPOPEnabled			= 0x00000100,	// User can connect over POP3 or PASS
	kMUIMAPEnabled			= 0x00000200,	// User can connect over IMAP or PASS
	
	kMUNotificationMask		= 0x0000F000,
	kMUNotificationON 		= 0x00001000,	// User wants mail notification
	kMUUseLastIPAddr 		= 0x00002000,	// Use last IP Address for notification - notifyIPAddress is ignored..
	kMUUseSpecificIPAddr	= 0x00004000,	// field notifyIPAddress is used...and kMUUseLastIPAddr should cleared..

	kMUSharedBoxFlagMask	= 0x000F0000,
	kMUSeparatePOPAndIMAP	= 0x00010000,	// User can connect over POP3, IMAP or PASS with separate inbox
	kMUShowPOPInIMAP		= 0x00020000,	// User can connect over POP3, IMAP or PASS with separate inbox

// Rhapsody only
	kMUAdminUserMask		= 0x00F0000,
	kMUAdminEnabled			= 0x0010000		// User is a administrator (can connect over IP Admin port)

};


enum eMUGAuthResults
{
	// successes
	kMUGAuthOK					= 0x0000,
	kMUGAuthNeedNewPasswd		= 0x0001,	// password needs changing
	kMUGAuthPasswdExpired		= 0x0002,
	kMUGAuthNotAdminUser		= 0x0004,

    // failures
	kMUGAuthError				= 0x0100,
	kMUGAuthLoginDisabled		= 0x0200,
	kMUGAuthAdminDisabled		= 0x0300,
	kMUGAuthMethodUnspported 	= 0x0800,

	kMUGAuthDirectoryError		= 0x1000,
	
	kMUGAuthUnknownError		= 0xFFFF
};


#endif // MAILUGCOMMON_H