/*
	$Id: MailTypes.h,v 1.1 2003/04/20 23:25:37 dasenbro Exp $

	File:		MailTypes.h

	Contains:	xxx put contents here xxx

	Version:	Apple Mail Server - Mac OS X :  $Revision: 1.1 $

	Written by:	Michael Dasenbrock

	Copyright:	 1996-2001 by Apple Computer, Inc., all rights reserved.

	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:
		$Log: MailTypes.h,v $
		Revision 1.1  2003/04/20 23:25:37  dasenbro
		Initial check-in.
		
		Revision 1.19  2002/06/10 22:44:21  dasenbro
		Changed order of Kerberos state flags.
		
		Revision 1.18  2002/05/30 17:21:30  dasenbro
		Removed duplicate typedefs.
		
		Revision 1.17  2002/05/09 16:58:53  dasenbro
		Changed all str... calls to CUtils::Str... to be NULL safe.
		
		Revision 1.16  2002/04/18 16:51:49  dasenbro
		Added type Bool = uInt32
		
		Revision 1.15  2002/04/16 05:48:36  dasenbro
		Removed bit flags for unused SMTP controls.
		
		Revision 1.14  2002/03/25 22:57:51  dasenbro
		Added kIOErr.
		
		Revision 1.13  2002/03/21 16:41:14  dasenbro
		Updated file version information.
		
		Revision 1.12  2002/02/20 21:25:56  dasenbro
		Added types from MailAdminHooks.h.
		
		Revision 1.11  2002/01/14 16:49:46  dasenbro
		Initial S4 updates.
		
		Revision 1.10  2001/06/21 20:50:49  dasenbro
		Updated file header info.
		
		Revision 1.9  2001/06/21 16:25:11  dasenbro
		Added new const.
		

	Projector History:
		 <3>	12/18/99	MED		Added a context data struct.

	To Do:
*/

#ifndef __MailTypes_h__
#define	__MailTypes_h__	1

typedef		char					sInt8;
typedef		unsigned char			uInt8;

typedef		short					sInt16;
typedef		unsigned short			uInt16;

typedef		long					sInt32;
typedef		unsigned long			uInt32;

typedef		long long				sInt64;
typedef		unsigned long long		uInt64;

typedef		uInt32					Bool;

typedef		sInt8					MSDateForm;

typedef		sInt16					ResIDT;
typedef		sInt32					PaneIDT;
typedef		sInt32					ClassIDT;
typedef		sInt32					DataIDT;
typedef		sInt32					ObjectIDT;

typedef 	uInt8					Boolean;
typedef		char *					Ptr;

typedef		uInt32					uTime_t;

typedef		sInt16 					OSErr;
typedef		sInt32 					OSStatus;
typedef		void *					LogicalAddress;
typedef		const void *			ConstLogicalAddress;
typedef		void *					PhysicalAddress;
typedef 	uInt8 *					BytePtr;
typedef 	uInt32 					ByteCount;
typedef 	uInt32 					ByteOffset;
typedef		sInt32 					Duration;
typedef 	uInt32 					OptionBits;
typedef 	uInt32 					ItemCount;
typedef 	uInt32 					PBVersion;
typedef		sInt16 					ScriptCode;
typedef		sInt16 					LangCode;
typedef		sInt16 					RegionCode;
typedef		unsigned long 			FourCharCode;
typedef		FourCharCode 			OSType;
typedef		FourCharCode 			ResType;
typedef		OSType *				OSTypePtr;
typedef		ResType *				ResTypePtr;

typedef		Ptr						MSFSSpec;

struct MSPoint {
	sInt16		v;
	sInt16		h;
};
typedef struct MSPoint MSPoint;

typedef unsigned char *					StringPtr;
typedef StringPtr *						StringHandle;
typedef const unsigned char *			ConstStringPtr;
typedef const unsigned char *			ConstStr255Param;
typedef const unsigned char *			ConstStr63Param;
typedef const unsigned char *			ConstStr32Param;
typedef const unsigned char *			ConstStr31Param;
typedef const unsigned char *			ConstStr27Param;
typedef const unsigned char *			ConstStr15Param;
#if TARGET_OS_MAC
typedef ConstStr63Param 				ConstStrFileNameParam;
#else
typedef ConstStr255Param 				ConstStrFileNameParam;
#endif  /* TARGET_OS_MAC */

typedef unsigned char 					Str255[256];
typedef unsigned char 					Str63[64];
typedef unsigned char 					Str32[33];
typedef unsigned char 					Str31[32];
typedef unsigned char 					Str27[28];
typedef unsigned char 					Str15[16];

#ifndef nil
	#define nil NULL
#endif

enum {
	kQErr						=  -1,						/*queue element not found during deletion*/
	kReadErr					= -19,						/*I/O System Errors*/
	kWritErr					= -20,						/*I/O System Errors*/
	kDskFulErr					= -34,						/*disk full*/
	kIOErr						= -36,						/*I/O error (bummers)*/
	kFnOpnErr					= -38,						/*File not open*/
	kFnfErr						= -43,						/*File not found*/
	kWPrErr						= -44,						/*diskette is write protected.*/
	kFLckdErr					= -45,						/*file is locked*/
	kDupFNErr					= -48,						/*duplicate filename (rename)*/
	kGfpErr						= -52,						/*get file position error*/
	kPermErr					= -54						/*permissions error (on file open)*/
};

enum {
	kVLckdErr					= -46,						/*volume is locked*/
	kWrPermErr					= -61,						/*write permissions error*/
	kDataVerErr					= -68						/*read verify compare failed*/
};

enum {
	kFileBoundsErr				= -1309						/*file's EOF, offset, mark or size is too big*/
};

enum {
	kNoErr						= 0,
};

// Error enums

enum {
	kMemFullErr					= -108							/*Not enough room in heap zone*/
};

enum {
	kErrAEEventNotHandled		= -1708						/* the AppleEvent was not handled by any handler */
};

/* ADSP Error Codes */
enum {
	kErrAborted					= -1279							/* control call was aborted */
};

enum {
	kiMemFullErr				= -108,
	kiIOAbort					= -27
};

enum {
	kShortDate					= 0,
	kLongDate					= 1,
	kAbbrevDate					= 2,
	kNumericDate				= 3,
	kMailBoxDate				= 4
};

enum {
	kDirectoryCreated			= 1810,
	kDirectoryDeleted			= 1811
};

enum {
	kFailedToCreateDirectory	= -1810,
	kFailedToDeleteDirectory	= -1811,
	kDirectoryAccessDenied		= -1812,
	kOtherDirectoryError		= -1813,
	kUnknownDirectoryError		= -1814
};

enum {
	kNullPtr					= -5640,					/*NULL pointer*/
	kNoUserOrGroup				= -5641,					/*unknown user or group*/
	kUnknownError				= -5666
};

typedef enum
{
	kMachineOwnerItem =				'Ownr',
	kAdministratorItem =			'Admn',
	kDisabledUserItem =				'DisU',
	kGuestItem =					'Gust',
	kUserItem =						'User',
	kGrouptItem =					'Rrup',
	kRemoteUserItem =				'RemU',
	kRemoteGroupItem =				'RemG',
	kNoItem =						'None'
} eUGType;

typedef struct UserStruct
{
	sInt32		fID;
	eUGType		fType;
	char		fUserName[ 256 ];
	char		fRealName[ 256 ];
	char		fPath[ 256 ];
	uInt32		fReserved;
} UserStruct;


// -- From MailAdminEvents.h

typedef enum
{
	kNoLogType,
	kAServerLogType,
	kAnErrorLogType
} ELogType;


typedef enum
{
	kUnKnown		= 0,
	kOutTCP			= 1,
	kOutAppleTalk	= 2,
	kOutUUCP		= 3,

	kNotUsedPadOutConnTypes		= 0xFFFFFFFF	// to force the compiler to use 4 bytes

} OutConnTypes;


typedef enum
{
	kUnknownState			= 0,
	kIdleState				= 1,
	kGetDNSMXListState		= 2,
	kGetDNSARecordState		= 3,
	kConnAttemptState		= 4,
	kConnectedState			= 5,
	kCleanupState			= 6,
	kUpdateProgressState	= 7,
	kWait4Termination		= 8,

	kNotUsedPadOutConnInfoState		= 0xFFFFFFFF	// to force the compiler to use 4 bytes
} OutConnInfoState;

typedef struct
{
	OutConnInfoState	fConnState;
	OutConnTypes		fConnType;
	Str255				fConnHostName;
	uInt32				fConnHostID;			// used in the terminate connection operation..
	uInt32				fConnectionNetAddress;	// either an IP Address or an AppleTalk Address
												// depending on fConnType
	uInt32				fConnTime;
	uInt32				fCurMessageNum;
	uInt32				fTotalMessages;
	uInt32				fCurMessagePart;
	uInt32				fTotalMessageParts;
} MailOutConnInfo;

// Radio Button Values

typedef enum {
	kNoMXValue		= 0x0000,
	kMXandARecord	= 0x0001,
	kMXonly			= 0x0002,
	kARecordOnly	= 0x0004
} eDNSRequest;

typedef enum {
	kNoCacheValue	= 0x0000,
	kRespectTTL		= 0x0001,
	kCacheNDS		= 0x0002
} eCacheSettings;



const uInt32 k24HoursADay = 0x00ffffff;	// 24 bits set, 24 hours a day...


// Server Prefs

typedef enum
{
	kSMTPStateUnknown		= 0,
	kSMTPStateAppleMail		= 1,
	kSMTPStateUseOtherMTA	= 2,
	kSMTPStateDisabled		= 3
} eSMTPState;

typedef enum
{
	kKerberosStateUnknown		= 0,
	kKerberosStateOff			= 1,
	kKerberosStateRequired		= 2,
	kKerberosStateAllowed		= 3
} eKerberosState;

// Bit flags.
typedef enum 
{ 
	kMSSFFwdAllUndelivNDRsToPMChk		= 0x01,	// Secret panel check box 407
	kMSSFSendBulkNDRsChk				= 0x02,	// Secret panel check box 408
	kMSSFBackupServerModeChk			= 0x04,	// Secret panel check box 409
//	kMSSFStrictSMTPInConnections		= 0x08,	// Secret panel check box 413
//	kMSSFRejectBadSMTPInConnections		= 0x10,	// Secret panel check box 412
	kMSSFDeleteAllEmptyDefaultHostsChk	= 0x20,	// Secret panel check box 410
	kMSFlagsLastFlagValue				= 0xff	// Note: Field size is 1 byte.

} MailServerPrefsFlagsAdvanced1;

// * Popup menu states for the various panels.

const uInt32 	kServerPrefsAdvNetworkDNSPopupCacheDNS			= 1;
const uInt32 	kServerPrefsAdvNetworkDNSPopupAlwaysCheckDNS	= 2;
// Advanced - 'network' panel popup menu states.

const uInt32 	kEditHostScheduleConnectionPopupConnectAsNeeded	= 1;
const uInt32 	kEditHostScheduleConnectionPopupUseCustome		= 2;
// Edit Host - 'Schedule' panel popup menu states.

const uInt32 	kEditHostNetworkDNSPopupUseServerGeneral		= 1;
const uInt32 	kEditHostNetworkDNSPopupAlwaysCheckDNS			= 2;
const uInt32 	kEditHostNetworkDNSPopupCacheDNS				= 3;

#endif // __MailTypes_h__
