/*
	File:		CHostEntryPref.10.1.h

	Contains:	C++ class definition for Host Entry

	Copyright:	 2003 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: CHostEntryPref.10.1.h,v $
		Revision 1.1  2003/04/20 23:46:10  dasenbro
		Initial check-in.
		

	To Do:
*/


#ifndef __CHostEntryPref_10_1_h__
#define __CHostEntryPref_10_1_h__ 1

#include <time.h>

#include "CDBMailBaseObject.10.1.h"
#include "CMailDatabase.10.1.h"
#include "HostPrefs.10.1.h"
#include "CString.h"
#include "MailGlobals.h"

#define		kDefaultHostPrefsID		50

static const char* const	kDefaultString_10_1		= "::default::";
static const char* const	kRejectSMTPString_10_1	= "::reject smtp::";

typedef enum
{
	kNoValue_10_1,
	kAllowAllMessages_10_1,
	kAllowLocalDelivery_10_1,
	kRejectAllMessages_10_1
} EInMsgPreference_10_1;

typedef enum
{
	kNoValueMailOut_10_1,
	kAllowAllMailOut_10_1,
	kHoldAllMailOut_10_1,
	kRejectAllMailOut_10_1
} EOutMsgPreference_10_1;

typedef enum
{
	kNoDNSDeltaValue_10_1,
	kRespectTTLValue_10_1,
	kUseCustomCacheDeltaValue_10_1
} ECacheDNSDeltaType_10_1;

typedef struct
{
	StdDBObjHeader_10_1	fDBHeader;

	ObjID				fHostEntryPrefID;	// self ID, here for data scavenging reasons...
	ObjID				fParentHostEntryID;	// objID of matching HostEntry Record...

	// Reserved
	uInt32				fReserved1;			// reserverd
	uInt32				fReserved2;			// reserverd

	InetDomainName		fName;				// name of prefs

	Boolean				fIsDefault;			// true if this is the default host prefs record

	HostPrefs			fPrefsData;

	StdDBObjFooter_10_1	fDBFooter;

} CHostEntryPrefData_10_1;


// CDBMailBaseObject Constants
const uInt32	kHostEntryPrefDataSize_10_1	= sizeof( CHostEntryPrefData_10_1 );
const uInt32	kHostEntryPrefVersion_10_1	= kDBCurrentVersion_10_1 + kHostEntryPrefDataSize_10_1;

class CHostEntryPref_10_1 : public CDBMailBaseObject_10_1
{
public:

	static CHostEntryPref_10_1*		GetDefaultHostEntry		( void );
	static CHostEntryPref_10_1*		GetHostEntryPrefsObj	( ObjID inHostID );

	// Static Methods
	static CHostEntryPref_10_1*		Create				( const char* inPrefName );
	static Boolean 					Delete				( CHostEntryPref_10_1* inHostEntryPref );
	static uInt32 					Count				( void );
	static Boolean					GetSetFields		( const eFieldDataRequest_10_1 inFieldRequest, const void *inObjDataPtr, void *outFieldData );

	static 	CHostEntryPref_10_1*	FindByID			( const	ObjID inObjectID );
	static	CHostEntryPref_10_1* FindByName			( const char* inPrefsName, bool inCreate );
	static	CDBBaseObject_10_1*	ObjectAllocNew		( void );

	static	OSType		GetObjTypeConstant	( void ) { return kHostPrefSignature_10_1; }
	static	uInt32		GetObjVersConstant	( void ) { return kHostEntryPrefVersion_10_1; }
	static	uInt32		GetObjSizeConstant	( void ) { return kHostEntryPrefDataSize_10_1; }

	virtual	ObjID		GetObjectID					( void );
	virtual	void		ChkCompilerStructAlignment	( void );
	void				Done						( CHostEntryPref_10_1* &inPtr );

	// Constructor/Destructor
						CHostEntryPref_10_1				( void );
	virtual			   ~CHostEntryPref_10_1				( void );

	CHostEntryPrefData_10_1*	GetHostEntryPrefData		( void );
	void				SetDirty					( void );

	void				Initialize					( Boolean inIsDefault );
	void				InitializeFromXML			( char & inXMLData );
	void				SetUpDefaultValue			( HostPrefs *inHostProfile );

	Boolean				IsDefault					( void );
	void				SetDefault					( void );

	// Object IDs
	ObjID				GetHostEntryPrefID			( void );
	void				SetHostEntryPrefID			( const ObjID inNewObjID );

	ObjID				GetParentHostEntryID		( void );
	void				SetParentHostEntryID		( const ObjID inParentHostEntryID );

	const char*			GetName						( void );
	void				SetName						( const char* inName );

	EInMsgPreference	GetInMsgPreferences			( void );
	void				SetInMsgPreferences			( const EInMsgPreference inInMsgPrefs );

	Boolean				GetNotifySenderOption		( void );
	void				SetNotifySenderOption		( const Boolean inNotifySenderOption );

	uInt32				GetASDID4BccCopy			( void );
	void				SetASDID4BccCopy			( const uInt32 inASDID4BccCopy );
	void				ClearASDID4BccCopy			( void );

	uInt32				GetASDID4Forward			( void );
	void				SetASDID4Forward			( const uInt32 inASDID4Forward );
	void				ClearASDID4Forward			( void );

	HostPrefs*			GetPrefsData				( void );
	void				SetPrefsData				( HostPrefs *inData );

// - Default Host Settings --
//	-- Incoming Mail ( NEW )
	uInt8		GetDeliverToLocalOnlyFlag	( void );
	void		SetDeliverToLocalOnlyFlag	( uInt8 inFlag );

	uInt8		GetLogRejectionsFlag		( void );
	void		SetLogRejectionsFlag		( uInt8 inFlag );

	uInt8		GetSendBCC_CopiesOfAllFlag	( void );
	void		SetSendBCC_CopiesOfAllFlag	( uInt8 inFlag );

	void		GetSendBCC_CopiesOfAllUser	( UserStruct *outInfo );
	void		SetSendBCC_CopiesOfAllUser	( UserStruct *inUserStruct );

// - Default Host Settings --
//	-- Outgoing Mail ( NEW )
	uInt32		GetOutMailPopupFlags		( void );
	void		SetOutMailPopupFlags		( uInt32 inFlag );

	uInt32		GetExpireOutMailAfterHours	( void );
	void		SetExpireOutMailAfterHours	( uInt32 inValue );

	uInt32		GetRetryFailedMinutes		( void );
	void		SetRetryFailedMinutes		( uInt32 inMinutes );

	uInt8		GetNotifySenderOfNDRFlag	( void );
	void		SetNotifySenderOfNDRFlag	( uInt8 inFlag );

	uInt32		GetNotifySenderOfNDRMinutes	( void );
	void		SetNotifySenderOfNDRMinutes	( uInt32 inMinutes );

	uInt8		GetNotifyPostmasterOfNDR	( void );
	void		SetNotifyPostmasterOfNDR	( uInt8 inFlag );

	uInt8		GetRelaySMTPFlag			( void );
	void		SetRelaySMTPFlag			( uInt8 inFlag );

	const char *GetRelaySMTPServer			( void );
	void		SetRelaySMTPServer			( const char *inSvrName, uInt32 inLen );

// - Default Host Settings --
//	-- Network Settings ( NEW )
	uInt16		GetDNSRequestButtonFlags	( void );
	void		SetDNSRequestButtonFlags	( uInt16 inFlag );

	uInt16		GetCacheSettingsButtonFlags	( void );
	void		SetCacheSettingsButtonFlags	( uInt16 inFlag );

	uInt32		GetCacheDNSMinutes			( void );
	void		SetCacheDNSMinutes			( uInt32 inFlag );

	uInt32		GetOpenConnTimeoutSeconds	( void );
	void		SetOpenConnTimeoutSeconds	( uInt32 inValue );

	uInt32		GetReadWriteTimeoutSeconds	( void );
	void		SetReadWriteTimeoutSeconds	( uInt32 inValue );

	uInt32		GetOutSMTPPortNumber		( void );
	void		SetOutSMTPPortNumber		( uInt32 inValue );


//	-- Incoming Mail ( OLD )
	EInMsgPreference	GetInHostMsgPref			( void );
	Boolean				GetLogMsgFromRejectFlag		( void );
	Boolean				GetLogMsgRecipRejectFlag	( void );
	Boolean				GetSendBCCFlag				( void );
	Boolean				GetBCCName					( CString &outStr );
	void				SetRejectSMTPInState		( void );

	// Mail Out Preferences
	EOutMsgPreference_10_1	GetOutHostMsgPref			( void );
	Boolean				GetUserNDROnRejectFlag  	( void );
	Boolean				GetPostMstrNDROnRejectFlag	( void );
	Boolean				GetRejectNDRPref			( void );

	Boolean				GetRedirectHostFlag			( void );
	void				SetRedirectHostFlag			( const Boolean inRedirectHostFlag );
	
	char *				GetRedirectHostName			( void );
	void				SetRedirectHostName			( const char *inRedirectHostName );

	Boolean				GetMsgExpireCheckBox		( void );
	uInt32				GetMsgExpireHoursValue		( void );
	
	Boolean				GetWarnSenderFlag			( void );
	Boolean				GetWarnPostMasterFlag		( void );
	uInt32				GetWarningTimeHours			( void );
	
	
	uInt32				GetHostDNSPopUpValue		( void );
	void				SetHostDNSPopUpValue		( const uInt32 inHostDNSPopUpValue );
	
	ECacheDNSDeltaType_10_1	GetDNSCacheDeltaType		( void );
	void				SetDSNCacheDeltaType		( const ECacheDNSDeltaType_10_1 inCachDeltaType );
	
	uInt32				GetCustomDNSDeltaValue		( void );
	void				SetCustomDNSDeltaValue		( const uInt32 inCustomDNSDeltaValue );
	
	Boolean				GetAllowMXListFlag			( void );
	Boolean				GetAllowARecordFlag			( void );
	
	Boolean				GetNetworkPortFlag			( void );
	uInt32				GetNetworkPortNumber		( void );
	
	Boolean				UseHostTimeouts				( void );
	uInt32				GetOpenTimeout				( void );
	uInt32				GetRdWrTimeout				( void );

	// schedule preferences
	
	Boolean				IsCustomSchedule			( void );
	Boolean				IsConnectionAllowed			( const EDays inDay2Check, const uInt32 inHour2Check );
	time_t				CalcNextAllowedTimeDelta	( const time_t inCurrentTime, Boolean  &outAllDaysAreOffFlag);
	
	Boolean				GetDefaultFreqFlag			( void );
	Boolean				GetCustomFreqFlag			( void );
	uInt32				GetCustomFreqValue			( void );

	Boolean				IsSendETRNOn				( void );
	Boolean				IsETRNAsNeededOn			( void );
	Boolean				IsETRNScheduleOn			( void );
	uInt32				GetETRNFreqValue			( void );

	// Persistent Fields
	CHostEntryPrefData_10_1		fHostEntryPrefData;
};

#endif // __CHostEntryPref_10_1_h__
