/*
	File:		CMailSpool.10.1.cpp

	Contains:	C++ implementation of generic mail spool objects

	Copyright:	 2003 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:
*/


// PP
#include <string.h>
#include <time.h>

// App
#include "CMailDatabase.10.1.h"
#include "CMailSpool.10.1.h"
#include "CEnvelopeInfo.10.1.h"
#include "CEnvelope.10.1.h"
#include "Database.10.1.h"
#include "CRootObject.10.1.h"
#include "UException.h"
#include "CGlobals.h"
#include "CUtils.h"

extern uInt32 gSyncFoldersStamp_10_1;


//--------------------------------------------------------------------------------------------------
//	* GetSetFields
//
//--------------------------------------------------------------------------------------------------

Boolean	CMailSpool_10_1::GetSetFields (	const eFieldDataRequest_10_1 inFieldRequest,
									const void *inObjDataPtr,
									void *outFieldData )
{
	Boolean			result = false;
	CMailSpoolData_10_1	*aMailSpoolDataPtr = (CMailSpoolData_10_1 *) inObjDataPtr;
	CMailSpool_10_1		*aTempObject	= NULL;
	ObjID			*anObjIDPtr = (ObjID *) outFieldData;

	switch ( inFieldRequest )
	{
		case kSetObjID_10_1:
			if (aMailSpoolDataPtr != NULL)
			{
				aMailSpoolDataPtr->fMailSpoolID = *anObjIDPtr;
			}
			break;

		case k2ndIDRequest_10_1:
			if ( aMailSpoolDataPtr != NULL )
			{
				if ( aMailSpoolDataPtr->fAccountID != 0 )
				{
					switch ( aMailSpoolDataPtr->fSpoolType )
					{
						case CMailSpool_10_1::kPOP3Spool:
						case CMailSpool_10_1::kIMAP4InBoxSpool:
						case CMailSpool_10_1::kIMAP4Spool:
							*anObjIDPtr = aMailSpoolDataPtr->fAccountID;
							result = true;
							break;
					}
				}
			}
			break;

		case kObjectPINGRequest_10_1:
			// cause the objects constructor to get called, so we force a check of
			// the struct alignment...
			aTempObject = new CMailSpool_10_1;
			delete aTempObject;
			break;

		case k2ndIDTargetChk_10_1:
			result = true;
			break;
			
		case kStringNameRequest_10_1:
		default:
			result = false;
			break;
	}

	return( result );

} // GetSetFields


//--------------------------------------------------------------------------------------------------
//	* GetMyID
//
//--------------------------------------------------------------------------------------------------

ObjID CMailSpool_10_1::GetObjectID	( void )
{
	return (this->GetMailSpoolID());
}

//--------------------------------------------------------------------------------------------------
//	 Done
//
//--------------------------------------------------------------------------------------------------

void CMailSpool_10_1::Done ( CMailSpool_10_1* &inPtr )
{
	CDBBaseObject_10_1 *aDBObject = (CDBBaseObject_10_1 *) inPtr;
	aDBObject->Done(aDBObject);

	inPtr = (CMailSpool_10_1 *)aDBObject;

}

//--------------------------------------------------------------------------------------------------
//	* FindByID
//
//--------------------------------------------------------------------------------------------------

CDBBaseObject_10_1 * CMailSpool_10_1::ObjectAllocNew	( void )
{
	return new CMailSpool_10_1;
}

CMailSpool_10_1* CMailSpool_10_1::FindByID ( const ObjID inObjectID )
{
	return (CMailSpool_10_1 *) CDBMailBaseObject_10_1::MailUniversalFindByID(	inObjectID,
														CMailSpool_10_1::GetObjTypeConstant(),
														CMailSpool_10_1::GetObjVersConstant(),
														CMailSpool_10_1::GetObjSizeConstant(),
														CMailSpool_10_1::ObjectAllocNew		);
} // FindByID


//--------------------------------------------------------------------------------------------------
//	* GetMailSpoolData
//
//--------------------------------------------------------------------------------------------------

CMailSpoolData_10_1* CMailSpool_10_1::GetMailSpoolData ( void )
{
	CMailSpoolData_10_1* result = NULL;
	if ( this != NULL )
	{
		result = &( this->fMailSpoolData );
	}

	return( result );
} // GetMailSpoolData



//--------------------------------------------------------------------------------------------------
//	* FindSystemSpool
//
//--------------------------------------------------------------------------------------------------

CMailSpool_10_1* CMailSpool_10_1::FindSystemSpool ( uInt32 inSystemSpoolType )
{
	try
	{
		CMailSpool_10_1* theMailSpool = NULL;
		ObjID		theSpoolID = 0;

		// xxx change this to a search...
		switch ( inSystemSpoolType )
		{
			case kIncomingSpool:
				if ( gRootObj_10_1 != NULL )
				{
					theSpoolID = gRootObj_10_1->GetSysSpoolID( inSystemSpoolType );
				}
				break;
			default:
				break;
		}

		if ( theSpoolID != 0 )
		{
			theMailSpool = FindByID( theSpoolID );
		}
		return( theMailSpool );
	}
	catch ( ExceptionCode err )
	{
		return( NULL );
	}
} // FindSystemSpool



//--------------------------------------------------------------------------------------------------
//	* FindByNameParentID
//
//--------------------------------------------------------------------------------------------------

CMailSpool_10_1* CMailSpool_10_1::FindByNameParentID ( char *inName,
											 ObjID inParentID,
											 ObjID inAccountID,
											 Boolean inCaseSensitive )
{
	Boolean			success		= false;
	OSErr			result		= kNoErr;
	ObjID			objID		= 0;
	CMailSpool_10_1	   *mailSpool	= nil;
	SDBIterator_10_1		iterator(gDB_10_1);

	result = gDB_10_1->CreateIterator( kMailSpoolSignature_10_1, &iterator, inAccountID );
	if ( result == kNoErr )
	{
		while ( !success && (gDB_10_1->NextObject( &iterator, objID ) == kNoErr) )
		{
			mailSpool = CMailSpool_10_1::FindByID( objID );
			if ( mailSpool != nil )
			{
				if ( mailSpool->GetParentID() == inParentID )
				{
					if ( inCaseSensitive == true )
					{
						success = (::strcmp( mailSpool->GetMailSpoolName(), inName ) == 0);
					}
					else
					{
						success = (CUtils::Stricmp( mailSpool->GetMailSpoolName(), inName ) == 0);
					}
				}

				if ( success == false )
				{
					mailSpool->Done( mailSpool );
				}
			}
		}
	}
	result = gDB_10_1->ReleaseIterator( &iterator );

	return( mailSpool );

} // FindByNameParentID






//--------------------------------------------------------------------------------------------------
//	* FindByName
//
//--------------------------------------------------------------------------------------------------

CMailSpool_10_1* CMailSpool_10_1::FindSharedByName ( char *inName, Boolean inCaseSensitive )
{
	Boolean			success		= false;
	OSErr			result		= kNoErr;
	ObjID			objID		= 0;
	CMailSpool_10_1	   *mailSpool	= nil;
	SDBIterator_10_1		iterator(gDB_10_1);

	result = gDB_10_1->CreateIterator( kMailSpoolSignature_10_1, &iterator );
	if ( result == kNoErr )
	{
		while ( !success && (gDB_10_1->NextObject( &iterator, objID ) == kNoErr) )
		{
			mailSpool = CMailSpool_10_1::FindByID( objID );
			if ( mailSpool != nil )
			{
				if ( (mailSpool->GetParentID() == kSharedParent) && 
					 (mailSpool->GetAccountID() == kSharedAccountID) )
				{
					if ( inCaseSensitive == true )
					{
						success = (::strcmp( mailSpool->GetMailSpoolName(), inName ) == 0);
					}
					else
					{
						success = (CUtils::Stricmp( mailSpool->GetMailSpoolName(), inName ) == 0);
					}
				}

				if ( success == false )
				{
					mailSpool->Done( mailSpool );
				}
			}
		}
	}
	result = gDB_10_1->ReleaseIterator( &iterator );

	return( mailSpool );

} // FindByName



//--------------------------------------------------------------------------------------------------
//	* Create
//
//--------------------------------------------------------------------------------------------------

CMailSpool_10_1* CMailSpool_10_1::Create ( uInt32		 inMailSpoolType,	// spool type
								 const char *inMailSpoolName,	// spool name
								 ObjID		 inAccountID,		// user account ID
								 ObjID		 inParentID )
{
	CMailSpool_10_1	   *spoolObj	= new CMailSpool_10_1( inAccountID, inMailSpoolType );		// creates a reference
	OSErr			result		= kNoErr;
	ObjID			aNewID		= 0;
	const char*		theType		= NULL;

	try
	{
		ThrowIfMemFail_( spoolObj );

		(gDB_10_1->GetBaseObjectCachePtr())->LockTheCache( CMailSpool_10_1::GetObjTypeConstant() );

		result = gDB_10_1->CreateObj( kMailSpoolSignature_10_1, aNewID, spoolObj->GetMailSpoolData() );
		if ( result == CMailDatabase_10_1::kDBNoErr )
		{
			spoolObj->Use();
			spoolObj->SetMailSpoolName( inMailSpoolName );
			spoolObj->SetParentID( inParentID );

			switch ( inMailSpoolType )
			{
				case kPOP3Spool:
					theType = "POP3";
					spoolObj->SetFlags( kSubscribedFlag );
					break;

				case kIMAP4InBoxSpool:
					theType = "IMAP4 Inbox";
					spoolObj->SetFlags( kSubscribedFlag );
					break;

				case kIMAP4Spool:
					theType = "IMAP4 Mailbox";
					spoolObj->SetFlags( 0 );
					break;

				case kIncomingSpool:
					theType = "Incoming";
					break;

				case kHostSpool:
					theType = "Host";
					break;

				case kSharedSpool:
					theType = "Shared";
					break;

				case kSystemSpool:
					theType = "System";
					break;

				case kUnknownSpool:
				default:
					theType = "Unknown";
					break;
			}

			spoolObj->SetDirty();
		}
		else
		{
			delete spoolObj;
			spoolObj = NULL;
		}

		// Set UID validity
		spoolObj->SetUIDValidity( spoolObj->GetMailSpoolID() | ::time( nil ) );

		(gDB_10_1->GetBaseObjectCachePtr())->UnLockTheCache(CMailSpool_10_1::GetObjTypeConstant());

		if ( spoolObj != NULL )
		{
			// Display in the Log
		}
	}

	catch ( ExceptionCode err )
	{
	}

	return( spoolObj );

} // Create



//--------------------------------------------------------------------------------------------------
//	* Delete
//
//--------------------------------------------------------------------------------------------------

Boolean CMailSpool_10_1::Delete ( CMailSpool_10_1 *inMailSpool )
{
	Boolean deleted = false;
	OSErr	result;

	try
	{
		if ( inMailSpool != NULL )
		{
			(gDB_10_1->GetBaseObjectCachePtr())->LockTheCache(CMailSpool_10_1::GetObjTypeConstant());

			inMailSpool->DeleteAllEnvelopeInfos();			// first delete all of the envelope infos
			inMailSpool->DeleteAllSharedSpools();			// next, delete any shared spools
			inMailSpool->RemoveGroupSharedSpools();			// next, delete this spool's shared reference to any group

			result = gDB_10_1->RemoveObj( kMailSpoolSignature_10_1, inMailSpool->GetMailSpoolID() );				// then remove the mail spool from the db
			deleted = ( result == kNoErr );
			if ( deleted )
			{
				inMailSpool->fMailSpoolData.fMailSpoolID = 0;
			}
			
			(gDB_10_1->GetBaseObjectCachePtr())->UnLockTheCache(CMailSpool_10_1::GetObjTypeConstant());
		}
	}

	catch ( ExceptionCode err )
	{
		(gDB_10_1->GetBaseObjectCachePtr())->UnLockTheCache(CMailSpool_10_1::GetObjTypeConstant());
	}

	return( deleted );

} // Delete



//--------------------------------------------------------------------------------------------------
//	* Count
//
//--------------------------------------------------------------------------------------------------

uInt32 CMailSpool_10_1::Count ( void )
{
	OSErr	result;
	uInt32	aCount = 0;

	if ( gDB_10_1 != NULL )
	{
		result = gDB_10_1->GetObjectCount( kMailSpoolSignature_10_1, aCount );
	}

	return( aCount );
} // Count



//--------------------------------------------------------------------------------------------------
//	* VerifyAll
//
//--------------------------------------------------------------------------------------------------

void CMailSpool_10_1::VerifyAll( void )
{
} // VerifyAll

#pragma mark -

//--------------------------------------------------------------------------------------------------
//	* CMailSpool_10_1
//
//--------------------------------------------------------------------------------------------------

CMailSpool_10_1::CMailSpool_10_1 ( ObjID inAccountID, uInt32 inMailSpoolType ) :
	CDBMailBaseObject_10_1(	&fMailSpoolData.fDBHeader,
				&fMailSpoolData.fDBFooter,
				&fMailSpoolData,
				CMailSpool_10_1::GetObjTypeConstant(),
				CMailSpool_10_1::GetObjVersConstant(),
				CMailSpool_10_1::GetObjSizeConstant() )

{
	fPopLock		= false;
	fRefCount		= 0;
	fSessionStamp	= 0;
	fChangeFlag		= 0;

	fMailSpoolData.fMailSpoolID		= 0;	// this is us (denormalized)
	fMailSpoolData.fParentID		= 0;	// this is our parent (or kRootParent if we are at root)
	fMailSpoolData.fAccountID		= 0;	// this is the account that owns us
	fMailSpoolData.fSpoolType		= 0;
	fMailSpoolData.fSpoolCount		= 0;
	fMailSpoolData.fSpoolSize		= 0;
	fMailSpoolData.fSharedFlags		= 0;
	fMailSpoolData.fLastEnvIDPosted	= 0;	// this is used for duplicate supression, prevents us from having
	fMailSpoolData.fRecentCount		= 0;
	fMailSpoolData.fDeletedCount	= 0;
	fMailSpoolData.fUnseenCount		= 0;
	fMailSpoolData.fRecentMark		= 0;
	fMailSpoolData.fNextUID			= 1;
	fMailSpoolData.fFlags			= 0;
	fMailSpoolData.fACLHeadID		= 0;

	fMailSpoolData.fUIDValidity		= 0;
	fMailSpoolData.fReserved2		= kReservedConst;

	::memset(fMailSpoolData.fSpoolName, 0, sizeof(fMailSpoolData.fSpoolName));
	fMailSpoolData.fAccountID = inAccountID;
	fMailSpoolData.fSpoolType = inMailSpoolType;

	this->ChkCompilerStructAlignment();
} // CMailSpool_10_1



//--------------------------------------------------------------------------------------------------
//	* ~CMailSpool_10_1
//
//--------------------------------------------------------------------------------------------------

CMailSpool_10_1::~CMailSpool_10_1 ( void )
{
} // ~CMailSpool_10_1

#pragma mark -



//--------------------------------------------------------------------------------------------------
//	* SetDirty
//
//--------------------------------------------------------------------------------------------------

void CMailSpool_10_1::SetDirty	( void )
{
	if ( ( this != NULL ) && ( this->GetMailSpoolID() != 0 ) )
	{
		this->setDirty();
	}
} // SetDirty



//--------------------------------------------------------------------------------------------------
//	* GetMailSpoolID
//
//--------------------------------------------------------------------------------------------------

ObjID CMailSpool_10_1::GetMailSpoolID ( void )
{
	return( fMailSpoolData.fMailSpoolID );
} // GetMailSpoolID



//--------------------------------------------------------------------------------------------------
//	* GetMailSpoolID
//
//--------------------------------------------------------------------------------------------------

void CMailSpool_10_1::SetMailSpoolID ( ObjID inSpoolID )
{
	if ( fMailSpoolData.fMailSpoolID != inSpoolID )
	{
		fMailSpoolData.fMailSpoolID = inSpoolID;
		this->SetDirty();
	}
} // GetMailSpoolID



//--------------------------------------------------------------------------------------------------
//	* GetParentID
//
//--------------------------------------------------------------------------------------------------

ObjID CMailSpool_10_1::GetParentID ( void )
{
	return( fMailSpoolData.fParentID );
} // GetParentID



//--------------------------------------------------------------------------------------------------
//	* SetParentID
//
//--------------------------------------------------------------------------------------------------

void CMailSpool_10_1::SetParentID ( ObjID inParentID )
{
	if ( fMailSpoolData.fParentID != inParentID )
	{
		fMailSpoolData.fParentID = inParentID;
		this->SetDirty();
	}
} // SetParentID



//--------------------------------------------------------------------------------------------------
//	* GetAccountID
//
//--------------------------------------------------------------------------------------------------

ObjID CMailSpool_10_1::GetAccountID ( void )
{
	return( fMailSpoolData.fAccountID );
} // GetAccountID



//--------------------------------------------------------------------------------------------------
//	* SetAccountID
//
//--------------------------------------------------------------------------------------------------

void CMailSpool_10_1::SetAccountID ( ObjID inAccountID )
{
	// the account ID is used as a CMailDatabase 2nd-ID object.  We need to flush
	// this through to the mail db immediately so that any iteration that is
	// going on will reflect the proper list iteration...
	// if you don't understand why this is important you don't understand the
	// Mail server's DB & our caching code and you shouldn't be changing it.
	
	if ( fMailSpoolData.fAccountID != inAccountID )
	{
		(gDB_10_1->GetBaseObjectCachePtr())->LockTheCache(CMailSpool_10_1::GetObjTypeConstant());

		fMailSpoolData.fAccountID = inAccountID;
		this->SetDirty();
		this->setDirty(true);	// call the CDBObject base class function, which will force a
								// write through to the Mail DB

		(gDB_10_1->GetBaseObjectCachePtr())->UnLockTheCache(CMailSpool_10_1::GetObjTypeConstant());
	}
} // SetAccountID



//--------------------------------------------------------------------------------------------------
//	* GetLastEnvIDPosted
//
//--------------------------------------------------------------------------------------------------

ObjID CMailSpool_10_1::GetLastEnvIDPosted ( void )
{
	return( fMailSpoolData.fLastEnvIDPosted );
} // GetLastEnvIDPosted



//--------------------------------------------------------------------------------------------------
//	* SetLastEnvIDPosted
//
//--------------------------------------------------------------------------------------------------

void CMailSpool_10_1::SetLastEnvIDPosted ( ObjID inEnvelopeID )
{
	if ( fMailSpoolData.fLastEnvIDPosted != inEnvelopeID )
	{
		fMailSpoolData.fLastEnvIDPosted = inEnvelopeID;
		this->SetDirty();
	}
} // SetLastEnvIDPosted


//--------------------------------------------------------------------------------------------------
//	* GetUIDValidity
//
//--------------------------------------------------------------------------------------------------

uInt32 CMailSpool_10_1::GetUIDValidity ( void )
{
	return( fMailSpoolData.fUIDValidity );
} // GetUIDValidity



//--------------------------------------------------------------------------------------------------
//	* SetUIDValidity
//
//--------------------------------------------------------------------------------------------------

void CMailSpool_10_1::SetUIDValidity ( uInt32 inUIDValidity )
{
	if ( fMailSpoolData.fUIDValidity != inUIDValidity )
	{
		fMailSpoolData.fUIDValidity = inUIDValidity;
		this->SetDirty();
	}
} // SetUIDValidity


#pragma mark -



//--------------------------------------------------------------------------------------------------
//	* GetMailSpoolType
//
//--------------------------------------------------------------------------------------------------

OSType CMailSpool_10_1::GetMailSpoolType ( void )
{
	return( fMailSpoolData.fSpoolType );
} // GetMailSpoolType



//--------------------------------------------------------------------------------------------------
//	* SetMailSpoolType
//
//--------------------------------------------------------------------------------------------------

void CMailSpool_10_1::SetMailSpoolType ( OSType inType )
{
	if ( fMailSpoolData.fSpoolType != inType )
	{
		fMailSpoolData.fSpoolType = inType;
		this->SetDirty();
	}
} // SetMailSpoolType



//--------------------------------------------------------------------------------------------------
//	* GetMailSpoolName
//
//--------------------------------------------------------------------------------------------------

const char* CMailSpool_10_1::GetMailSpoolName ( void )
{
	return( fMailSpoolData.fSpoolName );
} // GetMailSpoolName



//--------------------------------------------------------------------------------------------------
//	* SetMailSpoolName
//
//--------------------------------------------------------------------------------------------------

void CMailSpool_10_1::SetMailSpoolName ( const char* inName )
{

	if (CUtils::Stricmp(fMailSpoolData.fSpoolName, inName) != 0)
	{
		CUtils::Strncpy ( fMailSpoolData.fSpoolName, (char *) inName, kMaxSpoolNameLength_10_1 );
		this->SetDirty();
	}
} // SetMailSpoolName



//--------------------------------------------------------------------------------------------------
//	* IncrementSpoolCount
//
//--------------------------------------------------------------------------------------------------

void CMailSpool_10_1::IncrementSpoolCount ( void )
{
	if ( this != NULL )
	{
		fMailSpoolData.fSpoolCount++;
		this->SetDirty();
		
		this->ReleaseObjectLock(true);
	}
} // IncrementSpoolCount



//--------------------------------------------------------------------------------------------------
//	* DecrementSpoolCount
//
//--------------------------------------------------------------------------------------------------

void CMailSpool_10_1::DecrementSpoolCount ( void )
{

	if ( this != NULL )
	{
		if ( fMailSpoolData.fSpoolCount != 0 )
		{
			fMailSpoolData.fSpoolCount--;
			this->SetDirty();
		}
		else
		{
		}

		this->ReleaseObjectLock(true);
	}
} // DecrementSpoolCount



//--------------------------------------------------------------------------------------------------
//	* IncrementSpoolSize
//
//--------------------------------------------------------------------------------------------------

void CMailSpool_10_1::IncrementSpoolSize ( uInt32 inAmount )
{

	if ( this != NULL )
	{
		fMailSpoolData.fSpoolSize += inAmount;
		this->SetDirty();
		this->ReleaseObjectLock(true);
	}
} // IncrementSpoolSize



//--------------------------------------------------------------------------------------------------
//	* DecrementSpoolSize
//
//--------------------------------------------------------------------------------------------------

void CMailSpool_10_1::DecrementSpoolSize ( uInt32 inAmount )
{

	if ( this != NULL )
	{
		if ( inAmount <= fMailSpoolData.fSpoolSize )
		{
			fMailSpoolData.fSpoolSize -= inAmount;
			this->SetDirty();
		}
		else
		{
			// this is due to the message being posted before the 822 headers were sanitized.
			fMailSpoolData.fSpoolSize = 0;
		}
		
		this->ReleaseObjectLock(true);
	}
} // DecrementSpoolSize



//--------------------------------------------------------------------------------------------------
//	* GetSpoolCount
//
//--------------------------------------------------------------------------------------------------

uInt32 CMailSpool_10_1::GetSpoolCount ( void )
{
	return( fMailSpoolData.fSpoolCount );
} // GetSpoolCount



//--------------------------------------------------------------------------------------------------
//	* GetSpoolSize
//
//--------------------------------------------------------------------------------------------------

uInt32 CMailSpool_10_1::GetSpoolSize ( void )
{
	return( fMailSpoolData.fSpoolSize );
} // GetSpoolSize



//--------------------------------------------------------------------------------------------------
//	* CalcRecentCount
//
//--------------------------------------------------------------------------------------------------

uInt32 CMailSpool_10_1::CalcRecentCount ( ObjID inRecentMark )
{
	uInt32			count		= 0;
	SDBIterator_10_1*	iterator	= nil;
	ObjID			objID;

	try
	{
		ThrowIfNULL_( this );

		iterator = this->GetEnvelopeInfoIterator();
		ThrowIfNULL_( iterator );

		while ( gDB_10_1->NextObject( iterator, objID ) == kNoErr )
		{
			if ( objID >= inRecentMark )
			{
				count++;
			}
			else
			{
				break;
			}
		}
	}
	catch ( ExceptionCode err )
	{
	}

	if ( ( this != nil ) && ( iterator != nil ) )
	{
		this->ReleaseEnvelopeInfoIterator ( iterator );
	}

	return( count );

} // CalcRecentCount


//--------------------------------------------------------------------------------------------------
//	* GetUnseenCount
//
//--------------------------------------------------------------------------------------------------

uInt32 CMailSpool_10_1::GetUnseenCount ( void )
{
	return( fMailSpoolData.fUnseenCount );
} // GetUnseenCount


//--------------------------------------------------------------------------------------------------
//	* SetUnseenCount
//
//--------------------------------------------------------------------------------------------------

void CMailSpool_10_1::SetUnseenCount ( uInt32 inCount )
{
	if ( fMailSpoolData.fUnseenCount != inCount )
	{
		fMailSpoolData.fUnseenCount = inCount;
		this->SetDirty();
	}
} // SetUnseenCount


//--------------------------------------------------------------------------------------------------
//	* IncrementUnseenCount
//
//--------------------------------------------------------------------------------------------------

void CMailSpool_10_1::IncrementUnseenCount ( void )
{
	fMailSpoolData.fUnseenCount++;
	this->SetDirty();
} // IncrementUnseenCount


//--------------------------------------------------------------------------------------------------
//	* DecrementUnseenCount
//
//--------------------------------------------------------------------------------------------------

void CMailSpool_10_1::DecrementUnseenCount ( void )
{
	if ( fMailSpoolData.fUnseenCount >= 0 )
	{
		fMailSpoolData.fUnseenCount--;
		this->SetDirty();
	}
} // DecrementUnseenCount


//--------------------------------------------------------------------------------------------------
//	* SetTOCMark
//
//--------------------------------------------------------------------------------------------------

void CMailSpool_10_1::SetTOCMark ( ObjID inTocMark )
{
	if ( fMailSpoolData.fRecentCount != inTocMark )
	{
		fMailSpoolData.fRecentCount = inTocMark;
		this->SetDirty();
	}
} // SetTOCMark



//--------------------------------------------------------------------------------------------------
//	* GetTOCMark
//
//--------------------------------------------------------------------------------------------------

ObjID CMailSpool_10_1::GetTOCMark ( void )
{
	return( (ObjID)fMailSpoolData.fRecentCount );
} // GetTOCMark



//--------------------------------------------------------------------------------------------------
//	* GetDeletedCount
//
//--------------------------------------------------------------------------------------------------

uInt32 CMailSpool_10_1::GetDeletedCount ( void )
{
	return( fMailSpoolData.fDeletedCount );
} // GetDeletedCount



//--------------------------------------------------------------------------------------------------
//	* SetDeletedCount
//
//--------------------------------------------------------------------------------------------------

void CMailSpool_10_1::SetDeletedCount ( uInt32 inCount )
{
	if ( this != NULL )
	{
		if ( fMailSpoolData.fDeletedCount != inCount )
		{
			if ( inCount < 0 )
			{
				fMailSpoolData.fDeletedCount = 0;
			}
			else if ( inCount > fMailSpoolData.fSpoolCount )
			{
				fMailSpoolData.fDeletedCount = fMailSpoolData.fSpoolCount;
			}
			else
			{
				fMailSpoolData.fDeletedCount = inCount;
			}
			this->SetDirty();
		}
		
		this->ReleaseObjectLock(true);
	}
} // SetDeletedCount



//--------------------------------------------------------------------------------------------------
//	* IncrementDeletedCount
//
//--------------------------------------------------------------------------------------------------

void CMailSpool_10_1::IncrementDeletedCount ( void )
{
	if ( this != NULL )
	{
		fMailSpoolData.fDeletedCount++;
		this->SetDirty();
		this->ReleaseObjectLock(true);
	}
} // IncrementDeletedCount



//--------------------------------------------------------------------------------------------------
//	* DecrementDeletedCount
//
//--------------------------------------------------------------------------------------------------

void CMailSpool_10_1::DecrementDeletedCount ( void )
{
	if ( this != NULL )
	{
		if ( fMailSpoolData.fDeletedCount > 0 )
		{
			fMailSpoolData.fDeletedCount--;
			this->SetDirty();
		}

		this->ReleaseObjectLock(true);
	}
} // DecrementDeletedCount



//--------------------------------------------------------------------------------------------------
//	* IncrementRefCount
//
//--------------------------------------------------------------------------------------------------

void CMailSpool_10_1::IncrementRefCount ( void )
{
	if ( this != NULL )
	{
		fRefCount++;
		this->ReleaseObjectLock(true);
	}
} // IncrementRefCount



//--------------------------------------------------------------------------------------------------
//	* DecrementRefCount
//
//--------------------------------------------------------------------------------------------------

void CMailSpool_10_1::DecrementRefCount ( void )
{
	if ( this != NULL )
	{
		if ( fRefCount > 0 )
		{
			fRefCount--;
		}
		this->ReleaseObjectLock(true);
	}
} // DecrementRefCount



//--------------------------------------------------------------------------------------------------
//	* GetRefCount
//
//--------------------------------------------------------------------------------------------------

sInt16 CMailSpool_10_1::GetRefCount ( void )
{
	return( fRefCount );
} // GetRefCount



//--------------------------------------------------------------------------------------------------
//	* ResetSpoolCounts
//
//--------------------------------------------------------------------------------------------------

void CMailSpool_10_1::ResetSpoolCounts ( void )
{
	ObjID			envInfoID		= 0;
	uInt32			uiNextUID		= 1;
	CEnvelopeInfo_10_1  *pEnvInfoObj		= nil;
	SDBIterator_10_1    *pIterator		= nil;

	if (  this != NULL  )
	{
		fMailSpoolData.fSpoolCount		= 0;
		fMailSpoolData.fSpoolSize		= 0;
		fMailSpoolData.fDeletedCount	= 0;

		pIterator = this->GetEnvelopeInfoIterator();
		if ( pIterator != nil )
		{
			while ( gDB_10_1->NextObject( pIterator, envInfoID ) == kNoErr )
			{
				pEnvInfoObj = CEnvelopeInfo_10_1::FindByID( envInfoID );
				if ( pEnvInfoObj != nil )
				{
					if ( pEnvInfoObj->GetUID() > uiNextUID )
					{
						uiNextUID = pEnvInfoObj->GetUID();
					}
					pEnvInfoObj->Done( pEnvInfoObj );
				}
			}

			this->ReleaseEnvelopeInfoIterator( pIterator );

			fMailSpoolData.fNextUID = uiNextUID + 1;
		}

		this->ReleaseObjectLock(true);
	}
} // ResetSpoolCounts



//--------------------------------------------------------------------------------------------------
//	* GetNextUID
//
//--------------------------------------------------------------------------------------------------

uInt32 CMailSpool_10_1::GetNextUID ( void )
{
	return( fMailSpoolData.fNextUID );
} // GetNextUID



//--------------------------------------------------------------------------------------------------
//	* SetNextUID
//
//--------------------------------------------------------------------------------------------------

void CMailSpool_10_1::SetNextUID ( uInt32 inNextUID )
{
	if ( this != NULL )
	{
		if ( fMailSpoolData.fNextUID < inNextUID )
		{
			fMailSpoolData.fNextUID = inNextUID;
			this->SetDirty();
		}

		this->ReleaseObjectLock(true);
	}
} // SetNextUID



//--------------------------------------------------------------------------------------------------
//	* GetSpoolStamp
//
//--------------------------------------------------------------------------------------------------

uInt32 CMailSpool_10_1::GetSpoolStamp ( Boolean inReset )
{
	if ( inReset == true )
	{
		SetSpoolStamp();
	}

	return( fSessionStamp );

} // GetSpoolStamp



//--------------------------------------------------------------------------------------------------
//	* SetSpoolStamp
//
//--------------------------------------------------------------------------------------------------

void CMailSpool_10_1::SetSpoolStamp ( void )
{
	fSessionStamp = ::time( nil );
} // SetSpoolStamp



//--------------------------------------------------------------------------------------------------
//	* GetChangeFlag
//
//--------------------------------------------------------------------------------------------------

uInt32 CMailSpool_10_1::GetChangeFlag ( Boolean inReset )
{
	if ( inReset == true )
	{
		SetChangeFlag();
	}

	return( fChangeFlag );

} // GetChangeFlag



//--------------------------------------------------------------------------------------------------
//	* SetChangeFlag
//
//--------------------------------------------------------------------------------------------------

void CMailSpool_10_1::SetChangeFlag ( void )
{
	fChangeFlag = ::time( nil );
} // SetChangeFlag



//--------------------------------------------------------------------------------------------------
//	* GetRecentMark
//
//--------------------------------------------------------------------------------------------------

ObjID CMailSpool_10_1::GetRecentMark ( Boolean inReset )
{
	if ( this != NULL )
	{
		ObjID	outRecentMark	= fMailSpoolData.fRecentMark;

		if ( inReset == true )
		{
			if ( fMailSpoolData.fRecentMark != gDB_10_1->GetCurrentObjID() )
			{
				fMailSpoolData.fRecentMark = gDB_10_1->GetCurrentObjID();
				this->SetDirty();
			}
		}

		this->ReleaseObjectLock(true);
		return( outRecentMark );
	}
	
	return (0);
} // GetRecentMark



//--------------------------------------------------------------------------------------------------
//	* SetFlags
//
//--------------------------------------------------------------------------------------------------

void CMailSpool_10_1::SetFlags ( uInt32 inFlags )
{
	if ( this != NULL )
	{
		fMailSpoolData.fFlags = inFlags;
		this->SetDirty();
		this->ReleaseObjectLock(true);
	}
} // SetFlags



//--------------------------------------------------------------------------------------------------
//	* GetFlags
//
//--------------------------------------------------------------------------------------------------

uInt32 CMailSpool_10_1::GetFlags ( void )
{
	return( fMailSpoolData.fFlags );
} // GetFlags



//--------------------------------------------------------------------------------------------------
//	* VerifyData
//
//--------------------------------------------------------------------------------------------------

void CMailSpool_10_1::VerifyData ( void )
{
} // VerifyData

#pragma mark -



//--------------------------------------------------------------------------------------------------
//	* Post
//
//--------------------------------------------------------------------------------------------------

Boolean CMailSpool_10_1::Post ( ObjID inEnvelopeID, Boolean inDoSuppress, ObjID &outEnvInfoID )
{
	uInt32			uiNextUID		= 0;
	CEnvelopeInfo_10_1  *pEnvInfoObj		= nil;
	CEnvelope_10_1	   *pEnvObj			= nil;

	try
	{
		if (  this != NULL  )
		{
			if ( inDoSuppress == true )
			{
				// Check to see if it already exists in this spool, suppress duplicates here( POP3 only )
				if ( inEnvelopeID == this->GetLastEnvIDPosted() )
				{
					this->ReleaseObjectLock(true);
					return( true );
				}

				this->SetLastEnvIDPosted( inEnvelopeID );
			}

			// Next find the envelope
			pEnvObj = CEnvelope_10_1::FindByID( inEnvelopeID );
			ThrowIfNULL_( pEnvObj );

			// Create a new CEnvelopeInfo_10_1 as a reference to this envelope
			pEnvInfoObj = CEnvelopeInfo_10_1::Create( this->GetMailSpoolID(), inEnvelopeID, pEnvObj->GetMessageSize(false) );
			ThrowIfNULL_( pEnvInfoObj );

			// Update our cached values
			IncrementSpoolCount();									//	fSpoolCount++
			IncrementSpoolSize( pEnvObj->GetMessageSize( false ) );	//	fSpoolSize += pEnvObj->GetMessageSize()
			IncrementUnseenCount();									//	fUnseenCount++
																	//	this->SetDirty();

			if ( this->GetMailSpoolType() == kHostSpool )
			{
				pEnvObj->AddReference( CEnvelope_10_1::kHostReference );
			}

			// This now affects all spools because of the Admin port
			if ( pEnvObj->GetViaCode() != CEnvelope_10_1::kViaIMAP )
			{
				pEnvInfoObj->SetFlags( pEnvInfoObj->GetFlags() );
			}

			uiNextUID = this->GetNextUID();

			pEnvInfoObj->SetUID( uiNextUID );
			this->SetNextUID( uiNextUID + 1 );

			outEnvInfoID = pEnvInfoObj->GetEnvelopeInfoID();

			// Update envelope's spool reference count
			pEnvObj->AddReference( CEnvelope_10_1::kSpoolReference );

			pEnvObj->Done( pEnvObj );
			pEnvInfoObj->Done( pEnvInfoObj );

			this->SetDirty();

			this->ReleaseObjectLock(true);
			return( true );
		}
	}

	catch ( ExceptionCode err )
	{
		if ( pEnvObj != nil )
		{
			pEnvObj->Done( pEnvObj );
			pEnvObj = nil;
		}

		if ( pEnvInfoObj != nil )
		{
			pEnvInfoObj->Done( pEnvInfoObj );
			pEnvInfoObj = nil;
		}

		this->ReleaseObjectLock(true);
		return( false );
	}
	
	return (false);
} // Post



//--------------------------------------------------------------------------------------------------
//	* Remove
//
//--------------------------------------------------------------------------------------------------

Boolean CMailSpool_10_1::Remove ( CEnvelopeInfo_10_1 *inEnvInfo )
{
	CEnvelopeInfo_10_1*	envInfoObj	= NULL;
	CEnvelope_10_1*		envObj		= NULL;
	CMailSpool_10_1*		outSpoolObj	= NULL;


	try
	{
		if ( this != NULL )
		{
			envInfoObj = inEnvInfo;

			if ( envInfoObj == NULL )	// it wasn't found, this is an error
			{
				this->ReleaseObjectLock(true);
				return( false );
			}

			envInfoObj->Use();

			if ( inEnvInfo->GetEnvelopeID() == this->GetLastEnvIDPosted() )	// hmmm, we should clear the lastID Posted if that's the actual message we're deleting.
			{
				this->SetLastEnvIDPosted( 0 );
			}

			// Next find the envelope
			envObj = CEnvelope_10_1::FindByID( inEnvInfo->GetEnvelopeID() );

			if (envObj != NULL)
			{
				if ( this->GetMailSpoolType() == kHostSpool )
				{
					envObj->RemoveReference( CEnvelope_10_1::kHostReference );
				}

				// Update envelope's reference count
				envObj->RemoveReference( CEnvelope_10_1::kSpoolReference );
				DecrementSpoolSize( envObj->GetMessageSize(false) );	//	fMailSpoolData.fSpoolSize -= envObj->GetMessageSize();
																		//	this->SetDirty();
				envObj->Done( envObj );
			}
			else
			{
				DecrementSpoolSize( envInfoObj->GetMessageSize(false) );	//	fMailSpoolData.fSpoolSize -= envObj->GetMessageSize();
																			//	this->SetDirty();
			}

			// Update our cached values
			DecrementSpoolCount();									//	fMailSpoolData.fSpoolCount--;

			if ( envInfoObj->GetFlags() & CEnvelopeInfo_10_1::kIMAP4Deleted )
			{
				this->DecrementDeletedCount();
			}

			if ( !(envInfoObj->GetFlags() & CEnvelopeInfo_10_1::kIMAP4Seen) )
			{
				this->DecrementUnseenCount();
			}

			// Now remove the envelope info reference from the database
			CEnvelopeInfo_10_1::Delete( envInfoObj );
			envInfoObj->Done( envInfoObj );

			this->SetDirty();
			this->ReleaseObjectLock( true );

			return( true );
		}
	}

	catch ( ExceptionCode err )
	{
		if ( outSpoolObj != nil )
		{
			outSpoolObj->Done( outSpoolObj );
			outSpoolObj = nil;
		}

		if ( envObj != nil )
		{
			envObj->Done( envObj );
			envObj = nil;
		}

		if ( envInfoObj != nil )
		{
			envInfoObj->Done( envInfoObj );
			envInfoObj = nil;
		}
		
		this->ReleaseObjectLock(true);
		return( false );
	}
	
	return (false);
} // Remove

#pragma mark -



//--------------------------------------------------------------------------------------------------
//	* GetEnvelopeInfoIterator
//
//--------------------------------------------------------------------------------------------------

SDBIterator_10_1* CMailSpool_10_1::GetEnvelopeInfoIterator ( void )
{
	OSErr	result;
	SDBIterator_10_1	*aSDBIterator = new SDBIterator_10_1(gDB_10_1);

	if ( aSDBIterator != NULL )
	{
		result = gDB_10_1->CreateIterator( kEnvelopeInfoSignature_10_1, aSDBIterator, this->GetMailSpoolID() );
		if ( result != kNoErr )
		{
			delete aSDBIterator;
			aSDBIterator = NULL;
		}
	}

	return( aSDBIterator );
} // GetEnvelopeInfoIterator



//--------------------------------------------------------------------------------------------------
//	* ReleaseEnvelopeInfoIterator
//
//--------------------------------------------------------------------------------------------------

void CMailSpool_10_1::ReleaseEnvelopeInfoIterator ( SDBIterator_10_1* &inIterator )
{
	OSErr aResult = kNoErr;
	if ( inIterator != NULL )
	{
		aResult = gDB_10_1->ReleaseIterator( inIterator );
		if (aResult != kNoErr)
		{
		}

		delete inIterator;
		inIterator = NULL;
	}
} // ReleaseEnvelopeInfoIterator



//--------------------------------------------------------------------------------------------------
//	* DeleteAllEnvelopeInfos
//
//--------------------------------------------------------------------------------------------------

void CMailSpool_10_1::DeleteAllEnvelopeInfos ( void )
{
	SDBIterator_10_1*	theIterator = NULL;
	CEnvelopeInfo_10_1	*aEnvInfo = NULL;
	Boolean			successful = false;
	ObjID			anEnvInfoID;

	try
	{
		ThrowIfNULL_( this );

		theIterator = this->GetEnvelopeInfoIterator();
		ThrowIfNULL_( theIterator );

		while ( gDB_10_1->GetCurObject( theIterator, anEnvInfoID ) == kNoErr )
		{
			aEnvInfo = CEnvelopeInfo_10_1::FindByID(anEnvInfoID);
			if (aEnvInfo != NULL)
			{
				this->Remove(aEnvInfo);
				aEnvInfo->Done(aEnvInfo);
			}
		}

	}
	catch ( ExceptionCode err )
	{
	}

	if ( ( this != NULL ) && ( theIterator != NULL ) )
	{
		this->ReleaseEnvelopeInfoIterator ( theIterator );
	}
} // DeleteAllEnvelopeInfos



//--------------------------------------------------------------------------------------------------
//	* DeleteAllSharedSpools
//
//--------------------------------------------------------------------------------------------------

void CMailSpool_10_1::DeleteAllSharedSpools ( void )
{
} // DeleteAllSharedSpools



//--------------------------------------------------------------------------------------------------
//	* RemoveGroupSharedSpools
//
//--------------------------------------------------------------------------------------------------

void CMailSpool_10_1::RemoveGroupSharedSpools ( void )
{
} // RemoveGroupSharedSpools



//--------------------------------------------------------------------------------------------------
//	* MoveEnvelopes
//
//		- Move emvelope infos from this spool to the target spool passed in
//
//--------------------------------------------------------------------------------------------------

void CMailSpool_10_1::MoveEnvelopes ( CMailSpool_10_1 *inTargetSpool )
{
	SDBIterator_10_1	   *iterator	= nil;
	Boolean			successful	= false;
	uInt32			uiNextUID	= 0;
	ObjID			envInfoID	= 0;
	ObjID			targetID	= inTargetSpool->GetMailSpoolID();
	CEnvelopeInfo_10_1  *pEnvInfoObj	= nil;

	try
	{
		iterator = this->GetEnvelopeInfoIterator();
		ThrowIfNULL_( iterator );

		gDB_10_1->ResetIterator( iterator, envInfoID );

		while ( gDB_10_1->GetCurObject( iterator, envInfoID ) == kNoErr )
		{
			pEnvInfoObj = CEnvelopeInfo_10_1::FindByID( envInfoID );
			if ( pEnvInfoObj != nil )
			{
				pEnvInfoObj->SetMailSpoolID( targetID );

				this->DecrementSpoolSize( pEnvInfoObj->GetMsgSize() );
				inTargetSpool->IncrementSpoolSize( pEnvInfoObj->GetMsgSize() );

				this->DecrementSpoolCount();
				inTargetSpool->IncrementSpoolCount();

				// If deleted
				if ( (pEnvInfoObj->GetFlags() & CEnvelopeInfo_10_1::kIMAP4Deleted) != 0 )
				{
					this->DecrementDeletedCount();
					inTargetSpool->IncrementDeletedCount();
				}

				// If not seen
				if ( !(pEnvInfoObj->GetFlags() & CEnvelopeInfo_10_1::kIMAP4Seen) )
				{
					this->DecrementUnseenCount();
					inTargetSpool->IncrementUnseenCount();
				}

				uiNextUID = inTargetSpool->GetNextUID();

				pEnvInfoObj->SetUID( uiNextUID );
				inTargetSpool->SetNextUID( uiNextUID + 1 );

				gDB_10_1->ResetIterator( iterator, envInfoID );

				pEnvInfoObj->Done( pEnvInfoObj );
			}
		}
	}

	catch ( ExceptionCode err )
	{
	}

	if ( ( this != NULL ) && ( iterator != NULL ) )
	{
		this->ReleaseEnvelopeInfoIterator( iterator );
	}
} // MoveEnvelopes



//--------------------------------------------------------------------------------------------------
//	* CopyEnvelopInfos
//
//		- copy emvelope infos from this spool to the target spool passed in
//
//--------------------------------------------------------------------------------------------------

void CMailSpool_10_1::CopyEnvelopInfos ( CMailSpool_10_1 *inTargetSpool )
{
	ObjID			envInfoID	= 0;
	ObjID			notUsed		= 0;
	SDBIterator_10_1	   *iterator	= nil;
	CEnvelopeInfo_10_1  *envInfoObj	= nil;

	try
	{
		iterator = this->GetEnvelopeInfoIterator();
		ThrowIfNULL_( iterator );

		while ( gDB_10_1->NextObject( iterator, envInfoID ) == kNoErr )
		{
			envInfoObj = CEnvelopeInfo_10_1::FindByID( envInfoID );
			if ( envInfoObj != nil )
			{
				inTargetSpool->Post( envInfoObj->GetEnvelopeID(), false, notUsed );
				envInfoObj->Done( envInfoObj );
			}
		}
	}

	catch ( ExceptionCode err )
	{
	}

	if ( (this != nil ) && (iterator != nil) )
	{
		this->ReleaseEnvelopeInfoIterator( iterator );
	}
} // CopyEnvelopInfos



#pragma mark -
#pragma mark * ACL

//--------------------------------------------------------------------------------------------------
//	* GetACLHeadID
//
//--------------------------------------------------------------------------------------------------

uInt32 CMailSpool_10_1::GetACLHeadID ( void )
{
	return( fMailSpoolData.fACLHeadID );
} // GetACLHeadID


//--------------------------------------------------------------------------------------------------
//	* SetACLHeadID
//
//--------------------------------------------------------------------------------------------------

void CMailSpool_10_1::SetACLHeadID ( uInt32 inNewValue )
{
	if ( fMailSpoolData.fACLHeadID != inNewValue )
	{
		fMailSpoolData.fACLHeadID = inNewValue;
		this->SetDirty();
	}
} // SetACLHeadID


//--------------------------------------------------------------------------------------------------
//	* GetSharedID
//
//--------------------------------------------------------------------------------------------------

uInt32 CMailSpool_10_1::GetSharedID ( void )
{
	return( fMailSpoolData.fSharedID );
} // GetSharedID


//--------------------------------------------------------------------------------------------------
//	* SetSharedID
//
//--------------------------------------------------------------------------------------------------

void CMailSpool_10_1::SetSharedID ( uInt32 inNewValue )
{
	if ( fMailSpoolData.fSharedID != inNewValue )
	{
		fMailSpoolData.fSharedID = inNewValue;
		this->SetDirty();
	}
} // SetSharedID


//--------------------------------------------------------------------------------------------------
//	* GetACLRights
//
//--------------------------------------------------------------------------------------------------

uInt32 CMailSpool_10_1::GetACLRights ( void )
{
	uInt32	result = 0;

	if ( fMailSpoolData.fFlags & kSharedFlag )
	{
		result = fMailSpoolData.fSharedFlags;
	}
	else
	{
		result = kACLAllRights;
	}

	return( result );

} // GetACLRights



//--------------------------------------------------------------------------------------------------
//	* SetACLRights
//
//--------------------------------------------------------------------------------------------------

void CMailSpool_10_1::SetACLRights ( uInt32 inNewRights )
{
	if ( fMailSpoolData.fSharedFlags != inNewRights )
	{
		if ( !(inNewRights & kACLCreate) )
		{
			fMailSpoolData.fFlags |= kNoInferiorsFlag;
		}
		else
		{
			fMailSpoolData.fFlags &= ~kNoInferiorsFlag;
		}

		fMailSpoolData.fSharedFlags = inNewRights;
		this->SetDirty();
	}
} // SetACLRights




//--------------------------------------------------------------------------------------------------
//	* IsAdmin
//
//--------------------------------------------------------------------------------------------------

Boolean CMailSpool_10_1::IsAdmin ( void )
{
	Boolean		result = false;

	if ( !(fMailSpoolData.fFlags & kSharedFlag) )
	{
		// Always true if folder ins't shared
		result = true;
	}
	else
	{
		// Is the "Admin" right set
		if ( fMailSpoolData.fSharedFlags & kACLAdmin )
		{
			result = true;
		}
	}
	return( result );

} // IsAdmin



//--------------------------------------------------------------------------------------------------
//	* GetNextACLObj
//
//--------------------------------------------------------------------------------------------------

Boolean CMailSpool_10_1::GetNextACLObj ( char **inObjPtr, Boolean inCreate )
{
	return( true );
} // GetNextACLObj



//--------------------------------------------------------------------------------------------------
//	* DeleteACL
//
//--------------------------------------------------------------------------------------------------

Boolean CMailSpool_10_1::DeleteACL ( ObjID inUserID, ObjID inShrdSpoolID )
{
	return( true );
} // DeleteACL



//--------------------------------------------------------------------------------------------------
//	* SetACL
//
//--------------------------------------------------------------------------------------------------

Boolean CMailSpool_10_1::SetACL ( ObjID inUserID, ObjID inShrdSpoolID, uInt32 inRights )
{
	return( true );
} // SetACL



//--------------------------------------------------------------------------------------------------
//	* RemoveUser
//
//--------------------------------------------------------------------------------------------------

Boolean CMailSpool_10_1::RemoveUser ( ObjID inUserID )
{
	return( true );
} // RemoveUser



//--------------------------------------------------------------------------------------------------
//	* IsObjectInACLList
//
//--------------------------------------------------------------------------------------------------

Boolean CMailSpool_10_1::IsUserInACLList ( ObjID inUserID, char *outACLData )
{
	return( true );
} // IsObjectInACLList



//--------------------------------------------------------------------------------------------------
//	* IsSpoolInList
//
//--------------------------------------------------------------------------------------------------

Boolean CMailSpool_10_1::IsSpoolInList ( ObjID inSpoolID )
{
	return( true );
} // IsSpoolInList



//--------------------------------------------------------------------------------------------------
//	* IsObjectInSeenList
//
//--------------------------------------------------------------------------------------------------

Boolean CMailSpool_10_1::IsObjectInSeenList ( ObjID inObjID )
{
	return( true );
} // IsObjectInSeenList



//--------------------------------------------------------------------------------------------------
//	* GetACLData
//
//--------------------------------------------------------------------------------------------------

Boolean CMailSpool_10_1::GetACLData ( ObjID inUserID, char &outData )
{
	return( true );
} // GetACLData



//--------------------------------------------------------------------------------------------------
//	* GetNextSharedObj
//
//--------------------------------------------------------------------------------------------------

Boolean CMailSpool_10_1::GetNextSharedObj ( char **inObjPtr, Boolean inCreate )
{
	return( true );
} // GetNextSharedObj



//--------------------------------------------------------------------------------------------------
//	* AddToSeenList
//
//--------------------------------------------------------------------------------------------------

void CMailSpool_10_1::AddToSeenList ( ObjID inObjID )
{
} // AddToSeenList



//--------------------------------------------------------------------------------------------------
//	* RemoveFromSeenList
//
//--------------------------------------------------------------------------------------------------

void CMailSpool_10_1::RemoveFromSeenList ( ObjID inObjID )
{
} // RemoveFromSeenList




//--------------------------------------------------------------------------------------------------
//	* ClearSeenFlags
//
//--------------------------------------------------------------------------------------------------

void CMailSpool_10_1::ClearSeenFlags ( void )
{
} // RemoveFromSeenList











