/*
	File:		CMailSpool.10.1.h

	Contains:	C++ class definitions for generic mail spool objects

	Copyright:	 2003 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: CMailSpool.10.1.h,v $
		Revision 1.1  2003/04/20 23:46:10  dasenbro
		Initial check-in.
		
		
	Projector History:

	To Do:
*/


#ifndef __CMailSpool_10_1__
#define __CMailSpool_10_1__ 1

#include "CMailDatabase.10.1.h"
#include "CDBBaseObject.10.1.h"
#include "CDBMailBaseObject.10.1.h"
#include "CEnvelopeInfo.10.1.h"
#include "DatabaseTypes.h"

const uInt32 kMaxSpoolNameLength_10_1 = 255;

typedef struct
{
	StdDBObjHeader_10_1	fDBHeader;

				ObjID		fMailSpoolID;		// this is us (denormalized)
				ObjID		fParentID;			// this is our parent (or kRootParent if we are at root)
				ObjID		fAccountID;			// this is the account that owns us

	// Reserved
				uInt32		fUIDValidity;
				uInt32		fReserved2;

	// ACL
				ObjID		fACLHeadID;			// Head pointer to ACL object list
				ObjID		fSharedID;

	// MailSpool Information
				OSType		fSpoolType;
				char		fSpoolName[ kMaxSpoolNameLength_10_1 + 1 ];
	volatile	uInt32		fSpoolCount;
	volatile	uInt32		fSpoolSize;
				uInt32		fSharedFlags;		// Now used for Shared folder rights ( was fChangeCount )
	volatile	ObjID		fLastEnvIDPosted;	// this is used for duplicate supression, prevents
												// us from having to search the entire mail spool.
	// IMAP Information
	volatile	uInt32		fRecentCount;
	volatile	uInt32		fDeletedCount;
	volatile	uInt32		fUnseenCount;
	volatile	ObjID		fRecentMark;
	volatile	uInt32		fNextUID;
	volatile	uInt32		fFlags;

	StdDBObjFooter_10_1	fDBFooter;
} CMailSpoolData_10_1;


// CDBMailBaseObject Constants
const uInt32 kMailSpoolDataSize_10_1	= sizeof( CMailSpoolData_10_1 );
const uInt32 kMailSpoolVersion_10_1		= kDBCurrentVersion_10_1 + kMailSpoolDataSize_10_1;


class CMailSpool_10_1 : public CDBMailBaseObject_10_1
{
public:
	typedef enum
	{
		// Unknown Spool
		kUnknownSpool		= '--SP',

		// System Spool
		kSystemSpool		= 'SysS',
		
		// User Spools
		kPOP3Spool			= 'p3SP',	// POP3 Mailbox
		kIMAP4InBoxSpool	= 'i4SP',	// IMAP4 Inbox Spool
		kIMAP4Spool			= 'imSP',	// IMAP4 Mailbox Spool
		
		// System Spools
		kIncomingSpool		= 'inSP',	// Incoming Routing
		kHostSpool			= 'hoSP',	// Routing == TCP/SMTP, ADSP/SMTP, or UUCP

		// Shared Spools
		kSharedSpool		= 'Shrd'

	} MailSpoolType;
	
	enum
	{
		kRootParent 	 = 1,
		kSystemAccountID = 2,
		kSharedParent	 = 3,
		kSharedAccountID = 4
	};

	typedef enum
	{
		kSubscribedFlag		= 0x00000001,
		kNoSelectFlag		= 0x00000002,
		kNoInferiorsFlag	= 0x00000004,
		kDeletedFlag		= 0x00000008,
		kSharedFlag			= 0x00000010,
		kPublishedFlag		= 0x00000020
	};

	typedef enum
	{
		kACLMask		= 0x0000FFFF,
		kACLLookup		= 0x00000001,
		kACLRead		= 0x00000002,
		kACLKeepSeen	= 0x00000004,
		kACLWrite		= 0x00000008,
		kACLInsert		= 0x00000010,
		kACLPost		= 0x00000020,
		kACLCreate		= 0x00000040,
		kACLDelete		= 0x00000080,
		kACLAdmin		= 0x00000100,
		kACLAllRights	= 0x000001FF
	};

	// Static Methods
	static CMailSpool_10_1*	FindSystemSpool 	( uInt32 inSystemSpoolType );
	static CMailSpool_10_1*	FindByNameParentID	( char *inName, ObjID inParentID, ObjID inAccountID, Boolean inCaseSensitive );
	static CMailSpool_10_1*	FindSharedByName	( char *inName, Boolean inCaseSensitive );
	static CMailSpool_10_1*	Create				( uInt32 inMailSpoolType,
											  const char* inMailSpoolName,
											  ObjID inAccountID		= kSystemAccountID,
											  ObjID inParentID		= kRootParent );

	static Boolean 		Delete			( CMailSpool_10_1* inMailSpool );
	static uInt32		Count			( void );
	static void			VerifyAll		( void );
	static Boolean		GetSetFields	( const eFieldDataRequest_10_1 inFieldRequest, const void *inObjDataPtr, void *outFieldData );

	static 	CMailSpool_10_1*	FindByID			( const	ObjID	inObjectID );
	static	CDBBaseObject_10_1*	ObjectAllocNew		( void );

	static	OSType		GetObjTypeConstant	( void ) { return kMailSpoolSignature_10_1; }
	static	uInt32		GetObjVersConstant	( void ) { return kMailSpoolVersion_10_1; }
	static	uInt32		GetObjSizeConstant	( void ) { return kMailSpoolDataSize_10_1; }

	virtual	ObjID		GetObjectID			( void );

	// Construction/Destruction
				CMailSpool_10_1				( ObjID inAccountID = 0, uInt32 inMailSpoolType = kUnknownSpool );
	virtual	   ~CMailSpool_10_1				( void );

	void		Done					( CMailSpool_10_1* &inPtr );

	// Object IDs 
	ObjID		GetMailSpoolID			( void );
	void		SetMailSpoolID			( ObjID inSpoolID );

	ObjID		GetParentID				( void );
	void		SetParentID				( ObjID inParentID );

	ObjID		GetAccountID			( void );
	void		SetAccountID			( ObjID inAccountID );
	
	ObjID		GetLastEnvIDPosted		( void );
	void		SetLastEnvIDPosted		( ObjID inEnvelopeID );

	uInt32		GetUIDValidity			( void );
	void		SetUIDValidity			( uInt32 inUIDValidity );

	// MailSpool Information 
	OSType		GetMailSpoolType		( void );
	void		SetMailSpoolType		( OSType inType );
	
	const char*	GetMailSpoolName		( void );
	void		SetMailSpoolName		( const char* inName );

	void		IncrementSpoolCount		( void );
	void		DecrementSpoolCount		( void );

	uInt32		GetUnseenCount			( void );
	void		SetUnseenCount			( uInt32 inCount );

	void		IncrementUnseenCount	( void );
	void		DecrementUnseenCount	( void );

	void		IncrementSpoolSize		( uInt32 inAmount );
	void		DecrementSpoolSize		( uInt32 inAmount );

	uInt32		GetSpoolCount			( void );			// Number of CEnvelopeInfo objects
	uInt32		GetSpoolSize			( void );			// Sum of sizes of CEnvelope objects

	// IMAP getters and setters
	uInt32		CalcRecentCount			(  ObjID inRecentMark = 0xFFFFFFFF );

	uInt32		GetDeletedCount			( void );
	void		SetDeletedCount			( uInt32 inCount );
	void		IncrementDeletedCount	( void );
	void		DecrementDeletedCount	( void );

	void		ResetSpoolCounts		( void );

	void		VerifyData				( void );

	uInt32		GetNextUID				( void );
	void		SetNextUID				( uInt32 inNextUID );

	uInt32		GetSpoolStamp			( Boolean inReset = false );
	void		SetSpoolStamp			( void );

	uInt32		GetChangeFlag			( Boolean inReset = false );
	void		SetChangeFlag			( void );

	ObjID		GetRecentMark			( Boolean inReset );

	void		SetFlags				( uInt32 inFlags );
	uInt32		GetFlags				( void );

	void		SetPopLock				( Boolean inLock ) { fPopLock = inLock; };
	Boolean		GetPopLock				( void ) { return( fPopLock ); };

	void		IncrementRefCount		( void );
	void		DecrementRefCount		( void );
	sInt16		GetRefCount				( void );

	void		SetTOCMark				( ObjID inTocMark );
	ObjID		GetTOCMark				( void );

	// Posting/Removal/Moving/Copying
	Boolean 	Post					( ObjID inEnvelopeID, Boolean inDoSuppress, ObjID &outEnvInfoID );
	Boolean 	Remove					( CEnvelopeInfo_10_1	*inEnvInfo );
	void		MoveEnvelopes			( CMailSpool_10_1		*inTargetSpool );
	void		CopyEnvelopInfos		( CMailSpool_10_1		*inTargetSpool );

	// CEnvelopeInfo Iterator Methods
	SDBIterator_10_1*	GetEnvelopeInfoIterator		( void );
	void			ReleaseEnvelopeInfoIterator	( SDBIterator_10_1* &inIterator );
	void			DeleteAllEnvelopeInfos		( void );
	void			DeleteAllSharedSpools		( void );
	void			RemoveGroupSharedSpools		( void );

	CMailSpoolData_10_1*		GetMailSpoolData		( void );
	void				SetDirty				( void );

	// ACL
	uInt32			GetACLRights				( void );
	void			SetACLRights				( uInt32 inNewRights );

	Boolean			IsAdmin						( void );
	Boolean			SetACL						( ObjID inAcctID, ObjID inShrdSpoolID, uInt32 inRights );
	Boolean			DeleteACL					( ObjID inAcctID, ObjID inShrdSpoolID );
	Boolean			GetACLData					( ObjID inUserId, char &outData );
	Boolean			RemoveUser					( ObjID inUserID );

	Boolean			IsUserInACLList				( ObjID inUserID, char *outACLData );
	Boolean			IsSpoolInList				( ObjID inSpoolID );
	Boolean			IsObjectInSeenList			( ObjID inObjID );

	uInt32			GetACLHeadID				( void );
	void			SetACLHeadID				( uInt32 inNewValue );

	uInt32			GetSharedID					( void );
	void			SetSharedID					( uInt32 inNewValue );

	Boolean			GetNextACLObj				( char **inObjPtr, Boolean inCreate = false );
	Boolean			GetNextSharedObj			( char **inObjPtr, Boolean inCreate = false );

	void			AddToSeenList				( ObjID inObjID );
	void			ClearSeenFlags				( void );
	void			RemoveFromSeenList			( ObjID inObjID );

protected:

	CMailSpoolData_10_1	fMailSpoolData;

	uInt32		fSessionStamp;
	uInt32		fChangeFlag;
	sInt16		fRefCount;
	Boolean		fPopLock;
};

#endif // __CMailSpool_10_1__
