/*
	File:		CMessagePart.10.1.h

	Contains:	C++ Class definition of a Blob-based message part

	Copyright:	 2003 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: CMessagePart.10.1.h,v $
		Revision 1.1  2003/04/20 23:46:10  dasenbro
		Initial check-in.
		

	To Do:
*/


#ifndef __CMessagePart_10_1_h__
#define __CMessagePart_10_1_h__ 1

#include "CMailDatabase.10.1.h"
#include "CDBBaseObject.10.1.h"
#include "CDBMailBaseObject.10.1.h"
#include "DatabaseTypes.h"

// WARNING!!!! Many of the assumptions about the operation of the server (maximum number of connections,
// maximum write-behind cache depth, server performance, footprint, etc.) are set assuming that kMessagePartSize
// is near 8K.  If you change this value and don't understand the implications, you get what you deserve.
// If you make it bigger then the server will overestimate the "load" it can handle and most likely crash
// under stress/volume with out of memory problems....if you make it smaller the performance will tank
// upload/download, and the server will not fully utilize it's partition....don't screw with this value!!!

typedef struct
{	// NOTE: this structure should be kept in sync with the fields in the actual
	// CMessagePartData struct...
	StdDBObjHeader_10_1	fDBHeader;
	ObjID			fMessagePartID;
	ObjID			fNextMsgPartID;
	ObjID			fEnvelopeID;

	// Reserved
	uInt32			fReserved1;				// reserverd
	uInt32			fReserved2;				// reserverd

	OSType			fPartType;
	uInt32			fSequenceNumber;
	
	Boolean			fLengthIsSet;
	Boolean			fDotStuffingRequired;
	uInt32			fDataLength;
	StdDBObjFooter_10_1	fDBFooter;
} SMsgPartHeader4Calc_10_1;


const uInt32 kSlopSafety_10_1		= 12;
const uInt32 kMessagePartSize_10_1	= (kMaxIDTableSize_10_1 - kSlopSafety_10_1) - (sizeof(ObjID) + sizeof(SMsgPartHeader4Calc_10_1));


typedef struct
{
	StdDBObjHeader_10_1	fDBHeader;
	ObjID				fMessagePartID;
	ObjID				fNextMsgPartID;
	ObjID				fEnvelopeID;

	// Reserved
	uInt32				fReserved1;				// reserverd
	uInt32				fReserved2;				// reserverd

	OSType				fPartType;
	uInt32				fSequenceNumber;
	
	Boolean				fLengthIsSet;
	Boolean				fDotStuffingRequired;
	uInt32				fDataLength;
	char				fPartData[ kMessagePartSize_10_1 ];
	StdDBObjFooter_10_1	fDBFooter;
} CMessagePartData_10_1;

// CDBMailBaseObject Constants
const uInt32 kMessagePartFixedDataSize_10_1	= sizeof (CMessagePartData_10_1);	
const uInt32 kMessagePartVersion_10_1		= kDBCurrentVersion_10_1 + kMessagePartFixedDataSize_10_1;



class CMessagePart_10_1 : public CDBMailBaseObject_10_1
{
public:
	
	typedef	enum 
	{ 
		kUnknownPartType =	'--PT', 
		kHeaderPartType	 =	'hdPT',
		kDataPartType	 =	'daPT'
	} PartType;

	// Static Methods
	static CMessagePart_10_1*	Create(OSType inPartType, ObjID inEnvelopeID, uInt32 inSequenceNumber );
	static Boolean			Delete(CMessagePart_10_1* inMessagePart);
	static uInt32			Count (void);
	static Boolean			GetSetFields	(const eFieldDataRequest_10_1 inFieldRequest, const void *inObjDataPtr, void *outFieldData);

	static 	CMessagePart_10_1*	FindByID			( const	ObjID	inObjectID );
	static	CDBBaseObject_10_1*	ObjectAllocNew		( void );

	static	OSType		GetObjTypeConstant	( void ) { return kMessagePartSignature_10_1; }
	static	uInt32		GetObjVersConstant	( void ) { return kMessagePartVersion_10_1; }
	static	uInt32		GetObjSizeConstant	( void ) { return kMessagePartFixedDataSize_10_1; }
	virtual	ObjID		GetObjectID			( void );
	virtual	void		ChkCompilerStructAlignment			( void );

	// Constructor/Destructor/Initialization
				CMessagePart_10_1();
	virtual		~CMessagePart_10_1();

	void		Done				( CMessagePart_10_1* &inPtr );
	
	// NeoAccess IDs
	ObjID		GetMessagePartID(void);

	ObjID		GetNextMessagePartID(void);
	void		SetNextMessagePartID(const ObjID inMessagePartID);
		
	ObjID		GetEnvelopeID (void);
	void		SetEnvelopeID (ObjID inEnvelopeID);
	
	OSType		GetPartType(void);
	void		SetPartType(OSType inPartType);
	
	uInt32		GetSequenceNumber (void);
	void		SetSequenceNumber (uInt32 inSequenceNumber);
	
	uInt32		GetDataLength(void);					// Actual length of data in fixed-sized part
	void		SetDataLength(uInt32 inDataLength);		// Actual length of data in fixed-sized part
	
	Boolean		GetDotStuffingRequired (void);
	void		SetDotStuffingRequired (const Boolean inDoDotStuffingFlag);
	
	char*		GetPartData(void);			// Start of part data
	
	void		VerifyData(void);
	
	virtual uInt32	GetObjectLength (void);
	
	
	void		CalculateChecksum(void);

	CMessagePartData_10_1*	GetWholeMessagePartData	( void );
	void				SetDirty (void);
	
	void				SetMsgHasBeenAttached	( const Boolean inSetFlag );
	Boolean				GetMsgHasBeenAttached	( void );
	
	Boolean				fMsgHasBeenAttached;

	CMessagePartData_10_1	fMsgPartData;
};



#endif /* __CMessagePart_10_1_h__ */
