/*
	File:		CRootObject.10.1.h

	Contains:	xxx put contents here xxx

	Copyright:	 2003 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: CRootObject.10.1.h,v $
		Revision 1.1  2003/04/20 23:46:10  dasenbro
		Initial check-in.
		

	To Do:
*/


#ifndef __CRootObject_10_1_h__
#define __CRootObject_10_1_h__ 1

#include "CMailDatabase.10.1.h"
#include "CDBBaseObject.10.1.h"
#include "CDBMailBaseObject.10.1.h"
#include "DatabaseTypes.h"

typedef struct
{
	uInt32		fVersionInfoID;
} SVersionInfo_10_1;


typedef struct
{
	StdDBObjHeader_10_1	fDBHeader;

	ObjID			fRootObjID;				// 
	ObjID			fInSpoolID;				// Incoming spool ID
	ObjID			fEnvDieSpoolID;			// 
	ObjID 			fStatMgrID;				// 
	ObjID 			fHostDefltPrefsID;		// 
	ObjID 			fRejectSMTPHostID;		// Obj ID for head of SMTP reject list
	ObjID			fAnyoneACLObjID;		// Holds a list of shared folders to group or anyone
	ObjID			fActiveHost2ndID;		// Holds the ObjID of the Active Host 2nd ID list..
	ObjID  			fTextObjectID;			// Holds the ID for the current text object
	uInt32			fIndexRefNum;			// 
	SVersionInfo_10_1	fVerInfo;				// 

	// Reserved
	uInt32			fReserved1;				// reserverd
	uInt32			fReserved2;				// reserverd

	StdDBObjFooter_10_1	fDBFooter;

} CRootObjectData_10_1;

const uInt32 kCRootObjectDataSize_10_1	= ( sizeof( CRootObjectData_10_1 ) );
const uInt32 kCRootObjectVersion_10_1	= kDBCurrentVersion_10_1 + kCRootObjectDataSize_10_1;

class CRootObject_10_1 : public CDBMailBaseObject_10_1
{
public:
		CRootObject_10_1	( void );
	   ~CRootObject_10_1	( void );

	static	CRootObject_10_1*	Find				( void );
	static	CRootObject_10_1*	Create				( void );
	static  Boolean			Delete				( CRootObject_10_1 *inRootObj );
	static	Boolean			GetSetFields		( const eFieldDataRequest_10_1 inFieldRequest, const void *inObjDataPtr, void *outFieldData );

	static 	CRootObject_10_1*	FindByID			( const	ObjID	inObjectID );
	static	CDBBaseObject_10_1*	ObjectAllocNew		( void );

	static	OSType		GetObjTypeConstant		( void ) { return kMailRootSignature_10_1; }
	static	uInt32		GetObjVersConstant		( void ) { return kCRootObjectVersion_10_1; }
	static	uInt32		GetObjSizeConstant		( void ) { return kCRootObjectDataSize_10_1; }

	virtual	ObjID		GetObjectID					( void );
	virtual	void		ChkCompilerStructAlignment	( void );
		void			Done						( CRootObject_10_1* &inPtr );

	CRootObjectData_10_1*	GetRootObjectData		( void );
		void			SetDirty				( void );

		ObjID			GetRootObjID			( void );
		void			SetObjectID				( ObjID inObjID );

		ObjID			GetSysSpoolID			( const OSType inSpoolType );
		void			SetSysSpoolID			( const OSType inSpoolType, ObjID inSysSpoolID );

		ObjID			GetStatMgrID			( void );
		void			SetStatMgrID			( ObjID inStatMgrID );

		SVersionInfo_10_1*	GetVerInfoID			( void );
		void			SetVerInfoID			( SVersionInfo_10_1 *inVerInfoStruct );

		ObjID			GetHostDefltPrefsID		( void );
		void			SetHostDefltPrefsID		( ObjID inHostDefltPrefsID );
		
		ObjID			GetEnvelopeDieSpoolID	( void );
		void			SetEnvelopeDieSpoolID	( const ObjID inDieSpoolID );

		ObjID			GetAnyoneObjID			( void );
		void			SetAnyoneObjID			( ObjID inValue );

		uInt32			GetIndexRefNum			( void );
		void			SetIndexRefNum			( uInt32 inRefNum );

		uInt32			GetVersionInfo			( void );
		void			SetVersionInfo			( uInt32 inVersInfo );

		uInt32			GetActiveHost2ndID		( const Boolean inCreateFlag );
		void			SetActiveHost2ndID		( const ObjID inActiveHost2ndID );

		ObjID			GetSMTPRejectHostID		( void );
		void			SetSMTPRejectHostID		( const ObjID inHostID );

		ObjID			GetCurrTextObjID		( void );
		void			SetCurrTextObjID		( ObjID inTextObjID );

private:

	CRootObjectData_10_1		fRootObjectData;
};

extern CRootObject_10_1 *gRootObj_10_1;

#endif // __CRootObject_10_1_h__

