/*
	File:		CServerPrefs.10.1.cpp

	Contains:	C++ implementation of EnvelopeInfo pointers to Envelopes.

	Copyright:	 2003 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:
*/


#include <string.h>
#include <time.h>

#include "Database.10.1.h"
#include "CServerPrefs.10.1.h"
#include "CHostEntryPref.10.1.h"
#include "CMailDatabase.10.1.h"
#include "MailTypes.h"
#include "CGlobals.h"
#include "CString.h"
#include "COSUtils.h"
//#include "COSUtils.h"
#include "AppResources.h"
//#include "ServerPrefs.10.1.h"
//#include "CGlobals.h"


// externs -----------------------------------------------------------------

const	uInt32		kMaxMessageSize	= 10240;

CServerPrefs_10_1*	CServerPrefs_10_1::prefsObjPtr = nil;

//--------------------------------------------------------------------------------------------------
//	* GetSetFields
//
//--------------------------------------------------------------------------------------------------

Boolean	CServerPrefs_10_1::GetSetFields	( const eFieldDataRequest_10_1 inFieldRequest, const void *inObjDataPtr, void *outFieldData )
{
	Boolean				 	result			= false;
	CServerPrefsData_10_1	*theData		= (CServerPrefsData_10_1 *)inObjDataPtr;
	CServerPrefs_10_1		*aTempObject	= NULL;
	ObjID					*anObjIDPtr		= (ObjID *)outFieldData;

	switch ( inFieldRequest )
	{
		case kSetObjID_10_1:
			theData->fServerPrefsID = *anObjIDPtr;
			break;
			
		case kObjectPINGRequest_10_1:
			// cause the objects constructor to get called, so we force a check of
			// the struct alignment...
			aTempObject = new CServerPrefs_10_1;
			delete aTempObject;
			break;

		case k2ndIDTargetChk_10_1:
			// fall through...
			
		case k2ndIDRequest_10_1:
		case kStringNameRequest_10_1:
		default:
			result = false;
			break;
	}
	
	return( result );

} // GetSetFields


//--------------------------------------------------------------------------------------------------
//	* GetMyID
//
//--------------------------------------------------------------------------------------------------

ObjID CServerPrefs_10_1::GetObjectID	( void )
{
	return( fServerPrefsData.fServerPrefsID );
} // GetMyID


//--------------------------------------------------------------------------------------------------
//	 Done
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::Done ( CServerPrefs_10_1* &inPtr )
{
	CDBBaseObject_10_1 *aDBObject = (CDBBaseObject_10_1 *) inPtr;
	aDBObject->Done(aDBObject);

	inPtr = (CServerPrefs_10_1 *)aDBObject;
} // Done


//--------------------------------------------------------------------------------------------------
//	* FindByID
//
//--------------------------------------------------------------------------------------------------

CDBBaseObject_10_1 * CServerPrefs_10_1::ObjectAllocNew	( void )
{
	return new CServerPrefs_10_1;
}

CServerPrefs_10_1* CServerPrefs_10_1::FindByID ( const ObjID inObjectID )
{
	return (CServerPrefs_10_1 *) CDBMailBaseObject_10_1::MailUniversalFindByID(	inObjectID,
														CServerPrefs_10_1::GetObjTypeConstant(),
														CServerPrefs_10_1::GetObjVersConstant(),
														CServerPrefs_10_1::GetObjSizeConstant(),
														CServerPrefs_10_1::ObjectAllocNew );
} // FindByID





//--------------------------------------------------------------------------------------------------
//	* Create
//
//--------------------------------------------------------------------------------------------------

CServerPrefs_10_1* CServerPrefs_10_1::Create ( void )
{
	CServerPrefs_10_1	*theServerPrefs = new CServerPrefs_10_1;
	OSErr			result = kNoErr;
	ObjID			aNewID = 0;
	uInt32			aLogMsgBit = 0;
	
	try
	{
		ThrowIfMemFail_ ( theServerPrefs );
		(gDB_10_1->GetBaseObjectCachePtr())->LockTheCache(CServerPrefs_10_1::GetObjTypeConstant());

		result = gDB_10_1->CreateObj( CServerPrefs_10_1::GetObjTypeConstant(), aNewID, theServerPrefs->GetServerPrefsData() );

		if ( result == CMailDatabase_10_1::kDBNoErr )
		{
			theServerPrefs->Use();
			theServerPrefs->SetDirty();
//			for (aLogMsgBit = kSLStartTransLogMsgs; aLogMsgBit <= kSLEndTransLogMsgs; aLogMsgBit++)
//			{
//				theServerPrefs->ClearLogMsgBit(kAServerLogType, aLogMsgBit);
//			}
		}
		else
		{
			delete theServerPrefs;
			theServerPrefs = nil;
		}
		
		(gDB_10_1->GetBaseObjectCachePtr())->UnLockTheCache(CServerPrefs_10_1::GetObjTypeConstant());
	}
	catch ( ExceptionCode err )
	{
	}
	
	return ( theServerPrefs );
} // Create


//--------------------------------------------------------------------------------------------------
//	* Delete
//
//--------------------------------------------------------------------------------------------------

Boolean CServerPrefs_10_1::Delete ( CServerPrefs_10_1* inServerPrefs )
{
	OSErr		result;
	Boolean		deleted = false;
	
	try
	{
		if ( inServerPrefs != nil )
		{
			(gDB_10_1->GetBaseObjectCachePtr())->LockTheCache(CServerPrefs_10_1::GetObjTypeConstant());

			result = gDB_10_1->RemoveObj( CServerPrefs_10_1::GetObjTypeConstant(), inServerPrefs->GetServerPrefsID() );
			deleted = ( result == kNoErr );
			if ( deleted )
			{
				inServerPrefs->fServerPrefsData.fServerPrefsID = 0;
			}
			
			(gDB_10_1->GetBaseObjectCachePtr())->UnLockTheCache(CServerPrefs_10_1::GetObjTypeConstant());
		}
	}
	catch ( ExceptionCode err )
	{
		(gDB_10_1->GetBaseObjectCachePtr())->UnLockTheCache(CServerPrefs_10_1::GetObjTypeConstant());
	}

	return ( deleted );
} // Delete


//--------------------------------------------------------------------------------------------------
//	* Count
//
//--------------------------------------------------------------------------------------------------

uInt32 CServerPrefs_10_1::Count ( void )
{
	OSErr result;
	uInt32 aCount = 0;
	result = gDB_10_1->GetObjectCount ( CServerPrefs_10_1::GetObjTypeConstant(), aCount );	// of ourselves
	if ( result != kNoErr )
	{
		aCount = 0;
	}
	
	return aCount;
} // Count


//--------------------------------------------------------------------------------------------------
//	* GetServerPrefsObj
//
//--------------------------------------------------------------------------------------------------

CServerPrefs_10_1* CServerPrefs_10_1::GetServerPrefsObj ( const Boolean inOKToFindFlag, const Boolean inForceInitFlag )
{
	OSErr			result;
	ObjID			objID;
	SDBIterator_10_1		iterator(gDB_10_1);
	CServerPrefs_10_1   *prefsObj = nil;
	uInt32			aLogMsgBit = 0;

	if ( (CServerPrefs_10_1::prefsObjPtr == nil) && (inOKToFindFlag == true) )
	{
		if ( (gDB_10_1 != nil) )
		{
			result = gDB_10_1->CreateIterator( CServerPrefs_10_1::GetObjTypeConstant(), &iterator );
			if ( result == kNoErr )
			{
				gDB_10_1->NextObject( &iterator, objID );
				if ( objID != 0 )
				{
					prefsObj = CServerPrefs_10_1::FindByID( objID );
				}
			}
			gDB_10_1->ReleaseIterator( &iterator );

			if ( prefsObj == nil )
			{
				prefsObj = CServerPrefs_10_1::Create();
				if ( prefsObj == nil )
				{
					return( nil );
				}
				prefsObj->Initialize();
			}
			else if ( inForceInitFlag == true )
			{
				prefsObj->Initialize();
			}
		}

#ifndef DEBUG		
		if (prefsObj != NULL)
		{
//			for (aLogMsgBit = kSLStartTransLogMsgs; aLogMsgBit <= kSLEndTransLogMsgs; aLogMsgBit++)
//			{
//				prefsObj->ClearLogMsgBit(kAServerLogType, aLogMsgBit);
//			}
		}
#endif
		
		CServerPrefs_10_1::prefsObjPtr = prefsObj;
	}
	else
	{
		prefsObj = CServerPrefs_10_1::prefsObjPtr;
		if ( (prefsObj != nil) && (inForceInitFlag == true) )
		{
			prefsObj->Initialize();
		}
	}

	return( prefsObj );

} // GetServerPrefsObj


#pragma mark -

//--------------------------------------------------------------------------------------------------
//	* CServerPrefs_10_1
//
//--------------------------------------------------------------------------------------------------


CServerPrefs_10_1::CServerPrefs_10_1 ( void ) :
	CDBMailBaseObject_10_1(	&fServerPrefsData.fDBHeader,
				&fServerPrefsData.fDBFooter,
				&fServerPrefsData,
				CServerPrefs_10_1::GetObjTypeConstant(),
				CServerPrefs_10_1::GetObjVersConstant(),
				CServerPrefs_10_1::GetObjSizeConstant() )
{
	::memset( &(fServerPrefsData.fServerPrefsID), 0, sizeof( CServerPrefsData_10_1 ) - (sizeof(StdDBObjHeader_10_1) + sizeof(StdDBObjFooter_10_1)) );

	// Reserved
	fServerPrefsData.fReserved1	= kReservedConst;
	fServerPrefsData.fReserved2	= kReservedConst;

} // CServerPrefs_10_1


//--------------------------------------------------------------------------------------------------
//	* CServerPrefs_10_1
//
//--------------------------------------------------------------------------------------------------

CServerPrefs_10_1::~CServerPrefs_10_1 ( void )
{
} // ~CServerPrefs_10_1


//--------------------------------------------------------------------------------------------------
//	* Initialize
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::Initialize ( void )
{

	ServerPrefs	   *prefsData = nil;

//	SRVLOG1( 0x04, "sizeof ServerPrefs = %d", sizeof( ServerPrefs ) );

	prefsData = &fServerPrefsData.fPrefsData;

	fServerPrefsData.fServerPrefsFlags = kNoSvrPrefsFlags_10_1;

	if ( prefsData != nil )
	{
	  // Mail Server Settings
	  // - Messages pane
		prefsData->fMaxMessageSizeFlag			= false;
		prefsData->fMaxMessageSizeValue			= kMaxMessageSize;	// ??

		prefsData->fBCC_Flag					= false;
		::memset( &prefsData->fBCC_UserInfo, 0, sizeof( UserStruct ) );

// - MED - This must be assimilated
prefsData->fMSPStdMailInSendBCCToUandGID = 0;

		prefsData->fAutoMailDeleteFlag			= false;
		prefsData->fDeleteUnseenDays			= 120;
		prefsData->fDeleteSeenDays				= 90;

		prefsData->fFWDUnknownLocalFlag			= false;
		::memset( &prefsData->fFWDUnknownLocalUserInfo, 0, sizeof( UserStruct ) );

	  // Mail Server Settings
	  // - Spam pane
		prefsData->fCheckSMTP_InFlag			= false;

		prefsData->fUseDefaultSpamSrvr			= true;
		prefsData->fDefaultSpamSrvr[ 0 ]		= '\0';
		::strcpy( prefsData->fDefaultSpamSrvr, "rbl.maps.vix.com" );

		prefsData->fUseCustomSpamSrvr			= false;
		prefsData->fCustomSpamSrvr[ 0 ]			= '\0';
		::strcpy( prefsData->fCustomSpamSrvr, "rbl.maps.vix.com" );

		prefsData->fLogIfBadSMTPNameFlag		= false;
		prefsData->fRejectIfBadNameFlag			= false;

		prefsData->fRequireLocalFromFlag		= true;
		prefsData->fRejectIfNotInHostListFlag	= false;

	  // Mail Server Settings
	  // - Protocols pane
		prefsData->fSMTP_InState				= 0;
		prefsData->fSMTP_InEnabled				= true;
		prefsData->fSMTP_OutEnabled				= true;
	
		prefsData->fSMTP_InPortNumber			= 25;
		prefsData->fSMTP_OutPortNumber			= 25;
	
		prefsData->fIMAP_Enabled				= true;
		prefsData->fIMAP_PortNumber				= 143;
	
		prefsData->fPOP_Enabled					= true;
		prefsData->fPOP_PortNumber				= 110;
	
		prefsData->fNotifyMail_Enabled			= true;
		prefsData->fNotifyMail_PortNumber		= 79;

	  // Mail Server Settings
	  // - SMTP Options...
		prefsData->fSMTP_InGreeting[ 0 ]		= '\0';
		prefsData->fSMTP_OutGreeting[ 0 ]		= '\0';
	
		prefsData->fSMTPRelayWhenBackupFlag		= false;
		prefsData->fSendUndelivNDRToPMFlag		= false;
		prefsData->fAllowNDRsBulkMailFlag		= false;

	  // Mail Server Settings
	  // - IMAP Options...
		prefsData->fIMAP_Greeting[ 0 ]			= '\0';
		prefsData->fAdminPort_Greeting[ 0 ]		= '\0';
	
		prefsData->fAdminPort_Enabled			= true;
		prefsData->fAdminPort_PortNumber		= 626;
	
		prefsData->fCaseSensativeFldrNameFlag	= false;
	
		prefsData->fConnPerIMAPAcctPerIP		= 32;
		prefsData->fIMAPConnIdleTimeout			= 30;	// In minutes

	  // Mail Server Settings
	  // - POP3 Options...
		prefsData->fPOP_Greeting[ 0 ]			= '\0';

		prefsData->fMaxIMAP_MessagesPerFolder	= 10000;
	}

	// Set our last IP address to 0 because we don't know who we are yet.
	SetOurLastIPAddr( 0 );

// Standard - 'Mail In' panel
	prefsData->fMSPStdMailInForwardMailForUnknownLocalUsersUandGID	= 0;
	prefsData->fMSPStdMailInForwardMailForUnknownLocalUsersChk		= false;
	prefsData->fLocalFromMustExist									= true;
	prefsData->fMSPStdMailInDontAllowAutoHostEntryCreationChk		= false;

// Standard - 'Mail Out' panel
	prefsData->fMSPStdMailOutAllowOutgoingMailBtn					= true;
	prefsData->fMSPStdMailOutHoldOutgoingMailBtn					= false;
	prefsData->fMSPStdMailOutWarnSenderOfNonDeliveryAfterBtn		= true;
	prefsData->fMSPStdMailOutMessageExpiresAfterEdit				= 72;
	prefsData->fMSPStdMailOutWarnSenderOfNonDeliveryAfterEdit		= 4;
	prefsData->fMSPStdMailOutWarnPostmasterOfNonDeliveryAfterBtn	= false;
	prefsData->fMSPStdMailOutForwardAllMailToChk					= false;
	prefsData->fMSPStdMailOutForwardAllMailToEdit[0]				= '\0';

// Advanced - 'Network' panel
	prefsData->fMSPAdvNetworkResolveMXListChk						= true;
	prefsData->fMSPAdvNetworkResolveDNSARecordChk					= true;
	prefsData->fMSPAdvNetworkOpenConnectionTimeoutEdit				= 120;
	prefsData->fMSPAdvNetworkReadWriteTimeoutEdit					= 120;
	prefsData->fMSPAdvNetworkRespectTimeToLiveBtn					= true;
	prefsData->fMSPAdvNetworkCacheDNSInformationBtn					= false;
	prefsData->fMSPAdvNetworkCacheDNSInformationForEdit				= 720;


	//-- Protocol preferences -----------------------------

	// SMTP IN
	prefsData->fSMTP_InConnLimit		= 256;

	// SMTP Out
	prefsData->fSMTP_OutConnLimit		= 128;

	// POP
	prefsData->fPOP_ConnLimit			= 512;

	// IMAP
	prefsData->fIMAP_ConnLimit			= 512;

	// Admin Port
	prefsData->fAdminPort_ConnLimit		= 32;

	// NotifyMail
	prefsData->fNotifyMail_ConnLimit	= 16;
	prefsData->fNotifyMail_Greeting[ 0 ]	= '\0';


	// Database flush frequency
	prefsData->fDB_FlushFrequency = 30;

	// Database cache size
	prefsData->fDB_CacheSize = 2048;

	// Database location
	prefsData->fDB_Location[ 0 ]  = '\0';
	::strcpy( prefsData->fDB_Location, "/Library/AppleMailServer/" );

	// Database min free space
	prefsData->fDB_MinFreeSpace = 2048;

//	uInt8 * vuInt8P = (uInt8 *)&prefsData->fMSPAdvMiscFlagsByte1;
//	*vuInt8P = 0;	// Clear bit flags.

	prefsData->fMSPAdvMiscFlagsByte1	= 0;
	prefsData->fMSPAdvMiscFlagsByte1	|= kMSSFDeleteAllEmptyDefaultHostsChk;

// Initialize the Directory U&G preference
	prefsData->fMSPDSExpireCacheUGAtShutdownChk = true;
	prefsData->fMSPDSExpireCacheUGAtStartupChk = false;
	prefsData->fMSPDSTimeToLive = 60 * 60;		// 1 hour=3600 sec - how long we cache the directory info	

// initialize the log bit map settings
	uInt16 i = 0;
	
	for ( i = 0; i < kMaxBitMapLogEntries; i++ )
	{
		prefsData->fMSPServerLogMessageBitMap[ i ] = 0xffffffff;
		prefsData->fMSPErrorLogMessageBitMap[ i ]  = 0xffffffff;
	}

	this->SetDirty();

} // Initialize

//--------------------------------------------------------------------------------------------------
//	* InitializeGreetings
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::InitializeGreetings ( void )
{
} // 


Boolean	CServerPrefs_10_1::IsLogMsgBitSet (const ELogType inLogType, const uInt32 inMsgBit2Check)
{
	Boolean result = false;

	if ( (this != NULL) && (inMsgBit2Check < (32 * kMaxBitMapLogEntries)) )
	{
		ServerPrefs	*prefsData = &fServerPrefsData.fPrefsData;
		const uInt32	theIndex2Check = inMsgBit2Check / 32;
		const uInt32	theMask = 0x01 << (inMsgBit2Check - (theIndex2Check * 32));
		
		switch (inLogType)
		{
			case kAServerLogType:
				result = ((prefsData->fMSPServerLogMessageBitMap[theIndex2Check] & theMask) != 0);
				break;
			
			case kAnErrorLogType:
				result = ((prefsData->fMSPErrorLogMessageBitMap[theIndex2Check] & theMask) != 0);
				break;
			default:
				break;
		}
	}

	return (result);
}

void CServerPrefs_10_1::SetLogMsgBit ( const ELogType inLogType, const uInt32 inMsgBit2Set )
{
	if ((this != NULL) && (inMsgBit2Set < (32 * kMaxBitMapLogEntries)))
	{
		ServerPrefs	*prefsData = &fServerPrefsData.fPrefsData;
		const uInt32	theIndex2Check = inMsgBit2Set / 32;
		const uInt32	theMask = 0x01 << (inMsgBit2Set - (theIndex2Check * 32));
		
		switch (inLogType)
		{
			case kAServerLogType:
				if ((prefsData->fMSPServerLogMessageBitMap[theIndex2Check] | theMask) != prefsData->fMSPServerLogMessageBitMap[theIndex2Check])
				{
					prefsData->fMSPServerLogMessageBitMap[theIndex2Check] = (prefsData->fMSPServerLogMessageBitMap[theIndex2Check] | theMask);
					this->SetDirty();
				}
				break;
			
			case kAnErrorLogType:
				if ((prefsData->fMSPErrorLogMessageBitMap[theIndex2Check] | theMask) != prefsData->fMSPErrorLogMessageBitMap[theIndex2Check])
				{
					prefsData->fMSPErrorLogMessageBitMap[theIndex2Check] = (prefsData->fMSPErrorLogMessageBitMap[theIndex2Check] | theMask);
					this->SetDirty();
				}
				break;

			default:
				break;
		}
	}
}

void	CServerPrefs_10_1::ClearLogMsgBit ( const ELogType inLogType, const uInt32 inMsgBit2Clear )
{
	if ((this != NULL) && (inMsgBit2Clear < (32 * kMaxBitMapLogEntries)))
	{
		ServerPrefs	*prefsData = &fServerPrefsData.fPrefsData;
		const uInt32	theIndex2Check = inMsgBit2Clear / 32;
		const uInt32	theMask = ~(0x01 << (inMsgBit2Clear - (theIndex2Check * 32)));
		
		switch (inLogType)
		{
			case kAServerLogType:
				if ((prefsData->fMSPServerLogMessageBitMap[theIndex2Check] & theMask) != prefsData->fMSPServerLogMessageBitMap[theIndex2Check])
				{
					prefsData->fMSPServerLogMessageBitMap[theIndex2Check] = (prefsData->fMSPServerLogMessageBitMap[theIndex2Check] & theMask);
					this->SetDirty();
				}
				break;
			
			case kAnErrorLogType:
				if ((prefsData->fMSPErrorLogMessageBitMap[theIndex2Check] & theMask) != prefsData->fMSPErrorLogMessageBitMap[theIndex2Check])
				{
					prefsData->fMSPErrorLogMessageBitMap[theIndex2Check] = (prefsData->fMSPErrorLogMessageBitMap[theIndex2Check] & theMask);
					this->SetDirty();
				}
				break;

			default:
				break;
		}
	}
}


#pragma mark -

//--------------------------------------------------------------------------------------------------
//	* SetDirty
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetDirty ( void )
{
	if ( ( this != nil ) && ( this->GetServerPrefsID() != 0 ) )
	{
		this->setDirty();
	}
} // SetDirty


//--------------------------------------------------------------------------------------------------
//	* GetServerPrefsData
//
//--------------------------------------------------------------------------------------------------

CServerPrefsData_10_1* CServerPrefs_10_1::GetServerPrefsData ( void )
{
	if ( this != nil )
	{
		return( &fServerPrefsData );
	}

	return( nil );

} // GetServerPrefsData


//--------------------------------------------------------------------------------------------------
//	* GetServerPrefsID
//
//--------------------------------------------------------------------------------------------------

ObjID CServerPrefs_10_1::GetServerPrefsID( void )
{
	return ( fServerPrefsData.fServerPrefsID );
} // GetServerPrefsID


//--------------------------------------------------------------------------------------------------
//	* SetServerPrefsID
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetServerPrefsID ( const ObjID inNewObjID )
{
	if ( fServerPrefsData.fServerPrefsID != inNewObjID )
	{
		fServerPrefsData.fServerPrefsID = inNewObjID;
		this->SetDirty();
	}
} // SetServerPrefsID


//--------------------------------------------------------------------------------------------------
//	* GetOurLastIPAddr
//
//--------------------------------------------------------------------------------------------------

uInt32 CServerPrefs_10_1::GetOurLastIPAddr( void )
{
	return ( fServerPrefsData.fOurLastIPAddress );
} // GetOurLastIPAddr


//--------------------------------------------------------------------------------------------------
//	* SetOurLastIPAddr
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetOurLastIPAddr ( const uInt32 inIPAddr )
{
	if ( fServerPrefsData.fOurLastIPAddress != inIPAddr )
	{
		fServerPrefsData.fOurLastIPAddress = inIPAddr;
		this->SetDirty();
	}
} // SetOurLastIPAddr


//--------------------------------------------------------------------------------------------------
//	* GetPrefsData
//
//--------------------------------------------------------------------------------------------------

ServerPrefs* CServerPrefs_10_1::GetPrefsData ( void )
{
	return ( &fServerPrefsData.fPrefsData );
} // GetServerPrefsID


//--------------------------------------------------------------------------------------------------
//	* SetPrefsData
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetPrefsData ( ServerPrefs *inData )
{
	fServerPrefsData.fTimeStamp	= ::time(nil);
	fServerPrefsData.fPrefsData = *inData;
	this->SetDirty();
} // SetServerPrefsID


//--------------------------------------------------------------------------------------------------
//	* GetPrefsTimeStamp
//
//--------------------------------------------------------------------------------------------------

uInt32 CServerPrefs_10_1::GetPrefsTimeStamp ( void )
{
	return( fServerPrefsData.fTimeStamp );

} // GetPrefsTimeStamp


//--------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------------
//	* GetMaxMessageSizeFlag
//
//--------------------------------------------------------------------------------------------------

bool CServerPrefs_10_1::GetMaxMessageSizeFlag ( void )
{
	return( fServerPrefsData.fPrefsData.fMaxMessageSizeFlag );

} // GetMaxMessageSizeFlag


//--------------------------------------------------------------------------------------------------
//	* SetMaxMessageSizeFlag
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetMaxMessageSizeFlag ( bool inFlag )
{
	if ( fServerPrefsData.fPrefsData.fMaxMessageSizeFlag != inFlag )
	{
		fServerPrefsData.fPrefsData.fMaxMessageSizeFlag = inFlag;
		this->SetDirty();
	}
} // SetMaxMessageSizeFlag


//--------------------------------------------------------------------------------------------------
//	* GetMaxMessageSize
//
//--------------------------------------------------------------------------------------------------

uInt32 CServerPrefs_10_1::GetMaxMessageSize ( void )
{
	return( fServerPrefsData.fPrefsData.fMaxMessageSizeValue );

} // GetMaxMessageSize


//--------------------------------------------------------------------------------------------------
//	* SetMaxMessageSize
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetMaxMessageSize ( uInt32 inValue )
{
	if ( fServerPrefsData.fPrefsData.fMaxMessageSizeValue != inValue )
	{
		fServerPrefsData.fPrefsData.fMaxMessageSizeValue = inValue;
		this->SetDirty();
	}
} // SetMaxMessageSize


//--------------------------------------------------------------------------------------------------
//	* GetBCC_Flag
//
//--------------------------------------------------------------------------------------------------

bool CServerPrefs_10_1::GetBCC_Flag ( void )
{
	return( fServerPrefsData.fPrefsData.fBCC_Flag );

} // GetBCC_Flag


//--------------------------------------------------------------------------------------------------
//	* SetBCC_Flag
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetBCC_Flag ( bool inFlag )
{
	if ( fServerPrefsData.fPrefsData.fBCC_Flag != inFlag )
	{
		fServerPrefsData.fPrefsData.fBCC_Flag = inFlag;
		this->SetDirty();
	}
} // SetBCC_Flag


//--------------------------------------------------------------------------------------------------
//	* GetBCC_UserStruct
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::GetBCC_UserStruct ( UserStruct *outInfo )
{
	if ( outInfo != nil )
	{
		::memcpy( outInfo, &fServerPrefsData.fPrefsData.fBCC_UserInfo, sizeof( UserStruct ) );
#ifdef _STUPID_UNIX_
		outInfo->fID		= fServerPrefsData.fPrefsData.fBCC_UserInfo.fID;
		outInfo->fType		= (eUGType)fServerPrefsData.fPrefsData.fBCC_UserInfo.fType;
		::strcpy( outInfo->fUserName, fServerPrefsData.fPrefsData.fBCC_UserInfo.fUserName );
		::strcpy( outInfo->fRealName, fServerPrefsData.fPrefsData.fBCC_UserInfo.fRealName );
		::strcpy( outInfo->fPath, fServerPrefsData.fPrefsData.fBCC_UserInfo.fPath );
#endif
	}
} // GetBCC_UserStruct


//--------------------------------------------------------------------------------------------------
//	* SetBCC_UserStruct
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetBCC_UserStruct ( UserStruct *inInfo )
{
	uInt32		uiStrLen	= 0;

	if ( inInfo != nil )
	{
		::memcpy( &fServerPrefsData.fPrefsData.fBCC_UserInfo, inInfo, sizeof( UserStruct ) );
		this->SetDirty();

	}
} // SetBCC_UserStruct


//--------------------------------------------------------------------------------------------------
//	* GetAutoMailDeleteFlag
//
//--------------------------------------------------------------------------------------------------

bool CServerPrefs_10_1::GetAutoMailDeleteFlag ( void )
{
	return( fServerPrefsData.fPrefsData.fAutoMailDeleteFlag );

} // GetAutoMailDeleteFlag


//--------------------------------------------------------------------------------------------------
//	* SetAutoMailDeleteFlag
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetAutoMailDeleteFlag ( bool inFlag )
{
	if ( fServerPrefsData.fPrefsData.fAutoMailDeleteFlag != inFlag )
	{
		fServerPrefsData.fPrefsData.fAutoMailDeleteFlag = inFlag;
		this->SetDirty();
	}
} // SetAutoMailDeleteFlag


//--------------------------------------------------------------------------------------------------
//	* GetDeleteUnseenDays
//
//--------------------------------------------------------------------------------------------------

uInt32 CServerPrefs_10_1::GetDeleteUnseenDays ( void )
{
	return( fServerPrefsData.fPrefsData.fDeleteUnseenDays );

} // GetDeleteUnseenDays


//--------------------------------------------------------------------------------------------------
//	* SetDeleteUnseenDays
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetDeleteUnseenDays ( uInt32 inValue )
{
	if ( fServerPrefsData.fPrefsData.fDeleteUnseenDays != inValue )
	{
		fServerPrefsData.fPrefsData.fDeleteUnseenDays = inValue;
		this->SetDirty();
	}
} // SetDeleteUnseenDays


//--------------------------------------------------------------------------------------------------
//	* GetDeleteSeenDays
//
//--------------------------------------------------------------------------------------------------

uInt32 CServerPrefs_10_1::GetDeleteSeenDays ( void )
{
	return( fServerPrefsData.fPrefsData.fDeleteSeenDays );

} // GetDeleteSeenDays


//--------------------------------------------------------------------------------------------------
//	* SetDeleteSeenDays
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetDeleteSeenDays ( uInt32 inValue )
{
	if ( fServerPrefsData.fPrefsData.fDeleteSeenDays != inValue )
	{
		fServerPrefsData.fPrefsData.fDeleteSeenDays = inValue;
		this->SetDirty();
	}
} // SetDeleteSeenDays


//--------------------------------------------------------------------------------------------------
//	* GetFWDUnknownLoalUserFlag
//
//--------------------------------------------------------------------------------------------------

bool CServerPrefs_10_1::GetFWDUnknownLoalUserFlag ( void )
{
	return( fServerPrefsData.fPrefsData.fFWDUnknownLocalFlag );

} // GetFWDUnknownLoalUserFlag


//--------------------------------------------------------------------------------------------------
//	* SetFWDUnknownLoalUserFlag
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetFWDUnknownLoalUserFlag ( bool inFlag )
{
	if ( fServerPrefsData.fPrefsData.fFWDUnknownLocalFlag != inFlag )
	{
		fServerPrefsData.fPrefsData.fFWDUnknownLocalFlag = inFlag;
		this->SetDirty();
	}

	if ( fServerPrefsData.fPrefsData.fMSPStdMailInForwardMailForUnknownLocalUsersChk != inFlag )
	{
		fServerPrefsData.fPrefsData.fMSPStdMailInForwardMailForUnknownLocalUsersChk = inFlag;
		this->SetDirty();
	}
} // SetFWDUnknownLoalUserFlag


//--------------------------------------------------------------------------------------------------
//	* GetFWDUnknownLoalUserUserStruct
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::GetFWDUnknownLoalUserUserStruct ( UserStruct *outInfo )
{
	if ( outInfo != nil )
	{
		::memcpy( outInfo, &fServerPrefsData.fPrefsData.fFWDUnknownLocalUserInfo, sizeof( UserStruct ) );
	}

} // GetFWDUnknownLoalUserUserStruct


//--------------------------------------------------------------------------------------------------
//	* SetFWDUnknownLoalUserUserStruct ()
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetFWDUnknownLoalUserUserStruct ( UserStruct *inInfo )
{
	uInt32		uiStrLen	= 0;

	if ( inInfo != nil )
	{
		::memcpy( &fServerPrefsData.fPrefsData.fFWDUnknownLocalUserInfo, inInfo, sizeof( UserStruct ) );

		this->SetDirty();
	}
} // SetFWDUnknownLoalUserUserStruct


//--------------------------------------------------------------------------------------------------
//	* GetCheckSMTP_InFlag ()
//
//--------------------------------------------------------------------------------------------------

bool CServerPrefs_10_1::GetCheckSMTP_InFlag ( void )
{
	return( fServerPrefsData.fPrefsData.fCheckSMTP_InFlag );

} // GetCheckSMTP_InFlag


//--------------------------------------------------------------------------------------------------
//	* SetCheckSMTP_InFlag ()
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetCheckSMTP_InFlag ( bool inFlag )
{
	if ( fServerPrefsData.fPrefsData.fCheckSMTP_InFlag != inFlag )
	{
		fServerPrefsData.fPrefsData.fCheckSMTP_InFlag = inFlag;
		this->SetDirty();
	}

	SetDoRBLSMTPConnFlag( inFlag );

} // SetCheckSMTP_InFlag


//--------------------------------------------------------------------------------------------------
//	* GetUseDefaultSpamSrvrFlag ()
//
//--------------------------------------------------------------------------------------------------

bool CServerPrefs_10_1::GetUseDefaultSpamSrvrFlag ( void )
{
	return( fServerPrefsData.fPrefsData.fUseDefaultSpamSrvr );

} // GetUseDefaultSpamSrvrFlag


//--------------------------------------------------------------------------------------------------
//	* SetUseDefaultSpamSrvrFlag ()
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetUseDefaultSpamSrvrFlag ( bool inFlag )
{
	if ( fServerPrefsData.fPrefsData.fUseDefaultSpamSrvr != inFlag )
	{
		fServerPrefsData.fPrefsData.fUseDefaultSpamSrvr = inFlag;
		this->SetDirty();
	}

} // SetUseDefaultSpamSrvrFlag


//--------------------------------------------------------------------------------------------------
//	* GetUseCustomSpamSrvrFlag ()
//
//--------------------------------------------------------------------------------------------------

bool CServerPrefs_10_1::GetUseCustomSpamSrvrFlag ( void )
{
	return( fServerPrefsData.fPrefsData.fUseCustomSpamSrvr );

} // GetUseCustomSpamSrvrFlag


//--------------------------------------------------------------------------------------------------
//	* SetUseCustomSpamSrvrFlag ()
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetUseCustomSpamSrvrFlag ( bool inFlag )
{
	if ( fServerPrefsData.fPrefsData.fUseCustomSpamSrvr != inFlag )
	{
		fServerPrefsData.fPrefsData.fUseCustomSpamSrvr = inFlag;
		this->SetDirty();
	}

	// Legacy support
	SetUseCustomRBLDomainFlag( inFlag );
	
} // SetUseCustomSpamSrvrFlag


//--------------------------------------------------------------------------------------------------
//	* GetDefaultSpamSrvr
//
//--------------------------------------------------------------------------------------------------

char* CServerPrefs_10_1::GetDefaultSpamSrvr ( void )
{
	return( fServerPrefsData.fPrefsData.fDefaultSpamSrvr );

} // GetDefaultSpamSrvr


//--------------------------------------------------------------------------------------------------
//	* SetDefaultSpamSrvr
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetDefaultSpamSrvr ( char *inSrvrName, uInt32 inLen )
{
	uInt32		uiStrLen	= inLen;

	if ( (inSrvrName != nil) && (inLen != 0) )
	{
		if ( uiStrLen > kStrSize )
		{
			uiStrLen = kStrSize - 1;
		}

		::memset( fServerPrefsData.fPrefsData.fDefaultSpamSrvr, 0, kStrSize ); 
		::memcpy( fServerPrefsData.fPrefsData.fDefaultSpamSrvr, inSrvrName, uiStrLen );

		this->SetDirty();
	}

} // SetDefaultSpamSrvr


//--------------------------------------------------------------------------------------------------
//	* GetCustomSpamSrvr
//
//--------------------------------------------------------------------------------------------------

char* CServerPrefs_10_1::GetCustomSpamSrvr ( void )
{
	return( fServerPrefsData.fPrefsData.fCustomSpamSrvr );

} // GetCustomSpamSrvr


//--------------------------------------------------------------------------------------------------
//	* SetCustomSpamSrvr
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetCustomSpamSrvr ( char *inSrvrName, uInt32 inLen )
{
	uInt32		uiStrLen	= inLen;
	CString		legacy( 128 );

	if ( (inSrvrName != nil) && (inLen != 0) )
	{
		if ( uiStrLen > kStrSize )
		{
			uiStrLen = kStrSize - 1;
		}

		::memset( fServerPrefsData.fPrefsData.fCustomSpamSrvr, 0, kStrSize ); 
		::memcpy( fServerPrefsData.fPrefsData.fCustomSpamSrvr, inSrvrName, inLen );

		// - This is for legacy support and will be deleted soon
		legacy.Set( inSrvrName, inLen );
		SetCustomRBLDomainName( legacy );
		
		this->SetDirty();
	}
} // SetCustomSpamSrvr


//--------------------------------------------------------------------------------------------------
//	* GetLogIfBadSMTPNameFlag ()
//
//--------------------------------------------------------------------------------------------------

bool CServerPrefs_10_1::GetLogIfBadSMTPNameFlag ( void )
{
	return( fServerPrefsData.fPrefsData.fLogIfBadSMTPNameFlag );

} // GetLogIfBadSMTPNameFlag


//--------------------------------------------------------------------------------------------------
//	* SetLogIfBadSMTPNameFlag ()
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetLogIfBadSMTPNameFlag ( bool inFlag )
{
} // SetLogIfBadSMTPNameFlag


//--------------------------------------------------------------------------------------------------
//	* GetRejectIfNameNoMatch ()
//
//--------------------------------------------------------------------------------------------------

bool CServerPrefs_10_1::GetRejectIfNameNoMatch ( void )
{
	return( fServerPrefsData.fPrefsData.fRejectIfBadNameFlag );

} // GetRejectIfNameNoMatch


//--------------------------------------------------------------------------------------------------
//	* SetRejectIfNameNoMatch ()
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetRejectIfNameNoMatch ( bool inFlag )
{
} // SetRejectIfNameNoMatch


//--------------------------------------------------------------------------------------------------
//	* GetRequireLocalFromFlag ()
//
//--------------------------------------------------------------------------------------------------

bool CServerPrefs_10_1::GetRequireLocalFromFlag ( void )
{
	return( fServerPrefsData.fPrefsData.fRequireLocalFromFlag );

} // GetRequireLocalFromFlag


//--------------------------------------------------------------------------------------------------
//	* SetRequireLocalFromFlag ()
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetRequireLocalFromFlag ( bool inFlag )
{
	if ( fServerPrefsData.fPrefsData.fRequireLocalFromFlag != inFlag )
	{
		fServerPrefsData.fPrefsData.fRequireLocalFromFlag = inFlag;
		this->SetDirty();
	}

	// Legacy support.  Will be deleted soon
	if ( fServerPrefsData.fPrefsData.fLocalFromMustExist != inFlag )
	{
		fServerPrefsData.fPrefsData.fLocalFromMustExist = inFlag;
		this->SetDirty();
	}
} // SetRequireLocalFromFlag


//--------------------------------------------------------------------------------------------------
//	* GetRejectIfNotInHostListFlag ()
//
//--------------------------------------------------------------------------------------------------

bool CServerPrefs_10_1::GetRejectIfNotInHostListFlag ( void )
{
	return( fServerPrefsData.fPrefsData.fRejectIfNotInHostListFlag );

} // GetRejectIfNotInHostListFlag


//--------------------------------------------------------------------------------------------------
//	* SetRejectIfNotInHostListFlag ()
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetRejectIfNotInHostListFlag ( bool inFlag )
{
	if ( fServerPrefsData.fPrefsData.fRejectIfNotInHostListFlag != inFlag )
	{
		fServerPrefsData.fPrefsData.fRejectIfNotInHostListFlag = inFlag;
		this->SetDirty();
	}
} // SetRejectIfNotInHostListFlag


//--------------------------------------------------------------------------------------------------
//	* GetSMTP_State
//
//--------------------------------------------------------------------------------------------------

uInt32 CServerPrefs_10_1::GetSMTP_State ( void )
{
	return( fServerPrefsData.fPrefsData.fSMTP_InState );

} // GetSMTP_State


//--------------------------------------------------------------------------------------------------
//	* SetSMTP_State
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetSMTP_State ( uInt32 inSMTP_State )
{
} // SetSMTP_State


//--------------------------------------------------------------------------------------------------
//	* GetSMTP_EnabledFlag
//
//--------------------------------------------------------------------------------------------------

bool CServerPrefs_10_1::GetSMTP_EnabledFlag ( void )
{
	return( fServerPrefsData.fPrefsData.fSMTP_InEnabled );

} // GetSMTP_EnabledFlag


//--------------------------------------------------------------------------------------------------
//	* SetSMTP_EnabledFlag
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetSMTP_EnabledFlag ( bool inSMTP_Flag )
{
} // SetSMTP_EnabledFlag



//--------------------------------------------------------------------------------------------------
//	* GetIMAP_EnabledFlag
//
//--------------------------------------------------------------------------------------------------

bool CServerPrefs_10_1::GetIMAP_EnabledFlag ( void )
{
	return( fServerPrefsData.fPrefsData.fIMAP_Enabled );

} // GetIMAP_EnabledFlag


//--------------------------------------------------------------------------------------------------
//	* SetIMAP_EnabledFlag
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetIMAP_EnabledFlag ( bool inIMAP_Flag )
{
} // SetIMAP_EnabledFlag


//--------------------------------------------------------------------------------------------------
//	* GetPOP3_EnabledFlag
//
//--------------------------------------------------------------------------------------------------

bool CServerPrefs_10_1::GetPOP3_EnabledFlag ( void )
{
	return( fServerPrefsData.fPrefsData.fPOP_Enabled );

} // GetPOP3_EnabledFlag


//--------------------------------------------------------------------------------------------------
//	* SetPOP3_EnabledFlag
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetPOP3_EnabledFlag ( bool inPOP3_Flag )
{
} // SetPOP3_EnabledFlag


//--------------------------------------------------------------------------------------------------
//	* GetNofifyEnabledFlag
//
//--------------------------------------------------------------------------------------------------

bool CServerPrefs_10_1::GetNofifyEnabledFlag ( void )
{
	return( fServerPrefsData.fPrefsData.fNotifyMail_Enabled );

} // GetNofifyEnabledFlag


//--------------------------------------------------------------------------------------------------
//	* SetNofifyEnabledFlag
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetNofifyEnabledFlag ( bool inNotify_Flag )
{
	if ( fServerPrefsData.fPrefsData.fNotifyMail_Enabled != inNotify_Flag )
	{
		fServerPrefsData.fPrefsData.fNotifyMail_Enabled = inNotify_Flag;
		this->SetDirty();
	}
} // SetNofifyEnabledFlag


//--------------------------------------------------------------------------------------------------
//	* GetSMTPRelayWhenBackupFlag ()
//
//--------------------------------------------------------------------------------------------------

bool CServerPrefs_10_1::GetSMTPRelayWhenBackupFlag ( void )
{
	return( fServerPrefsData.fPrefsData.fSMTPRelayWhenBackupFlag );

} // GetSMTPRelayWhenBackupFlag


//--------------------------------------------------------------------------------------------------
//	* SetSMTPRelayWhenBackupFlag ()
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetSMTPRelayWhenBackupFlag ( bool inFlag )
{
	if ( fServerPrefsData.fPrefsData.fSMTPRelayWhenBackupFlag != inFlag )
	{
		fServerPrefsData.fPrefsData.fSMTPRelayWhenBackupFlag = inFlag;
		this->SetDirty();
	}
} // SetSMTPRelayWhenBackupFlag


//--------------------------------------------------------------------------------------------------
//	* GetSendUndelivNDRToPMFlag ()
//
//--------------------------------------------------------------------------------------------------

bool CServerPrefs_10_1::GetSendUndelivNDRToPMFlag ( void )
{
	return( fServerPrefsData.fPrefsData.fSendUndelivNDRToPMFlag );

} // GetSendUndelivNDRToPMFlag


//--------------------------------------------------------------------------------------------------
//	* SetSendUndelivNDRToPMFlag ()
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetSendUndelivNDRToPMFlag ( bool inFlag )
{
	if ( fServerPrefsData.fPrefsData.fSendUndelivNDRToPMFlag != inFlag )
	{
		fServerPrefsData.fPrefsData.fSendUndelivNDRToPMFlag = inFlag;
		this->SetDirty();
	}
} // SetSendUndelivNDRToPMFlag


//--------------------------------------------------------------------------------------------------
//	* GetAllowNDRsBulkMailFlag ()
//
//--------------------------------------------------------------------------------------------------

bool CServerPrefs_10_1::GetAllowNDRsBulkMailFlag ( void )
{
	return( fServerPrefsData.fPrefsData.fAllowNDRsBulkMailFlag );

} // GetAllowNDRsBulkMailFlag


//--------------------------------------------------------------------------------------------------
//	* SetAllowNDRsBulkMailFlag ()
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetAllowNDRsBulkMailFlag ( bool inFlag )
{
	if ( fServerPrefsData.fPrefsData.fAllowNDRsBulkMailFlag != inFlag )
	{
		fServerPrefsData.fPrefsData.fAllowNDRsBulkMailFlag = inFlag;
		this->SetDirty();
	}
} // SetAllowNDRsBulkMailFlag


//--------------------------------------------------------------------------------------------------
//	* GetAllowIMAPAdminAccessFlag ()
//
//--------------------------------------------------------------------------------------------------

bool CServerPrefs_10_1::GetAllowIMAPAdminAccessFlag ( void )
{
	return( fServerPrefsData.fPrefsData.fAdminPort_Enabled );

} // GetAllowIMAPAdminAccessFlag


//--------------------------------------------------------------------------------------------------
//	* SetAllowIMAPAdminAccessFlag ()
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetAllowIMAPAdminAccessFlag ( bool inFlag )
{
} // SetAllowIMAPAdminAccessFlag


//--------------------------------------------------------------------------------------------------
//	* GetAdminPortNumber
//
//--------------------------------------------------------------------------------------------------

uInt32 CServerPrefs_10_1::GetAdminPortNumber ( void )
{
	return( fServerPrefsData.fPrefsData.fAdminPort_PortNumber );

} // GetAdminPortNumber


//--------------------------------------------------------------------------------------------------
//	* SetAdminPortNumber
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetAdminPortNumber ( uInt32 inValue )
{
} // SetAdminPortNumber


//--------------------------------------------------------------------------------------------------
//	* GetCaseSensativeFldrNameFlag ()
//
//--------------------------------------------------------------------------------------------------

bool CServerPrefs_10_1::GetCaseSensativeFldrNameFlag ( void )
{
	return( fServerPrefsData.fPrefsData.fCaseSensativeFldrNameFlag );

} // GetCaseSensativeFldrNameFlag


//--------------------------------------------------------------------------------------------------
//	* SetCaseSensativeFldrNameFlag ()
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetCaseSensativeFldrNameFlag ( bool inFlag )
{
	if ( fServerPrefsData.fPrefsData.fCaseSensativeFldrNameFlag != inFlag )
	{
		fServerPrefsData.fPrefsData.fCaseSensativeFldrNameFlag = inFlag;
		this->SetDirty();
	}
} // SetCaseSensativeFldrNameFlag


//--------------------------------------------------------------------------------------------------
//	* GetConnPerIMAPAcctPerIP
//
//--------------------------------------------------------------------------------------------------

uInt32 CServerPrefs_10_1::GetConnPerIMAPAcctPerIP ( void )
{
	return( fServerPrefsData.fPrefsData.fConnPerIMAPAcctPerIP );

} // GetConnPerIMAPAcctPerIP


//--------------------------------------------------------------------------------------------------
//	* SetConnPerIMAPAcctPerIP
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetConnPerIMAPAcctPerIP ( uInt32 inValue )
{
	if ( fServerPrefsData.fPrefsData.fConnPerIMAPAcctPerIP != inValue )
	{
		fServerPrefsData.fPrefsData.fConnPerIMAPAcctPerIP = inValue;
		this->SetDirty();
	}
} // SetConnPerIMAPAcctPerIP


//--------------------------------------------------------------------------------------------------
//	* GetIMAPConnIdleTimeout
//
//--------------------------------------------------------------------------------------------------

uInt32 CServerPrefs_10_1::GetIMAPConnIdleTimeout ( void )
{
	return( fServerPrefsData.fPrefsData.fIMAPConnIdleTimeout );

} // GetIMAPConnIdleTimeout


//--------------------------------------------------------------------------------------------------
//	* SetIMAPConnIdleTimeout
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetIMAPConnIdleTimeout ( uInt32 inValue )
{
	if ( fServerPrefsData.fPrefsData.fIMAPConnIdleTimeout != inValue )
	{
		fServerPrefsData.fPrefsData.fIMAPConnIdleTimeout = inValue;
		this->SetDirty();
	}
} // SetIMAPConnIdleTimeout

// --- xxx --- xxx --- xxx --- xxx --- xxx --- xxx --- xxx --- xxx --- xxx --- xxx --- xxx --- xxx 


//--------------------------------------------------------------------------------------------------
//	* GetMsgExpirationHours
//
//--------------------------------------------------------------------------------------------------

uInt32 CServerPrefs_10_1::GetMsgExpirationHours ( void )
{
	return( fServerPrefsData.fPrefsData.fMSPStdMailOutMessageExpiresAfterEdit );

} // GetMsgExpirationHours


//--------------------------------------------------------------------------------------------------
//	* GetMsgWarningHours
//
//--------------------------------------------------------------------------------------------------

uInt32 CServerPrefs_10_1::GetMsgWarningHours ( void )
{
	return( fServerPrefsData.fPrefsData.fMSPStdMailOutWarnSenderOfNonDeliveryAfterEdit );

} // GetMsgWarningHours


//--------------------------------------------------------------------------------------------------
//	* GetForwardRemoteMsgFlag
//
//--------------------------------------------------------------------------------------------------

Boolean CServerPrefs_10_1::GetForwardRemoteMsgFlag ( void )
{
	return( fServerPrefsData.fPrefsData.fMSPStdMailOutForwardAllMailToChk == true );

} // GetForwardRemoteMsgFlag


//--------------------------------------------------------------------------------------------------
//	* SetForwardRemoteMsgFlag
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetForwardRemoteMsgFlag ( const Boolean inSetForwardRemoteMailFlag )
{
	if (fServerPrefsData.fPrefsData.fMSPStdMailOutForwardAllMailToChk != inSetForwardRemoteMailFlag)
	{
		fServerPrefsData.fPrefsData.fMSPStdMailOutForwardAllMailToChk = inSetForwardRemoteMailFlag;
		this->SetDirty();
	}
} // GetForwardRemoteMsgFlag


//--------------------------------------------------------------------------------------------------
//	* GetForwardRemoteMsgName
//
//--------------------------------------------------------------------------------------------------

char * CServerPrefs_10_1::GetForwardRemoteMsgName ( void )
{
	char *theName = (char *) fServerPrefsData.fPrefsData.fMSPStdMailOutForwardAllMailToEdit;
	
	if ((unsigned char)(theName[0]) < 0xff)
	{
		theName[theName[0]+1] = 0x00;
	}
	return((char *) &fServerPrefsData.fPrefsData.fMSPStdMailOutForwardAllMailToEdit[1]);
} // GetForwardRemoteMsgName


//--------------------------------------------------------------------------------------------------
//	* GetServerDNSCachePopUp
//
//--------------------------------------------------------------------------------------------------

uInt32 CServerPrefs_10_1::GetServerDNSCachePopUp ( void )
{
	// kServerPrefsAdvNetworkDNSPopupCacheDNS				= 1;
	// kServerPrefsAdvNetworkDNSPopupAlwaysCheckDNS		= 2;

	return( fServerPrefsData.fPrefsData.fMSPAdvNetworkDNSPopup );
} // GetServerDNSCachePopUp


//--------------------------------------------------------------------------------------------------
//	* GetServerDNSCacheDeltaValue
//
//--------------------------------------------------------------------------------------------------

uInt32 CServerPrefs_10_1::GetServerDNSCacheDeltaValue ( void )
{
	return( fServerPrefsData.fPrefsData.fMSPAdvNetworkCacheDNSInformationForEdit );
} // GetServerDNSCacheDeltaValue


//--------------------------------------------------------------------------------------------------
//	* GetServerResolveMXFlag
//
//--------------------------------------------------------------------------------------------------

Boolean CServerPrefs_10_1::GetServerResolveMXFlag ( void )
{
	return( fServerPrefsData.fPrefsData.fMSPAdvNetworkResolveMXListChk == true );

} // GetServerResolveMXFlag


//--------------------------------------------------------------------------------------------------
//	* GetServerResolveARecord
//
//--------------------------------------------------------------------------------------------------

Boolean CServerPrefs_10_1::GetServerResolveARecord ( void )
{
	return( fServerPrefsData.fPrefsData.fMSPAdvNetworkResolveDNSARecordChk == true );

} // GetServerResolveARecord


//--------------------------------------------------------------------------------------------------
//	* GetCheckMaxMsgSize
//
//--------------------------------------------------------------------------------------------------

Boolean CServerPrefs_10_1::GetCheckMaxMsgSize ( void )
{
	return( fServerPrefsData.fPrefsData.fMaxMessageSizeFlag );

} // GetCheckMaxMsgSize


//--------------------------------------------------------------------------------------------------
//	* GetSendBCCFlag
//
//--------------------------------------------------------------------------------------------------

Boolean CServerPrefs_10_1::GetSendBCCFlag ( void )
{
	return( fServerPrefsData.fPrefsData.fBCC_Flag );

} // GetSendBCCFlag


//--------------------------------------------------------------------------------------------------
//	* GetMsgWarningFlag
//
//--------------------------------------------------------------------------------------------------

Boolean CServerPrefs_10_1::GetMsgWarningFlag ( void )
{
	return( fServerPrefsData.fPrefsData.fMSPStdMailOutWarnSenderOfNonDeliveryAfterBtn );

} // GetMsgWarningFlag


//--------------------------------------------------------------------------------------------------
//	* GetWarn_PM_OfNonDelivery
//
//--------------------------------------------------------------------------------------------------

Boolean CServerPrefs_10_1::GetWarn_PM_OfNonDelivery ( void )
{
	return( fServerPrefsData.fPrefsData.fMSPStdMailOutWarnPostmasterOfNonDeliveryAfterBtn );

} // GetWarn_PM_OfNonDelivery


//----------------------------------------------------------------------------------
// * SetThisProtocolPort ()
//
// ---------------------------------------------------------------------------------

void CServerPrefs_10_1::SetThisProtocolPort ( PortSelector inPortSelector, uInt16 inPortNumber )
{
} // SetThisPortocolPort
	

//----------------------------------------------------------------------------------
// * GetThisProtocolPort ()
//
// ---------------------------------------------------------------------------------

uInt16 CServerPrefs_10_1::GetThisProtocolPort (  PortSelector inPortSelector )
{
	return( 0 );
} // GetThisProtocolPort

//--------------------------------------------------------------------------------------------------
//	* GetSMTPInPort
//
//--------------------------------------------------------------------------------------------------

uInt16 CServerPrefs_10_1::GetSMTPInPort ( void )
{
	return( fServerPrefsData.fPrefsData.fSMTP_InPortNumber );

} // GetSMTPInPort


//--------------------------------------------------------------------------------------------------
//	* SetSMTPInPort
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetSMTPInPort ( uInt16 inPort )
{
} // SetSMTPInPort


//--------------------------------------------------------------------------------------------------
//	* GetSMTPOutPort
//
//--------------------------------------------------------------------------------------------------

uInt16 CServerPrefs_10_1::GetSMTPOutPort ( void )
{
	return( fServerPrefsData.fPrefsData.fSMTP_OutPortNumber );

} // GetSMTPOutPort


//--------------------------------------------------------------------------------------------------
//	* SetSMTPOutPort
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetSMTPOutPort ( uInt16 inPort )
{
	if ( fServerPrefsData.fPrefsData.fSMTP_OutPortNumber != inPort )
	{
		fServerPrefsData.fPrefsData.fSMTP_OutPortNumber = inPort;
		this->SetDirty();
	}
} // SetSMTPOutPort


//--------------------------------------------------------------------------------------------------
//	* GetIMAPPort
//
//--------------------------------------------------------------------------------------------------

uInt16 CServerPrefs_10_1::GetIMAPPort ( void )
{
	return( fServerPrefsData.fPrefsData.fIMAP_PortNumber );

} // GetIMAPPort


//--------------------------------------------------------------------------------------------------
//	* SetIMAPPort
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetIMAPPort ( uInt16 inPort )
{
} // SetIMAPPort


//--------------------------------------------------------------------------------------------------
//	* GetPOP3Port
//
//--------------------------------------------------------------------------------------------------

uInt16 CServerPrefs_10_1::GetPOP3Port ( void )
{
	return( fServerPrefsData.fPrefsData.fPOP_PortNumber );

} // GetPOP3Port


//--------------------------------------------------------------------------------------------------
//	* SetPOP3Port
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetPOP3Port ( uInt16 inPort )
{
} // SetPOP3Port


//--------------------------------------------------------------------------------------------------
//	* GetNotifyMailPort
//
//--------------------------------------------------------------------------------------------------

uInt16 CServerPrefs_10_1::GetNotifyMailPort ( void )
{
	return( fServerPrefsData.fPrefsData.fNotifyMail_PortNumber );
} // GetNotifyMailPort


//--------------------------------------------------------------------------------------------------
//	* SetNotifyMailPort
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetNotifyMailPort ( uInt16 inPort )
{
} // SetNotifyMailPort


//--------------------------------------------------------------------------------------------------
//	* GetAdminPort
//
//--------------------------------------------------------------------------------------------------

uInt16 CServerPrefs_10_1::GetAdminPort ( void )
{
	return( fServerPrefsData.fPrefsData.fAdminPort_PortNumber );
} // GetAdminPort


//--------------------------------------------------------------------------------------------------
//	* GetOpenTimeout
//
//--------------------------------------------------------------------------------------------------

uInt32 CServerPrefs_10_1::GetOpenTimeout ( void )
{
	return( fServerPrefsData.fPrefsData.fMSPAdvNetworkOpenConnectionTimeoutEdit );
} // GetOpenTimeout


//--------------------------------------------------------------------------------------------------
//	* GetRdWrTimeout
//
//--------------------------------------------------------------------------------------------------

uInt32 CServerPrefs_10_1::GetRdWrTimeout ( void )
{
	return( fServerPrefsData.fPrefsData.fMSPAdvNetworkReadWriteTimeoutEdit );
} // GetRdWrTimeout


//--------------------------------------------------------------------------------------------------
//	* GetSMTPResponseName
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::GetSMTPResponseName ( CString &outName )
{
	uInt32		strLen	= 0;
	const char *pStr	= nil;

	outName.Clear();

	if ( fServerPrefsData.fPrefsData.fSMTP_InGreeting[ 0 ] == '\0' )
	{
	}
	else
	{
		outName.Set( fServerPrefsData.fPrefsData.fSMTP_InGreeting );
	}
} // GetSMTPResponseName


//--------------------------------------------------------------------------------------------------
//	* SetSMTPResponseName
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetSMTPResponseName ( const char *inName )
{
	uInt32		strLen	= 0;

	if ( inName != nil )
	{
		strLen = ::strlen( inName );
		if ( strLen > kStrSize - 1 )
		{
			strLen = kStrSize - 1;
		}
		::memset( fServerPrefsData.fPrefsData.fSMTP_InGreeting, 0, kStrSize );
		::strncpy( fServerPrefsData.fPrefsData.fSMTP_InGreeting, inName, strLen );

		this->SetDirty();
	}
} // SetSMTPResponseName


//--------------------------------------------------------------------------------------------------
//	* GetSMTPOutResponseName
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::GetSMTPOutResponseName ( CString &outName )
{
	uInt32		strLen	= 0;
	const char *pStr	= nil;

	outName.Clear();

	if ( fServerPrefsData.fPrefsData.fSMTP_OutGreeting[ 0 ] == '\0' )
	{
	}
	else
	{
		outName.Set( fServerPrefsData.fPrefsData.fSMTP_OutGreeting );
	}
} // GetSMTPOutResponseName


//--------------------------------------------------------------------------------------------------
//	* SetSMTPOutResponseName
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetSMTPOutResponseName ( const char *inName )
{
	uInt32		strLen	= 0;

	if ( inName != nil )
	{
		strLen = ::strlen( inName );
		if ( strLen > kStrSize - 1 )
		{
			strLen = kStrSize - 1;
		}
   		::memset( fServerPrefsData.fPrefsData.fSMTP_OutGreeting, 0, kStrSize );
		::strncpy( fServerPrefsData.fPrefsData.fSMTP_OutGreeting, inName, strLen );

		this->SetDirty();
	}
} // SetSMTPOutResponseName


//--------------------------------------------------------------------------------------------------
//	* GetPOP3ResponseName
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::GetPOP3ResponseName ( CString &outName )
{
	uInt32		strLen	= 0;
	const char *pStr	= nil;

	outName.Clear();

	if ( fServerPrefsData.fPrefsData.fPOP_Greeting[ 0 ] == '\0' )
	{
	}
	else
	{
		outName.Set( fServerPrefsData.fPrefsData.fPOP_Greeting );
	}
} // GetPOP3ResponseName


//--------------------------------------------------------------------------------------------------
//	* SetPOP3ResponseName
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetPOP3ResponseName ( const char *inName )
{
	uInt32		strLen	= 0;

	if ( inName != nil )
	{
		strLen = ::strlen( inName );
		if ( strLen > kStrSize - 1 )
		{
			strLen = kStrSize - 1;
		}
		::memset( fServerPrefsData.fPrefsData.fPOP_Greeting, 0, kStrSize );
		::strncpy( fServerPrefsData.fPrefsData.fPOP_Greeting, inName, strLen );

		this->SetDirty();
	}
} // SetPOP3ResponseName


//--------------------------------------------------------------------------------------------------
//	* GetIMAPResponseName
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::GetIMAPResponseName ( CString &outName )
{
	uInt32		strLen	= 0;
	const char *pStr	= nil;

	outName.Clear();

	if ( fServerPrefsData.fPrefsData.fIMAP_Greeting[ 0 ] == '\0' )
	{
	}
	else
	{
		outName.Set( fServerPrefsData.fPrefsData.fIMAP_Greeting );
	}
} // GetIMAPResponseName


//--------------------------------------------------------------------------------------------------
//	* SetIMAPResponseName
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetIMAPResponseName ( const char *inName )
{
	uInt32		strLen	= 0;

	if ( inName != nil )
	{
		strLen = ::strlen( inName );
		if ( strLen > kStrSize - 1 )
		{
			strLen = kStrSize - 1;
		}
		::memset( fServerPrefsData.fPrefsData.fIMAP_Greeting, 0, kStrSize );
		::strncpy( fServerPrefsData.fPrefsData.fIMAP_Greeting, inName, strLen );

		this->SetDirty();
	}
} // SetIMAPResponseName


//----------------------------------------------------------------------------------
// * IsProtocolOn()
//
//		- returns the prefs whether this listener is turned on
//
// ---------------------------------------------------------------------------------

Boolean CServerPrefs_10_1::IsProtocolOn ( uInt32 inWhichProtocolType )
{
	return( 0 );
} //IsProtocolOn


//----------------------------------------------------------------------------------
// * SetProtocolState ()
//
//	- Sets the state (on or off) of the protocl in server preferences
// ---------------------------------------------------------------------------------

void CServerPrefs_10_1::SetProtocolState ( uInt32 inWhichProtocolType, Boolean inState )
{
} //SetProtocolState


//--------------------------------------------------------------------------------------------------
//	* IsPOP3_On
//
//--------------------------------------------------------------------------------------------------

Boolean CServerPrefs_10_1::IsPOP3_On ( void )
{
	return( fServerPrefsData.fPrefsData.fPOP_Enabled );

} // IsPOP3_On


//--------------------------------------------------------------------------------------------------
//	* IsSMTP_On
//
//--------------------------------------------------------------------------------------------------

Boolean CServerPrefs_10_1::IsSMTP_On ( void )
{
	return( fServerPrefsData.fPrefsData.fSMTP_InEnabled );

} // IsSMTP_On


//--------------------------------------------------------------------------------------------------
//	* IsIMAP_On
//
//--------------------------------------------------------------------------------------------------

Boolean CServerPrefs_10_1::IsIMAP_On ( void )
{
	return( fServerPrefsData.fPrefsData.fIMAP_Enabled );

} // IsIMAP_On


//--------------------------------------------------------------------------------------------------
//	* IsNotifyMail_On
//
//--------------------------------------------------------------------------------------------------

Boolean CServerPrefs_10_1::IsNotifyMail_On ( void )
{
	return( fServerPrefsData.fPrefsData.fNotifyMail_Enabled );

} // IsNotifyMail_On


//--------------------------------------------------------------------------------------------------
//	* IsAdminPort_On
//
//--------------------------------------------------------------------------------------------------

Boolean CServerPrefs_10_1::IsAdminPort_On ( void )
{
	return( fServerPrefsData.fPrefsData.fAdminPort_Enabled );

} // IsAdminPort_On


//--------------------------------------------------------------------------------------------------
//	* ForwardToAnyUser
//
//--------------------------------------------------------------------------------------------------

Boolean CServerPrefs_10_1::ForwardToAnyUser ( void )
{
	return( fServerPrefsData.fPrefsData.fMSPStdMailInForwardMailForUnknownLocalUsersChk );

} // ForwardToAnyUser


//--------------------------------------------------------------------------------------------------
//	* IsHoldMailOn
//
//--------------------------------------------------------------------------------------------------

Boolean CServerPrefs_10_1::IsHoldMailOn ( void )
{
	return( fServerPrefsData.fPrefsData.fMSPStdMailOutHoldOutgoingMailBtn );

} // IsHoldMailOn


//--------------------------------------------------------------------------------------------------
//	* CantCreateLocalHosts
//
//--------------------------------------------------------------------------------------------------

Boolean CServerPrefs_10_1::CantCreateLocalHosts ( void )
{
	return( fServerPrefsData.fPrefsData.fMSPStdMailInDontAllowAutoHostEntryCreationChk );

} // CantCreateLocalHosts


//--------------------------------------------------------------------------------------------------
//	* LocalFromMustExist
//
//--------------------------------------------------------------------------------------------------

Boolean CServerPrefs_10_1::LocalFromMustExist ( void )
{
	return( fServerPrefsData.fPrefsData.fLocalFromMustExist );

} // LocalFromMustExist


//--------------------------------------------------------------------------------------------------
//	* GetBCCUserID
//
//--------------------------------------------------------------------------------------------------

uInt32 CServerPrefs_10_1::GetBCCUserID ( void )
{
	return( fServerPrefsData.fPrefsData.fBCC_UserInfo.fID );
//	return (fServerPrefsData.fPrefsData.fMSPStdMailInSendBCCToUandGID);
} // GetBCCUserID

//--------------------------------------------------------------------------------------------------
//	* GetForwardAnyUserID
//
//--------------------------------------------------------------------------------------------------

uInt32 CServerPrefs_10_1::GetForwardAnyUserID ( void )
{
	return ( fServerPrefsData.fPrefsData.fFWDUnknownLocalUserInfo.fID );
//	return ( fServerPrefsData.fPrefsData.fMSPStdMailInForwardMailForUnknownLocalUsersUandGID );
} // GetForwardAnyUserID


//--------------------------------------------------------------------------------------------------
//	* GetBCCName
//
//--------------------------------------------------------------------------------------------------

Boolean CServerPrefs_10_1::GetBCCName ( CString &outStr )
{
	Boolean		bResult		= false;

	if ( (fServerPrefsData.fPrefsData.fBCC_UserInfo.fID != 0) &&
		 (fServerPrefsData.fPrefsData.fBCC_UserInfo.fUserName[ 0 ] != 0) )
	{
		outStr.Set( &fServerPrefsData.fPrefsData.fBCC_UserInfo.fUserName[ 1 ],
					fServerPrefsData.fPrefsData.fBCC_UserInfo.fUserName[ 0 ] );
		bResult = true;
	}

	return( bResult );
	
} // GetBCCName


//--------------------------------------------------------------------------------------------------
//	* GetAnyUserName
//
//--------------------------------------------------------------------------------------------------

Boolean CServerPrefs_10_1::GetAnyUserName ( CString &outStr )
{
	Boolean		bResult		= false;

	if ( (fServerPrefsData.fPrefsData.fFWDUnknownLocalUserInfo.fID != 0) &&
		 (fServerPrefsData.fPrefsData.fFWDUnknownLocalUserInfo.fUserName[ 0 ] != 0) )
	{
		outStr.Set( &fServerPrefsData.fPrefsData.fFWDUnknownLocalUserInfo.fUserName[ 1 ],
					fServerPrefsData.fPrefsData.fFWDUnknownLocalUserInfo.fUserName[ 0 ] );

		bResult = true;
	}

	return( bResult );

} // GetAnyUserName


//--------------------------------------------------------------------------------------------------
//	* IsExpireMessagesOn
//
//--------------------------------------------------------------------------------------------------

Boolean CServerPrefs_10_1::IsExpireMessagesOn ( void )
{
	return ( fServerPrefsData.fPrefsData.fAutoMailDeleteFlag == true );

} // IsExpireMessagesOn


//--------------------------------------------------------------------------------------------------
//	* GetExpireSeenMsgs
//
//--------------------------------------------------------------------------------------------------

uInt32 CServerPrefs_10_1::GetExpireSeenMsgs ( void )
{
	return ( fServerPrefsData.fPrefsData.fDeleteSeenDays );

} // GetExpireSeenMsgs


//--------------------------------------------------------------------------------------------------
//	* GetExpireUnSeenMsgs
//
//--------------------------------------------------------------------------------------------------

uInt32 CServerPrefs_10_1::GetExpireUnSeenMsgs ( void )
{
	return ( fServerPrefsData.fPrefsData.fDeleteUnseenDays );

} // GetExpireUnSeenMsgs


//--------------------------------------------------------------------------------------------------
//	* IsCaseSensitiveOn
//
//--------------------------------------------------------------------------------------------------

Boolean CServerPrefs_10_1::IsCaseSensitiveOn ( void )
{
	return ( fServerPrefsData.fPrefsData.fCaseSensativeFldrNameFlag );

} // IsCaseSensitiveOn


//--------------------------------------------------------------------------------------------------
//	* SendBulkNDRs
//
//--------------------------------------------------------------------------------------------------

Boolean CServerPrefs_10_1::SendBulkNDRs ( void )
{
	return ( fServerPrefsData.fPrefsData.fMSPAdvMiscFlagsByte1 & kMSSFSendBulkNDRsChk );

} // SendBulkNDRs


//--------------------------------------------------------------------------------------------------
//	* FwdBadNDRsToPostmaster
//
//--------------------------------------------------------------------------------------------------

Boolean CServerPrefs_10_1::FwdBadNDRsToPostmaster ( void )
{
	return ( fServerPrefsData.fPrefsData.fMSPAdvMiscFlagsByte1 & kMSSFFwdAllUndelivNDRsToPMChk );

} // FwdBadNDRsToPostmaster


//--------------------------------------------------------------------------------------------------
//	* VerifySMTPInConnections
//
//--------------------------------------------------------------------------------------------------

Boolean CServerPrefs_10_1::VerifySMTPInConnections ( void )
{
	return ( 0 );
} // VerifySMTPInConnections


//--------------------------------------------------------------------------------------------------
//	* RejectBadSMTPInConnections
//
//--------------------------------------------------------------------------------------------------

Boolean CServerPrefs_10_1::RejectBadSMTPInConnections ( void )
{
	return ( 0 );
} // RejectBadSMTPInConnections


//--------------------------------------------------------------------------------------------------
//	* IngoreAntiSPAMIfRelay
//
//--------------------------------------------------------------------------------------------------

Boolean CServerPrefs_10_1::IngoreAntiSPAMIfRelay ( void )
{
	return ( (fServerPrefsData.fPrefsData.fMSPAdvMiscFlagsByte1 & kMSSFBackupServerModeChk ) != 0);
} // IngoreAntiSPAMIfRelay


//--------------------------------------------------------------------------------------------------
//	* DeleteDefaultHosts
//
//--------------------------------------------------------------------------------------------------

Boolean CServerPrefs_10_1::DeleteDefaultHosts ( void )
{
	return ( (fServerPrefsData.fPrefsData.fMSPAdvMiscFlagsByte1 & kMSSFDeleteAllEmptyDefaultHostsChk) != 0 );

} // DeleteDefaultHosts


//--------------------------------------------------------------------------------------------------
//	* GetIMAPIdleTime
//
//--------------------------------------------------------------------------------------------------

uInt32 CServerPrefs_10_1::GetIMAPIdleTime ( void )
{
	return ( fServerPrefsData.fPrefsData.fIMAPConnIdleTimeout );

} // GetIMAPIdleTime


//--------------------------------------------------------------------------------------------------
//	* GetMaxIMAPConnections
//
//--------------------------------------------------------------------------------------------------

uInt32 CServerPrefs_10_1::GetMaxIMAPConnections ( void )
{
	return ( fServerPrefsData.fPrefsData.fConnPerIMAPAcctPerIP );

} // GetMaxIMAPConnections


// The following are extracted from CServerPrefs2 and combined into CServerPrefs_10_1
//--------------------------------------------------------------------------------------------------
//	* SetDoRBLSMTPConnFlag
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetDoRBLSMTPConnFlag ( const Boolean inConnFlag )
{
}

//--------------------------------------------------------------------------------------------------
//	* GetDoRBLSMTPConnFlag ()
//
//--------------------------------------------------------------------------------------------------

Boolean	CServerPrefs_10_1::GetDoRBLSMTPConnFlag ( void )
{
	return( 0 );
}
	

//--------------------------------------------------------------------------------------------------
//	* SetUseCustomRBLDomainFlag ()
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetUseCustomRBLDomainFlag ( const Boolean inCustRBLDomainFlag )
{
}

//--------------------------------------------------------------------------------------------------
//	* GetUseCustomRBLDomainFlag
//
//--------------------------------------------------------------------------------------------------

Boolean	CServerPrefs_10_1::GetUseCustomRBLDomainFlag ( void )
{
	return( 0 );
}
	

//--------------------------------------------------------------------------------------------------
//	* SetFullHostListCheck
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetFullHostListCheck ( const Boolean	inFullHostListChkFlag )
{
}

//--------------------------------------------------------------------------------------------------
//	* GetFullHostListCheck ()
//
//--------------------------------------------------------------------------------------------------

Boolean	CServerPrefs_10_1::GetFullHostListCheck ( void )
{
	return( 0 );
}
	

//--------------------------------------------------------------------------------------------------
//	* SetCustomRBLDomainName
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetCustomRBLDomainName ( CString	&inName	)
{
	if ( inName.GetLength() != 0 )
	{
		if ( ::strcmp( inName.GetData(), (char *)this->fServerPrefsData.fRBLAlternateDomainName ) != 0 )
		{
			::strcpy( (char *)this->fServerPrefsData.fRBLAlternateDomainName, inName.GetData() );
			this->SetDirty();
		}
	}
} // SetCustomRBLDomainName


//--------------------------------------------------------------------------------------------------
//	* GetCustomRBLDomainName
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::GetCustomRBLDomainName ( CString	&outName )
{
	sInt32		len = 0;

	outName.Clear();

	len = ::strlen( fServerPrefsData.fPrefsData.fCustomSpamSrvr );
	if ( len > 0 )
	{
		outName.Set( fServerPrefsData.fPrefsData.fCustomSpamSrvr, len );
	}
	else
	{
		outName.Set( "rbl.maps.vix.com" );
	}
} // GetCustomRBLDomainName


//--------------------------------------------------------------------------------------------------
//	Directory Services stuff
//
//--------------------------------------------------------------------------------------------------


Boolean	CServerPrefs_10_1::IsExpireUGAtStartupOn ( void ) const
{
	return fServerPrefsData.fPrefsData.fMSPDSExpireCacheUGAtStartupChk;
}


void CServerPrefs_10_1::SetExpireUGAtStartup	( const Boolean inFlag )
{
	if (fServerPrefsData.fPrefsData.fMSPDSExpireCacheUGAtStartupChk != inFlag)
	{
		fServerPrefsData.fPrefsData.fMSPDSExpireCacheUGAtStartupChk = inFlag;
		this->SetDirty();
	}
}
uInt32 CServerPrefs_10_1::GetUGTTLDelta ( void ) const
{
	return fServerPrefsData.fPrefsData.fMSPDSTimeToLive ;
}

void CServerPrefs_10_1::SetUGTTLDelta	( const uInt32 inTime)
{
	if (fServerPrefsData.fPrefsData.fMSPDSTimeToLive != inTime)
	{
		fServerPrefsData.fPrefsData.fMSPDSTimeToLive = inTime;
		this->SetDirty();
	}
}


//--------------------------------------------------------------------------------------------------
//	* SetPrefsFlags  (was SetPrefs2Flags)
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::SetPrefsFlags ( uInt32 inFlags )
{
	
	if ( this->fServerPrefsData.fServerPrefsFlags != inFlags )
	{
		this->fServerPrefsData.fServerPrefsFlags = inFlags;
		this->SetDirty();
	}
} // SetPrefsFlags


//--------------------------------------------------------------------------------------------------
//	* DoSendmailRules ()
//
//--------------------------------------------------------------------------------------------------

void CServerPrefs_10_1::DoSendmailRules ( void )
{
}



