/*
	$Id: CMimePart.h,v 1.1 2003/04/20 23:30:51 dasenbro Exp $

	File:		CMimePart.h

	Contains:	C++ Class definition of a Blob-based message part

	Version:	Apple Mail Server - Mac OS X :  $Revision: 1.1 $

	Written by:	Michael Dasenbrock

	Copyright:	 1996-2001 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: CMimePart.h,v $
		Revision 1.1  2003/04/20 23:30:51  dasenbro
		Initial check-in.
		
		Revision 1.7  2002/03/21 16:41:32  dasenbro
		Updated file version information.
		
		Revision 1.6  2001/06/21 19:37:41  dasenbro
		Added Change History.
		

	Projector History:

	  <ASM2>	 1/24/99	MED		Added DecLastPart.

	To Do:
*/

#ifndef __CMimePart_h__
#define __CMimePart_h__ 1

#include "MailTypes.h"

class CMimePart
{
public:
				CMimePart				( void );
	virtual	   ~CMimePart				( void );

	Boolean		GetIsText				( void );
	void		SetIsText				( Boolean inIsText );

	uInt32		GetMsgPartID			( void );
	void		SetMsgPartID			( uInt32 inMessagePartID );

	uInt32		GetOffset				( void );
	void		SetOffset				( uInt32 inOffset );

	uInt32		GetLength				( void );
	void		SetLength				( uInt32 inLength );

	uInt32		GetLineCount			( void );
	void		SetLineCount			( uInt32 inLineCount );

	char*		GetPartNumStr			( void );

	void		IncLastPart				( void );
	void		DecLastPart				( void );

	void		ZeroLastSubPart			( void );
	void		IncNextBasePart			( void );
	void		SetMimePartNumber		( void );

	enum {
		kMaxMimeParts	= 16,
		kMaxPartLen		= 32
	};

private:
	Boolean		fIsText;
	uInt32		fMsgPartNum;
	uInt32		fPartOffset;
	uInt32		fPartLength;
	uInt32		fLineCount;

	uInt16		fBaseParts[ kMaxMimeParts ];
	char		fBaseStr[ kMaxPartLen ];
};


#endif // __CMimePart_h__
