/*
	$Id: COSUtils.h,v 1.2 2003/04/23 16:08:10 dasenbro Exp $

	File:	COSUtils.h

	Contains: Various OS Utilities

	Version:	Apple Mail Server - Mac OS X :  $Revision: 1.2 $

	Written by: Michael Dasenbrock

	Copyright:	 1996-2001 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: COSUtils.h,v $
		Revision 1.2  2003/04/23 16:08:10  dasenbro
		Removed calls to LogViewer.
		
		Revision 1.1  2003/04/20 23:29:40  dasenbro
		Initial check-in.
		
		Revision 1.14  2002/05/09 16:59:04  dasenbro
		Changed all str... calls to CUtils::Str... to be NULL safe.
		
		Revision 1.13  2002/04/21 16:26:57  dasenbro
		Moved LogViewer calls to utils and added DoesFileExist() for simple
		file check.
		
		Revision 1.12  2002/04/18 18:09:16  dasenbro
		Changed bool to Bool for word alignment.
		
		Revision 1.11  2002/04/15 21:27:52  dasenbro
		Added CreateAndVerifyPath() for folder verification and creation..
		
		Revision 1.10  2002/03/21 16:41:47  dasenbro
		Updated file version information.
		
		Revision 1.9  2002/02/20 20:38:58  dasenbro
		Added DoesDirectoryExist() and GetOldFullDBPath().
		
		Revision 1.8  2002/01/14 17:05:05  dasenbro
		Initial S4 updates.
		
		Revision 1.7  2001/07/09 15:36:49  dasenbro
		Added GetMailLogFolder() to move the mail logs to their own folder.
		
		Revision 1.6  2001/06/21 20:44:01  dasenbro
		Added Change History.
		

	Projector History:

		 <7>	 4/28/98	MED		Added GetDBCachePercentage to get, well you guessed it, the DB
									Cache Percentage.
		 <6>	 3/29/98	MED		Added GetNameToDirID().
		 <5>	 3/11/98	MED		Added GetGMT().
		 <4>	 2/23/98	MED		Added GetMaxIMAPConnections() to get the max number of
									connections per IMAP user login.
		 <3>	 2/13/98	DOR		Return boolean in GetASDUser to indicate success or fail.
		 <2>	  2/9/98	MED		Added GetASDUserOrGroupName().
		 <1>	  2/3/98	MED		first checked in

	To Do:
 */


#ifndef __OSUTIL_H
#define __OSUTIL_H 1

// App
#include "CString.h"
#include "CStatMgr.h"

// Utils
#include "MailTypes.h"


// consts -----------------------------------------------------------------------

const uInt32	kMaxConnTimeTCP_ResID		= 128;
const uInt32	kMaxAttemptTimeTCP_ResID	= 128;
const sInt32	kMachineStrID				= -16413;	// Sharing setup machine ID

// ---------------------------------------------------------------------------
//		* Constants
// ---------------------------------------------------------------------------

// Resource ID of string in prefs data file holding path of data folder

// enums ------------------------------------------------------------------------

typedef enum {
	kADSPAsyncTimeout	= 'adsp',
	kTCPAsyncTimeout	= 'tcp '
} TimeoutSelector;


typedef enum {
	kDevelopment 	= 0x20,							
	kAlpha 			= 0x40,
	kBeta 			= 0x60,
	kFinal 			= 0x80
} ReleaseStage;


// structs ----------------------------------------------------------------------

typedef struct
{
	uInt16 version;
	uInt16 maxAliasCount;
	uInt16 refreshInterval;
} AliasCachePrefs;


typedef struct
{
	uInt16 version;
	uInt16 pop3BatchLimit;
} POP3BatchLimit;


typedef struct
{
	uInt16 version;
	uInt16 maxRCPTCount;
} MaxRCPTCount;


typedef struct
{
	uInt16	version;
	uInt16	maxTime;
} MaxTime, *MaxTimePtr, **MaxTimeHndl;


typedef struct
{
	uInt16 adspAsyncTimeout;
	uInt16 tcpAsyncTimeout;
} Timeouts;


typedef struct
{
	uInt8 major;
	uInt8 minor;
	uInt8 stage;
	uInt8 substage;
	// there's more, but we don't care
} VersStruct;


class COSUtils
{
public:
    static	void			InitializeGlobals				( void );
	static	void			GetMachineName					( char *outBuffer );
	static	void			GetGMT							( char *eastWest, sInt32 *inDeltaMin, sInt32 *inDeltaHr );
	static	uInt16			GetPOP3ContextBatchLimit		( void );
	static	uInt16			GetMaxConnectTime				( uInt32 inResID );
	static	uInt16			GetMaxRCPTCount					( void );
	static	uInt16			GetMaxTimeAttempt				( uInt32 inResID );
	static	CString&		GetAppNameAndVers				( void );
	static	CString&		GetShortVersion					( void );
	static	const char*		GetDBRootPath					( void );
	static	const char*		GetDBFolder						( void );
	static	const char*		GetFullDBPath					( void );
	static	const char*		GetOldFullDBPath				( void );
	static	const char*		GetDefaultDBPath				( void );
	static	void			SetDefaultDBPath				( const char *inStr );
	static	const char*		GetCurrentDayFolder				( void );
	static	const char*		GetTargetFolder					( void );
	static	void			SetTargetFolder					( uInt32 inNumber );
	static	const char*		GetFullMailFolderPath			( void );
	static	const char*		GetMailStoreFolderPath			( void );
	static	const char*		GetDailyMailStoreFolderPath		( void );
	static	const char*		GetCurrentMailStoreFolderPath	( void );
	static	const char*		GetFullAccountFolderPath		( void );
	static	const char*		GetLogFileFolder				( void );
	static	const char*		GetMailLogFolder				( void );
	static	const char*		GetMigrationFolder				( void );
	static	const char*		GetConfigFolder					( void );
	static	const char*		GetTempFolder					( void );

	static	sInt32			VerifyDirectory					( const char *inPath );
	static	sInt32			CreateAndVerifyPath				( const char *inPath, uid_t inUID, gid_t inGID, mode_t inPermission, bool inCreateAll = true );
	static	sInt32			CreateDirectory					( const char *inPath, uid_t inUID, gid_t inGID, mode_t inPermission );

	static	long long		GetFileSystemFreeSpace			( const char *inFSName );
	static	bool			DoesDirectoryExist				( const char *inDirName );
	static	bool			DoesFileExist					( const char *inPathName );
	static	bool			IsDirectoryWritable				( const char *inDirName );
	static	sInt32			GetUID							( const char *inUserName );
	static	bool			AuthenticateUser				( const char *inUserName, const char *inPasswd );
	static	int				DateString						( long dateTime, MSDateForm longFlag, Str255 outResult );
	static	int				TimeString						( long dateTime, bool wantSeconds, Str255 outResult );
	static	int				DateTimeString					( long dateTime, MSDateForm longFlag, Str255 outResult );

	static	uInt32			CountEntires					( const char *inPath );
	static	const char*		FindCurrentFolder				( void );
	static	void			CreateNewCurrentFolder			( void );
	static	CString*		GetPath							( CString &inPath, uid_t inUID, gid_t inGID, mode_t inPermission );

protected:
	static	void			Signal							( void );
	static ExceptionCode	Wait ( sInt32 milliSecs = 0 );

	static	char	   *fDBRootPath;
	static	char	   *fStaticDBFolder;
	static	char	   *fStaticMailFolder;
	static	char	   *fStaticMailStoreFolder;
	static	char	   *fStaticDailyMailStoreFolder;
	static	char	   *fStaticCurrentMailStoreFolder;
	static	char	   *fStaticCurrentMailStorePath;
	static	char	   *fStaticDateFolder;
	static	char	   *fStaticTargetFolder;
	static	char	   *fStaticAccountsFolder;
	static	char	   *fStaticTempFolder;
	static	char	   *fFullDBPath;
	static	char	   *fFullOldDBPath;
	static	char	   *fDefaultDBPath;
	static	char	   *fLogFileFolder;
	static	char	   *fMailLogFolder;
	static	char	   *fMigrationFolder;
	static	char	   *fConfigFolder;

	static	uInt32		fDay;
	static	uInt32		fMonth;

};

#endif // __OSUTIL_H
