/*
	$Id: CGlobals.h,v 1.2 2003/07/22 18:43:38 dasenbro Exp $

	File: CGlobals.h

	Contains: Static application globals

	Version:	Apple Mail Server - Mac OS X :  $Revision: 1.2 $

	Copyright:	 1996-2001 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: CGlobals.h,v $
		Revision 1.2  2003/07/22 18:43:38  dasenbro
		Mark messages that have been migrated.
		
		Revision 1.1  2003/04/20 23:25:37  dasenbro
		Initial check-in.
		
		Revision 1.15  2002/05/20 21:44:16  dasenbro
		Added reset TOC calls.
		
		Revision 1.14  2002/05/09 16:58:53  dasenbro
		Changed all str... calls to CUtils::Str... to be NULL safe.
		
		Revision 1.13  2002/04/18 18:09:08  dasenbro
		Changed bool to bool for word alignment.
		
		Revision 1.12  2002/03/21 16:40:01  dasenbro
		Added network transition globals.
		
		Revision 1.11  2002/03/11 23:47:09  dasenbro
		Added host pref globals.
		
		Revision 1.10  2002/02/20 21:24:58  dasenbro
		Added routines from MailAdminHooks.h.
		
		Revision 1.9  2001/07/25 18:59:27  dasenbro
		Set a min disk space KB const.
		
		Revision 1.8  2001/06/21 20:50:49  dasenbro
		Updated file header info.
		
		Revision 1.7  2001/06/21 16:25:50  dasenbro
		Added new const.
		
		Revision 1.6  2001/05/23 22:32:35  dasenbro
		New project stuff.
		
		Revision 1.5  2001/05/23 22:10:17  dasenbro
		Added kMaxGroupMembership for ACL support.
		
		01/11/01	ANC		Created by root on Thu Jan 11 2001

	To Do:

*/


#ifndef __CGlobals_h__
#define __CGlobals_h__ 1

#include "MailTypes.h"
#include "UException.h"

class	CProtocol;
class	LEventSemaphore;

const uInt32	kMaxConnList		= 1024;
const uInt32	kReservedConst		= 0xFF00FF00;
const uInt32	kMigratedConst		= 0x00FF00FF;
const uInt32	kMaxGroupMembership	= 256;
const uInt32	kFreeDiskSpaceKB	= 2 * 1024;		// 2 Meg min fee space

typedef struct ConnList ConList;
typedef struct ConnList
{
	uInt32		fCount;
	CProtocol  *fList[ kMaxConnList ];
	ConList	   *fNext;
} ConnList;


class CGlobals
{
public:
typedef enum {
	kAppRunning			= 0x8088,
	kAppStopNow			= 0x808A
} eAppState;

	static	bool			QuitNow						( void );
	static	void			SetAppQuit					( void );

	static	bool			GetRepairDB					( void );
	static	void			SetRepairDB					( bool inState );

	static	bool			GetImport					( void );
	static	void			SetImport					( bool inState );

	static	bool			GetExport					( void );
	static	void			SetExport					( bool inState );

	static	bool			GetMigrate					( void );
	static	void			SetMigrate					( bool inState );

	static	bool			GetReadHostPrefs			( void );
	static	void			SetReadHostPrefs			( bool inState );

	static	bool			GetReadServerPrefs			( void );
	static	void			SetReadServerPrefs			( bool inState );

	static	bool			GetReadRelayList				( void );
	static	void			SetReadRelayList			( bool inState );

	static	bool			GetReadSMTPReject			( void );
	static	void			SetReadSMTPReject			( bool inState );

	static	bool			GetNetTransition			( void );
	static	void			SetNetTransition			( bool inState );

	static	uInt32			GetTOCResetValue			( void );
	static	void			SetTOCResetValue			( const uInt32 inValue );

	static	void			AddConnection				( CProtocol *inConnection );
	static	void			RemoveConnection			( CProtocol *inConnection );
	static	uInt32			KillAllConnections			( void );

	static	uInt32			GetCurrentMessageCount		( void );
	static	void			SetCurrentMessageCount		( uInt32 inCount );
	static	void			IncrementCurMsgCount		( void );
protected:

private:

	static	eAppState	sDieGasPumper;
	static	bool		sRepairDB;
	static	bool		sImport;
	static	bool		sExport;
	static	bool		sMigrate;
	static	bool		sReadHostPrefs;
	static	bool		sReadServerPrefs;
	static	bool		sReadRelay;
	static	bool		sReadReject;
	static	bool		sNetTransition;

	static	uInt32		sTOCResetValue;
	static	uInt32		sMsgCount;

	static	ConnList	*sConnList;
};

#endif // __CGlobals_h__
