/*
	$Id: CIDTable.cpp,v 1.1 2003/04/20 23:32:51 dasenbro Exp $

	File:		CIDTable.cpp

	Contains:	xxx put contents here xxx

	Version:	Apple Mail Server - Mac OS X :  $Revision: 1.1 $

	Written by:	David O'Rourke

	Copyright:	 1996-2001 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Notes:

		// *********************************************************************************
		// Warning: DO NOT CHANGE/ADD/REMOVE PUBLIC/PRIVATE DATA FIELDS TO THIS CLASS/STRUCT
		// WITHOUT CONSULTING WITH A APPLE MAIL TEAM MEMBER.  CHANGES TO
		// THIS STRUCTURE __WILL__ CAUSE FILE FORMAT COMPATIBILITY ISSUES FOR APPLESHARE IP 5.0
		// AND 6.0 MAIL DATABASES.
		//
		// FAILURE TO HEED THIS WARNING __WILL__ LEAD TO DATA LOSS
		// AND/OR CRASHING BUGS WHEN CUSTOMERS ATTEMPT TO USE YOUR SIMPLE MODIFICATIONS WITH
		// A PRE-EXISTING MAIL DATABASE.
		//
		// SINCE THIS FILE IS SHARED BY MORE COMPONENTS THAN JUST YOURS, PLEASE BE AWARE OF THE
		// C++ FRAGILE BASE CLASS PROBLEM AND DON'T MAKE CHANGES IN THE BASE CLASS SOURCE CODE
		// WITH OUT CONSULTING OTHER SOURCES THAT ARE DEPENDANT ON THIS STURUCTURE.
		// *********************************************************************************


	Change History:

		$Log: CIDTable.cpp,v $
		Revision 1.1  2003/04/20 23:32:51  dasenbro
		Initial check-in.
		
		Revision 1.11  2002/03/21 16:41:17  dasenbro
		Updated file version information.
		
		Revision 1.10  2001/06/21 20:50:53  dasenbro
		Updated file header info.
		
		Revision 1.9  2001/06/21 17:01:16  dasenbro
		Added Change History.
		

	Projector History:

	  <ASX3>	  6/4/99	DOR		Sanity checking code.
		 <2>	  4/2/98	DOR		Make reset objectID work correctly.

	To Do:
*/


#include <string.h>

#include "CIDTable.h"


CIDTable::CIDTable ( const OSType inTableType, const uInt32 inEntrySize )
{
	// *********************************************************************************
	// Warning: DO NOT CHANGE/ADD/REMOVE PUBLIC/PRIVATE DATA FIELDS TO THIS CLASS/STRUCT
	// WITHOUT CONSULTING WITH A APPLESHARE IP MAIL TEAM MEMBER.  CHANGES TO
	// THIS STRUCTURE __WILL__ CAUSE FILE FORMAT COMPATIBILITY ISSUES FOR APPLESHARE IP 5.0
	// AND 6.0 MAIL DATABASES.
	//
	// FAILURE TO HEED THIS WARNING __WILL__ LEAD TO DATA LOSS
	// AND/OR CRASHING BUGS WHEN CUSTOMERS ATTEMPT TO USE YOUR SIMPLE MODIFICATIONS WITH
	// A PRE-EXISTING MAIL DATABASE.
	//
	// SINCE THIS FILE IS SHARED BY MORE COMPONENTS THAN JUST YOURS, PLEASE BE AWARE OF THE
	// C++ FRAGILE BASE CLASS PROBLEM AND DON'T MAKE CHANGES IN THE BASE CLASS SOURCE CODE
	// WITH OUT CONSULTING OTHER SOURCES THAT ARE DEPENDANT ON THIS STURUCTURE.
	// *********************************************************************************

	::memset( &fTempHeader, 0, sizeof( SIDTableHeader ) );

	fTempHeader.fDataTableVersion = kCIDTableVersion;
	fTempHeader.fTableType = inTableType;
	fTempHeader.fDataSize = inEntrySize;
	long *temp = (long *) this;
	fTempHeader.fSanityValue = *temp;

	this->SetTable(NULL, 0);
	this->ClearIDTable();
	
	CIDTable::CheckBackwardCompatibility();
}

void CIDTable::CheckBackwardCompatibility ( void )
{
	//*************************************************************************************************
	// if any of these checks cause a debugger break, then some change has caused the binary size of
	// these data types to be different than what was shipped with AppleShare IP 5.0 & 6.0....
	// this means that there will be data-loss or crashing bugs with this version of CIDTable since
	// portions of CIDTable have been written to disk in their native binary format....
//	CIDTable::ReportBackwardCompatibility(sizeof(ObjID),			4);		// NOTE: this is hard coded for a reason!!
//	CIDTable::ReportBackwardCompatibility(sizeof(PageID),			4);		// NOTE: this is hard coded for a reason!!
//	CIDTable::ReportBackwardCompatibility(sizeof(SIDTableHeader),	40);	// NOTE: this is hard coded for a reason!!
//	CIDTable::ReportBackwardCompatibility(kMaxIDTableSize,			8152);	// NOTE: this is hard coded for a reason!!
//	CIDTable::ReportBackwardCompatibility(kStandardPageSize,		8192);	// NOTE: this is hard coded for a reason!!
//	CIDTable::ReportBackwardCompatibility(sizeof(SIDTable),			8192);	// NOTE: this is hard coded for a reason!!
}

uInt32 CIDTable::GetEntryMaxByteSize ( void )
{
	return (kMaxIDTableSize - sizeof(ObjID));
}

void CIDTable::ReportBackwardCompatibility ( const uInt32 curSize, const uInt32 correctSize )
{
	if (curSize != correctSize)
	{
//		DebugStr("\pWARNING: CIDTable Base Class data element size problem.  Potential File format compatibility problem detected!");
	}
}

CIDTable::~CIDTable ( void )
{
	long *temp = (long *) this;
// xxxxx	BaseDBAssert(fTempHeader.fSanityValue == *temp);
	this->ClearIDTable();
	fPageID = 0;
	fIDTablePtr = NULL;
}

OSStatus CIDTable::SetTable ( void *inTablePtr, const PageID inPageID )
{
	fPageID = inPageID;
	fIDTablePtr = (SIDTable *) inTablePtr;
	
	return kIDTableNoErr;
}

		
OSStatus CIDTable::AddID2List ( const ObjID inEntryID, const void *inEntryData, Boolean allowNewMin, Boolean allowNewMax )
{
	OSStatus	result = kIDTableNoErr;
	uInt32		anIndex;
	ObjID		anID;
	Boolean		doInsertFlag = true;
	
	this->SanityCheck();

	if (this->GetEntryCount() < this->GetEntryMaxCount())
	{
		result = this->FindEntry(inEntryID, anIndex);
		if (result != kIDTableNoErr)
		{
			if (anIndex != kCIDNullIndex)
			{
				result = this->GetEntry(anIndex, anID);
				if (anID == inEntryID)
				{	// this should never happen, but it's here just in case....
					BaseDBAssert(anID != inEntryID);	// drop into the debugger to bring it to someone's attention...
					result = kIDTableDuplicateObject;
				}
				else if (anID < inEntryID)
				{
					anIndex += 1;
				}

				if ((inEntryID < this->GetEntryIDMin()) && (allowNewMin == false))
				{
					result = kIDNewMinNotAllowed;
					doInsertFlag = false;
				}
				
				if ((inEntryID > this->GetEntryIDMax()) && (allowNewMax == false))
				{
					result = kIDNewMaxNotAllowed;
					doInsertFlag = false;
				}
			}
			else
			{	// this should only occur when the table is empty...otherwise we've always found a match...
				anIndex = this->GetEntryCount();
				BaseDBAssert(anIndex == 0);
			}
			
			if (doInsertFlag)
			{
				result = this->InsertEntry(anIndex, inEntryID, inEntryData);
			}
		}
		else
		{
			result = kIDTableDuplicateObject;
		}
	}
	else
	{
		result = kIDTableFull;
	}

	this->SanityCheck();
	
	return result;
}

OSStatus CIDTable::RemoveIDFromList ( const ObjID inEntryID )
{
	OSStatus	result = kIDTableNoErr;
	uInt32		anIndex;
	
	this->SanityCheck();
	
	result = this->FindEntry(inEntryID, anIndex);
	if (result == kIDTableNoErr)
	{
		this->DeleteEntry(anIndex);
	}
	
	this->SanityCheck();
	
	return result;
}

OSStatus CIDTable::FindEntry ( const ObjID inEntryID, uInt32 &outEntryIndex )
{
	OSStatus	result = kIDTableNoSuchObject;
	uInt32		index = 0;
	long		high = 0;
	long		low = 0;
	ObjID		anID;
	Boolean		done = false;
	
	this->SanityCheck();

	outEntryIndex = kCIDNullIndex;
	
	if ((this->GetEntryCount() > 0) && (fIDTablePtr != NULL))
	{
		if ((inEntryID >= this->GetEntryIDMin()) && (inEntryID <= this->GetEntryIDMax()))
		{
			if (inEntryID == this->GetEntryIDMin())
			{
				outEntryIndex = 0;
				index = 0;
				GetEntry(index, anID);
				BaseDBAssert(inEntryID == anID);
				result = kIDTableNoErr;
			}
			else if (inEntryID == this->GetEntryIDMax())
			{
				outEntryIndex = this->GetEntryCount() - 1;
				index = this->GetEntryCount() - 1;
				GetEntry(index, anID);
				BaseDBAssert(inEntryID == anID);
				result = kIDTableNoErr;
			}
			else
			{
				done = false;
				low = 0;
				high = this->GetEntryCount() - 1;
				while (low <= high)
				{
					index = low + ((high - low) / 2);
					outEntryIndex = index;

					GetEntry(index, anID);

					if (anID == inEntryID)
					{
						result = kIDTableNoErr;
						break;
					}

					if (anID < inEntryID)
						low = index + 1;
					else
						high = index - 1;
				}
			}
		}
		else
		{
			if (inEntryID < this->GetEntryIDMin())
			{
				outEntryIndex = 0;
			}
			else
			{
				outEntryIndex = this->GetEntryCount() - 1;
			}
		}
	}

	this->SanityCheck();
	
	return result;
}

OSStatus CIDTable::SetEntryData		( const ObjID inEntryID, const void *inEntryData )
{
	OSStatus result = kIDTableNoErr;
	uInt32	 anIndex;
	
	this->SanityCheck();

	result = this->FindEntry(inEntryID, anIndex);
	if (result != kIDTableNoErr)
	{
		result = kIDTableNoSuchObject;
	}
	else
	{
		result = this->SetEntry(anIndex, inEntryID, inEntryData);
	}

	this->SanityCheck();
	
	return result;
}
		
OSStatus CIDTable::ResetEntryID		( const ObjID inOldEntryID, const ObjID inNewEntryID )
{
	OSStatus	result		= kIDTableNoErr;
	uInt32		anIndex		= 0;
	ObjID		tempObjID	= 0;
	ObjID		prevID		= 0;
	ObjID		nextID		= 0;
	
	this->SanityCheck();

	result = this->FindEntry(inOldEntryID, anIndex);
	if (result != kIDTableNoErr)
	{
		result = kIDTableNoSuchObject;
	}
	else
	{
		result = this->GetEntry(anIndex, tempObjID);
		BaseDBAssert(tempObjID == inOldEntryID);

		if (anIndex > 0)
		{
			result = this->GetEntry(anIndex-1, prevID);
			BaseDBAssert(prevID < inNewEntryID);
			BaseDBAssert(prevID != inNewEntryID);
		}
		else
		{
			result = this->GetEntry(anIndex, prevID);
			BaseDBAssert(prevID != inNewEntryID);
		}
		
		if (anIndex < (this->GetEntryCount() - 1))
		{
			result = this->GetEntry(anIndex+1, nextID);
			BaseDBAssert(nextID > inNewEntryID);
			BaseDBAssert(nextID != inNewEntryID);
		}
		else
		{
			result = this->GetEntry(anIndex, nextID);
			BaseDBAssert(nextID != inNewEntryID);
		}
		
		result = this->SetEntry2ObjID(anIndex, inNewEntryID);
		this->SetEntryIDMin(inNewEntryID, (anIndex == 0));
		this->SetEntryIDMax(inNewEntryID, (anIndex == (this->GetEntryCount() - 1)));
	}

	this->SanityCheck();
	
	return result;
}
		
uInt32 CIDTable::GetEntryDataSize ( void )
{
	uInt32 result = 0;
	
	this->SanityCheck();

	if (fIDTablePtr != NULL)
	{
		result = fIDTablePtr->fIDTableHeader.fDataSize;
	}

	this->SanityCheck();
	
	return result;
}

uInt32 CIDTable::GetEntryMaxCount	( void )
{
	uInt32 result = 0;
	
	this->SanityCheck();

	if (fIDTablePtr != NULL)
		result = fIDTablePtr->fIDTableHeader.fMaxCount;

	this->SanityCheck();
	
	return result;
}

OSStatus CIDTable::SetEntryCount ( const uInt32 inEntryCount )
{
	OSStatus result = kIDTableNoErr;
	
	this->SanityCheck();
	
	if (inEntryCount <= this->GetEntryMaxCount())
	{
		if (fIDTablePtr != NULL)
			fIDTablePtr->fIDTableHeader.fCount = inEntryCount;
	}
	else
	{
		result = kIDTableEntryCountTooBig;
	}
	
	this->SanityCheck();
	
	return result;
}

uInt32 CIDTable::GetEntryCount ( void )
{
	uInt32 result = 0;
	
	this->SanityCheck();
	
	if (fIDTablePtr != NULL)
		result = fIDTablePtr->fIDTableHeader.fCount;

	this->SanityCheck();
	
	return result;
}

OSType CIDTable::GetTableType ( void )
{
	OSType result = 0;
	
	this->SanityCheck();
	
	if (fIDTablePtr != NULL)
		result = fIDTablePtr->fIDTableHeader.fTableType;

	this->SanityCheck();
	
	return result;
}

OSStatus CIDTable::SetEntryIDMin ( const uInt32 inEntryIDMin, Boolean inForceSet )
{
	OSStatus result = kIDTableNoErr;
	
	this->SanityCheck();
	
	if ((inEntryIDMin < this->GetEntryIDMin()) || (inForceSet))
	{
		if (fIDTablePtr != NULL)
		{
			fIDTablePtr->fIDTableHeader.fMinID = inEntryIDMin;
		}
	}

	this->SanityCheck();
	
	return result;
}

uInt32 CIDTable::GetEntryIDMin ( void )
{
	uInt32 result	= 0;
	
	this->SanityCheck();
	
	if (fIDTablePtr != NULL)
	{
		result = fIDTablePtr->fIDTableHeader.fMinID;
	}

	this->SanityCheck();
	
	return result;
}

OSStatus CIDTable::SetEntryIDMax ( const uInt32 inEntryIDMax, Boolean inForceSet )
{
	OSStatus result = kIDTableNoErr;
	
	this->SanityCheck();
	
	if ((inEntryIDMax > this->GetEntryIDMax()) || (inForceSet))
	{
		if (fIDTablePtr != NULL)
		{
			fIDTablePtr->fIDTableHeader.fMaxID = inEntryIDMax;
		}
	}

	this->SanityCheck();
	
	return result;
}

uInt32 CIDTable::GetEntryIDMax ( void )
{
	uInt32 result	= 0;
	
	this->SanityCheck();
	
	if (fIDTablePtr != NULL)
	{
		result = fIDTablePtr->fIDTableHeader.fMaxID;
	}
	
	this->SanityCheck();
	
	return result;
}
		
OSStatus CIDTable::ClearIDTable ( void )
{
	OSStatus result = kIDTableNoErr;
	
	this->SanityCheck();
	
	fTempHeader.fCount = 0;
	fTempHeader.fMinID = 0xffffffff;
	fTempHeader.fMaxID = 0;
	fTempHeader.fNextID = 0;
	fTempHeader.fPrevID = 0;

	fTempHeader.fMaxCount = kMaxIDTableSize / (sizeof(ObjID) + 	fTempHeader.fDataSize);
	BaseDBAssert(fTempHeader.fMaxCount > 0);

	if (fIDTablePtr != NULL)
	{
		fIDTablePtr->fIDTableHeader = fTempHeader;
		::memset(fIDTablePtr->fIDTableData, 0, kMaxIDTableSize);
	}

	this->SanityCheck();
	
	return result;
}
		
PageID CIDTable::GetNextID ( void )
{
	uInt32 result = 0;
	
	this->SanityCheck();

	if (fIDTablePtr != NULL)
	{
		result = fIDTablePtr->fIDTableHeader.fNextID;
		if (fIDTablePtr->fIDTableHeader.fNextID != 0)
		{
			BaseDBAssert(fIDTablePtr->fIDTableHeader.fNextID != fIDTablePtr->fIDTableHeader.fPrevID);
		}
	}

	this->SanityCheck();
	
	return result;
}

OSStatus CIDTable::SetNextID ( const PageID inNextIDTable )
{
	OSStatus result = kIDTableNoErr;
	
	this->SanityCheck();

	if (fIDTablePtr != NULL)
	{
		fIDTablePtr->fIDTableHeader.fNextID = inNextIDTable;
		if (fIDTablePtr->fIDTableHeader.fNextID != 0)
		{
			BaseDBAssert(fIDTablePtr->fIDTableHeader.fNextID != fIDTablePtr->fIDTableHeader.fPrevID);
		}
	}

	this->SanityCheck();
	
	return result;
}

OSStatus CIDTable::SetTablePageID ( const PageID inPageID )
{
	OSStatus result = kIDTableNoErr;
	
	this->SanityCheck();
	this->fPageID = inPageID;
	this->SanityCheck();
	
	return result;
}

PageID CIDTable::GetTablePageID ( void )
{
	PageID result;
	
	this->SanityCheck();
	result = this->fPageID;
	this->SanityCheck();
	
	return result;
}

OSStatus CIDTable::SetPrevID ( const PageID inPageID )
{
	OSStatus result = kIDTableNoErr;
	
	this->SanityCheck();

	if (fIDTablePtr != NULL)
	{
		fIDTablePtr->fIDTableHeader.fPrevID = inPageID;
		if (fIDTablePtr->fIDTableHeader.fPrevID != 0)
		{
			BaseDBAssert(fIDTablePtr->fIDTableHeader.fNextID != fIDTablePtr->fIDTableHeader.fPrevID);
		}
	}

	this->SanityCheck();
	
	return result;
}

PageID CIDTable::GetPrevID ( void )
{
	PageID result	= 0;
	
	this->SanityCheck();
	if (fIDTablePtr != NULL)
	{
		result = fIDTablePtr->fIDTableHeader.fPrevID;
		if (fIDTablePtr->fIDTableHeader.fPrevID != 0)
		{
			BaseDBAssert(fIDTablePtr->fIDTableHeader.fNextID != fIDTablePtr->fIDTableHeader.fPrevID);
		}
	}
	
	this->SanityCheck();
	
	return result;
}

OSStatus CIDTable::DeleteEntry (const uInt32 inIndex)
{
	OSStatus result = kIDTableNoErr;
	
	this->SanityCheck();
	if (inIndex < this->GetEntryCount())
	{
		uInt32	startIndex = inIndex;
		ObjID	tempObjID = 0;
		char	*tempData = NULL;

		if (this->GetEntryDataSize() > 0)
		{
			tempData = new char[this->GetEntryDataSize()];
			BaseDBAssert(tempData != NULL);
			::memset(tempData, 0, this->GetEntryDataSize());
		}
		
		for (startIndex = inIndex; startIndex < (this->GetEntryCount() - 1); startIndex++)
		{
			this->GetEntry(startIndex + 1, tempObjID, tempData);
			this->SetEntry(startIndex, tempObjID, tempData);
		}
		
		if (tempData != NULL)
		{
			::memset(tempData, 0, this->GetEntryDataSize());
		}
		this->SetEntry(this->GetEntryCount() - 1, 0, tempData);
		
		
		if (tempData != NULL)
		{
			delete tempData;
			tempData = NULL;
		}

		this->SetEntryCount(this->GetEntryCount() - 1);

		this->SetEntryIDMin(0xffffffff, true);
		this->SetEntryIDMax(0, true);
		if (this->GetEntryCount() > 0)
		{
			this->GetEntry(0, tempObjID);
			this->SetEntryIDMin(tempObjID, true);
			this->GetEntry((this->GetEntryCount() - 1), tempObjID);
			this->SetEntryIDMax(tempObjID, true);
		}
		
	}
	else
	{
		result = kIDTableIndexOutOfRange;
	}

	this->SanityCheck();
	
	return result;
}

OSStatus CIDTable::InsertEntry (const uInt32 inIndex, const ObjID inObjID, const void *inObjData)
{
	OSStatus result = kIDTableNoErr;
	
	this->SanityCheck();
	if (inIndex <= this->GetEntryCount())
	{
		sInt32	curIndex = 0;
		ObjID	tempObjID = 0;
		char	*tempData = NULL;

		this->SetEntryCount(this->GetEntryCount() + 1);

		if ((this->GetEntryCount() > 1) && (inIndex < this->GetEntryCount()-1))
		{
			if (this->GetEntryDataSize() > 0)
			{
					tempData = new char[this->GetEntryDataSize()];
					BaseDBAssert(tempData != NULL);
					::memset(tempData, 0, this->GetEntryDataSize());
			}
			sInt32 tempIndex = inIndex;
			for (curIndex = this->GetEntryCount()-2; (curIndex >= tempIndex) && (curIndex >= 0); curIndex--)
			{
				result = this->GetEntry(curIndex, tempObjID, tempData);
				BaseDBAssert(result == kIDTableNoErr);

				result = this->SetEntry(curIndex+1, tempObjID, tempData);
				BaseDBAssert(result == kIDTableNoErr);
			}
			if (tempData != NULL)
			{
				delete tempData;
				tempData = NULL;
			}
		}

		result = this->SetEntry(inIndex, inObjID, inObjData);		
		BaseDBAssert(result == kIDTableNoErr);

		this->GetEntry(0, tempObjID);
		this->SetEntryIDMin(tempObjID, true);
		this->GetEntry((this->GetEntryCount() - 1), tempObjID);
		this->SetEntryIDMax(tempObjID, true);
	}
	else
	{
		result = kIDTableIndexOutOfRange;
	}

	this->SanityCheck();
	
	return result;
}

OSStatus CIDTable::GetEntry	(const uInt32 inIndex, ObjID &outObjID, Ptr inEntryData )
{
	OSStatus result = kIDTableNoErr;
	char	*anEntryPtr;
	ObjID	*anObjIDPtr;
	char	*aDataPtr;
	
	this->SanityCheck();
	
	if ( (inIndex < this->GetEntryMaxCount()) && (fIDTablePtr != NULL) )
	{
		anEntryPtr = fIDTablePtr->fIDTableData;
		anEntryPtr += inIndex * (sizeof(ObjID) + this->GetEntryDataSize());
		anObjIDPtr = (ObjID *) anEntryPtr;
		aDataPtr = anEntryPtr + sizeof(ObjID);
		
		outObjID = *anObjIDPtr;
		if ((inEntryData != NULL) && (this->GetEntryDataSize() != 0))
		{
			::memcpy(inEntryData, aDataPtr, this->GetEntryDataSize());
		}
	}
	else
	{
		result = kIDTableIndexOutOfRange;
	}
	
	this->SanityCheck();
	
	return result;
}

OSStatus CIDTable::SetEntry	(const uInt32 inIndex, const ObjID inObjID, const void * inEntryData)
{
	OSStatus result = kIDTableNoErr;
	char	*anEntryPtr;
	ObjID	*anObjIDPtr;
	char	*aDataPtr;
	
	this->SanityCheck();
	
	if ((inIndex < this->GetEntryMaxCount()) && (fIDTablePtr != NULL))
	{
		anEntryPtr = fIDTablePtr->fIDTableData;
		anEntryPtr += inIndex * (sizeof(ObjID) + this->GetEntryDataSize());
		anObjIDPtr = (ObjID *) anEntryPtr;
		aDataPtr = anEntryPtr + sizeof(ObjID);
		
		*anObjIDPtr = inObjID;
		if ((inEntryData != NULL) && (this->GetEntryDataSize() != 0))
		{
			::memcpy(aDataPtr, (void *) inEntryData, this->GetEntryDataSize());
		}
	}
	else
	{
		result = kIDTableIndexOutOfRange;
	}
	
	this->SanityCheck();
	
	return result;
}
		
OSStatus CIDTable::SetEntry2ObjID (const uInt32 inIndex, const ObjID inNewObjID)
{
	OSStatus result = kIDTableNoErr;
	char	*anEntryPtr;
	ObjID	*anObjIDPtr;
	
	this->SanityCheck();
	
	if ((inIndex < this->GetEntryMaxCount()) && (fIDTablePtr != NULL))
	{
		anEntryPtr = fIDTablePtr->fIDTableData;
		anEntryPtr += inIndex * (sizeof(ObjID) + this->GetEntryDataSize());
		anObjIDPtr = (ObjID *) anEntryPtr;
		*anObjIDPtr = inNewObjID;
	}
	else
	{
		result = kIDTableIndexOutOfRange;
	}
	
	this->SanityCheck();
	
	return result;
}
		
OSStatus CIDTable::SanityCheck	( void )
{
	OSStatus result = kIDTableNoErr;
	
	if (this != NULL)
	{
		long *temp = (long *) this;
// xxxx		BaseDBAssert(fTempHeader.fSanityValue == *temp);
		
		if ((this->fIDTablePtr != NULL) && (fPageID != 0))
		{
//			BaseDBAssert(fIDTablePtr->fIDTableHeader.fNextID != fPageID);
//			BaseDBAssert(fIDTablePtr->fIDTableHeader.fPrevID != fPageID);
		}
	}

//#ifdef DEBUG
#ifdef crap_this_will_compile_out
	
	BaseDBAssert(this != NULL);
	uInt32	index = 0;
	char	*anEntryPtr;
	ObjID	*anObjIDPtr;
	ObjID	anIDLeft = 0;
	ObjID	anIDRight = 0;
	
	for (index = 0; index < fIDTable.fIDTableHeader.fCount; index++)
	{
		if (index < fIDTable.fIDTableHeader.fMaxCount)
		{
			anEntryPtr = fIDTable.fIDTableData;
			anEntryPtr += index * (sizeof(ObjID) + this->GetEntryDataSize());
			anObjIDPtr = (ObjID *) anEntryPtr;
			
			anIDRight = *anObjIDPtr;

			BaseDBAssert(anIDLeft < anIDRight);
			anIDLeft = anIDRight;
		}
	}
	
	BaseDBAssert(fIDTable.fIDTableHeader.fDataSize < sizeof(SIDTable));
	BaseDBAssert(fIDTable.fIDTableHeader.fMaxCount > 0);
	BaseDBAssert(fIDTable.fIDTableHeader.fMaxCount <= (sizeof(SIDTable)/sizeof(ObjID)));
	BaseDBAssert(fIDTable.fIDTableHeader.fCount <= fIDTable.fIDTableHeader.fMaxCount);

#endif

	return result;
}

