/*
	$Id: CMailDatabase.h,v 1.1 2003/04/20 23:32:51 dasenbro Exp $

	File:		CMailDatabase.h

	Contains:	xxx put contents here xxx

	Version:	Apple Mail Server - Mac OS X :  $Revision: 1.1 $

	Written by:	David O'Rourke

	Copyright:	 1996-2001 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: CMailDatabase.h,v $
		Revision 1.1  2003/04/20 23:32:51  dasenbro
		Initial check-in.
		
		Revision 1.15  2002/06/13 01:30:32  dasenbro
		Updated DB tag to final version.
		
		Revision 1.14  2002/06/04 18:02:53  dasenbro
		Cleaned up commented object signature consts.
		
		Revision 1.13  2002/03/21 16:41:17  dasenbro
		Updated file version information.
		
		Revision 1.12  2002/03/11 23:43:39  dasenbro
		Removed host pref object.  Host prefs are now stored in the directory.
		
		Revision 1.11  2002/01/14 16:56:01  dasenbro
		Initial S4 updates.
		
		Revision 1.10  2001/06/21 20:50:54  dasenbro
		Updated file header info.
		
		Revision 1.9  2001/06/21 17:05:39  dasenbro
		Added Change History.
		

	Projector History:

	  <ASM2>	  6/7/99	DOR		Add parameter to the constructor.

	To Do:
*/

#ifndef __CMailDatabase_h__
#define	__CMailDatabase_h__	1

#include "CBaseDatabase.h"

// DBObject Signatures
const uInt32 kMailRootSignature			= 'Root';
const uInt32 kAccountSignature			= 'Acct';
const uInt32 kMailSpoolSignature		= 'MSpl';
const uInt32 kEnvelopeInfoSignature		= 'EInf';
const uInt32 kEnvelopeSignature			= 'Envp';
const uInt32 kRecipientSignature		= 'Rcpt';
const uInt32 kHostEntrySignature		= 'HstE';
const uInt32 kDNSCacheSignature			= 'DNSC';
const uInt32 kStatMgrSignature			= 'Stat';
const uInt32 kMsgTOCSignature			= 'MToc';
const uInt32 kExpansionSignature		= 'Expn';
const uInt32 kPOP3AcctInfoSignature		= 'P3If';
const uInt32 kMessageStringSignature	= 'MStr';
const uInt32 kTextObjectSignature		= 'TxOb';

typedef enum {
	kFlush		= true,
	kNoFlush	= false
} ObjectFlush;

enum 
{
	// Version is divided into parts:
	// 0xFF000000 == Major Version
	// 0x00FF0000 == Minor Version
	// 0x0000FF00 == Development Stage (Dev, Alpha, Beta, Final)
	// 0x000000FF == Development Substage
	
	kDBVersionNumber1	= 0x0500010A,			// 5.0a10
	kDBVersionNumber2	= 0x05000201,			// 5.0b1
	kDBVersionNumber3	= 0x05000209,	 		// 5.0b9
	kDBVersionNumber4	= 0x05000301,			// 5.0f1
	kDBVersionNumber5	= 0x05000303,			// 5.0f3
	kDBVersionNumber6	= 0x05000304,			// 5.0f4
	kDBVersionNumber7	= 0x05000306,			// 5.0f6e1
	kDBVersionNumber8	= 0x05000307,			// 5.0f6e2	-- includes new field in CHostEntry
	kDBVersionNumber9	= 0x05020308,			// 5.0f6e2	-- includes new field in CHostEntry
	kDBVersionNumber10	= 0x05010306,			// 5.0.1b6

// AppleShareIP 6.0 IMAP Server versions...5.0.2 was the last version of ASIP..
	kDBVersionNumber11	= 0x06000001,			// 6.0 dev-1
	kDBVersionNumber12	= 0x06000002,			// 6.0 a1c10
	kDBVersionNumber13	= 0x06000004,			// 6.0 post-a1
	kDBVersionNumber14	= 0x06000007,			// 6.0 a7c1
	kDBVersionNumber15	= 0x1000B001,			// 10.0 b1
	kDBVersionNumber16	= 0x1002A001,			// 10.2 a1
	kDBVersionNumber17	= 0x10020B01,			// 10.2 b1
	kDBCurrentVersion = kDBVersionNumber17
};

//------------------------------------------------------------------------------
// Constants
//------------------------------------------------------------------------------

const uInt32 kVersionInfoVersion =  kDBCurrentVersion;
const uInt32 kVersionInfoDataSize = 2 * sizeof(uInt32);

class CDBMailObjectCache;
class CMailDatabase : public CBaseDatabase
{
	public:
							CMailDatabase			(	const uInt32 inMinFreeDiskSpace,
													   	CDBMailObjectCache *inMailBaseObjectCache,
													  	uInt32 inPageCacheCount = kNormalPageCacheCount );
		virtual				~CMailDatabase			( void );
		

	private:
	
		// functions that must be provided as virtual functions
		virtual	void	DoYield		( const Boolean inForceYieldFlag );

		virtual void	DoLockDB			( void );
		virtual void	DoReleaseDB			( void );

		virtual Boolean	IsThreadQuitting	( void );
};

#endif	// __CMailDatabase_h__
