/*
	$Id: CStr2IDTable.h,v 1.1 2003/04/20 23:32:51 dasenbro Exp $

	File:		CSTr2IDTable.h

	Contains:	xxx put contents here xxx

	Version:	Apple Mail Server - Mac OS X :  $Revision: 1.1 $

	Written by:	David O'Rourke

	Copyright:	 1997-2001 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Notes:

		// *********************************************************************************
		// Warning: DO NOT CHANGE/ADD/REMOVE PUBLIC/PRIVATE DATA FIELDS TO THIS CLASS/STRUCT
		// WITHOUT CONSULTING WITH A APPLE MAIL TEAM MEMBER.  CHANGES TO
		// THIS STRUCTURE __WILL__ CAUSE FILE FORMAT COMPATIBILITY ISSUES FOR APPLESHARE IP 5.0
		// AND 6.0 MAIL DATABASES.
		//
		// FAILURE TO HEED THIS WARNING __WILL__ LEAD TO DATA LOSS
		// AND/OR CRASHING BUGS WHEN CUSTOMERS ATTEMPT TO USE YOUR SIMPLE MODIFICATIONS WITH
		// A PRE-EXISTING MAIL DATABASE.
		//
		// SINCE THIS FILE IS SHARED BY MORE COMPONENTS THAN JUST YOURS, PLEASE BE AWARE OF THE
		// C++ FRAGILE BASE CLASS PROBLEM AND DON'T MAKE CHANGES IN THE BASE CLASS SOURCE CODE
		// WITH OUT CONSULTING OTHER SOURCES THAT ARE DEPENDANT ON THIS STURUCTURE.
		// *********************************************************************************


	Change History:

		$Log: CStr2IDTable.h,v $
		Revision 1.1  2003/04/20 23:32:51  dasenbro
		Initial check-in.
		
		Revision 1.6  2002/03/21 16:41:17  dasenbro
		Updated file version information.
		
		Revision 1.5  2001/06/21 20:50:54  dasenbro
		Updated file header info.
		
		Revision 1.4  2001/06/21 17:05:39  dasenbro
		Added Change History.
		

	Projector History:


	To Do:
*/


#ifndef __CSTr2IDTable_h__
#define __CSTr2IDTable_h__ 1

#include "DatabaseTypes.h"

const uInt32	kStr2IDTableType		= 'str2';
const uInt32	kStr2IDMaxStringSize	= 256;
typedef struct
{
	// *********************************************************************************
	// Warning: DO NOT CHANGE/ADD/REMOVE PUBLIC/PRIVATE DATA FIELDS TO THIS CLASS/STRUCT
	// WITHOUT CONSULTING WITH A APPLE MAIL TEAM MEMBER.  CHANGES TO
	// THIS STRUCTURE __WILL__ CAUSE FILE FORMAT COMPATIBILITY ISSUES FOR APPLESHARE IP 5.0
	// AND 6.0 MAIL DATABASES.
	//
	// FAILURE TO HEED THIS WARNING __WILL__ LEAD TO DATA LOSS
	// AND/OR CRASHING BUGS WHEN CUSTOMERS ATTEMPT TO USE YOUR SIMPLE MODIFICATIONS WITH
	// A PRE-EXISTING MAIL DATABASE.
	//
	// SINCE THIS FILE IS SHARED BY MORE COMPONENTS THAN JUST YOURS, PLEASE BE AWARE OF THE
	// C++ FRAGILE BASE CLASS PROBLEM AND DON'T MAKE CHANGES IN THE BASE CLASS SOURCE CODE
	// WITH OUT CONSULTING OTHER SOURCES THAT ARE DEPENDANT ON THIS STURUCTURE.
	// *********************************************************************************

	short	fStrOffset;
	ObjID	fObjID;
	PageID	fObjPageID;
} SStr2IDEntry;

typedef struct
{
	// *********************************************************************************
	// Warning: DO NOT CHANGE/ADD/REMOVE PUBLIC/PRIVATE DATA FIELDS TO THIS CLASS/STRUCT
	// WITHOUT CONSULTING WITH A APPLE MAIL TEAM MEMBER.  CHANGES TO
	// THIS STRUCTURE __WILL__ CAUSE FILE FORMAT COMPATIBILITY ISSUES FOR APPLESHARE IP 5.0
	// AND 6.0 MAIL DATABASES.
	//
	// FAILURE TO HEED THIS WARNING __WILL__ LEAD TO DATA LOSS
	// AND/OR CRASHING BUGS WHEN CUSTOMERS ATTEMPT TO USE YOUR SIMPLE MODIFICATIONS WITH
	// A PRE-EXISTING MAIL DATABASE.
	//
	// SINCE THIS FILE IS SHARED BY MORE COMPONENTS THAN JUST YOURS, PLEASE BE AWARE OF THE
	// C++ FRAGILE BASE CLASS PROBLEM AND DON'T MAKE CHANGES IN THE BASE CLASS SOURCE CODE
	// WITH OUT CONSULTING OTHER SOURCES THAT ARE DEPENDANT ON THIS STURUCTURE.
	// *********************************************************************************

	uInt32			fDataTableVersion;
	
	OSType			fTableType;
	Boolean			fCaseSensitiveFlag;
	uInt32			fCount;			// current number of entries in this table

	PageID			fNextID;
	PageID			fPrevID;
	PageID			fParentID;
	
	unsigned short	fStringHeap;
	char			fCurrentMinString[kStr2IDMaxStringSize];

	// -------------------------------------------------------
	SStr2IDEntry	f1stStringEntry[1];	// this field _MUST_ be the last field in the struct...
} SStr2IDTableHeader;

const uInt32 kMaxStr2IDTableSize = (kStandardPageSize - sizeof(SStr2IDTableHeader));
const uInt32 kStr2IDTableVersion1	= 0x05010001 + sizeof(SStr2IDTableHeader) + kMaxStr2IDTableSize;
const uInt32 kStr2IDTableCurVersion	= kStr2IDTableVersion1;
const uInt32 kStr2IDNullIndex = 0xffffffff;

typedef struct
{
	SStr2IDTableHeader	fStr2IDTableHeader;
	char				fStr2IDDTableData[kMaxStr2IDTableSize];
} SStr2IDTable;

class CStr2IDTable
{
	public:
							CStr2IDTable		( const Boolean inCaseSensitiveFlag );
		virtual 			~CStr2IDTable		( void );
		
		static void CheckBackwardCompatibility	( void );
		static void ReportBackwardCompatibility	( const uInt32 curSize, const uInt32 correctSize );
		static void			strncpy				(	char *inTargetStr,
													char *inSourceStr,
													const uInt32 inMaxLength );
		
		virtual OSStatus	SetTable			( void *inTablePtr, const PageID inPageID);
		
		virtual	OSStatus	AddStr2List			( const char *inEntryString, const ObjID inEntryID, const PageID inObjPageID, Boolean allowNewMin = false);
		virtual OSStatus	RemoveStrFromList	( const char *inEntryString );
		virtual OSStatus	FindEntry			( const char *inEntryString, uInt32 &outIndex );
		virtual OSStatus	GetEntry			( const uInt32 inIndex, SStr2IDEntry &outEntry );

		virtual OSType		GetTableType			( void );
		virtual Boolean		GetCaseSensitiveFlag	( void );
		virtual char *		GetNewString			( const char *inSourceString, const Boolean inMakeLowerCaseFlag );

		virtual OSStatus		SetStringHeap			( const unsigned short inStringHeap );
		virtual unsigned short	GetStringHeap			( void );

		
		virtual OSStatus	SetEntryCount		( const uInt32 inEntryCount );
		virtual uInt32		GetEntryCount		( void );

		virtual OSStatus	ClearStr2IDTable	( const Boolean inCaseSensitiveFlag );

		virtual	char *		GetCharStar			( const unsigned short inStringOffset );
		virtual char *		GetMinCharStar		( void );
		
		virtual PageID		GetParentID			( void );
		virtual OSStatus    SetParentID			( const PageID inParentIDTable );
		
		virtual PageID		GetNextID			( void );
		virtual OSStatus    SetNextID			( const PageID inNextIDTable );
		
		virtual PageID		GetPrevID			( void );
		virtual OSStatus    SetPrevID			( const PageID inPrevIDTable );
		
		virtual	OSStatus	SetTablePageID		( const PageID inPageID );
		virtual	PageID		GetTablePageID		( void );
		
		enum
		{
			kStr2IDTableNoErr = 0,
			kStr2IDTableFull = -1,
			kStr2IDTableNoSuchObject = -2,
			kStr2IDTableDuplicateObject = -3,
			kStr2IDTableObjNoAdd = -4,
			kStr2IDTableIndexOutOfRange = -5,
			kStr2IDTableEntryCountTooBig = -6,
			kStr2IDTableNoInsertAllowed = -7,
			kStr2IDNewMinNotAllowed = -8,
			kStr2IDNewMaxNotAllowed = -9,
			kStr2IDBadTablePtr = -10,
			kStr2IDBadString = -11,
			kStr2IDString2Big = -12,
			kStr2IDBadThisObject = -13
		};
	
	protected:
		virtual uInt32		CalcFreeSpace	( void );
		virtual OSStatus	DeleteEntry 	(const uInt32 inIndex);
		virtual OSStatus	SetEntry		(const uInt32 inIndex, const SStr2IDEntry inEntry );
		virtual OSStatus	InsertEntry		(const uInt32 inIndex, const SStr2IDEntry inEntry);
				OSStatus	SanityCheck		( void );

		// volitile data, no read/write to disk
		PageID				fPageID;
		SStr2IDTableHeader	fTempHeader;
		
		// Data portion of the object, this can be saved and restored
		// to disk....
		SStr2IDTable		*fStr2IDTablePtr;
};

#endif	// __CSTr2IDTable_h__
