/*
	$Id: Database.h,v 1.1 2003/04/20 23:32:51 dasenbro Exp $

	File:	Database.h

	Contains: Database functions.

	Version:	Apple Mail Server - Mac OS X :  $Revision: 1.1 $

	Written by: David O'Rourke 

	Copyright:	 1996-2001 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: Database.h,v $
		Revision 1.1  2003/04/20 23:32:51  dasenbro
		Initial check-in.
		
		Revision 1.13  2002/04/21 16:51:49  dasenbro
		Added 10.2 DB header tag.
		
		Revision 1.12  2002/04/18 18:09:09  dasenbro
		Changed bool to Bool for word alignment.
		
		Revision 1.11  2002/03/21 16:41:17  dasenbro
		Updated file version information.
		
		Revision 1.10  2002/02/20 21:14:41  dasenbro
		Added new DB version consts and CDBUtils class.
		
		Revision 1.9  2002/01/14 16:56:01  dasenbro
		Initial S4 updates.
		
		Revision 1.8  2001/06/21 20:50:54  dasenbro
		Updated file header info.
		
		Revision 1.7  2001/06/21 17:10:00  dasenbro
		Added Change History.
		

	Projector History:

		 <5>	 8/31/98	MED		Added IsDBFull() to check if the DB is at its 2 gig limit.
		 <4>	 8/24/98	MED		Added CanCreateDB() to check for enough disk space to create the
									DB.
		 <3>	 3/25/98	MED		Added a flags argument to InitializeMainDB to return DB open
									state and the enums for the state flags.
		 <2>	  2/3/98	MED		Cleaned OSUtil.cp into CUtils.cp, COSUtils.cp and
									CSmartYield.cp.

	To Do:
 */


#ifndef _DATABASE_H
#define _DATABASE_H 1

//#include <CoreServices/CoreServices.h>	// for FSSpec
#include "MailTypes.h"
#include "CMailDatabase.h"

// DB Cache Percentage Resource
const uInt32 kDatabasePercentageResType = 'DBcp';
const uInt32 kDatabasePercentageResID = 128;

//#if PRAGMA_ALIGN_SUPPORTED
//#pragma options align=mac68k
//#endif

typedef struct
{
	uInt16 version;
	uInt16 percentage;
} DBCachePercentage;

//#if PRAGMA_ALIGN_SUPPORTED
//#pragma options align=reset
//#endif


enum {
	kSeedDB		= 'sdDB',
	kNormalDB	= 'nmDB'
};

enum {
	kDBIsOK				= 0x00000001,
	kNewDBCreated		= 0x00000002,
	kWrongDBVersion		= 0x00000004,
	kPoorlyClosedDB		= 0x00000008,
	kCantOpenDB			= 0x00000010
};

typedef enum {
	kDBVerUnknown		= 0x00000001,
	kDBVer6_X			= 0x00000002,
	kDBVer10_0			= 0x00000004,
	kDBVer10_1			= 0x00000006,
	kDBCurrent			= 0x00000008
} eDBVers;

#define	kSrcCustomMailFolderIconID		130
#define	kDestCustomMailFolderIconID		-16455		// magic value from Inside Macintosh volume 6 (VI), page 9-28
#define	kCustomIconResFileName			"\pIcon\r"

class	CString;

class CDBUtils
{
public:
	static	Bool	GetDoDBUpgrade		( void );
	static	void	SetDoDBUpgrade		( Bool inFlag );

	static	void	GetOldDBPath		( CString &outString );
	static	void	SetOldDBPath		( const char *inString );

	static	void	GetNewDBPath		( CString &outString );
	static	void	SetNewDBPath		( const char *inString );

	static	sInt32	GetOldDBPathLength	( void );
	static	sInt32	GetNewDBPathLength	( void );

private:
	static	Bool	fDoDBUpgrade;
	static	CString	fOldDBPath;
	static	CString	fNewDBPath;
};

// Main Database
sInt32		CheckDBVersion			( const char *inDBPath, eDBVers *outDBVer );
sInt32		ValidateMailDB			( const char *inDBPath );
Bool		InitializeMainDB		( const char *inSpec, uInt32 &outDBFlags );
void		CloseMainDB				( void );
void		GetDiskFreeSpace		( long long &volFree );

OSErr		CanCreateDB				( void );
Boolean		IsDBFull				( void );

extern CMailDatabase *gDB;


#endif /* _DATABASE_H */
