/*
	$Id: DatabaseTypes.h,v 1.1 2003/04/20 23:32:51 dasenbro Exp $

	File:		DatabaseTypes.h

	Contains:	xxx put contents here xxx

	Version:	Apple Mail Server - Mac OS X :  $Revision: 1.1 $

	Written by:	David O'Rourke

	Copyright:	 1996-2001 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: DatabaseTypes.h,v $
		Revision 1.1  2003/04/20 23:32:51  dasenbro
		Initial check-in.
		
		Revision 1.9  2002/03/21 16:41:17  dasenbro
		Updated file version information.
		
		Revision 1.8  2001/06/21 20:50:54  dasenbro
		Updated file header info.
		
		Revision 1.7  2001/06/21 17:05:39  dasenbro
		Added Change History.
		

	Projector History:

	  <ASX4>	  6/8/99	DOR		improve the assert
	  <ASX3>	  6/4/99	DOR		T'is a better assert...

	To Do:
*/



#ifndef __DatabaseTypes_h__
#define __DatabaseTypes_h__	1

#include "MailTypes.h"

const uInt32 kStandardPageSize	= (8*1024);
const uInt32 kSmallDBObjSize	= kStandardPageSize / 1024;
const uInt32 kMaxDBObjSize		= kStandardPageSize / 4;
const uInt32 kMaxObjTypeCount	= 32;
const uInt32 kNoHintPage		= 0;
const OSType kFreeListType		= 'free';

typedef uInt32	PageID;
typedef	uInt32	ObjID;
const uInt32 kLargeObjID = 0xffffffff;

/* 			debugstr("Assertion Failed! (" #__condition__ ") - File:<" __FILE__ ">;"); \ */

#ifdef DEBUG
	extern Boolean gBaseDatabaseAssert;
	#define BaseDBAssert(__condition__) 							\
		if ((!(__condition__)) && (gBaseDatabaseAssert == true))	\
		{ 															\
			char	string[ 256 ];	\
			::sprintf( string, "***** ASSERTION FAILED! ***** %s, %d", __FILE__, __LINE__ );	\
			::AssertLog( string );	\
		}
#else
	#define BaseDBAssert(__condition__)
#endif

#ifdef DEBUG
	#define BaseDBAssert_if(__IFcondition__)	\
		BaseDBAssert((__IFcondition__));		\
		if ((__IFcondition__))
#else
	#define BaseDBAssert_if(__IFcondition__)	\
		if ((__IFcondition__))
#endif


#endif	// __DatabaseTypes_h__
