/*
	File:		CExpansion.10.1.cpp

	Contains:	C++ implementation of generic 

	Copyright:	 1996-2001 by Apple Computer, Inc., all rights reserved.

	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

	To Do:
*/


// PP
#include <string.h>
#include <time.h>

// App
#include "Database.10.1.h"
#include "CMailDatabase.10.1.h"
#include "CExpansion.10.1.h"
#include "CDBMailBaseObject.10.1.h"
#include "CString.h"
#include "CMailSpool.10.1.h"
#include "UException.h"
#include "CGlobals.h"


//--------------------------------------------------------------------------------------------------
//	* GetSetFields
//
//--------------------------------------------------------------------------------------------------

Boolean	CExpansion_10_1::GetSetFields (	const eFieldDataRequest_10_1	 inFieldRequest,
									const void				*inObjDataPtr,
									void					*outFieldData )
{
	Boolean			 result			= false;
	CExpandData_10_1	   *aclDataPtr		= (CExpandData_10_1 *)inObjDataPtr;
	CExpansion_10_1	   *aTempObject		= NULL;
	ObjID		   *anObjIDPtr		= (ObjID *)outFieldData;

	if ( aclDataPtr != nil )
	{
		switch ( inFieldRequest )
		{
			case kSetObjID_10_1:
				aclDataPtr->fObjectID = *anObjIDPtr;
				break;

			case kObjectPINGRequest_10_1:
				// cause the objects constructor to get called, so we force a check of
				// the struct alignment...
				aTempObject = new CExpansion_10_1;
				delete aTempObject;
				break;

			case k2ndIDTargetChk_10_1:
				// fall through...
			
			default:
				result = false;
				break;
		}
	}

	return( result );
} // GetSetFields


//--------------------------------------------------------------------------------------------------
//	* GetObjectID
//
//--------------------------------------------------------------------------------------------------

ObjID CExpansion_10_1::GetObjectID ( void )
{
	return ( this->GetMyObjectID() );
}

//--------------------------------------------------------------------------------------------------
//	 Done
//
//--------------------------------------------------------------------------------------------------

void CExpansion_10_1::Done ( CExpansion_10_1* &inPtr )
{
	CDBBaseObject_10_1 *aDBObject = (CDBBaseObject_10_1 *) inPtr;
	aDBObject->Done(aDBObject);
	inPtr = (CExpansion_10_1 *)aDBObject;
}


//--------------------------------------------------------------------------------------------------
//	* ObjectAllocNew
//
//--------------------------------------------------------------------------------------------------

CDBBaseObject_10_1* CExpansion_10_1::ObjectAllocNew ( void )
{
	return( new CExpansion_10_1 );
} // ObjectAllocNew


//--------------------------------------------------------------------------------------------------
//	* FindByID
//
//--------------------------------------------------------------------------------------------------

CExpansion_10_1* CExpansion_10_1::FindByID ( const ObjID inObjectID )
{
	CExpansion_10_1	*outObj	= nil;

	outObj = (CExpansion_10_1 *) CDBMailBaseObject_10_1::MailUniversalFindByID ( inObjectID,
															CExpansion_10_1::GetObjTypeConstant(),
															CExpansion_10_1::GetObjVersConstant(),
															CExpansion_10_1::GetObjSizeConstant(),
															CExpansion_10_1::ObjectAllocNew );
	if ( outObj != nil )
	{
		outObj->SetMaxItems();
	}

	return( outObj );

} // FindByID


//--------------------------------------------------------------------------------------------------
//	* Create
//
//--------------------------------------------------------------------------------------------------

CExpansion_10_1* CExpansion_10_1::Create ( ObjID inOwner, uInt32 inItemSize )
{
	CExpansion_10_1	*objPtr	= nil;		// creates a reference
	OSErr		result	= kNoErr;
	ObjID		aNewID	= 0;

	try
	{
		// If the itemsize is greater than we have room for, bail
		ThrowIf_( (sInt32)inItemSize > kMaxDataBlockSize_10_1 );

		objPtr = new CExpansion_10_1;
		ThrowIfMemFail_( objPtr );

		(gDB_10_1->GetBaseObjectCachePtr())->LockTheCache(CExpansion_10_1::GetObjTypeConstant());

		result = gDB_10_1->CreateObj( kExpansionSignature_10_1, aNewID, objPtr->GetMyObjectData() );
		if ( result == CMailDatabase_10_1::kDBNoErr )
		{
			objPtr->Use();
			objPtr->SetOwnerID( inOwner );
			objPtr->SetItemSize( inItemSize );
			objPtr->SetDirty();
		}
		else
		{
			delete objPtr;
			objPtr = nil;
		}
		
		(gDB_10_1->GetBaseObjectCachePtr())->UnLockTheCache( CExpansion_10_1::GetObjTypeConstant() );
	}

	catch ( ExceptionCode err )
	{
		(gDB_10_1->GetBaseObjectCachePtr())->UnLockTheCache( CExpansion_10_1::GetObjTypeConstant() );
	}
	
	return( objPtr );

} // Create



//--------------------------------------------------------------------------------------------------
//	* Delete
//
//--------------------------------------------------------------------------------------------------

Boolean CExpansion_10_1::Delete ( CExpansion_10_1 *inObjPtr )
{
	Boolean deleted = false;
	OSErr	result;

	try
	{
		if ( inObjPtr != nil )
		{
			result = gDB_10_1->RemoveObj( kExpansionSignature_10_1, inObjPtr->GetMyObjectID());
			deleted = ( result == kNoErr );
			if ( deleted )
			{
				inObjPtr->SetMyObjectID( 0 );
			}
		}
	}
	catch ( ExceptionCode err )
	{
	}

	return( deleted );

} // Delete



//--------------------------------------------------------------------------------------------------
//	* Count
//
//--------------------------------------------------------------------------------------------------

uInt32 CExpansion_10_1::Count ( void )
{
	OSErr	result;
	uInt32	aCount = 0;

	if ( gDB_10_1 != nil )
	{
		result = gDB_10_1->GetObjectCount( kExpansionSignature_10_1, aCount );
	}

	return( aCount );

} // Count



//--------------------------------------------------------------------------------------------------
//	* 
//
//--------------------------------------------------------------------------------------------------

void CExpansion_10_1::VerifyAll( void )
{
} // VerifyAll


#pragma mark -
#pragma mark * Construct

//--------------------------------------------------------------------------------------------------
//	* CExpansion_10_1
//
//--------------------------------------------------------------------------------------------------

CExpansion_10_1::CExpansion_10_1 ( void ) :
	CDBMailBaseObject_10_1 (	&fObjectData.fDBHeader,
				&fObjectData.fDBFooter,
				&fObjectData,
				CExpansion_10_1::GetObjTypeConstant(),
				CExpansion_10_1::GetObjVersConstant(),
				CExpansion_10_1::GetObjSizeConstant() )

{
	fObjectData.fObjectID		= 0;
	fObjectData.fOwnerID		= 0;

	fObjectData.fPrevObjectID	= 0;
	fObjectData.fNextObjectID	= 0;

	fObjectData.fItemSize		= 0;
	fObjectData.fItemCount		= 0;

	// Reserved
	fObjectData.fReserved1		= kReservedConst;
	fObjectData.fReserved2		= kReservedConst;

	::memset( &fObjectData.fDataBlock, 0, sizeof( fObjectData.fDataBlock ) );

	fTotalItems = 0;

	this->ChkCompilerStructAlignment();
} // CExpansion_10_1



//--------------------------------------------------------------------------------------------------
//	* ~CExpansion_10_1
//
//--------------------------------------------------------------------------------------------------

CExpansion_10_1::~CExpansion_10_1 ( void )
{
} // ~CExpansion_10_1



void	CExpansion_10_1::ChkCompilerStructAlignment	( void )
{
	/*
		this dump was aquired by using the MPW command DumpSYM - TTE from the .xsym file produced
		from a Code Warrior Pro 1 Release Build of the AppleShare IP Mail Server for MacOS version 6.2
		
		this version of the structure is consider the "reference" standard for all future ASIP Mail Servers.
		If the structure does NOT match these offsets the version of the Mail Server that 
		you are compiling will _NOT_ be compatible with AppleShare IP 6.0, 6.1, or 6.2 (this also effects
		the AppleShare IP Mail Tool, and to a more limited extent the AppleShare IP Mail Admin since some
		of these structures are passed across the wire..)
		
		If _ANY_ of these Asserts "fire" you've got a backwards compatibility problem that _MUST_ be fixed!!
		
		this code wasn't put here for my personal amusement, this code was put here from a hard earned lesson
		that simple changes to headers/compilers _WILL_ break this stuff, better to know now than after we
		ship.  Look upon this code as a debugging AIDE, not an impediment.
		
		Type Name:  CExpandData		TINFO offset: 50884		(TINFO SYM file offset (hex): $1246C4)
			RecordOf 
			offset 0 NamedTypeOf fDBHeader TypeDef of "Type ID 248"
			offset 12 NamedTypeOf fObjectID 
			offset 16 NamedTypeOf fOwnerID unsigned long 
			offset 20 NamedTypeOf fPrevObjectID 
			offset 24 NamedTypeOf fNextObjectID unsigned long 
			offset 28 NamedTypeOf fItemCount 
			offset 30 NamedTypeOf fItemSize signed short 
			offset 32 NamedTypeOf fReserved1 
			offset 36 NamedTypeOf fReserved2 unsigned long 
			offset 40 NamedTypeOf fDataBlock 
			offset 168 NamedTypeOf fDBFooter TypeDef of "Type ID 250"
	*/

	static Boolean	aRunOnceFlag = false;	
	if (aRunOnceFlag == false)
	{
		CExpandData_10_1	*tempData = &(this->fObjectData);
		register unsigned long baseAddr = (unsigned long) tempData;

		//FileFormatSaftyChk(CExpandData, fDBHeader,		0);
		//FileFormatSaftyChk(CExpandData, fObjectID,		12);				// this is us (denormalized)
		//FileFormatSaftyChk(CExpandData, fOwnerID,		16);				// who ownes us
		//FileFormatSaftyChk(CExpandData, fPrevObjectID,	20);			// Link to previous object
		//FileFormatSaftyChk(CExpandData, fNextObjectID,	24);			// Link to next object
		//FileFormatSaftyChk(CExpandData, fItemCount,		28);
		//FileFormatSaftyChk(CExpandData, fItemSize,		30);
		//FileFormatSaftyChk(CExpandData, fReserved1,		32);
		//FileFormatSaftyChk(CExpandData, fReserved2,		36);
		//FileFormatSaftyChk(CExpandData, fDataBlock[0],	40);
		//FileFormatSaftyChk(CExpandData, fDBFooter,		168);
//		this->ReportBackwardCompatibility(sizeof(CExpandData),	172,	"CExpandData", "SIZEOF()");
//		this->ReportBackwardCompatibility(kExpansionDataSize,	172,	"CExpandData", "kExpansionDataSize");
	}
	
	aRunOnceFlag = true;
}

//--------------------------------------------------------------------------------------------------
//	* GetMyObjectData
//
//--------------------------------------------------------------------------------------------------

CExpandData_10_1* CExpansion_10_1::GetMyObjectData ( void )
{
	CExpandData_10_1* result = nil;
	if ( this != nil )
	{
		result = &( this->fObjectData );
	}

	return( result );

} // GetMyObjectData



//--------------------------------------------------------------------------------------------------
//	* SetDirty
//
//--------------------------------------------------------------------------------------------------

void CExpansion_10_1::SetDirty	( void )
{
	if ( (this != nil) && (this->GetMyObjectID() != 0) )
	{
		setDirty();
	}
} // SetDirty


#pragma mark -
#pragma mark * Getters/Setters

//--------------------------------------------------------------------------------------------------
//	** GetMyObjectID
//
//--------------------------------------------------------------------------------------------------

ObjID CExpansion_10_1::GetMyObjectID ( void )
{
	return( fObjectData.fObjectID );
} // GetMyObjectID



//--------------------------------------------------------------------------------------------------
//	* SetMyObjectID
//
//--------------------------------------------------------------------------------------------------

void CExpansion_10_1::SetMyObjectID ( ObjID inObjID )
{
	if ( fObjectData.fObjectID != inObjID )
	{
		fObjectData.fObjectID = inObjID;
		this->SetDirty();
	}
} // SetMyObjectID



//--------------------------------------------------------------------------------------------------
//	** GetOwnerID
//
//--------------------------------------------------------------------------------------------------

ObjID CExpansion_10_1::GetOwnerID ( void )
{
	return( fObjectData.fOwnerID );
} // GetOwnerID



//--------------------------------------------------------------------------------------------------
//	* SetOwnerID
//
//--------------------------------------------------------------------------------------------------

void CExpansion_10_1::SetOwnerID ( ObjID inObjID )
{
	if ( fObjectData.fOwnerID != inObjID )
	{
		fObjectData.fOwnerID = inObjID;
		this->SetDirty();
	}
} // SetOwnerID



//--------------------------------------------------------------------------------------------------
//	** GetPrevObjectID
//
//--------------------------------------------------------------------------------------------------

ObjID CExpansion_10_1::GetPrevObjectID ( void )
{
	return( fObjectData.fPrevObjectID );
} // GetPrevObjectID



//--------------------------------------------------------------------------------------------------
//	* SetPrevObjectID
//
//--------------------------------------------------------------------------------------------------

void CExpansion_10_1::SetPrevObjectID ( ObjID inObjID )
{
	if ( fObjectData.fPrevObjectID != inObjID )
	{
		fObjectData.fPrevObjectID = inObjID;
		this->SetDirty();
	}
} // SetPrevObjectID



//--------------------------------------------------------------------------------------------------
//	** GetNextObjectID
//
//--------------------------------------------------------------------------------------------------

ObjID CExpansion_10_1::GetNextObjectID ( void )
{
	return( fObjectData.fNextObjectID );
} // GetNextObjectID



//--------------------------------------------------------------------------------------------------
//	* SetNextObjectID
//
//--------------------------------------------------------------------------------------------------

void CExpansion_10_1::SetNextObjectID ( ObjID inObjID )
{
	if ( fObjectData.fNextObjectID != inObjID )
	{
		fObjectData.fNextObjectID = inObjID;
		this->SetDirty();
	}
} // SetNextObjectID



//--------------------------------------------------------------------------------------------------
//	** GetItemCount
//
//--------------------------------------------------------------------------------------------------

sInt16 CExpansion_10_1::GetItemCount ( void )
{
	return( fObjectData.fItemCount );
} // GetItemCount



//--------------------------------------------------------------------------------------------------
//	* SetItemCount
//
//--------------------------------------------------------------------------------------------------

void CExpansion_10_1::SetItemCount ( sInt16 inCount )
{
	if ( fObjectData.fItemCount != inCount )
	{
		fObjectData.fItemCount = inCount;
		this->SetDirty();
	}
} // SetItemCount



//--------------------------------------------------------------------------------------------------
//	* IncItemCount
//
//--------------------------------------------------------------------------------------------------

void CExpansion_10_1::IncItemCount ( void )
{
	if ( fObjectData.fItemCount < GetMaxItems() )
	{
		fObjectData.fItemCount++;
		this->SetDirty();
	}
} // IncItemCount



//--------------------------------------------------------------------------------------------------
//	* DecItemCount
//
//--------------------------------------------------------------------------------------------------

void CExpansion_10_1::DecItemCount ( void )
{
	if ( fObjectData.fItemCount > 0 )
	{
		fObjectData.fItemCount--;
		this->SetDirty();
	}
} // DecItemCount



//--------------------------------------------------------------------------------------------------
//	* GetItemSize
//
//--------------------------------------------------------------------------------------------------

sInt16 CExpansion_10_1::GetItemSize ( void )
{
	return( fObjectData.fItemSize );
} // GetItemSize



//--------------------------------------------------------------------------------------------------
//	* SetItemSize
//
//--------------------------------------------------------------------------------------------------

void CExpansion_10_1::SetItemSize ( sInt16 inSize )
{
	if ( (fObjectData.fItemSize != inSize) && ( inSize <= kMaxDataBlockSize_10_1) )
	{
		fObjectData.fItemSize = inSize;
		this->SetMaxItems();
		this->SetDirty();
	}
} // SetItemSize


//--------------------------------------------------------------------------------------------------
//	* GetMaxItems
//
//--------------------------------------------------------------------------------------------------

sInt16 CExpansion_10_1::GetMaxItems ( void )
{
	return( fTotalItems );
} // GetMaxItems



//--------------------------------------------------------------------------------------------------
//	* SetMaxItems
//
//--------------------------------------------------------------------------------------------------

void CExpansion_10_1::SetMaxItems ( void )
{
	sInt16	total	= 0;
	sInt16	size	= this->GetItemSize();

	if ( size > 0 )
	{
		total = kMaxDataBlockSize_10_1 / size;
	}

	if ( fTotalItems != total )
	{
		fTotalItems = total;
		this->SetDirty();
	}
} // SetMaxItems




//--------------------------------------------------------------------------------------------------
//	* GetDataBlock
//
//--------------------------------------------------------------------------------------------------

void CExpansion_10_1::GetDataBlock ( char *outData )
{
	::memcpy( outData, &fObjectData.fDataBlock, kMaxDataBlockSize_10_1 );
} // GetDataBlock



//--------------------------------------------------------------------------------------------------
//	* SetDataBlock
//
//--------------------------------------------------------------------------------------------------

void CExpansion_10_1::SetDataBlock ( char *inData )
{
	::memcpy( &fObjectData.fDataBlock, inData, kMaxDataBlockSize_10_1 );
	this->SetDirty();
} // SetDataBlock



