/*
	File:		CTextObject.10.1.cpp

	Contains:	C++ implementation of generic 

	Copyright:	 2003 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:
*/


// PP
#include <string.h>
#include <stdlib.h>

// App
#include "CTextObject.10.1.h"
#include "Database.10.1.h"
#include "UException.h"
#include "CGlobals.h"


//--------------------------------------------------------------------------------------------------
//	* GetSetFields ()
//
//--------------------------------------------------------------------------------------------------

Boolean	CTextObject_10_1::GetSetFields (	const eFieldDataRequest_10_1	 inFieldRequest,
											const void				*inObjDataPtr,
											void					*outFieldData )
{
	Boolean				 	result			= false;
	CTextObjectData_10_1   *aclDataPtr		= (CTextObjectData_10_1 *)inObjDataPtr;
	CTextObject_10_1	   *aTempObject		= NULL;
	ObjID				   *anObjIDPtr		= (ObjID *)outFieldData;

	if ( aclDataPtr != nil )
	{
		switch ( inFieldRequest )
		{
			case kSetObjID_10_1:
				aclDataPtr->fObjectID = *anObjIDPtr;
				break;

			case kObjectPINGRequest_10_1:
				// cause the objects constructor to get called, so we force a check of
				// the struct alignment...
				aTempObject = new CTextObject_10_1;
				if ( aTempObject != nil )
				{
					delete aTempObject;
				}
				break;

			case k2ndIDTargetChk_10_1:
				// fall through...
			
			default:
				result = false;
				break;
		}
	}

	return( result );

} // GetSetFields


//--------------------------------------------------------------------------------------------------
//	* GetObjectID ()
//
//--------------------------------------------------------------------------------------------------

ObjID CTextObject_10_1::GetObjectID ( void )
{
	return ( this->GetMyObjectID() );
} // GetObjectID


//--------------------------------------------------------------------------------------------------
//	 Done
//
//--------------------------------------------------------------------------------------------------

void CTextObject_10_1::Done ( CTextObject_10_1* &inPtr )
{
	CDBBaseObject_10_1 *aDBObject = (CDBBaseObject_10_1 *) inPtr;
	aDBObject->Done(aDBObject);

	inPtr = (CTextObject_10_1 *)aDBObject;
} // Done


//--------------------------------------------------------------------------------------------------
//	* ObjectAllocNew ()
//
//--------------------------------------------------------------------------------------------------

CDBBaseObject_10_1* CTextObject_10_1::ObjectAllocNew ( void )
{
	return( new CTextObject_10_1 );
} // ObjectAllocNew


//--------------------------------------------------------------------------------------------------
//	* FindByID ()
//
//--------------------------------------------------------------------------------------------------

CTextObject_10_1* CTextObject_10_1::FindByID ( const ObjID inObjectID )
{
	CTextObject_10_1	*outObj	= nil;

	outObj = (CTextObject_10_1 *) CDBMailBaseObject_10_1::MailUniversalFindByID ( inObjectID,
															CTextObject_10_1::GetObjTypeConstant(),
															CTextObject_10_1::GetObjVersConstant(),
															CTextObject_10_1::GetObjSizeConstant(),
															CTextObject_10_1::ObjectAllocNew );
	return( outObj );

} // FindByID


//--------------------------------------------------------------------------------------------------
//	* Create ()
//
//--------------------------------------------------------------------------------------------------

CTextObject_10_1* CTextObject_10_1::Create ( void )
{
	CTextObject_10_1	*objPtr	= nil;		// creates a reference
	OSErr		result	= kNoErr;
	ObjID		aNewID	= 0;

	try
	{
		objPtr = new CTextObject_10_1;
		ThrowIfMemFail_( objPtr );

		(gDB_10_1->GetBaseObjectCachePtr())->LockTheCache( CTextObject_10_1::GetObjTypeConstant() );

		result = gDB_10_1->CreateObj( kTextObjectSignature_10_1, aNewID, objPtr->GetMyObjectData() );
		if ( result == CMailDatabase_10_1::kDBNoErr )
		{
			objPtr->Use();
			objPtr->SetDirty();
		}
		else
		{
			delete objPtr;
			objPtr = nil;
		}
		
		(gDB_10_1->GetBaseObjectCachePtr())->UnLockTheCache( CTextObject_10_1::GetObjTypeConstant() );
	}

	catch ( ExceptionCode err )
	{
		(gDB_10_1->GetBaseObjectCachePtr())->UnLockTheCache( CTextObject_10_1::GetObjTypeConstant() );
	}
	
	return( objPtr );

} // Create


//--------------------------------------------------------------------------------------------------
//	* Delete ()
//
//--------------------------------------------------------------------------------------------------

Boolean CTextObject_10_1::Delete ( CTextObject_10_1 *inObjPtr )
{
	Boolean deleted = false;
	OSErr	result;

	try
	{
		if ( inObjPtr != nil )
		{
			result = gDB_10_1->RemoveObj( kTextObjectSignature_10_1, inObjPtr->GetMyObjectID());
			deleted = ( result == kNoErr );
			if ( deleted )
			{
				inObjPtr->SetMyObjectID( 0 );
			}
		}
	}
	catch ( ExceptionCode err )
	{
	}

	return( deleted );

} // Delete


//--------------------------------------------------------------------------------------------------
//	* Count ()
//
//--------------------------------------------------------------------------------------------------

uInt32 CTextObject_10_1::Count ( void )
{
	OSErr	result;
	uInt32	aCount = 0;

	if ( gDB_10_1 != nil )
	{
		result = gDB_10_1->GetObjectCount( kTextObjectSignature_10_1, aCount );
	}

	return( aCount );

} // Count


//--------------------------------------------------------------------------------------------------
//	* VerifyAll ()
//
//--------------------------------------------------------------------------------------------------

void CTextObject_10_1::VerifyAll ( void )
{
} // VerifyAll


#pragma mark -
#pragma mark * Construct

//--------------------------------------------------------------------------------------------------
//	* CTextObject_10_1 ()
//
//--------------------------------------------------------------------------------------------------

CTextObject_10_1::CTextObject_10_1 ( void ) :
	CDBMailBaseObject_10_1 (	&fObjectData.fDBHeader,
				&fObjectData.fDBFooter,
				&fObjectData,
				CTextObject_10_1::GetObjTypeConstant(),
				CTextObject_10_1::GetObjVersConstant(),
				CTextObject_10_1::GetObjSizeConstant() )

{
	fObjectData.fObjectID		= 0;
	fObjectData.fNextObj		= 0;
	fObjectData.fItemCount		= 0;
	fObjectData.fOffset			= 0;

	// Reserved
	fObjectData.fReserved1		= kReservedConst;
	fObjectData.fReserved2		= kReservedConst;

	::memset( &fObjectData.fStringData, 0, kTextObjSize_10_1 );

	this->ChkCompilerStructAlignment();

} // CTextObject_10_1


//--------------------------------------------------------------------------------------------------
//	* ~CTextObject_10_1 ()
//
//--------------------------------------------------------------------------------------------------

CTextObject_10_1::~CTextObject_10_1 ( void )
{
} // ~CTextObject_10_1

void	CTextObject_10_1::ChkCompilerStructAlignment	( void )
{
//		this dump was aquired by using the MPW command DumpSYM - TTE from the .xsym file produced
//		from a Code Warrior Pro 1 Release Build of the AppleShare IP Mail Server for MacOS version 6.2
//		
//		this version of the structure is consider the "reference" standard for all future ASIP Mail Servers.
//		If the structure does NOT match these offsets the version of the Mail Server that 
//		you are compiling will _NOT_ be compatible with AppleShare IP 6.0, 6.1, or 6.2 (this also effects
//		the AppleShare IP Mail Tool, and to a more limited extent the AppleShare IP Mail Admin since some
//		of these structures are passed across the wire..)
//		
//		If _ANY_ of these Asserts "fire" you've got a backwards compatibility problem that _MUST_ be fixed!!
//		
//		this code wasn't put here for my personal amusement, this code was put here from a hard earned lesson
//		that simple changes to headers/compilers _WILL_ break this stuff, better to know now than after we
//		ship.  Look upon this code as a debugging AIDE, not an impediment.
//		
//		Type Name:  CTextObjectData_10_1		TINFO offset: 50884		(TINFO SYM file offset (hex): $1246C4)
//			RecordOf 
//			offset 0 NamedTypeOf fDBHeader TypeDef of "Type ID 248"
//			offset 12 NamedTypeOf fObjectID 
//			offset 16 NamedTypeOf fOwnerID unsigned long 
//			offset 20 NamedTypeOf fPrevObjectID 
//			offset 24 NamedTypeOf fNextObjectID unsigned long 
//			offset 28 NamedTypeOf fItemCount 
//			offset 30 NamedTypeOf fItemSize signed short 
//			offset 32 NamedTypeOf fReserved1 
//			offset 36 NamedTypeOf fReserved2 unsigned long 
//			offset 40 NamedTypeOf fDataBlock 
//			offset 168 NamedTypeOf fDBFooter TypeDef of "Type ID 250"
//	
//
//	static Boolean	aRunOnceFlag = false;	
//	if (aRunOnceFlag == false)
//	{
//		CTextObjectData_10_1	*tempData = &(this->fObjectData);
//		register unsigned long baseAddr = (unsigned long) tempData;
//
//		//FileFormatSaftyChk(CTextObjectData_10_1, fDBHeader,		0);
//		//FileFormatSaftyChk(CTextObjectData_10_1, fObjectID,		12);				// this is us (denormalized)
//		//FileFormatSaftyChk(CTextObjectData_10_1, fOwnerID,		16);				// who ownes us
//		//FileFormatSaftyChk(CTextObjectData_10_1, fPrevObjectID,	20);			// Link to previous object
//		//FileFormatSaftyChk(CTextObjectData_10_1, fNextObjectID,	24);			// Link to next object
//		//FileFormatSaftyChk(CTextObjectData_10_1, fItemCount,		28);
//		//FileFormatSaftyChk(CTextObjectData_10_1, fItemSize,		30);
//		//FileFormatSaftyChk(CTextObjectData_10_1, fReserved1,		32);
//		//FileFormatSaftyChk(CTextObjectData_10_1, fReserved2,		36);
//		//FileFormatSaftyChk(CTextObjectData_10_1, fDataBlock[0],	40);
//		//FileFormatSaftyChk(CTextObjectData_10_1, fDBFooter,		168);
//		this->ReportBackwardCompatibility(sizeof(CTextObjectData_10_1),	172,	"CTextObjectData_10_1", "SIZEOF()");
//		this->ReportBackwardCompatibility(kExpansionDataSize,	172,	"CTextObjectData_10_1", "kExpansionDataSize");
//	}
//	
//	aRunOnceFlag = true;
}

//--------------------------------------------------------------------------------------------------
//	* GetMyObjectData ()
//
//--------------------------------------------------------------------------------------------------

CTextObjectData_10_1* CTextObject_10_1::GetMyObjectData ( void )
{
	CTextObjectData_10_1* result = nil;
	if ( this != nil )
	{
		result = &( this->fObjectData );
	}

	return( result );

} // GetMyObjectData


//--------------------------------------------------------------------------------------------------
//	* SetDirty ()
//
//--------------------------------------------------------------------------------------------------

void CTextObject_10_1::SetDirty	( void )
{
	if ( (this != nil) && (this->GetMyObjectID() != 0) )
	{
		setDirty();
	}
} // SetDirty


#pragma mark -
#pragma mark * Getters/Setters

//--------------------------------------------------------------------------------------------------
//	* GetMyObjectID ()
//
//--------------------------------------------------------------------------------------------------

ObjID CTextObject_10_1::GetMyObjectID ( void )
{
	return( fObjectData.fObjectID );
} // GetMyObjectID


//--------------------------------------------------------------------------------------------------
//	* SetMyObjectID ()
//
//--------------------------------------------------------------------------------------------------

void CTextObject_10_1::SetMyObjectID ( ObjID inObjID )
{
	if ( fObjectData.fObjectID != inObjID )
	{
		fObjectData.fObjectID = inObjID;
		this->SetDirty();
	}
} // SetMyObjectID


//--------------------------------------------------------------------------------------------------
//	* GetNextObjectID ()
//
//--------------------------------------------------------------------------------------------------

ObjID CTextObject_10_1::GetNextObjectID ( void )
{
	return( fObjectData.fNextObj );
} // GetNextObjectID


//--------------------------------------------------------------------------------------------------
//	* SetNextObjectID ()
//
//--------------------------------------------------------------------------------------------------

void CTextObject_10_1::SetNextObjectID ( ObjID inObjID )
{
	if ( fObjectData.fNextObj != inObjID )
	{
		fObjectData.fNextObj = inObjID;
		this->SetDirty();
	}
} // SetNextObjectID


//--------------------------------------------------------------------------------------------------
//	* GetOffset ()
//
//--------------------------------------------------------------------------------------------------

uInt32 CTextObject_10_1::GetOffset ( void )
{
	return( fObjectData.fOffset );
} // GetOffset


//--------------------------------------------------------------------------------------------------
//	* SetOffset ()
//
//--------------------------------------------------------------------------------------------------

void CTextObject_10_1::SetOffset ( uInt32 inOffset )
{
	if ( fObjectData.fOffset != inOffset )
	{
		fObjectData.fOffset = inOffset;
		this->SetDirty();
	}
} // SetOffset


//--------------------------------------------------------------------------------------------------
//	* GetItemCount ()
//
//--------------------------------------------------------------------------------------------------

sInt32 CTextObject_10_1::GetItemCount ( void )
{
	return( fObjectData.fItemCount );
} // GetItemCount


//--------------------------------------------------------------------------------------------------
//	* SetItemCount ()
//
//--------------------------------------------------------------------------------------------------

void CTextObject_10_1::SetItemCount ( sInt32 inCount )
{
	if ( (sInt32)fObjectData.fItemCount != inCount )
	{
		fObjectData.fItemCount = inCount;
		this->SetDirty();
	}
} // SetItemCount


//--------------------------------------------------------------------------------------------------
//	* IncrementItemCount ()
//
//--------------------------------------------------------------------------------------------------

void CTextObject_10_1::IncrementItemCount ( void )
{
	fObjectData.fItemCount++;
	this->SetDirty();
} // IncrementItemCount


//--------------------------------------------------------------------------------------------------
//	* DecrementItemCount ()
//
//--------------------------------------------------------------------------------------------------

void CTextObject_10_1::DecrementItemCount ( void )
{
	if ( fObjectData.fItemCount > 0 )
	{
		fObjectData.fItemCount--;
		this->SetDirty();
	}
} // DecrementItemCount


//--------------------------------------------------------------------------------------------------
//	* GetDataBlock ()
//
//--------------------------------------------------------------------------------------------------

char* CTextObject_10_1::GetDataBlock ( void )
{
	return( fObjectData.fStringData );
} // GetDataBlock


//--------------------------------------------------------------------------------------------------
//	* SetDataBlock ()
//
//--------------------------------------------------------------------------------------------------

void CTextObject_10_1::SetDataBlock ( char *inData )
{
	if ( inData != nil )
	{
		::memcpy( &fObjectData.fStringData, inData, kTextObjSize_10_1 );
		this->SetDirty();
	}
} // SetDataBlock


//--------------------------------------------------------------------------------------------------
//	* AddString ()
//
//--------------------------------------------------------------------------------------------------

sInt32 CTextObject_10_1::AddString ( const char *inString, uInt16 *outOffset )
{
	sInt32		siResult	= kNoErr;
	uInt16		usStrLen	= 0;

	if ( inString != nil )
	{
		usStrLen = ::strlen( inString );

		if ( (fObjectData.fOffset + 4) >= kTextObjSize_10_1 )
		{
			siResult = kObjectFull;
		}
		else if ( (usStrLen + fObjectData.fOffset + 2) > kTextObjSize_10_1 )
		{
			siResult = kStringTooBig;
		}
		else
		{
			*outOffset = fObjectData.fOffset;

			// Copy the marker
			::memcpy( fObjectData.fStringData + fObjectData.fOffset, kStringMarker, 2 );

			// Bump the offset past the marker
			fObjectData.fOffset += 2;

			// Copy the length of the string
			::memcpy( fObjectData.fStringData + fObjectData.fOffset, &usStrLen, 2 );

			// Bump the offset past the length
			fObjectData.fOffset += 2;

			// Copy the string
			::memcpy( fObjectData.fStringData + fObjectData.fOffset, inString, usStrLen );
			
			// Bump the offset past the string
			fObjectData.fOffset += usStrLen;

			// Increment the object count
			fObjectData.fItemCount++;

			// Set the object to dirty
			this->SetDirty();
		}
	}
	else
	{
		siResult = kNullStirng;
	}

	return( siResult );

} // AddString


//--------------------------------------------------------------------------------------------------
//	* RemoveString ()
//
//--------------------------------------------------------------------------------------------------

sInt32 CTextObject_10_1::RemoveString ( uInt16 inOffset )
{
	sInt32		siResult	= kNoErr;
	uInt16		usOffset	= 0;
	uInt16		usStrLen	= 0;

	usOffset = inOffset;
	if ( inOffset < kTextObjSize_10_1 )
	{
		if ( ::memcmp( fObjectData.fStringData + usOffset, kStringMarker, 2 ) == 0 )
		{
			// Skip past the marker
			usOffset += 2;

			// Get the length of the string
			::memcpy( &usStrLen, fObjectData.fStringData + usOffset, 2 );

			// Verify that the lenght is not too big.  It can't be bigger than
			//	the text object size minus the offset
			if ( usStrLen <= (kTextObjSize_10_1 - usOffset) )
			{
				// Everything checks out.  Decrement the string count
				DecrementItemCount();

				siResult = kNoErr;
			}
			else
			{
				siResult = kInvalidString;
			}
		}
		else
		{
			siResult = kInvalidOffset;
		}
	}
	else
	{
		siResult = kOffsetTooBig;
	}

	return( siResult );

} // RemoveString


//--------------------------------------------------------------------------------------------------
//	* GetString ()
//
//--------------------------------------------------------------------------------------------------

sInt32 CTextObject_10_1::GetString ( uInt16 inOffset, char **outStr )
{
	sInt32		siResult	= kNoErr;
	uInt16		usOffset	= 0;
	uInt16		usStrLen	= 0;
	char	   *pOutStr		= nil;

	if ( outStr != nil )
	{
		usOffset = inOffset;
		if ( inOffset < kTextObjSize_10_1 )
		{
			if ( ::memcmp( fObjectData.fStringData + usOffset, kStringMarker, 2 ) == 0 )
			{
				// Skip past the marker
				usOffset += 2;

				// Get the length of the string
				::memcpy( &usStrLen, fObjectData.fStringData + usOffset, 2 );

				// Skip past the length
				usOffset += 2;

				// Verify that the lenght is not too big.  It can't be bigger than
				//	the text object size minus the offset
				if ( usStrLen <= (kTextObjSize_10_1 - usOffset) )
				{
					if ( ::strlen( fObjectData.fStringData + usOffset ) == usStrLen )
					{
						pOutStr = (char *)::calloc( usStrLen + 1, sizeof( char ) );
						if ( pOutStr != nil )
						{
							// Copy out the string
							::memcpy( pOutStr, fObjectData.fStringData + usOffset, usStrLen );

							*outStr = pOutStr;

							siResult = kNoErr;
						}
						else
						{
							siResult = kMemFullErr;
						}
					}
					else
					{
						siResult = kCorruptStrObj;
					}
				}
				else
				{
					siResult = kInvalidString;
				}
			}
			else
			{
				siResult = kInvalidOffset;
			}
		}
		else
		{
			siResult = kOffsetTooBig;
		}
	}
	else
	{
		siResult = kEmptyDestString;
	}

	return( siResult );

} // GetString

