/*
	File:		UHeaders.10.1.h

	Contains:	C++ class definition of 822 Header Manipulation class

	Copyright:	 1996-2001 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: UHeaders.10.1.h,v $
		Revision 1.1  2003/04/20 23:46:10  dasenbro
		Initial check-in.
		
		
	To Do:
*/


#ifndef __UHeaders_10_1_h__
#define __UHeaders_10_1_h__ 1

#include "CEnvelope.10.1.h"
#include "CSmallMsgPart.10.1.h"
#include "CMessagePart.10.1.h"

#include "DatabaseTypes.h"

const uInt32 kMaxReceivedHeadersResType_10_1	= 'MaxR';
const uInt32 kMaxReceivedHeadersResID_10_1	= 128;

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif

typedef struct
{
	uInt16 version;
	uInt16 maxReceivedHeaders;
} MaxReceivedHeaders_10_1;

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

class UHeaders_10_1
{
public:
	// Static members
	static char* FindHeaderTerm			( char *inBuffer, uInt32 inBufferLength );
	static long	 GetMaxReceivedHeaders	( void );
	static const char* GetMsgviaString	( CEnvelope_10_1 *inEnvelope );

	// Constructor - Destructor
				UHeaders_10_1			( ObjID inEnvelopeID );
	virtual	   ~UHeaders_10_1			( void );

	// Initialization
	Boolean		Initialize			( void );

	// Header Management
	void		Sanitize822Headers	( uInt32 inServerIPAddr );
//	Boolean		GetReturnAddress	( char *outValue );
	Boolean		HeaderValue			( char *inBuffer, long inBufLen, const char *inHeader, char *outBuffer );
	long		RemoveHeader		( char *inBuffer, long inBufLen, char *inHeader );
	long		CountReceived		( void );

	Boolean		GetHeaderFromMsg	( const char *inHeader, CString &outBuffer, Boolean inIncludeTag = false, Boolean inCheckPrefix = true );
	Boolean		GetHeaderFromBuff	( char *inBuffer, long inBufLen, const char *inHeader, CString &outBuffer, Boolean inIncludeTag = false );

	void		Get822Header		( CString &outHdr );

protected:
	ObjID		fEnvelopeID;
	
private:
	char*		FindHdrTag			( const char *inString, const char *inHdrTag );

	char			   *fDataPtr;
	char			   *fEndPtr;
	uInt32				fHdrLen;
	CEnvelope_10_1	   *fEnvelope;
	CSmallMsgPart_10_1 *fSmallMsgPart;
	CMessagePart_10_1  *fLargeMsgPart;
};


#endif // __UHeaders_10_1_h__
