 /*
	$Id: CMailboxes.h,v 1.1 2003/04/20 23:30:51 dasenbro Exp $

	File:		CMailboxes.h

	Contains:	

	Version:	Apple Mail Server - Mac OS X :  $Revision: 1.1 $

	Written by:	Michael Dasenbrock

	Copyright:	 1996-2001 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: CMailboxes.h,v $
		Revision 1.1  2003/04/20 23:30:51  dasenbro
		Initial check-in.
		
		Revision 1.5  2002/03/21 16:41:32  dasenbro
		Updated file version information.
		
		Revision 1.4  2001/06/21 20:51:03  dasenbro
		Updated file header info.
		
		Revision 1.3  2001/06/21 19:35:25  dasenbro
		Added Change History.
		

	Projector History:

	 <ASM22>	 3/22/99	MED		Added an account ID to the constructor.
		<21>	11/11/98	MED		Fixed a wild card list bug.
		<20>	11/10/98	MED		Fixed multiple wild card list problem.
		<19>	10/28/98	DOR		Undo previous fix.
		<18>	10/28/98	DOR		fix for bug#2282687
		<17>	 9/14/98	MED		Added an IsShared flag to GetThisMailboxesID().
		<16>	 8/24/98	MED		Addes support for x-list.
		<15>	 8/10/98	MED		Added better support of ACLs.
		<14>	  8/3/98	MED		6.1 - Added get/set account for ACL support.
		<13>	 4/25/98	MED		Added GetMailboxCount and some max defines.
		<12>	  4/8/98	MED		Added case sensitive mailbox namespace checking.
		<11>	 3/17/98	MED		Added MatchCase() to match the response mailbox path with that
									of the one on the command line.
		<10>	 2/23/98	MED		Made RenameMailbox() virtual so admin port can override.
		 <9>	 2/11/98	MED		Added delimiter constants.
		 <8>	  2/9/98	MED		Removed CEndpoint, it wi no longer needed.
		 <7>	  2/7/98	MED		Made some member functions virtual to add support for the admin
									port.  Hey, that rhymes.
		 <6>	  2/5/98	MED		Fixed the FIND command to show only subscribed mailboxes.
		 <5>	  2/4/98	MED		Modified WriteMailboxPath to take the spool flags to check for
									Noselect.
		 <4>	  2/2/98	MED		Simplified the user of the "Reference Name" argument in the list
									command.  We now concatenate the 2 args to form a single mailbox
									path.
		 <3>	 1/27/98	MED		Added list support for POP3 inbox in the IMAP mailbox list.
		 <2>	 11/5/97	MED		Added kCmdSubUnsub constant.

	To Do:
*/


#ifndef __CMailboxes_h__
#define __CMailboxes_h__

#include "DatabaseTypes.h"
#include "MailTypes.h"

class CMailSpool;
class CString;

// Mailbox class defines

#define		kNoFlags			"()"
#define		kQuotedDelimStr		"\"/\""
#define		kHierDelimStr		"/"
#define		kDotDelimStr		"."
#define		kDoubleDelimStr		"//"
#define		kHierDelimChar		'/'
#define		kHierRootChar		'~'
#define		kHierRootStr		"~/"
#define		kEmptyFieldStr		"\"\""
#define		kEOL				"\r\n"
#define		kTerminator			'\0'
#define		kStarStr			"*"
#define		kPercentStr			"&"
#define		kDoubleStarStr		"**"
#define		kDoublePercentStr	"%%"
#define		kStarPercentStr		"*%"
#define		kPercentStarStr		"%*"

const	uInt16	kMailboxNameLen			= 128;
const	uInt16	kMaxMailboxDepth		= 32;
const	uInt32	kMaxMailboxCount		= 1000;

class	CIMAPSession;

class CMailboxes
{
public:
	typedef enum
	{
		kMatchExact			= 0x0001,
		kMatchOnly			= 0x0002,
		kMatchAll			= 0x0004,
		kMatchBetween		= 0x0008,
		kHasPrefix			= 0x0100,
		kEndActions			= 0xFFFF
	} eActions;

	typedef enum
	{
		kListRootOnly		= 0x0001,
		kListOneMailbox		= 0x0002,
		kListAll			= 0x0010,
		kListSubOnly		= 0x0020,

		kEndFlags			= 0xFFFF
	} eFlags;

	typedef enum
	{
		kCmdFind			=  1,
		kCmdList			=  2,
		kCmdLsub			=  3,
		kCmdCreate			=  4,
		kCmdSelect			=  5,
		kCmdCopy			=  6,
		kCmdExamine			=  7,
		kCmdDelete			=  8,
		kCmdRename			=  9,
		kCmdStatus			= 10,
		kCmdSubUnsub		= 11,
		kCmd_X_List			= 12
	} eCommand;

					CMailboxes				( char *inSession, Boolean inIs8BitOn, ObjID inAcctID = 0 );
	virtual		   ~CMailboxes				( void );

	void			Initialize				( const char *arg1, const char *arg2, const char *inCommand, eCommand inCmdType );

	ObjID			GetCurrentMailboxID		( void );

	ObjID			GetMailbox1ObjID		( void );
	ObjID			GetMailbox2ObjID		( void );

	OSErr			DeleteMailbox			( void );
	OSStatus		MailboxHasInferiors		( ObjID mailboxID );
	Boolean			CanDelete				( ObjID inMbID );

	ObjID			GetThisMailboxesID		( char *inMailbox, ObjID inParentID, Boolean &IsShared );
	void			GetFullPath				( CString &inMbPath, CMailSpool *inMbSpool, const char *inDelim );
	uInt32			GetMailboxCount			( void );

	Boolean			IsInHierarchy			( ObjID inTargetID, ObjID inParentID );
	void			ListRoot				( CString &outMbList );

	ObjID			GetAccountID			( void );
	void			SetAccountID			( ObjID inAcctID );

	virtual	void	ListMailboxes			( CString &outMbList, Boolean inListPopInbox );
	virtual	ObjID	VerifyMailboxPath		( char *inMbPath );
	virtual sInt16	CreateMailbox			( Boolean inIsShared = false, ObjID inSharedSpoolID = 0, ObjID *outNewSpoolID = nil );
	virtual sInt16	RenameMailbox			( CMailSpool *inMbSpool );

protected:
	Boolean			HasPrefix				( char *inData );
	char*			SetPrefix				( char *inData );
	void			SetPrefixString			( char inChar, uInt16 inWhere );
	void			StripPrefix				( char *inData );
	sInt16			SetupCommand			( eCommand inCmdType );

	void			MatchCase				( CString &inMbStr );
	void			WriteMailboxPath		( CString &inMbPath, CString &outMbList, uInt32 inMBFlags );

	Boolean			CheckListConditions		( CString &inMbPath, Boolean &outListDeleted );
	Boolean			DoesThisMatch			( CString &inCmdArgs, CString &inMbName );
	Boolean			GetArgToken				( char *inData, CString &inCmdArgs );

	void			CombineArgs				( void );
	sInt16			VerifyArgs				( void );
	Boolean			OkToList				( CMailSpool *inSpool, Boolean inListPopInbox );

	void			SetMailbox1				( const char *inStr );
	void			SetMailbox2				( const char *inStr );

	char			fFldrPrefix[ 10 ];
	CIMAPSession   *fSession;

	ObjID			fAccountID;

	CString		   *fArg1;
	CString		   *fArg2;
	CString		   *fCommand;
	uInt32			fCmdType;

	uInt16			fFlags;

	eActions	   *fActions;
	sInt16			fActionCnt;

private:
	Boolean			f8BitOn;

};

#endif
