/*
	$Id: CIDList.h,v 1.1 2003/04/20 23:29:40 dasenbro Exp $

	File:		CIDList.h

	Contains:	break out from CPeriodicTasks files.

	Version:	Apple Mail Server - Mac OS X :  $Revision: 1.1 $

	Written by:	Chris Jalbert

	Copyright:	 1996-2001 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: CIDList.h,v $
		Revision 1.1  2003/04/20 23:29:40  dasenbro
		Initial check-in.
		
		Revision 1.7  2002/03/21 16:41:47  dasenbro
		Updated file version information.
		
		Revision 1.6  2001/06/21 20:43:28  dasenbro
		Added Change History.
		

	Projector History:

		 <1>	04/07/98	CPJ		Initial breakout.

	To Do:

*/

#ifndef CIDLIST_H
#define CIDLIST_H 1

#include "DatabaseTypes.h"

#define	kMaxDataCount	16

class CIDList
{
	public:

    enum {	kEmptyValue	= 0x00000000,
			kDeadValue	= 0xffffffff
    };


							CIDList();
		virtual				~CIDList();
		virtual		Boolean	AddID2List		(	ObjID	inData,
												Boolean	inDataFlag,
												Boolean	inDuplicateSuppress = false	);	// true means msg added to list
																						// false means msg not added to list
																						// (inDuplicateSuppress == true) means don't allow duplicates to be added to the list
		virtual		void	ClearIDList		(	void	);
		virtual		uInt32	GetItemCount	(	void	);
		virtual		Boolean	GetItem			(	uInt32	inIndex,
												ObjID	&outData,
												Boolean	&outDataFlag,
												Boolean	inClearItem = false	);	// true means item was valid
																				// false means index was:
																				//		a) empty
																				//		b) invalid
																				//	return value of false outData is not touched
																				//  (inClearItem == true) removes item from list
		virtual		Boolean	GetFirstItem	( ObjID &outData, Boolean &outDataFlag );
		virtual		Boolean	GetNextItem		( uInt32 &inNextItem, ObjID &outData, Boolean &outDataFlag, const Boolean inClearItem );

		virtual		uInt32	GetMaxItemCount	(	void	);

	protected:
	private:
		ObjID	fDataList[kMaxDataCount];
		Boolean	fDataFlagList[kMaxDataCount];
};

#endif // CIDLIST_H 1

