/*
	$Id: CRootObject.cpp,v 1.1 2003/04/20 23:29:40 dasenbro Exp $

	File:		CRootObject.cpp

	Contains:	xxx put contents here xxx

	Version:	Apple Mail Server - Mac OS X :  $Revision: 1.1 $

	Written by:	Michael Dasenbrock

	Copyright:	 1997-2001 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: CRootObject.cpp,v $
		Revision 1.1  2003/04/20 23:29:40  dasenbro
		Initial check-in.
		
		Revision 1.15  2002/06/04 17:36:03  dasenbro
		Added UnLockTheCache() to the catch().
		
		Revision 1.14  2002/05/20 21:41:41  dasenbro
		Added reset TOC calls.
		
		Revision 1.13  2002/05/09 16:47:25  dasenbro
		Changed all str... calls to CUtils::Str... to be NULL safe.
		
		Revision 1.12  2002/03/21 16:41:47  dasenbro
		Updated file version information.
		
		Revision 1.11  2002/03/11 23:10:49  dasenbro
		Changed noErr to kNoErr.
		
		Revision 1.10  2002/03/05 20:42:02  dasenbro
		Added ThrowIfNULL_ for the this pointer.
		
		Revision 1.9  2001/06/21 20:51:10  dasenbro
		Updated file header info.
		
		Revision 1.8  2001/06/21 20:09:54  dasenbro
		Added Change History.
		

	Projector History:

	 <ASM13>	  2/4/99	MED		Added getter/setter for version info.
		<12>	10/30/98	DOR		Added support for 2nd ID's to host entries.  We now move host's
									onto and off of a 2nd ID list based on their "nextAttemptTime"
									value.  The outgoing threads will only visit hosts on the
									"active" host list, therefore limiting the number of hosts that
									must be visited to process outgoing mail.
		<11>	  9/8/98	MED		Added getters/setters for the unused data members.
		<10>	  6/1/98	DOR		Remove the "kAdd" argument from Create since we no longer use
									it.
		 <9>	  6/1/98	MED		Changed ::Create to be a more kinder and gentler ::Create.
		 <8>	 5/19/98	MED		Added future expansion data members.
		 <7>	  4/2/98	DOR		Create/Save an ObjectID for dead envelopes.
		 <6>	 3/14/98	DOR		Close up a race condition in ::Create..
		 <4>	 3/10/98	DOR		Remove Outgoing & IMAP spool
		 <3>	 2/23/98	MED		Added an IndexRefNum to stamp the V-Twin index file now that we
									have indexing on demand.
		 <2>	 12/3/97	MED		Added a HostEntry default prefs ID field and the related Getter
									and Setter.

	To Do:
*/


#include <string.h>
#include <time.h>

#include "CRootObject.h"
#include "Database.h"
#include "CMailSpool.h"
#include "CStatMgr.h"
#include "CGlobals.h"

//--------------------------------------------------------------------------------------------------
//	* Globals
//
//--------------------------------------------------------------------------------------------------

CRootObject *gRootObj = NULL;


//--------------------------------------------------------------------------------------------------
//	* GetSetFields ()
//
//--------------------------------------------------------------------------------------------------

Boolean	CRootObject::GetSetFields	(const eFieldDataRequest inFieldRequest, const void *inObjDataPtr, void *outFieldData)
{
	Boolean			result = false;
	CRootObjectData	*theData = (CRootObjectData *) inObjDataPtr;
	CRootObject		*aTempObject	= NULL;
	ObjID			*anObjIDPtr = (ObjID *) outFieldData;

	switch (inFieldRequest)
	{
		case kSetObjID:
			theData->fRootObjID = *anObjIDPtr;
			break;

		case kObjectPINGRequest:
			// cause the objects constructor to get called, so we force a check of
			// the struct alignment...
			aTempObject = new CRootObject;
			delete aTempObject;
			break;

		case k2ndIDTargetChk:
			// fall through...

		default:
			result = false;
			break;
	}

	return result;
} // GetSetFields


//--------------------------------------------------------------------------------------------------
//	* GetObjectID ()
//
//--------------------------------------------------------------------------------------------------

ObjID CRootObject::GetObjectID	( void )
{
	return( fRootObjectData.fRootObjID );
} // GetObjectID


//--------------------------------------------------------------------------------------------------
//	* SetObjectID ()
//
//--------------------------------------------------------------------------------------------------

void CRootObject::SetObjectID ( ObjID inObjID )
{
	if ( fRootObjectData.fRootObjID != inObjID )
	{
		fRootObjectData.fRootObjID = inObjID;
		this->SetDirty();
	}
} // SetObjectID


//--------------------------------------------------------------------------------------------------
//	 Done
//
//--------------------------------------------------------------------------------------------------

void CRootObject::Done ( CRootObject* &inPtr )
{
	CDBBaseObject *aDBObject = (CDBBaseObject *) inPtr;
	aDBObject->Done(aDBObject);

	inPtr = (CRootObject *)aDBObject;

}

//--------------------------------------------------------------------------------------------------
//	* CRootObject ()
//
//--------------------------------------------------------------------------------------------------

CRootObject::CRootObject ( void ) :
	CDBMailBaseObject(	&fRootObjectData.fDBHeader,
				&fRootObjectData.fDBFooter,
				&fRootObjectData,
				CRootObject::GetObjTypeConstant(),
				CRootObject::GetObjVersConstant(),
				CRootObject::GetObjSizeConstant() )
{
	fRootObjectData.fRootObjID				= 0;
	fRootObjectData.fInSpoolID				= 0;
	fRootObjectData.fEnvDieSpoolID			= 0;
	fRootObjectData.fStatMgrID				= 0;
	fRootObjectData.fTocResetValue			= 0;
	fRootObjectData.fMessageTag				= 0;
	fRootObjectData.fAnyoneACLObjID			= 0;
	fRootObjectData.fActiveHost2ndID		= 0;
	fRootObjectData.fIndexRefNum			= 0;
	fRootObjectData.fTextObjectID			= 0;
	fRootObjectData.fVerInfo.fVersionInfoID = 0;

	// Reserved
	fRootObjectData.fReserved1				= kReservedConst;
	fRootObjectData.fReserved2				= kReservedConst;

	this->ChkCompilerStructAlignment();
} // CRootObject


//--------------------------------------------------------------------------------------------------
//	* ~CRootObject ()
//
//--------------------------------------------------------------------------------------------------

CRootObject::~CRootObject ( void )
{
} // ~CRootObject


void	CRootObject::ChkCompilerStructAlignment	( void )
{
	/*
		this dump was aquired by using the MPW command DumpSYM - TTE from the .xsym file produced
		from a Code Warrior Pro 1 Release Build of the AppleShare IP Mail Server for MacOS version 6.2

		this version of the structure is consider the "reference" standard for all future ASIP Mail Servers.
		If the structure does NOT match these offsets the version of the Mail Server that 
		you are compiling will _NOT_ be compatible with AppleShare IP 6.0, 6.1, or 6.2 (this also effects
		the AppleShare IP Mail Tool, and to a more limited extent the AppleShare IP Mail Admin since some
		of these structures are passed across the wire..)

		If _ANY_ of these Asserts "fire" you've got a backwards compatibility problem that _MUST_ be fixed!!

		this code wasn't put here for my personal amusement, this code was put here from a hard earned lesson
		that simple changes to headers/compilers _WILL_ break this stuff, better to know now than after we
		ship.  Look upon this code as a debugging AIDE, not an impediment.

		Type Name:  CRootObjectData		TINFO offset: 25680		(TINFO SYM file offset (hex): $11E450)
			RecordOf 
			offset 0 NamedTypeOf fDBHeader TypeDef of "Type ID 248"
			offset 12 NamedTypeOf fRootObjID 
			offset 16 NamedTypeOf fAnyoneACLObjID unsigned long 
			offset 20 NamedTypeOf fActiveHost2ndID 
			offset 24 NamedTypeOf fInSpoolID unsigned long 
			offset 28 NamedTypeOf fEnvDieSpoolID 
			offset 32 NamedTypeOf fStatMgrID unsigned long 
			offset 36 NamedTypeOf fTocResetValue 
			offset 40 NamedTypeOf fIndexRefNum unsigned long 
			offset 44 NamedTypeOf fVerInfo 
			offset 48 NamedTypeOf fDBFooter TypeDef of "Type ID 250"
	*/
	static Boolean	aRunOnceFlag = false;
	if (aRunOnceFlag == false)
	{
		//FileFormatSaftyChk(CRootObjectData, fDBHeader,			0);
		//FileFormatSaftyChk(CRootObjectData, fRootObjID,			12);		// this is us (denormalized)
		//FileFormatSaftyChk(CRootObjectData, fAnyoneACLObjID,			16);
		//FileFormatSaftyChk(CRootObjectData, fActiveHost2ndID,	20);	// Holds the ObjID of the Active Host 2nd ID list..
		//FileFormatSaftyChk(CRootObjectData, fInSpoolID,			24);
		//FileFormatSaftyChk(CRootObjectData, fEnvDieSpoolID,		28);
		//FileFormatSaftyChk(CRootObjectData, fStatMgrID,			32);
		//FileFormatSaftyChk(CRootObjectData, fTocResetValue,	36);
		//FileFormatSaftyChk(CRootObjectData, fIndexRefNum,		40);
		//FileFormatSaftyChk(CRootObjectData, fVerInfo,			44);
		//FileFormatSaftyChk(CRootObjectData, fDBFooter,			48);
//		this->ReportBackwardCompatibility(sizeof(CRootObjectData),	52,	"CRootObjectData", "SIZEOF()");
//		this->ReportBackwardCompatibility(kCRootObjectDataSize,	52,	"CRootObjectData", "kCRootObjectDataSize");
	}

	aRunOnceFlag = true;
}

#pragma mark -

//--------------------------------------------------------------------------------------------------
//	* ObjectAllocNew ()
//
//--------------------------------------------------------------------------------------------------

CDBBaseObject * CRootObject::ObjectAllocNew	( void )
{
	return new CRootObject;
} // ObjectAllocNew


//--------------------------------------------------------------------------------------------------
//	* FindByID ()
//
//--------------------------------------------------------------------------------------------------

CRootObject* CRootObject::FindByID ( const ObjID inObjectID )
{
	return (CRootObject *) CDBMailBaseObject::MailUniversalFindByID(	inObjectID,
														CRootObject::GetObjTypeConstant(),
														CRootObject::GetObjVersConstant(),
														CRootObject::GetObjSizeConstant(),
														CRootObject::ObjectAllocNew		);
} // FindByID


//--------------------------------------------------------------------------------------------------
//	* Find ()
//
//--------------------------------------------------------------------------------------------------

CRootObject* CRootObject::Find ( void )
{
	OSStatus		result;
	ObjID			rootObjID		= 0;
	uInt32			rootObjCount	= 0;
	CRootObject	   *pRootObj		= NULL;
	SDBIterator		aIterator( gDB );

	Try_
	{
		if ( gRootObj == NULL )
		{
			result = gDB->GetObjectCount( kMailRootSignature, rootObjCount );
			if ( result == kNoErr )
			{
				if ( rootObjCount == 0 )
				{
					// Need to create it
					pRootObj = CRootObject::Create();
					ThrowIfNULL_( pRootObj );
					gRootObj = pRootObj;
				}
				else if ( rootObjCount != 1 )
				{
					result = gDB->CreateIterator( kMailRootSignature, &aIterator );
					while ( gDB->NextObject( &aIterator, rootObjID ) == kNoErr )
					{
						pRootObj = CRootObject::FindByID( rootObjID );
						if ( pRootObj != nil )
						{
							CRootObject::Delete( pRootObj );
							pRootObj->Done( pRootObj );
							pRootObj = nil;
						}
					}
					gDB->ReleaseIterator( &aIterator );

					// Need to create it
					pRootObj = CRootObject::Create();
					ThrowIfNULL_( pRootObj );
					gRootObj = pRootObj;
				}
				else
				{
					// Lets find it
					pRootObj = new CRootObject;
					ThrowIfNULL_( pRootObj );

					result = gDB->CreateIterator( kMailRootSignature, &aIterator );
					if ( result == kNoErr )
					{
						if ( gDB->GetCurObject( &aIterator, rootObjID, pRootObj->GetRootObjectData() ) == kNoErr )
						{
							pRootObj->Use();
						}
						else
						{
							delete( pRootObj );
							pRootObj = NULL;
						}
					}
					gDB->ReleaseIterator( &aIterator );

					gRootObj = pRootObj;
				}
			}
		}
		else
		{
			pRootObj = gRootObj;
		}
	}

	Catch_( err )
	{
		return( NULL );
	}

	return ( pRootObj );

} // Find


//--------------------------------------------------------------------------------------------------
//	* Create ()
//
//--------------------------------------------------------------------------------------------------

CRootObject* CRootObject::Create ( void )
{
	OSStatus		result		= kNoErr;
	ObjID			newRootID	= 0;
	CRootObject	   *pNewRootObj	= nil;
	CStatMgr	   *aStatMgr	= nil;
	CMailSpool	   *pInSpool	= nil;

	try
	{
		pNewRootObj = new CRootObject;
		ThrowIfMemFail_( pNewRootObj );

		(gDB->GetBaseObjectCachePtr())->LockTheCache( CRootObject::GetObjTypeConstant() );

		aStatMgr = CStatMgr::Create();
		ThrowIfNULL_( aStatMgr );

		pInSpool = CMailSpool::Create( CMailSpool::kIncomingSpool, "Incoming", CMailSpool::kRootParent );
		ThrowIfNULL_( pInSpool );

		pNewRootObj->SetStatMgrID( aStatMgr->GetStatMgrID() );
		pNewRootObj->SetSysSpoolID( CMailSpool::kIncomingSpool, pInSpool->GetMailSpoolID() );

		pInSpool->Done( pInSpool );
		aStatMgr->Done( aStatMgr );

		pNewRootObj->SetMessageTag( ::time( nil ) );

		//------------------------------------------------------------------------------
		// Just consume a Database ObjectID to avoid duplicate ID's in the future...
		// this ID is used to "build" the 2nd ID list, that keeps track of dead
		// CEnvelope objects, due to CDatabase's implemenation it is important that this
		// ID _NOT_ be duplicated ever again...so we create an object, save off it's ID
		// and then delete that object to avoid confusing any other code...

		pInSpool = CMailSpool::Create( CMailSpool::kIncomingSpool, "Envelope Die Spool", CMailSpool::kRootParent );
		ThrowIfNULL_( pInSpool );

		pNewRootObj->SetEnvelopeDieSpoolID( pInSpool->GetObjectID() );
		pInSpool->Done( pInSpool );

		pNewRootObj->GetActiveHost2ndID( true );	// force the root obj's 2nd ID to be created...

		result = gDB->CreateObj( kMailRootSignature, newRootID, pNewRootObj->GetRootObjectData() );

		if ( result == CMailDatabase::kDBNoErr )
		{
			pNewRootObj->Use();
			pNewRootObj->SetDirty();
		}
		else
		{
			delete( pNewRootObj );
			pNewRootObj = nil;
		}

		(gDB->GetBaseObjectCachePtr())->UnLockTheCache( CRootObject::GetObjTypeConstant() );
	}

	catch ( long err )
	{
		if ( aStatMgr != nil )
		{
			aStatMgr->Done( aStatMgr );
		}

		if ( pInSpool != nil )
		{
			pInSpool->Done( pInSpool );
		}

		(gDB->GetBaseObjectCachePtr())->UnLockTheCache( CRootObject::GetObjTypeConstant() );
	}

	return( pNewRootObj );

} // Create


//--------------------------------------------------------------------------------------------------
//	* Delete
//
//--------------------------------------------------------------------------------------------------

Boolean CRootObject::Delete ( CRootObject *inObjPtr )
{
	Boolean deleted = false;
	OSErr	result;

	try
	{
		if ( inObjPtr != nil )
		{
			result = gDB->RemoveObj( kMailRootSignature, inObjPtr->GetObjectID() );
			deleted = ( result == kNoErr );
			if ( deleted )
			{
				inObjPtr->SetObjectID( 0 );
			}
		}
	}

	catch( long err )
	{
	}

	catch( ... )
	{
	}

	return( deleted );

} // Delete


//--------------------------------------------------------------------------------------------------
//	* GetRootObjectData ()
//
//--------------------------------------------------------------------------------------------------

CRootObjectData* CRootObject::GetRootObjectData ( void )
{
	if (this != NULL)
	{
		return &(this->fRootObjectData);
	}
	else
	{
		return NULL;
	}
} // GetRootObjectData


//--------------------------------------------------------------------------------------------------
//	* SetDirty ()
//
//--------------------------------------------------------------------------------------------------

void CRootObject::SetDirty	( void )
{
	if ((this != NULL) && (this->GetRootObjID() != 0))
	{
		setDirty();
	}
} // SetDirty


//--------------------------------------------------------------------------------------------------
//	* GetRootObjID ()
//
//--------------------------------------------------------------------------------------------------

ObjID CRootObject::GetRootObjID ( void )
{
	return( fRootObjectData.fRootObjID );
} // GetRootObjID


//--------------------------------------------------------------------------------------------------
//	* GetSysSpoolID ()
//
//--------------------------------------------------------------------------------------------------

ObjID CRootObject::GetSysSpoolID ( const OSType inSpoolType )
{
	ObjID	result = 0;

	switch ( inSpoolType )
	{
		case CMailSpool::kIncomingSpool:
			result = fRootObjectData.fInSpoolID;
			break;

		default:
			break;
	}

	return( result );
} // GetSysSpoolID


//--------------------------------------------------------------------------------------------------
//	* SetSysSpoolID ()
//
//--------------------------------------------------------------------------------------------------

void CRootObject::SetSysSpoolID ( const OSType inSpoolType, ObjID inSysSpoolID )
{
	switch ( inSpoolType )
	{
		case CMailSpool::kIncomingSpool:
			fRootObjectData.fInSpoolID = inSysSpoolID;
			break;

		default:
			break;
	}
	this->SetDirty();
} // SetSysSpoolID


//--------------------------------------------------------------------------------------------------
//	* GetStatMgrID ()
//
//--------------------------------------------------------------------------------------------------

ObjID CRootObject::GetStatMgrID ( void )
{
	return( fRootObjectData.fStatMgrID );

} // SetStatMgrID


//--------------------------------------------------------------------------------------------------
//	* GetStatMgrID ()
//
//--------------------------------------------------------------------------------------------------

void CRootObject::SetStatMgrID ( ObjID inStatMgrID )
{
	if ( inStatMgrID != fRootObjectData.fStatMgrID )
	{
		fRootObjectData.fStatMgrID = inStatMgrID;
		this->SetDirty();
	}
} // SetStatMgrID


//--------------------------------------------------------------------------------------------------
//	* GetStatMgrID ()
//
//--------------------------------------------------------------------------------------------------

SVersionInfo* CRootObject::GetVerInfoID ( void )
{
	return( &fRootObjectData.fVerInfo );

}


//--------------------------------------------------------------------------------------------------
//	* GetStatMgrID ()
//
//--------------------------------------------------------------------------------------------------

void CRootObject::SetVerInfoID ( SVersionInfo *inVerInfoStruct )
{
	if ( ::memcmp( &fRootObjectData.fVerInfo, inVerInfoStruct, sizeof( SVersionInfo ) != 0 ) )
	{
		::memcpy(  &fRootObjectData.fVerInfo, inVerInfoStruct, sizeof( SVersionInfo ) );
		this->SetDirty();
	}
} // GetStatMgrID


//--------------------------------------------------------------------------------------------------
//	* GetEnvelopeDieSpoolID ()
//
//--------------------------------------------------------------------------------------------------

ObjID CRootObject::GetEnvelopeDieSpoolID ( void )
{
	return ( fRootObjectData.fEnvDieSpoolID );
} // GetEnvelopeDieSpoolID


//--------------------------------------------------------------------------------------------------
//	* SetEnvelopeDieSpoolID ()
//
//--------------------------------------------------------------------------------------------------

void CRootObject::SetEnvelopeDieSpoolID ( const ObjID inDieSpoolID )
{
	if ( inDieSpoolID != fRootObjectData.fEnvDieSpoolID )
	{
		fRootObjectData.fEnvDieSpoolID = inDieSpoolID;
		this->SetDirty();
	}
} // SetEnvelopeDieSpoolID


//--------------------------------------------------------------------------------------------------
//	* GetIndexRefNum ()
//
//--------------------------------------------------------------------------------------------------

uInt32 CRootObject::GetIndexRefNum ( void )
{
	return ( fRootObjectData.fIndexRefNum );
} // GetIndexRefNum


//--------------------------------------------------------------------------------------------------
//	* SetIndexRefNum ()
//
//--------------------------------------------------------------------------------------------------

void CRootObject::SetIndexRefNum ( uInt32 inRefNum )
{
	if ( inRefNum != fRootObjectData.fIndexRefNum )
	{
		fRootObjectData.fIndexRefNum = inRefNum;
		this->SetDirty();
	}
} // SetIndexRefNum


//--------------------------------------------------------------------------------------------------
//	* GetVersionInfo ()
//
//--------------------------------------------------------------------------------------------------

uInt32 CRootObject::GetVersionInfo ( void )
{
	return ( fRootObjectData.fVerInfo.fVersionInfoID );
} // GetVersionInfo


//--------------------------------------------------------------------------------------------------
//	* SetVersionInfo ()
//
//--------------------------------------------------------------------------------------------------

void CRootObject::SetVersionInfo ( uInt32 inVersInfo )
{
	if ( fRootObjectData.fVerInfo.fVersionInfoID != inVersInfo )
	{
		fRootObjectData.fVerInfo.fVersionInfoID = inVersInfo;
		this->SetDirty();
	}
} // SetVersionInfo


//--------------------------------------------------------------------------------------------------
//	* GetAnyoneObjID ()
//
//--------------------------------------------------------------------------------------------------

uInt32 CRootObject::GetAnyoneObjID ( void )
{
	return ( fRootObjectData.fAnyoneACLObjID );
} // GetAnyoneObjID


//--------------------------------------------------------------------------------------------------
//	* SetAnyoneObjID ()
//
//--------------------------------------------------------------------------------------------------

void CRootObject::SetAnyoneObjID ( uInt32 inValue )
{
	if ( inValue != fRootObjectData.fAnyoneACLObjID )
	{
		fRootObjectData.fAnyoneACLObjID = inValue;
		this->SetDirty();
	}
} // SetAnyoneObjID


//--------------------------------------------------------------------------------------------------
//	* GetActiveHost2ndID ()
//
//--------------------------------------------------------------------------------------------------

ObjID CRootObject::GetActiveHost2ndID ( const Boolean inCreateFlag )
{

	if ( inCreateFlag == true )
	{
		if ( (fRootObjectData.fActiveHost2ndID == 0) || (fRootObjectData.fActiveHost2ndID == 0xf0f0f0f0) )
		{
			CMailSpool *anInSpool	= nil;

			//------------------------------------------------------------------------------
			// Just consume a Database ObjectID to avoid duplicate ID's in the future...
			// this ID is used to "build" the 2nd ID list, that keeps track of active host entries..
			// due to CDatabase's implemenation it is important that this
			// ID _NOT_ be duplicated ever again...so we create an object, save off it's ID
			// and then delete that object to avoid confusing any other code...

			anInSpool = CMailSpool::Create( CMailSpool::kIncomingSpool, "Active Host Entries", CMailSpool::kRootParent );
			ThrowIfNULL_(anInSpool);

			this->SetActiveHost2ndID( anInSpool->GetObjectID() );
//			CMailSpool::Delete(anInSpool);
			anInSpool->Done( anInSpool );
		}
	}

	return ( fRootObjectData.fActiveHost2ndID );
} // GetActiveHost2ndID


//--------------------------------------------------------------------------------------------------
//	* SetActiveHost2ndID ()
//
//--------------------------------------------------------------------------------------------------

void CRootObject::SetActiveHost2ndID ( const ObjID inActiveHost2ndID )
{
	if ( inActiveHost2ndID != fRootObjectData.fActiveHost2ndID )
	{
		fRootObjectData.fActiveHost2ndID = inActiveHost2ndID;
		this->SetDirty();
	}
} // SetActiveHost2ndID


//--------------------------------------------------------------------------------------------------
//	* GetMessageTag ()
//
//--------------------------------------------------------------------------------------------------

ObjID CRootObject::GetMessageTag ( void )
{
	return ( fRootObjectData.fMessageTag );

} // GetMessageTag


//--------------------------------------------------------------------------------------------------
//	* SetMessageTag ()
//
//--------------------------------------------------------------------------------------------------

void CRootObject::SetMessageTag ( const ObjID inHostID )
{
	if ( inHostID != fRootObjectData.fMessageTag )
	{
		fRootObjectData.fMessageTag = inHostID;
		this->SetDirty();
	}
} // SetMessageTag


//--------------------------------------------------------------------------------------------------
//	* GetTOCResetValue ()
//
//--------------------------------------------------------------------------------------------------

ObjID CRootObject::GetTOCResetValue ( void )
{

	return ( fRootObjectData.fTocResetValue );
} // GetTOCResetValue


//--------------------------------------------------------------------------------------------------
//	* SetTOCResetValue ()
//
//--------------------------------------------------------------------------------------------------

void CRootObject::SetTOCResetValue ( const uInt32 inValue )
{
	if ( fRootObjectData.fTocResetValue != inValue )
	{
		fRootObjectData.fTocResetValue = inValue;
		this->SetDirty();
	}
} // SetTOCResetValue


// ------------------------------------------------------------------
//	* GetCurrTextObjID
// ------------------------------------------------------------------

ObjID CRootObject::GetCurrTextObjID ( void )
{
	return( fRootObjectData.fTextObjectID );
} // GetCurrTextObjID


// ------------------------------------------------------------------
//	* SetCurrTextObjID
// ------------------------------------------------------------------

void CRootObject::SetCurrTextObjID ( ObjID inTextObjID )
{
	if ( fRootObjectData.fTextObjectID != inTextObjID )
	{
		fRootObjectData.fTextObjectID = inTextObjID;
		this->SetDirty();
	}
} // SetCurrTextObjID

