/*
	$Id: CTokenizer.h,v 1.1 2003/04/20 23:29:40 dasenbro Exp $

	File:	CTokenizer.h

	Version:	Apple Mail Server - Mac OS X :  $Revision: 1.1 $

	Contains: A Class which parses CString object into tokens.

	Written by: Claris Corporation 

	Copyright:	 1996-2001 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: CTokenizer.h,v $
		Revision 1.1  2003/04/20 23:29:40  dasenbro
		Initial check-in.
		
		Revision 1.8  2002/03/21 16:41:47  dasenbro
		Updated file version information.
		
		Revision 1.7  2001/06/21 20:45:06  dasenbro
		Added Change History.
		

	Projector History:


	To Do:
 */


#ifndef _CTOKENIZER_H
#define _CTOKENIZER_H 1

#include "MailTypes.h"

#include "CString.h"

//------------------------------------------------------------------------------
// *CTokenizer - a tokenizer for CStrings
//------------------------------------------------------------------------------

class CTokenizer
{
	public:

		CTokenizer( CString&, const char*);
		CTokenizer();
		~CTokenizer();
		
		void		Retokenize( CString&, const char *inDelim );
		char*		Get( int n );
		int			GetLength( int n );
		Boolean		Compare(int n, char* pattern);
		Boolean		CompareNoCase(int n, char* pattern);
		int			Count();
		
	protected:
		void		InitTokenizer();
		void		BuildTokenTable(CString& targ, const char* delim);
		void		AddToken(char*,int);

		int			mTokenCount;
		char		**mTokenTable;
		int			*mTokenLengthTable;	
		int			mTokenTableSize;	

	public:

		enum  {
			kRangeErr	= 'tok0'			// Access beyond# of tokens
		};
};

//------------------------------------------------------------------------------
// *Inlines
//------------------------------------------------------------------------------

inline int CTokenizer::Count()
{
	return mTokenCount;
}

//------------------------------------------------------------------------------

#endif
