/*
	$Id: CSharedFlags.cpp,v 1.1 2003/04/20 23:33:11 dasenbro Exp $

	File:		CSharedFlags.cpp

	Contains:	C++ implementation of generic 

	Version:	Apple Mail Server - Mac OS X :  $Revision: 1.1 $

	Written by:	Michael Dasenbrock

	Copyright:	 1996-2001 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: CSharedFlags.cpp,v $
		Revision 1.1  2003/04/20 23:33:11  dasenbro
		Initial check-in.
		
		Revision 1.5  2002/03/21 16:24:19  dasenbro
		Updated version information.
		
		Revision 1.4  2001/06/21 20:50:50  dasenbro
		Updated file header info.
		
		Revision 1.3  2001/06/21 16:28:14  dasenbro
		Removed some dead code.
		

	Projector History:


	To Do:
*/


// PP
#include <string.h>
#include <time.h>

// App
#include "CBaseDatabase.h"
#include "CSharedFlags.h"
#include "CExpansion.h"
#include "CString.h"
#include "CMailSpool.h"
#include "UException.h"

extern CMailDatabase *gDB;

//--------------------------------------------------------------------------------------------------
//	* CSharedFlags
//
//--------------------------------------------------------------------------------------------------

CSharedFlags::CSharedFlags( void ) : CExpansion ()
{
} // CSharedFlags



//--------------------------------------------------------------------------------------------------
//	* ~CSharedFlags
//
//--------------------------------------------------------------------------------------------------

CSharedFlags::~CSharedFlags ( void )
{
} // ~CSharedFlags


//--------------------------------------------------------------------------------------------------
//	 Done
//
//--------------------------------------------------------------------------------------------------

void CSharedFlags::Done ( CSharedFlags* &inPtr )
{
	CDBBaseObject *aDBObject = (CDBBaseObject *) inPtr;
	aDBObject->Done(aDBObject);
	inPtr = (CSharedFlags *)aDBObject;

}

//--------------------------------------------------------------------------------------------------
//	* SetSharedInfo
//
//--------------------------------------------------------------------------------------------------

Boolean CSharedFlags::SetSharedInfo ( ObjID inObjID )
{
	Boolean		result	= false;
	Boolean		done	= false;
	sInt16		i		= 0;
	char		data[ kMaxDataBlockSize ];
	SFlags		*p	= nil;

	GetDataBlock( data );
	p = (SFlags *)&data;

	if ( GetItemCount() < GetMaxItems() )
	{
		while ( !done && (i < GetMaxItems()) )
		{
			if ( p[ i ].fSharedID == 0 )
			{
				p[ i ].fSharedID = inObjID;
				IncItemCount();
				SetDataBlock( data );
				done	= true;
				result	= true;
			}
			else if ( p[ i ].fSharedID == inObjID )
			{
				done	= true;
				result	= true;
			}
			i++;
		}
	}

	return( result );

} // SetSharedInfo



//--------------------------------------------------------------------------------------------------
//	* DeleteSharedInfo
//
//--------------------------------------------------------------------------------------------------

Boolean CSharedFlags::DeleteSharedInfo ( ObjID inObjID )
{
	Boolean		result	= false;
	Boolean		done	= false;
	sInt16		i		= 0;
	char		data[ kMaxDataBlockSize ];
	SFlags		*p	= nil;

	GetDataBlock( data );
	p = (SFlags *)&data;

	while ( !done && (i < GetMaxItems()) )
	{
		if ( p[ i ].fSharedID == inObjID )
		{
			p[ i ].fSharedID = 0;

			DecItemCount();
			SetDataBlock( data );

			done = true;
			result = true;
		}
		i++;
	}

	return( result );

} // DeleteSharedInfo



//--------------------------------------------------------------------------------------------------
//	* IsObjectInList
//
//--------------------------------------------------------------------------------------------------

Boolean CSharedFlags::IsObjectInList ( ObjID inObjID )
{
	Boolean		result	= false;
	Boolean		done	= false;
	sInt16		i		= 0;
	char		data[ kMaxDataBlockSize ];
	SFlags		*p	= nil;

	GetDataBlock( data );
	p = (SFlags *)&data;

	while ( !done && (i < GetMaxItems()) )
	{
		if ( p[ i ].fSharedID == inObjID )
		{
			done	= true;
			result	= true;
		}
		i++;
	}

	return( result );

} // IsObjectInList



//--------------------------------------------------------------------------------------------------
//	* ClearIDs
//
//--------------------------------------------------------------------------------------------------

void CSharedFlags::ClearIDs ( void )
{
	char		data[ kMaxDataBlockSize ];

	GetDataBlock( data );

	::memset( data, 0, sizeof( data ) );

	SetDataBlock( data );

} // ClearIDs




















