/*
	File:		CMailDatabase.10.1.h

	Copyright:	 2003 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:
*/

#ifndef __CMailDatabase_10_1_h__
#define	__CMailDatabase_10_1_h__	1

#include "CBaseDatabase.10.1.h"

// DBObject Signatures
const uInt32 kMailRootSignature_10_1		= 'Root';
const uInt32 kAccountSignature_10_1			= 'Acct';
const uInt32 kMailSpoolSignature_10_1		= 'MSpl';
const uInt32 kEnvelopeInfoSignature_10_1	= 'EInf';
const uInt32 kEnvelopeSignature_10_1		= 'Envp';
const uInt32 kRecipientSignature_10_1		= 'Rcpt';
const uInt32 kMessagePartSignature_10_1		= 'MsgP';
const uInt32 KSmallMsgPartSignature_10_1	= 'SMpt';
const uInt32 kHostEntrySignature_10_1		= 'HstE';
const uInt32 kDNSCacheSignature_10_1		= 'DNSC';
const uInt32 kHostPrefSignature_10_1		= 'HePf';
const uInt32 kServerPrefsSignature_10_1		= 'SvPf';
const uInt32 kStatMgrSignature_10_1			= 'Stat';
const uInt32 kMsgTOCSignature_10_1			= 'MToc';
const uInt32 kExpansionSignature_10_1		= 'Expn';
const uInt32 kPOP3AcctInfoSignature_10_1	= 'P3If';
const uInt32 kMessageStringSignature_10_1	= 'MStr';
const uInt32 kTextObjectSignature_10_1		= 'TxOb';

typedef enum {
	kFlush_10_1		= true,
	kNoFlush_10_1	= false
} ObjectFlush_10_1;

enum 
{
	// Version is divided into parts:
	// 0xFF000000 == Major Version
	// 0x00FF0000 == Minor Version
	// 0x0000FF00 == Development Stage (Dev, Alpha, Beta, Final)
	// 0x000000FF == Development Substage
	
	kDBVersionNumber1_10_1	= 0x0500010A,			// 5.0a10
	kDBVersionNumber2_10_1	= 0x05000201,			// 5.0b1
	kDBVersionNumber3_10_1	= 0x05000209,	 		// 5.0b9
	kDBVersionNumber4_10_1	= 0x05000301,			// 5.0f1
	kDBVersionNumber5_10_1	= 0x05000303,			// 5.0f3
	kDBVersionNumber6_10_1	= 0x05000304,			// 5.0f4
	kDBVersionNumber7_10_1	= 0x05000306,			// 5.0f6e1
	kDBVersionNumber8_10_1	= 0x05000307,			// 5.0f6e2	-- includes new field in CHostEntry
	kDBVersionNumber9_10_1	= 0x05020308,			// 5.0f6e2	-- includes new field in CHostEntry
	kDBVersionNumber10_10_1	= 0x05010306,			// 5.0.1b6

// AppleShareIP 6.0 IMAP Server versions...5.0.2 was the last version of ASIP..
	kDBVersionNumber11_10_1	= 0x06000001,			// 6.0 dev-1
	kDBVersionNumber12_10_1	= 0x06000002,			// 6.0 a1c10
	kDBVersionNumber13_10_1	= 0x06000004,			// 6.0 post-a1
	kDBVersionNumber14_10_1	= 0x06000007,			// 6.0 a7c1
	kDBVersionNumber15_10_1	= 0x1000B001,			// 10.0 b1
	kDBCurrentVersion_10_1 = kDBVersionNumber15_10_1
};

//------------------------------------------------------------------------------
// Constants
//------------------------------------------------------------------------------

const uInt32 kVersionInfoVersion_10_1 =  kDBCurrentVersion_10_1;
const uInt32 kVersionInfoDataSize_10_1 = 2 * sizeof(uInt32);

class CDBMailObjectCache_10_1;
class CMailDatabase_10_1 : public CBaseDatabase_10_1
{
	public:
							CMailDatabase_10_1			(	const uInt32 inMinFreeDiskSpace,
															CDBMailObjectCache_10_1 *inMailBaseObjectCache,
															uInt32 inPageCacheCount = kNormalPageCacheCount_10_1 );
		virtual				~CMailDatabase_10_1			( void );
		

	private:
	
		// functions that must be provided as virtual functions
		virtual	void	DoYield				( const Boolean inForceYieldFlag );

		virtual void	DoLockDB			( void );
		virtual void	DoReleaseDB			( void );

		virtual Boolean	IsThreadQuitting	( void );
};

#endif	// __CMailDatabase_10_1_h__
