/*
	$Id: CDBMailBaseObject.cpp,v 1.1 2003/04/20 23:32:51 dasenbro Exp $

	File:		CDBMailBaseObject.cpp

	Contains:	C++ implementation of basic persistent database object

	Version:	Apple Mail Server - Mac OS X :  $Revision: 1.1 $

	Written by:	Nick Brosnahan

	Copyright:	 1996-2001 by Apple Computer, Inc., all rights reserved.

	Change History:

		$Log: CDBMailBaseObject.cpp,v $
		Revision 1.1  2003/04/20 23:32:51  dasenbro
		Initial check-in.
		
		Revision 1.9  2002/03/21 16:41:17  dasenbro
		Updated file version information.
		
		Revision 1.8  2001/06/21 20:50:53  dasenbro
		Updated file header info.
		
		Revision 1.7  2001/06/21 17:01:16  dasenbro
		Added Change History.
		

	Projector History:

	  <ASM4>	  6/7/99	DOR		Pass NULL to a base-class constructor.
	  <ASM3>	  6/4/99	DOR		Add code to check object characteristics and report if there are
									any word-alignment issues with this version of
									sources/compiler/header-files.  This check is a runtime sanity
									check to hopefully "catch" any potential build problems that
									could lead to file-format compatilbility problems with 6.0, 6.1
									or 6.2....
	  <ASM2>	  6/2/99	DOR		Add a new virtual function to check compiler object offset
									issues.  Avoid a "silent" bad build when the build preferences
									are wrong.

	To Do:
*/

#include "Database.h"
#include "CDBMailBaseObject.h"
#include "CString.h"

// ----------------------------------------------------------------------------------------
#pragma mark * Static Methods *
// ----------------------------------------------------------------------------------------

#pragma mark -

CDBMailObjectCacheList::CDBMailObjectCacheList()
{
}

CDBMailObjectCacheList::~CDBMailObjectCacheList()
{
}
		
void CDBMailObjectCacheList::DoListLock ( void )
{
//	this->fObjectLock.Wait();
}

void CDBMailObjectCacheList::DoListRelease ( void )
{
//	this->fObjectLock.Signal();
}

#pragma mark -

CDBMailObjectCache::CDBMailObjectCache() : CDBBaseObjectCache ( NULL )
{
//	fCacheLock = NULL;
}

CDBMailObjectCache::~CDBMailObjectCache()
{
//	if ( fCacheLock != NULL )
//	{
//		delete [] fCacheLock;
//		fCacheLock = NULL;
//	}
}

void CDBMailObjectCache::SetBaseDBPtr( CBaseDatabase *inBaseDBPtr )
{
	BaseDBAssert_if (this != NULL)
	{
		this->fBaseDBPtr = inBaseDBPtr;
		this->SetUpHashTable();
//		if ( fCacheLock != NULL )
//		{
//			delete [] fCacheLock;
//			fCacheLock = NULL;
//		}
		if (this->GetListCount() != 0)
		{
//			fCacheLock = new CFastMutex[ this->GetListCount() ];
		}
	}
}
		
void CDBMailObjectCache::Wait ( const uInt32 inIndex )
{
	BaseDBAssert(this != NULL);
	BaseDBAssert(inIndex < this->GetListCount());
//	BaseDBAssert(fCacheLock != NULL);

//	if ((this != NULL) && (inIndex < this->GetListCount()) && (fCacheLock != NULL))
//	{
//		this->fCacheLock[inIndex].Wait();
//	}
}

void CDBMailObjectCache::Signal ( const uInt32 inIndex )
{
	BaseDBAssert(this != NULL);
	BaseDBAssert(inIndex < this->GetListCount());
//	BaseDBAssert(fCacheLock != NULL);
	
//	if ((this != NULL) && (inIndex < this->GetListCount()) && (fCacheLock != NULL))
//	{
//		this->fCacheLock[inIndex].Signal();
//	}
}

#pragma mark -

CDBMailBaseObject::CDBMailBaseObject (	StdDBObjHeader	*inObjHeader,
				 	  					StdDBObjFooter	*inObjFooter,
				 	   					void			*inObjData,
				 	   					const OSType	inObjSignature,
				 	   					const uInt32	inObjVersion,
				 	   					const uInt32	inObjSize 		)
	: CDBBaseObject (inObjHeader, inObjFooter, inObjData, inObjSignature, inObjVersion, inObjSize)
{
}

CDBMailBaseObject::~CDBMailBaseObject ( void )
{
}

void CDBMailBaseObject::ChkCompilerStructAlignment ( void )
{
}

CDBBaseObject *CDBMailBaseObject::Use ( CBaseDatabase	*inBaseDB )
{
	#pragma unused (inBaseDB)
	
	return (CDBBaseObject::Use(gDB));
}

CDBMailBaseObject* CDBMailBaseObject::MailUniversalFindByID (	const ObjID		inObjID,
																const OSType	inObjType,
																const uInt32	inObjVersion,
																const uInt32	inObjSize,
																ObjAllocFuncPtr	inObjAllocFuncPtr	)
{
	return ((CDBMailBaseObject*) CDBBaseObject::UniversalFindByID( 	gDB,
																	inObjID, inObjType, inObjVersion,
																	inObjSize, inObjAllocFuncPtr));
}

void CDBMailBaseObject::ReportBackwardCompatibility ( const uInt32 curSize, const uInt32 correctSize, char *inBaseClassName, char *inFieldName )
{
	if (curSize != correctSize)
	{
		CString	aTempString;
		
		aTempString.Sprintf("### FILE FORMAT COMPATIBILITY SAFETY CHECK FAILED ### %s::%s - offset is (%d) vs. (%d) reference standard",inBaseClassName, inFieldName, curSize, correctSize);
// xxxx		ERRLOG1(kLogApplication, kELFileFormatCHKFailed, aTempString.GetData());
	}
	
	#ifdef DEBUG
		if (curSize == correctSize)
		{
			CString	aTempString1;
			
			aTempString1.Sprintf("### File Format Compatibility Safety Check Good! - %s::%s - offset is (%d) vs. (%d) reference standard",inBaseClassName, inFieldName, curSize, correctSize);
// xxxx			ERRLOG1(kLogApplication, kELFileFormatCHKFailed, aTempString1.GetData());
		}
	#endif
	
	if ((curSize > CIDTable::GetEntryMaxByteSize()) || (curSize > kStandardPageSize))
	{
		CString	aTempString2;
		
		aTempString2.Sprintf("### FILE FORMAT COMPATIBILITY SAFETY CHECK FAILED ### %s::%s - objectsize of (%d) is too big.",inBaseClassName, inFieldName, curSize);
// xxxx		ERRLOG1(kLogApplication, kELFileFormatCHKFailed, aTempString2.GetData());
	}
}

//--------------------------------------------------------------------------------------------------
//	* GetObjectLock
//
//--------------------------------------------------------------------------------------------------

ExceptionCode CDBMailBaseObject::GetObjectLock ( const Boolean inWaitForObjectLock,
										 const uInt32  inMaxWaitTime )
{
	ExceptionCode grabError	= kNoErr;
	
//	grabError = fObjectLock.Wait(semaphore_NoWait);
	while ((grabError != kNoErr) && (inWaitForObjectLock == true))
	{
//		grabError = fWait4ObjectLock.Wait(inMaxWaitTime);

		if (grabError == kNoErr)
		{
			Try_
			{
//				fWait4ObjectLock.Reset();
			}
			Catch_(err)
			{
			}
		}
//		grabError = fObjectLock.Wait(semaphore_NoWait);
	}

	return (grabError);
} // GetObjectLock



//--------------------------------------------------------------------------------------------------
//	* ReleaseObjectLock
//
//--------------------------------------------------------------------------------------------------

void CDBMailBaseObject::ReleaseObjectLock ( const Boolean inNotifyOtherThreadsFlag )
{
//	fObjectLock.Signal();
	if (inNotifyOtherThreadsFlag == true)
	{
		this->WakeUpObjectThreads();
	}
} // ReleaseObjectLock

void CDBMailBaseObject::WakeUpObjectThreads ( void )
{
//	fWait4ObjectLock.Signal();
}

