/*
	$Id: CIDTable.h,v 1.1 2003/04/20 23:32:51 dasenbro Exp $

	File:		CIDTable.h

	Contains:	xxx put contents here xxx

	Version:	Apple Mail Server - Mac OS X :  $Revision: 1.1 $

	Written by:	David O'Rourke

	Copyright:	 1996-2001 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Notes:

		// *********************************************************************************
		// Warning: DO NOT CHANGE/ADD/REMOVE PUBLIC/PRIVATE DATA FIELDS TO THIS CLASS/STRUCT
		// WITHOUT CONSULTING WITH A APPLE MAIL TEAM MEMBER.  CHANGES TO
		// THIS STRUCTURE __WILL__ CAUSE FILE FORMAT COMPATIBILITY ISSUES FOR APPLESHARE IP 5.0
		// AND 6.0 MAIL DATABASES.
		//
		// FAILURE TO HEED THIS WARNING __WILL__ LEAD TO DATA LOSS
		// AND/OR CRASHING BUGS WHEN CUSTOMERS ATTEMPT TO USE YOUR SIMPLE MODIFICATIONS WITH
		// A PRE-EXISTING MAIL DATABASE.
		//
		// SINCE THIS FILE IS SHARED BY MORE COMPONENTS THAN JUST YOURS, PLEASE BE AWARE OF THE
		// C++ FRAGILE BASE CLASS PROBLEM AND DON'T MAKE CHANGES IN THE BASE CLASS SOURCE CODE
		// WITH OUT CONSULTING OTHER SOURCES THAT ARE DEPENDANT ON THIS STURUCTURE.
		// *********************************************************************************

	Change History:

		$Log: CIDTable.h,v $
		Revision 1.1  2003/04/20 23:32:51  dasenbro
		Initial check-in.
		
		Revision 1.6  2002/03/21 16:41:17  dasenbro
		Updated file version information.
		
		Revision 1.5  2001/06/21 20:50:54  dasenbro
		Updated file header info.
		
		Revision 1.4  2001/06/21 17:05:39  dasenbro
		Added Change History.
		

	Projector History:

	  <ASX3>	  6/4/99	DOR		Sanity checking code.

	To Do:
*/


#ifndef __CIDTable_h__
#define __CIDTable_h__	1

#include "DatabaseTypes.h"

typedef struct
{
	// *********************************************************************************
	// Warning: DO NOT CHANGE/ADD/REMOVE PUBLIC/PRIVATE DATA FIELDS TO THIS CLASS/STRUCT
	// WITHOUT CONSULTING WITH A APPLE MAIL TEAM MEMBER.  CHANGES TO
	// THIS STRUCTURE __WILL__ CAUSE FILE FORMAT COMPATIBILITY ISSUES FOR APPLESHARE IP 5.0
	// AND 6.0 MAIL DATABASES.
	//
	// FAILURE TO HEED THIS WARNING __WILL__ LEAD TO DATA LOSS
	// AND/OR CRASHING BUGS WHEN CUSTOMERS ATTEMPT TO USE YOUR SIMPLE MODIFICATIONS WITH
	// A PRE-EXISTING MAIL DATABASE.
	//
	// SINCE THIS FILE IS SHARED BY MORE COMPONENTS THAN JUST YOURS, PLEASE BE AWARE OF THE
	// C++ FRAGILE BASE CLASS PROBLEM AND DON'T MAKE CHANGES IN THE BASE CLASS SOURCE CODE
	// WITH OUT CONSULTING OTHER SOURCES THAT ARE DEPENDANT ON THIS STURUCTURE.
	// *********************************************************************************

	uInt32	fDataTableVersion;
	
	OSType	fTableType;
	uInt32	fDataSize;		// size of the entry data

	uInt32	fCount;			// current number of entries in this table
	uInt32	fMaxCount;		// max number of entries in this table

	ObjID	fMinID;			// min ID, present in this table
	ObjID	fMaxID;			// max ID present in this table

	PageID	fNextID;
	PageID	fPrevID;
	
	long	fSanityValue;
} SIDTableHeader;

const uInt32 kMaxIDTableSize	= (kStandardPageSize - sizeof(SIDTableHeader));
const uInt32 kCIDTableVersion	= 0x00550001 + sizeof(SIDTableHeader) + kMaxIDTableSize;
const uInt32 kCIDNullIndex		= 0xffffffff;

typedef struct
{
	// *********************************************************************************
	// Warning: DO NOT CHANGE/ADD/REMOVE PUBLIC/PRIVATE DATA FIELDS TO THIS CLASS/STRUCT
	// WITHOUT CONSULTING WITH A APPLE MAIL TEAM MEMBER.  CHANGES TO
	// THIS STRUCTURE __WILL__ CAUSE FILE FORMAT COMPATIBILITY ISSUES FOR APPLESHARE IP 5.0
	// AND 6.0 MAIL DATABASES.
	//
	// FAILURE TO HEED THIS WARNING __WILL__ LEAD TO DATA LOSS
	// AND/OR CRASHING BUGS WHEN CUSTOMERS ATTEMPT TO USE YOUR SIMPLE MODIFICATIONS WITH
	// A PRE-EXISTING MAIL DATABASE.
	//
	// SINCE THIS FILE IS SHARED BY MORE COMPONENTS THAN JUST YOURS, PLEASE BE AWARE OF THE
	// C++ FRAGILE BASE CLASS PROBLEM AND DON'T MAKE CHANGES IN THE BASE CLASS SOURCE CODE
	// WITH OUT CONSULTING OTHER SOURCES THAT ARE DEPENDANT ON THIS STURUCTURE.
	// *********************************************************************************


	SIDTableHeader	fIDTableHeader;
	char			fIDTableData[ kMaxIDTableSize ];
} SIDTable;

class CIDTable
{
	// *********************************************************************************
	// Warning: DO NOT CHANGE/ADD/REMOVE PUBLIC/PRIVATE DATA FIELDS TO THIS CLASS/STRUCT
	// WITHOUT CONSULTING WITH A APPLE MAIL TEAM MEMBER.  CHANGES TO
	// THIS STRUCTURE __WILL__ CAUSE FILE FORMAT COMPATIBILITY ISSUES FOR APPLESHARE IP 5.0
	// AND 6.0 MAIL DATABASES.
	//
	// FAILURE TO HEED THIS WARNING __WILL__ LEAD TO DATA LOSS
	// AND/OR CRASHING BUGS WHEN CUSTOMERS ATTEMPT TO USE YOUR SIMPLE MODIFICATIONS WITH
	// A PRE-EXISTING MAIL DATABASE.
	//
	// SINCE THIS FILE IS SHARED BY MORE COMPONENTS THAN JUST YOURS, PLEASE BE AWARE OF THE
	// C++ FRAGILE BASE CLASS PROBLEM AND DON'T MAKE CHANGES IN THE BASE CLASS SOURCE CODE
	// WITH OUT CONSULTING OTHER SOURCES THAT ARE DEPENDANT ON THIS STURUCTURE.
	// *********************************************************************************

	public:
							CIDTable			( const OSType inTableType, const uInt32 inEntrySize = 0);
		virtual 			~CIDTable			( void );
		
		static void		CheckBackwardCompatibility		( void );		
		static void		ReportBackwardCompatibility		( const uInt32 curSize, const uInt32 correctSize );		
		static uInt32	GetEntryMaxByteSize				( void );

		virtual OSStatus	SetTable			( void *inTablePtr, const PageID inPageID);
		
		virtual	OSStatus	AddID2List			( const ObjID inEntryID, const void *inEntryData = NULL , Boolean allowNewMin = false, Boolean allowNewMax = true);
		virtual OSStatus	RemoveIDFromList	( const ObjID inEntryID );
		virtual OSStatus	FindEntry			( const ObjID inEntryID, uInt32 &outEntryIndex );
		virtual OSStatus	GetEntry			( const uInt32 inIndex, ObjID &outObjID, const Ptr inEntryData = NULL );
		virtual OSStatus	SetEntryData		( const ObjID inEntryID, const void *inEntryData = NULL );
		virtual OSStatus	ResetEntryID		( const ObjID inOldEntryID, const ObjID inNewEntryID );

		virtual OSType		GetTableType		( void );		

		virtual uInt32		GetEntryDataSize	( void );
		virtual uInt32		GetEntryMaxCount	( void );

		virtual OSStatus	SetEntryCount		( const uInt32 inEntryCount );
		virtual uInt32		GetEntryCount		( void );

		virtual OSStatus	SetEntryIDMin		( const uInt32 inEntryIDMin, Boolean inForceSet = false);
		virtual uInt32		GetEntryIDMin		( void );

		virtual OSStatus	SetEntryIDMax		( const uInt32 inEntryIDMax, Boolean inForceSet = false );
		virtual uInt32		GetEntryIDMax		( void );
		
		virtual OSStatus	ClearIDTable		( void );

		virtual PageID		GetNextID			( void );
		virtual OSStatus    SetNextID			( const PageID inNextIDTable );
		
		virtual PageID		GetPrevID			( void );
		virtual OSStatus    SetPrevID			( const PageID inNextIDTable );
		
		virtual	OSStatus	SetTablePageID		( const PageID inPageID );
		virtual	PageID		GetTablePageID		( void );
		
		enum
		{
			kIDTableNoErr = 0,
			kIDTableFull = -1,
			kIDTableNoSuchObject = -2,
			kIDTableDuplicateObject = -3,
			kIDTableObjNoAdd = -4,
			kIDTableIndexOutOfRange = -5,
			kIDTableEntryCountTooBig = -6,
			kIDTableNoInsertAllowed = -7,
			kIDNewMinNotAllowed = -8,
			kIDNewMaxNotAllowed = -9
		};
	
	protected:
		virtual OSStatus	DeleteEntry 	(const uInt32 inIndex);
		virtual OSStatus	SetEntry		(const uInt32 inIndex, const ObjID inObjID, const void * inEntryData = NULL);
		virtual OSStatus	InsertEntry		(const uInt32 inIndex, const ObjID inObjID, const void * inEntryData = NULL);
		virtual OSStatus	SetEntry2ObjID	(const uInt32 inIndex, const ObjID inNewObjID);		
				OSStatus	SanityCheck		( void );

		// volitile data, no read/write to disk
		PageID			fPageID;
		SIDTableHeader	fTempHeader;
		
		// Data portion of the object, this can be saved and restored
		// to disk....
		SIDTable		*fIDTablePtr;
};

#endif	// __CIDTable_h__
