/*
	$Id: DSHostPrefs.h,v 1.1 2003/04/20 23:34:11 dasenbro Exp $

	File:		DSHostPrefs.h

	Contains:	class definition of DSHostPrefs object

	Version:	Apple Mail Server - Mac OS X :  $Revision: 1.1 $

	Written by:	Michael Dasenbrock

	Copyright:	 1996-2002 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: DSHostPrefs.h,v $
		Revision 1.1  2003/04/20 23:34:11  dasenbro
		Initial check-in.
		
		Revision 1.3  2002/04/18 18:09:10  dasenbro
		Changed bool to Bool for word alignment.
		
		Revision 1.2  2002/03/21 16:38:52  dasenbro
		Addes network transition support.
		
		Revision 1.1  2002/03/11 23:06:43  dasenbro
		Initial check-in.
		


	To Do:
*/

#ifndef __DSHostPrefs_h__
#define __DSHostPrefs_h__ 1

#include "DSPrefs.h"
#include "MailTypes.h"

class CString;

class DSHostPrefs : public DSPrefs
{
public:
					DSHostPrefs					( void );
	virtual		   ~DSHostPrefs					( void );

	tDirStatus		GetDeliverToLocalOnlyFlag	( Bool *outFlag, Bool inForceRead = false );
	tDirStatus		SetDeliverToLocalOnlyFlag	( const Bool inFlag, Bool inForceWrite = false );

	tDirStatus		GetLogRejectionsFlag		( Bool *outFlag, Bool inForceRead = false );
	tDirStatus		SetLogRejectionsFlag		( const Bool inFlag, Bool inForceWrite = false );

	tDirStatus		GetSendBCC_CopiesOfAllFlag	( Bool *outFlag, Bool inForceRead = false );
	tDirStatus		SetSendBCC_CopiesOfAllFlag	( const Bool inFlag, Bool inForceWrite = false );

	tDirStatus		GetSendBCC_CopiesOfAllUser	( UserStruct *inUserInfo, Bool inForceRead = false );
	tDirStatus		SetSendBCC_CopiesOfAllUser	( const UserStruct *inUserInfo, Bool inForceWrite = false );;

	tDirStatus		GetOutMailPopupFlags		( uInt32 *outValue, Bool inForceRead = false );
	tDirStatus		SetOutMailPopupFlags		( const uInt32 inValue, Bool inForceWrite = false );

	tDirStatus		GetNotifySenderOfNDRFlag	( Bool *outFlag, Bool inForceRead = false );
	tDirStatus		SetNotifySenderOfNDRFlag	( const Bool inFlag, Bool inForceWrite = false );

	tDirStatus		GetNotifySenderOfNDRHours	( uInt32 *outValue, Bool inForceRead = false );
	tDirStatus		SetNotifySenderOfNDRHours	( const uInt32 inValue, Bool inForceWrite = false );

	tDirStatus		GetNotifyPostmasterOfNDR	( Bool *outFlag, Bool inForceRead = false );
	tDirStatus		SetNotifyPostmasterOfNDR	( const Bool inFlag, Bool inForceWrite = false );

	tDirStatus		GetRelaySMTPFlag			( Bool *outFlag, Bool inForceRead = false );
	tDirStatus		SetRelaySMTPFlag			( const Bool inFlag, Bool inForceWrite = false );

	tDirStatus		GetRelaySMTPServer			( CString &outStr, Bool inForceRead = false );
	tDirStatus		SetRelaySMTPServer			( const char *inStr, Bool inForceWrite = false );;

	tDirStatus		GetExpireOutMailAfterHours	( uInt32 *outValue, Bool inForceRead = false );
	tDirStatus		SetExpireOutMailAfterHours	( const uInt32 inValue, Bool inForceWrite = false );
	
	tDirStatus		GetRetryFailedMinutes		( uInt32 *outValue, Bool inForceRead = false );
	tDirStatus		SetRetryFailedMinutes		( const uInt32 inValue, Bool inForceWrite = false );

	tDirStatus		GetDNSRequestButtonFlags	( uInt32 *outValue, Bool inForceRead = false );
	tDirStatus		SetDNSRequestButtonFlags	( const uInt32 inValue, Bool inForceWrite = false );

	tDirStatus		GetCacheSettingsButtonFlags	( uInt32 *outValue, Bool inForceRead = false );
	tDirStatus		SetCacheSettingsButtonFlags	( const uInt32 inValue, Bool inForceWrite = false );
	
	tDirStatus		GetCacheDNSMinutes			( uInt32 *outValue, Bool inForceRead = false );
	tDirStatus		SetCacheDNSMinutes			( const uInt32 inValue, Bool inForceWrite = false );

	tDirStatus		GetOpenConnTimeoutSeconds	( uInt32 *outValue, Bool inForceRead = false );
	tDirStatus		SetOpenConnTimeoutSeconds	( const uInt32 inValue, Bool inForceWrite = false );

	tDirStatus		GetReadWriteTimeoutSeconds	( uInt32 *outValue, Bool inForceRead = false );
	tDirStatus		SetReadWriteTimeoutSeconds	( const uInt32 inValue, Bool inForceWrite = false );

	tDirStatus		GetOutSMTPPortNumber		( uInt32 *outValue, Bool inForceRead = false );
	tDirStatus		SetOutSMTPPortNumber		( const uInt32 inValue, Bool inForceWrite = false );

private:

typedef enum
{
	kSunday		= 0,
	kMonday		= 1,
	kTuesday	= 2,
	kWednesday	= 3,
	kThursday	= 4,
	kFriday		= 5,
	kSaturday	= 6,
	kDayCount	= 7
} EDays;

typedef struct
{
	uInt32	fDayHours[ kDayCount ];
} SAllowConnectionTimes;

	// Incoming Mail
	Bool			fDeliverToLocalOnlyFlag;	// Deliver mail to local addresses only (no SMTP relay)
	Bool			fLogRejectionsFlag;			// Log recipient rejections to error log
	Bool			fSendBCCofAllToUserFlag;	// Send BCC copies ov all messages to:
	UserStruct	   *fSendBCCofAllToUserInfo;	// BCC user data

	// Outgoing Mail
	uInt32			fOutMailPopupFlags;			// Outgoing mail pop-up
	Bool			fNotifySenderOfNDRFlag;		// Notify Sender of non-deliver flag
	Bool			fNotifyPostmasterOfNDR;		// Notify Postmaster of non-delivery flag
	Bool			fRelaySMTPFlag;				// Relay all SMTP mail via flag
	uInt32			fExpireMsgAfterHours;		// Messages expire after ??? hours
	uInt32			fRetryFailedMinutes;		// Retry failed connections every ??? minutes
	uInt32			fNotifySenderOfNDRHours;	// Notify Sender of non-deliver after ??? hours
	char		   *fSMTPRelayServerName;		// Relay Server Name

	// Network Settings
	uInt32			fDNS_RequestButtonFlag;		// DNS Request button settings (1,2,3...)
	uInt32			fCacheSettingsButtonFlag;	// Cache Settings button flag
	uInt32			fCacheDNSMinutes;			// Cache DNS info for ??? minutes
	uInt32			fOpenConnTimeoutSeconds;	// Open connection timeout in ??? seconds
	uInt32			fReadWriteTimeoutSeconds;	// Read/Write timeout in ??? seconds
	uInt32			fOutSMTPPortNumber;			// Default SMTP port number
};

#endif // __DSHostPrefs_h__
