/*
	$Id: DSMailUserCache.h,v 1.1 2003/04/20 23:34:11 dasenbro Exp $

	File:		DSMailCache.h

	Contains:	C++ class definitions for Apple Directory Services cache

	Version:	Apple Mail Server - Mac OS X :  $Revision: 1.1 $

	Written by:	Jason Townsend

	Copyright:	 2000-2001 by Apple Computer, Inc., all rights reserved.

	Change History:

		$Log: DSMailUserCache.h,v $
		Revision 1.1  2003/04/20 23:34:11  dasenbro
		Initial check-in.
		
		Revision 1.11  2002/03/21 16:38:52  dasenbro
		Addes network transition support.
		
		Revision 1.10  2002/02/20 21:04:16  dasenbro
		Syntax changes.
		
		Revision 1.9  2001/06/21 20:50:55  dasenbro
		Updated file header info.
		
		Revision 1.8  2001/06/21 17:22:47  dasenbro
		Added Change History.
		

	Projector History:

 */

#ifndef __DSMailCache_h__
#define __DSMailCache_h__ 1

#include "DSMailUser.h"
#include "DSMailGroup.h"

// Max hash tabel entries

const uInt32 kMailCacheHashTableSize = 199;

typedef enum {
	kDSCUnknown		= 0,
	kDSCUser		= 1,
	kDSCGroup		= 2
} DSCRecordType;

// ---------------------------------------------------------------------------
//	* class DSCacheEntry
//
// ---------------------------------------------------------------------------

class DSCacheEntry
{
public:
	DSCacheEntry	( void );
	
	void		   *fEntry;
	uTime_t			fTimeStamp;
	DSCRecordType	fRecType;
};


// ---------------------------------------------------------------------------
//	* class DSMailCache
//
// ---------------------------------------------------------------------------

class DSMailCache
{
public:
						DSMailCache			( void );
	virtual			   ~DSMailCache			( void );

	// DSMailUsers
	DSMailUser *		GetUserByName		( const char *inName );
	DSMailUser *		GetUserByID			( const uInt32 inID );
	void				AddUserToCache		( DSMailUser *inMailUser, const char *inName );

	DSMailGroup *		GetGroupByName		( const char *inName );
	DSMailGroup *		GetGroupByID		( const uInt32 inID );
	void				AddGroupToCache		( DSMailGroup *inMailUser );

private:
	uInt32				HashString			( const char *inString );

	DSCacheEntry		fNameHashTable	[ kMailCacheHashTableSize ];
	DSCacheEntry		fIDHashTable	[ kMailCacheHashTableSize ];
};

#endif
